/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassGenerator;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassGeneratorExtension;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;
import org.jetbrains.kotlin.jvm.abi.AbiMethodInfo;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor;", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGeneratorExtension;", "()V", "abiClassInfo", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "getAbiClassInfo", "()Ljava/util/Map;", "generateClass", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;", "generator", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "AbiInfoClassGenerator", "jvm-abi-gen"})
public final class JvmAbiClassBuilderInterceptor
implements ClassGeneratorExtension {
    @NotNull
    private final Map<String, AbiClassInfo> abiClassInfo = new LinkedHashMap();

    @NotNull
    public final Map<String, AbiClassInfo> getAbiClassInfo() {
        return this.abiClassInfo;
    }

    @NotNull
    public ClassGenerator generateClass(@NotNull ClassGenerator generator, @Nullable IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        return new AbiInfoClassGenerator(generator, declaration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005JG\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\u00072\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070*H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\rH\u0016J?\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0001JK\u00105\u001a\u0002062\b\u00100\u001a\u0004\u0018\u0001072\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0010\u00108\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010*H\u0016\u00a2\u0006\u0002\u00109J#\u0010:\u001a\u00020;2\u0006\u0010&\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0007H\u0096\u0001J\u0018\u0010<\u001a\u00020=2\u0006\u00102\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\rH\u0016J$\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u00010\u0007H\u0016J-\u0010A\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00072\b\u0010B\u001a\u0004\u0018\u00010\u00072\b\u0010C\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020$H\u0096\u0001J\u001b\u0010D\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00072\b\u0010E\u001a\u0004\u0018\u00010\u0007H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0013\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor$AbiInfoClassGenerator;", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;", "delegate", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor;Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "internalName", "", "getInternalName", "()Ljava/lang/String;", "setInternalName", "(Ljava/lang/String;)V", "isPrivateClass", "", "isWhenMappingClass", "()Z", "localOrAnonymousClass", "getLocalOrAnonymousClass", "setLocalOrAnonymousClass", "(Z)V", "maskedMethods", "", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getMaskedMethods", "()Ljava/util/Set;", "methodInfos", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiMethodInfo;", "getMethodInfos", "()Ljava/util/Map;", "publicAbi", "getPublicAbi", "setPublicAbi", "defineClass", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "done", "generateSmapCopyToAnnotation", "newField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "desc", "value", "", "newMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "exceptions", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "newRecordComponent", "Lorg/jetbrains/org/objectweb/asm/RecordComponentVisitor;", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "visible", "visitEnclosingMethod", "owner", "visitInnerClass", "outerName", "innerName", "visitSource", "debug", "jvm-abi-gen"})
    private final class AbiInfoClassGenerator
    implements ClassGenerator {
        @NotNull
        private final ClassGenerator delegate;
        private final boolean isPrivateClass;
        public String internalName;
        private boolean localOrAnonymousClass;
        private boolean publicAbi;
        @NotNull
        private final Map<Method, AbiMethodInfo> methodInfos;
        @NotNull
        private final Set<Method> maskedMethods;

        public AbiInfoClassGenerator(@Nullable ClassGenerator delegate, IrClass irClass) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.isPrivateClass = irClass != null && DescriptorVisibilities.isPrivate((DescriptorVisibility)irClass.getVisibility());
            this.methodInfos = new LinkedHashMap();
            this.maskedMethods = new LinkedHashSet();
        }

        @NotNull
        public FieldVisitor newField(@Nullable IrField declaration, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return this.delegate.newField(declaration, access, name, desc, signature, value);
        }

        @NotNull
        public RecordComponentVisitor newRecordComponent(@NotNull String name, @NotNull String desc, @Nullable String signature) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return this.delegate.newRecordComponent(name, desc, signature);
        }

        public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.delegate.visitInnerClass(name, outerName, innerName, access);
        }

        public void visitSource(@NotNull String name, @Nullable String debug) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.delegate.visitSource(name, debug);
        }

        @NotNull
        public final String getInternalName() {
            String string = this.internalName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalName");
            return null;
        }

        public final void setInternalName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.internalName = string;
        }

        public final boolean getLocalOrAnonymousClass() {
            return this.localOrAnonymousClass;
        }

        public final void setLocalOrAnonymousClass(boolean bl) {
            this.localOrAnonymousClass = bl;
        }

        public final boolean getPublicAbi() {
            return this.publicAbi;
        }

        public final void setPublicAbi(boolean bl) {
            this.publicAbi = bl;
        }

        @NotNull
        public final Map<Method, AbiMethodInfo> getMethodInfos() {
            return this.methodInfos;
        }

        @NotNull
        public final Set<Method> getMaskedMethods() {
            return this.maskedMethods;
        }

        public void defineClass(int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
            Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
            if ((access & 0x2000) != 0) {
                this.publicAbi = true;
            }
            this.setInternalName(name);
            this.delegate.defineClass(version, access, name, signature, superName, interfaces);
        }

        public void visitEnclosingMethod(@NotNull String owner, @Nullable String name, @Nullable String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.localOrAnonymousClass = true;
            this.delegate.visitEnclosingMethod(owner, name, desc);
        }

        @NotNull
        public MethodVisitor newMethod(@Nullable IrFunction declaration, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (this.publicAbi) {
                return this.delegate.newMethod(declaration, access, name, desc, signature, exceptions);
            }
            if (StringsKt.endsWith$default((String)name, (String)"$$forInline", (boolean)false, (int)2, null) && !this.isPrivateClass) {
                this.methodInfos.put(new Method(name, desc), AbiMethodInfo.KEEP);
                ((Collection)this.maskedMethods).add(new Method(StringsKt.removeSuffix((String)name, (CharSequence)"$$forInline"), desc));
                return this.delegate.newMethod(declaration, access, name, desc, signature, exceptions);
            }
            if ((access & 2) != 0 && declaration != null && DescriptorVisibilities.isPrivate((DescriptorVisibility)declaration.getVisibility()) || Intrinsics.areEqual((Object)name, (Object)"<clinit>") || StringsKt.startsWith$default((String)name, (String)"access$", (boolean)false, (int)2, null) && (access & 0x1000) != 0) {
                return this.delegate.newMethod(declaration, access, name, desc, signature, exceptions);
            }
            IrFunction irFunction = declaration;
            boolean bl = irFunction != null ? irFunction.isInline() : false;
            if (bl && !this.isPrivateClass) {
                this.methodInfos.put(new Method(name, desc), AbiMethodInfo.KEEP);
            } else {
                this.methodInfos.put(new Method(name, desc), AbiMethodInfo.STRIP);
            }
            return this.delegate.newMethod(declaration, access, name, desc, signature, exceptions);
        }

        @NotNull
        public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            AnnotationVisitor delegate = this.delegate.visitAnnotation(desc, visible);
            if (this.publicAbi || !Intrinsics.areEqual((Object)desc, (Object)JvmAnnotationNames.METADATA_DESC)) {
                return delegate;
            }
            return new AnnotationVisitor(delegate, this){
                final /* synthetic */ AbiInfoClassGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(589824, $delegate);
                }

                public void visit(@Nullable String name, @Nullable Object value) {
                    if (Intrinsics.areEqual((Object)name, (Object)"xi") && value instanceof Integer) {
                        this.this$0.setPublicAbi(this.this$0.getPublicAbi() || (((Number)value).intValue() & 0x80) != 0);
                    }
                    super.visit(name, value);
                }
            };
        }

        public void done(boolean generateSmapCopyToAnnotation) {
            if (this.publicAbi) {
                JvmAbiClassBuilderInterceptor.this.getAbiClassInfo().put(this.getInternalName(), AbiClassInfo.Public.INSTANCE);
            } else if (!this.localOrAnonymousClass && !this.isWhenMappingClass()) {
                for (Method method : this.maskedMethods) {
                    this.methodInfos.replace(method, AbiMethodInfo.STRIP);
                }
                JvmAbiClassBuilderInterceptor.this.getAbiClassInfo().put(this.getInternalName(), new AbiClassInfo.Stripped(this.methodInfos));
            }
            this.delegate.done(generateSmapCopyToAnnotation);
        }

        private final boolean isWhenMappingClass() {
            return StringsKt.endsWith$default((String)this.getInternalName(), (String)"$WhenMappings", (boolean)false, (int)2, null);
        }
    }
}

