/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.internal.hash.HashCode;

public class TwoStageModuleArtifactCache
implements ModuleArtifactCache {
    private final ModuleArtifactCache readOnlyCache;
    private final ModuleArtifactCache writableCache;
    private final Path readOnlyCachePath;

    public TwoStageModuleArtifactCache(Path readOnlyCachePath, ModuleArtifactCache readOnlyCache, ModuleArtifactCache writableCache) {
        this.readOnlyCachePath = readOnlyCachePath;
        this.readOnlyCache = readOnlyCache;
        this.writableCache = writableCache;
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, HashCode moduleDescriptorHash) {
        if (artifactFile.toPath().startsWith(this.readOnlyCachePath)) {
            return;
        }
        this.writableCache.store(key, artifactFile, moduleDescriptorHash);
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, List<String> attemptedLocations, HashCode descriptorHash) {
        this.writableCache.storeMissing(key, attemptedLocations, descriptorHash);
    }

    @Override
    @Nullable
    public CachedArtifact lookup(ArtifactAtRepositoryKey key) {
        CachedArtifact lookup = this.writableCache.lookup(key);
        if (lookup != null) {
            return lookup;
        }
        return this.readOnlyCache.lookup(key);
    }

    @Override
    public void clear(ArtifactAtRepositoryKey key) {
        this.writableCache.clear(key);
    }
}

