/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.processing.DelegatingProcessor;
import org.gradle.api.internal.tasks.compile.processing.DynamicProcessingStrategy;
import org.gradle.api.internal.tasks.compile.processing.IncrementalFiler;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingEnvironment;

public class DynamicProcessor
extends DelegatingProcessor {
    private final DynamicProcessingStrategy strategy;

    public DynamicProcessor(Processor delegate, AnnotationProcessorResult result) {
        super(delegate);
        this.strategy = new DynamicProcessingStrategy(delegate.getClass().getName(), result);
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        IncrementalFiler incrementalFiler = new IncrementalFiler(processingEnv.getFiler(), this.strategy);
        IncrementalProcessingEnvironment incrementalEnvironment = new IncrementalProcessingEnvironment(processingEnv, incrementalFiler);
        super.init(incrementalEnvironment);
        this.strategy.updateFromOptions(this.getSupportedOptions());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.strategy.recordProcessingInputs(this.getSupportedAnnotationTypes(), annotations, roundEnv);
        return super.process(annotations, roundEnv);
    }
}

