/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeFinishExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements NestedRootBuild {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildTreeLifecycleController buildTreeLifecycleController;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner, BuildTreeState buildTree) {
        super(buildTree, buildDefinition, owner);
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        BuildScopeServices buildServices = this.getBuildServices();
        BuildLifecycleController buildLifecycleController = this.getBuildController();
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = (BuildTreeLifecycleControllerFactory)buildServices.get(BuildTreeLifecycleControllerFactory.class);
        ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)buildServices.get(ExceptionAnalyser.class);
        BuildStateRegistry buildStateRegistry = (BuildStateRegistry)buildServices.get(BuildStateRegistry.class);
        DefaultBuildTreeWorkExecutor buildTreeWorkExecutor = new DefaultBuildTreeWorkExecutor();
        DefaultBuildTreeFinishExecutor buildTreeFinishExecutor = new DefaultBuildTreeFinishExecutor(buildStateRegistry, exceptionAnalyser, buildLifecycleController);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(buildLifecycleController, (BuildTreeWorkExecutor)buildTreeWorkExecutor, (BuildTreeFinishExecutor)buildTreeFinishExecutor);
    }

    public void attach() {
        ((BuildStateRegistry)this.getBuildServices().get(BuildStateRegistry.class)).attachRootBuild((RootBuildState)this);
    }

    public StartParameterInternal getStartParameter() {
        return this.getBuildController().getGradle().getStartParameter();
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public Path calculateIdentityPathForProject(Path projectPath) {
        return this.getBuildController().getGradle().getIdentityPath().append(projectPath);
    }

    public File getBuildRootDir() {
        return ((BuildLayout)this.getBuildController().getGradle().getServices().get(BuildLayout.class)).getRootDirectory();
    }

    public IncludedBuildInternal getModel() {
        throw new UnsupportedOperationException();
    }

    public Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        throw new UnsupportedOperationException();
    }

    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        throw new UnsupportedOperationException();
    }

    public <T> T run(final Function<? super BuildTreeLifecycleController, T> action) {
        final GradleInternal gradle = this.getBuildController().getGradle();
        ServiceRegistry services = gradle.getServices();
        BuildOperationExecutor executor = (BuildOperationExecutor)services.get(BuildOperationExecutor.class);
        return (T)executor.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                Object result = action.apply(RootOfNestedBuildTree.this.buildTreeLifecycleController);
                context.setResult((Object)new RunNestedBuildBuildOperationType.Result(){});
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Run nested build").details((Object)new RunNestedBuildBuildOperationType.Details(){

                    public String getBuildPath() {
                        return gradle.getIdentityPath().getPath();
                    }
                });
            }
        });
    }
}

