/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.Facet;
import org.gradle.plugins.ide.eclipse.model.WtpFacet;
import org.gradle.util.internal.ConfigureUtil;

public abstract class EclipseWtpFacet {
    private final XmlFileContentMerger file;
    private List<Facet> facets = Lists.newArrayList();

    @Inject
    public EclipseWtpFacet(XmlFileContentMerger file) {
        this.file = file;
    }

    public XmlFileContentMerger getFile() {
        return this.file;
    }

    public void file(@DelegatesTo(value=XmlFileContentMerger.class) Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.file);
    }

    public void file(Action<? super XmlFileContentMerger> action) {
        action.execute((Object)this.file);
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    public void facet(Map<String, ?> args) {
        Facet newFacet = (Facet)ConfigureUtil.configureByMap(args, (Object)new Facet());
        List<Facet> newFacets = "jst.ejb".equals(newFacet.getName()) ? Arrays.asList(new Facet(Facet.FacetType.fixed, "jst.ejb", null), newFacet) : Collections.singletonList(newFacet);
        this.facets = Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.getFacets().stream().filter(f -> f.getType() != newFacet.getType() || !Objects.equals(f.getName(), newFacet.getName())).collect(Collectors.toList()), newFacets));
    }

    List<Facet> replaceInconsistentFacets(List<Facet> facets) {
        if (facets.stream().anyMatch(f -> "jst.ejb".equals(f.getName()))) {
            return facets.stream().filter(f -> !"jst.utility".equals(f.getName())).collect(Collectors.toList());
        }
        return facets;
    }

    public void mergeXmlFacet(WtpFacet xmlFacet) {
        this.file.getBeforeMerged().execute((Object)xmlFacet);
        xmlFacet.configure(this.replaceInconsistentFacets(this.getFacets()));
        this.file.getWhenMerged().execute((Object)xmlFacet);
    }
}

