/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.util.IoUtils;

@Mojo(name="provision-file", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class ProvisionFileStateMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(alias="install-dir", required=true)
    private File installDir;
    @Parameter(alias="plugin-options", required=false)
    private Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    private boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    private boolean logTime;
    @Parameter(alias="provisioning-file", required=true)
    private File provisioningFile;
    @Parameter(alias="record-state", defaultValue="true")
    private boolean recordState = true;
    @Parameter(defaultValue="false", property="galleon.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the provision-file goal.");
            return;
        }
        if (!this.provisioningFile.exists()) {
            throw new MojoExecutionException("Provisioning file " + this.provisioningFile + " doesn't exist.");
        }
        String vers = APIVersion.checkForLatestVersion();
        if (vers != null) {
            this.getLog().warn((CharSequence)("A new version of Galleon is available, you should update your dependency to " + vers));
        }
        try {
            this.doProvision();
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Provisioning failed", (Exception)e);
        }
    }

    private void doProvision() throws MojoExecutionException, ProvisioningException {
        MavenArtifactRepositoryManager artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        Path home = this.installDir.toPath();
        if (!this.recordState) {
            IoUtils.recursiveDelete(home);
        }
        try (Provisioning pm = ((GalleonBuilder)new GalleonBuilder().addArtifactResolver(artifactResolver)).newProvisioningBuilder(this.provisioningFile.toPath()).setInstallationHome(home).setMessageWriter(new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            pm.provision(this.provisioningFile.toPath(), this.pluginOptions);
        }
    }
}

