/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.storage;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;

public class KeyStoreResolverTest
extends TestCase {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    static /* synthetic */ Class class$org$apache$xml$security$test$keys$storage$KeyStoreResolverTest;

    public KeyStoreResolverTest() {
        super("KeyStoreResolverTest");
    }

    public KeyStoreResolverTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$keys$storage$KeyStoreResolverTest == null ? (class$org$apache$xml$security$test$keys$storage$KeyStoreResolverTest = KeyStoreResolverTest.class$("org.apache.xml.security.test.keys.storage.KeyStoreResolverTest")) : class$org$apache$xml$security$test$keys$storage$KeyStoreResolverTest);
    }

    public void testKeyStoreResolver() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "data" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "samples" + SEP + "input" + SEP + "keystore2.jks");
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        KeyStoreResolver keyStoreResolver = new KeyStoreResolver(keyStore);
        Iterator iterator = keyStoreResolver.getIterator();
        this.checkIterator(iterator);
        Iterator iterator2 = keyStoreResolver.getIterator();
        this.checkIterator(iterator2);
        iterator = keyStoreResolver.getIterator();
        iterator2 = keyStoreResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate = (X509Certificate)iterator2.next())) continue;
            KeyStoreResolverTest.fail((String)"KeyStoreResolver iterators are not independent");
        }
        KeyStoreResolverTest.assertFalse((boolean)iterator2.hasNext());
    }

    private void checkIterator(Iterator iterator) {
        int n = 0;
        iterator.hasNext();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            x509Certificate.getSubjectDN().getName();
            ++n;
        }
        KeyStoreResolverTest.assertEquals((int)3, (int)n);
        try {
            iterator.next();
            KeyStoreResolverTest.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

