/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.cache.impl;

import com.almworks.dup.util.Event;
import com.almworks.dup.util.EventListener;
import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoEvent;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.ArtifactLoadOption;
import com.almworks.tracker.eapi.alpha.ArtifactPresentationKey;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.cache.impl.DataFile;
import com.almworks.tracklink.codelinks.cache.impl.DataInputStream;
import com.almworks.tracklink.popup.ArtifactInfoList;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.Log;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.HashMap;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifespan;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactInfoCacheImpl
implements ArtifactInfoCache,
EventListener<ArtifactInfoEvent> {
    @NonNls
    private static final String ARTIFACTS_FILE = "artifacts.dat";
    private final Map<Project, TrackerConnector> myConnectors = new HashMap();
    private final Map<String, ArtifactInfo> myArtifactMap = new HashMap();
    private final DataFile myStorage;
    private final List<EventListener<ArtifactInfoEvent>> myListeners = new CopyOnWriteArrayList<EventListener<ArtifactInfoEvent>>();
    private final List<ArtifactInfoList> myModels = new CopyOnWriteArrayList<ArtifactInfoList>();

    public ArtifactInfoCacheImpl() {
        File dataHome = TrackLinkPlugin.getSystemHome();
        try {
            this.myStorage = new DataFile(new File(dataHome, ARTIFACTS_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnector(Lifespan lifespan, final Project project, final TrackerConnector connector) {
        Map<Project, TrackerConnector> map = this.myConnectors;
        synchronized (map) {
            this.myConnectors.put(project, connector);
            lifespan.add(new Detach(){

                protected void doDetach() {
                    ArtifactInfoCacheImpl.this.unregisterConnector(project, connector);
                }
            });
        }
        connector.getArtifactLoader().events().addListener(lifespan, ArtifactInfoEvent.class, (EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnector(Project project, TrackerConnector connector) {
        Map<Project, TrackerConnector> map = this.myConnectors;
        synchronized (map) {
            TrackerConnector removed = this.myConnectors.remove(project);
            assert (removed == connector) : removed + " " + connector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEvent(ArtifactInfoEvent event) {
        ArtifactInfo oldInfo;
        assert (EventQueue.isDispatchThread());
        ArtifactInfo info = event.getArtifactInfo();
        String url = info.getUrl();
        if (url == null) {
            Log.warn("artifact info with null url: " + info);
            return;
        }
        Map<String, ArtifactInfo> map = this.myArtifactMap;
        synchronized (map) {
            oldInfo = this.myArtifactMap.put(url, info);
        }
        if (!this.equal(oldInfo, info)) {
            int modelCount;
            this.myStorage.setDirty();
            int listenerCount = this.myListeners.size();
            if (listenerCount > 0) {
                for (EventListener<ArtifactInfoEvent> eventListener : this.myListeners) {
                    eventListener.onEvent((Event)event);
                }
            }
            if (oldInfo != null && (modelCount = this.myModels.size()) > 0) {
                for (ArtifactInfoList listModel : this.myModels) {
                    listModel.onInfoChanged(info);
                }
            }
        }
    }

    private boolean equal(ArtifactInfo info1, ArtifactInfo info2) {
        if (info1 == info2) {
            return true;
        }
        if (info1 == null || info2 == null) {
            return false;
        }
        if (info1.getStatus() != info2.getStatus()) {
            return false;
        }
        if (info1.getTimestamp() != info2.getTimestamp()) {
            return false;
        }
        Collection keys = info1.getApplicableKeys();
        if (keys.size() != info2.getApplicableKeys().size()) {
            return false;
        }
        for (ArtifactPresentationKey key : keys) {
            Object v1 = info1.getPresentation(key);
            Object v2 = info2.getPresentation(key);
            if (!(v1 instanceof String && v2 instanceof String ? v1.hashCode() != v2.hashCode() : !Comparing.equal((Object)v1, (Object)v2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ArtifactInfo getArtifactInfoSnapshot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/cache/impl/ArtifactInfoCacheImpl.getArtifactInfoSnapshot must not be null");
        }
        Map<String, ArtifactInfo> map = this.myArtifactMap;
        // MONITORENTER : map
        ArtifactInfo artifactInfo = this.myArtifactMap.get(url);
        if (artifactInfo == null) {
            artifactInfo = new UrlOnlyArtifactInfo(url);
            this.myArtifactMap.put(url, artifactInfo);
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        // MONITOREXIT : map
        if (artifactInfo2 == null) throw new IllegalStateException("@NotNull method com/almworks/tracklink/codelinks/cache/impl/ArtifactInfoCacheImpl.getArtifactInfoSnapshot must not return null");
        return artifactInfo2;
    }

    @Override
    public void listenArtifactInfo(Lifespan lifespan, final EventListener<ArtifactInfoEvent> listener) {
        assert (EventQueue.isDispatchThread());
        this.myListeners.add(listener);
        lifespan.add(new Detach(){

            protected void doDetach() {
                assert (EventQueue.isDispatchThread());
                ArtifactInfoCacheImpl.this.myListeners.remove(listener);
            }
        });
    }

    @Override
    public final ArtifactInfoList getListModel(Object key, Project project, Lifespan lifespan, String url) {
        return this.getListModel(key, project, lifespan, Collections.singleton(url));
    }

    @Override
    public ArtifactInfoList getListModel(Object key, Project project, Lifespan lifespan, Collection<String> urls) {
        assert (EventQueue.isDispatchThread());
        if (urls.size() == 0) {
            return ArtifactInfoList.EMPTY;
        }
        TrackerConnector connector = this.getConnector(project);
        if (connector == null) {
            Log.error("no connector for project " + project);
            return ArtifactInfoList.EMPTY;
        }
        if (urls.size() > 1) {
            urls = ArtifactInfoCacheImpl.filter(urls);
        }
        ArrayList<ArtifactInfo> list = new ArrayList<ArtifactInfo>(urls.size());
        for (String url : urls) {
            if (url == null) continue;
            ArtifactInfo snapshot = this.getArtifactInfoSnapshot(url);
            list.add(snapshot);
        }
        final ArtifactInfoList listModel = new ArtifactInfoList(list);
        this.myModels.add(listModel);
        lifespan.add(new Detach(){

            protected void doDetach() {
                ArtifactInfoCacheImpl.this.myModels.remove(listModel);
            }
        });
        connector.getArtifactLoader().subscribeArtifacts(key, lifespan, urls, ArtifactLoadOption.NONE);
        return listModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackerConnector getConnector(Project project) {
        Map<Project, TrackerConnector> map = this.myConnectors;
        synchronized (map) {
            return this.myConnectors.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeArtifacts(Collection<String> urls) {
        Map<String, ArtifactInfo> map = this.myArtifactMap;
        synchronized (map) {
            for (String url : urls) {
                this.myArtifactMap.remove(url);
            }
        }
    }

    private static Set<String> filter(@NotNull Collection<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/cache/impl/ArtifactInfoCacheImpl.filter must not be null");
        }
        HashSet<String> set = new HashSet<String>(urls.size());
        set.addAll(urls);
        return set;
    }

    public void readExternal() {
        try {
            byte[] bytes = this.myStorage.read();
            DataInputStream stream = this.myStorage.getInputStream();
            while (!stream.atEnd()) {
                LightArtifactInfo info = new LightArtifactInfo(bytes, stream.getPosition());
                LightArtifactInfo.readAll(stream, (HashMap<ArtifactPresentationKey, Object>)null);
                this.onEvent(new ArtifactInfoEvent((ArtifactInfo)info));
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal() {
        if (!this.myStorage.isDirty()) {
            return;
        }
        Map<String, ArtifactInfo> map = this.myArtifactMap;
        synchronized (map) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                for (Map.Entry<String, ArtifactInfo> entry : this.myArtifactMap.entrySet()) {
                    ArtifactInfo info = entry.getValue();
                    if (info.getStatus() != ArtifactInfoStatus.OK) continue;
                    DataInputStream.writeString(stream, entry.getKey());
                    DataInputStream.writeLong(stream, info.getTimestamp());
                    Collection allKeys = info.getApplicableKeys();
                    DataInputStream.writeInt(stream, allKeys.size());
                    for (ArtifactPresentationKey key : allKeys) {
                        if (key.getValueClass() != String.class) continue;
                        String value = (String)info.getPresentation(key);
                        if (value == null) {
                            value = "";
                        }
                        DataInputStream.writeString(stream, key.getName());
                        DataInputStream.writeString(stream, value);
                    }
                }
                this.myStorage.write(stream.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UrlOnlyArtifactInfo
    implements ArtifactInfo {
        private static Set<ArtifactPresentationKey> DEFAULT_KEYS = Collections.unmodifiableSet(new HashSet<ArtifactPresentationKey>(Arrays.asList(GenericKeys.ID, GenericKeys.SUMMARY, GenericKeys.SHORT_DESCRIPTION_HTML, GenericKeys.LONG_DESCRIPTION_HTML)));
        private final String myUrl;
        private final String myStringID;
        private final long myTimeStamp;

        public UrlOnlyArtifactInfo(String url) {
            this.myUrl = url;
            this.myStringID = Utils.getHackedID(this.myUrl);
            this.myTimeStamp = System.currentTimeMillis();
        }

        public String getUrl() {
            return this.myUrl;
        }

        @Nullable
        public ArtifactInfoStatus getStatus() {
            return null;
        }

        public long getTimestamp() {
            return this.myTimeStamp;
        }

        @Nullable
        public <T> T getPresentation(ArtifactPresentationKey<T> key) {
            if (GenericKeys.ID.equals(key)) {
                return (T)this.myStringID;
            }
            if (DEFAULT_KEYS.contains(key)) {
                return (T)"";
            }
            return null;
        }

        public Collection<ArtifactPresentationKey> getApplicableKeys() {
            return DEFAULT_KEYS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LightArtifactInfo
    implements ArtifactInfo {
        private final byte[] myBytes;
        private final int myDataOffset;

        public LightArtifactInfo(byte[] bytes, int dataOffset) {
            this.myBytes = bytes;
            this.myDataOffset = dataOffset;
        }

        public String getUrl() {
            return this.getStream().readString();
        }

        private DataInputStream getStream() {
            return new DataInputStream(this.myBytes, this.myDataOffset);
        }

        public ArtifactInfoStatus getStatus() {
            return ArtifactInfoStatus.OK;
        }

        public long getTimestamp() {
            DataInputStream stream = this.getStream();
            stream.readString();
            return stream.readLong();
        }

        public <T> T getPresentation(ArtifactPresentationKey<T> key) {
            return (T)this.readAll().get(key);
        }

        public Collection<ArtifactPresentationKey> getApplicableKeys() {
            return this.readAll().keySet();
        }

        private Map<ArtifactPresentationKey, Object> readAll() {
            HashMap map = new HashMap();
            DataInputStream stream = this.getStream();
            LightArtifactInfo.readAll(stream, (HashMap<ArtifactPresentationKey, Object>)map);
            return map;
        }

        private static void readAll(DataInputStream stream, @Nullable HashMap<ArtifactPresentationKey, Object> map) {
            stream.readString();
            stream.readLong();
            int keysCount = stream.readInt();
            for (int i = 0; i < keysCount; ++i) {
                String name = stream.readString();
                String value = stream.readString();
                if (map == null) continue;
                ArtifactPresentationKey key = GenericKeys.fromExternalForm((String)name, String.class);
                map.put((Object)key, (Object)value);
            }
        }
    }
}

