/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import java.util.logging.Logger;

final class AuthenticationJNI {
    private static final int maximumpointersize = 128;
    private static final int NI_MAXHOST = 1025;
    private static boolean enabled = false;
    private static Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.AuthenticationJNI");
    private static int sspiBlobMaxlen = 0;
    private byte[] sniSec = new byte[128];
    private int[] sniSecLen = new int[]{0};
    private String DNSNameAndPort = null;
    private static final UnsatisfiedLinkError linkError;

    AuthenticationJNI() {
    }

    UnsatisfiedLinkError getLinkError() {
        return linkError;
    }

    static int GetMaxSSPIBlobSize() {
        return sspiBlobMaxlen;
    }

    static boolean IsEnabled() {
        return enabled;
    }

    int GenerateClientContext(byte[] byArray, int n, byte[] byArray2, int[] nArray, boolean[] blArray) {
        return AuthenticationJNI.SNISecGenClientContext(this.sniSec, this.sniSecLen, byArray, n, byArray2, nArray, blArray, this.DNSNameAndPort, null, null, authLogger);
    }

    int ReleaseClientContext() {
        int n = 0;
        if (this.sniSecLen[0] > 0) {
            n = AuthenticationJNI.SNISecReleaseClientContext(this.sniSec, this.sniSecLen[0], authLogger);
            this.sniSecLen[0] = 0;
        }
        return n;
    }

    void InitDNSNameAndPort(String string, int n) {
        this.DNSNameAndPort = AuthenticationJNI.GetDNSName(string) + ":" + n;
    }

    static String GetDNSName(String string) {
        String[] stringArray = new String[1];
        if (AuthenticationJNI.GetDNSName(string, stringArray, authLogger) != 0) {
            stringArray[0] = "";
        }
        return stringArray[0];
    }

    private static native int SNISecGenClientContext(byte[] var0, int[] var1, byte[] var2, int var3, byte[] var4, int[] var5, boolean[] var6, String var7, String var8, String var9, Logger var10);

    private static native int SNISecReleaseClientContext(byte[] var0, int var1, Logger var2);

    private static native int SNISecInitPackage(int[] var0, Logger var1);

    private static native int SNISecTerminatePackage(Logger var0);

    private static native int SNIGetSID(byte[] var0, Logger var1);

    private static native boolean SNIIsEqualToCurrentSID(byte[] var0, Logger var1);

    private static native int GetDNSName(String var0, String[] var1, Logger var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        try {
            String string = "sqljdbc_auth";
            System.loadLibrary(string);
            int[] nArray = new int[]{0};
            if (0 != AuthenticationJNI.SNISecInitPackage(nArray, authLogger)) {
                throw new UnsatisfiedLinkError();
            }
            sspiBlobMaxlen = nArray[0];
            enabled = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
            unsatisfiedLinkError = unsatisfiedLinkError2;
            authLogger.warning("Failed to load the sqljdbc_auth.dll cause :- " + unsatisfiedLinkError2.getMessage());
        }
        finally {
            linkError = unsatisfiedLinkError;
        }
    }
}

