/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveServerConfig {
    public static final String XML_TAG = "slave_config";
    public static final String XML_TAG_MASTERS = "masters";
    private List<SlaveServer> masters;
    private SlaveServer slaveServer;
    private boolean reportingToMasters;
    private boolean joining;

    public SlaveServerConfig() {
        this.masters = new ArrayList<SlaveServer>();
    }

    public SlaveServerConfig(SlaveServer slaveServer) {
        this();
        this.slaveServer = slaveServer;
    }

    public SlaveServerConfig(List<SlaveServer> masters, boolean reportingToMasters, SlaveServer slaveServer) {
        this.masters = masters;
        this.reportingToMasters = reportingToMasters;
        this.slaveServer = slaveServer;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        for (SlaveServer slaveServer : this.masters) {
            xml.append(slaveServer.getXML());
        }
        XMLHandler.addTagValue((String)"report_to_masters", (boolean)this.reportingToMasters);
        if (this.slaveServer != null) {
            xml.append(this.slaveServer.getXML());
        }
        XMLHandler.addTagValue((String)"joining", (boolean)this.joining);
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public SlaveServerConfig(Node node) {
        this();
        Node mastersNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_MASTERS);
        int nrMasters = XMLHandler.countNodes((Node)mastersNode, (String)"slaveserver");
        for (int i = 0; i < nrMasters; ++i) {
            Node masterSlaveNode = XMLHandler.getSubNodeByNr((Node)mastersNode, (String)"slaveserver", (int)i);
            SlaveServer masterSlaveServer = new SlaveServer(masterSlaveNode);
            this.checkNetworkInterfaceSetting(masterSlaveNode, masterSlaveServer);
            this.masters.add(masterSlaveServer);
        }
        this.reportingToMasters = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"report_to_masters"));
        Node slaveNode = XMLHandler.getSubNode((Node)node, (String)"slaveserver");
        if (slaveNode != null) {
            this.slaveServer = new SlaveServer(slaveNode);
            this.checkNetworkInterfaceSetting(slaveNode, this.slaveServer);
        }
        this.joining = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"joining"));
    }

    private void checkNetworkInterfaceSetting(Node slaveNode, SlaveServer slaveServer) {
        String networkInterfaceName = XMLHandler.getTagValue((Node)slaveNode, (String)"network_interface");
        if (!Const.isEmpty((String)networkInterfaceName)) {
            try {
                String newHostname = Const.getIPAddress((String)networkInterfaceName);
                if (newHostname != null) {
                    slaveServer.setHostname(newHostname);
                    slaveServer.setName(slaveServer.getName() + "-" + newHostname);
                    LogWriter.getInstance().logBasic("Slave server configuration", "Hostname for slave server [" + slaveServer.getName() + "] is set to [" + newHostname + "], information derived from network " + networkInterfaceName, new Object[0]);
                }
            }
            catch (SocketException e) {
                LogWriter.getInstance().logError("Slave server configuration", "Unable to get the IP address for network interface " + networkInterfaceName + " for slave server [" + slaveServer.getName() + "]", (Throwable)e);
            }
        }
    }

    public SlaveServerConfig(String hostname, int port, boolean joining) {
        this();
        this.joining = joining;
        this.slaveServer = new SlaveServer(hostname + ":" + port, hostname, "" + port, null, null);
    }

    public List<SlaveServer> getMasters() {
        return this.masters;
    }

    public void setMasters(List<SlaveServer> masters) {
        this.masters = masters;
    }

    public SlaveServer getSlaveServer() {
        return this.slaveServer;
    }

    public void setSlaveServer(SlaveServer slaveServer) {
        this.slaveServer = slaveServer;
    }

    public boolean isReportingToMasters() {
        return this.reportingToMasters;
    }

    public void setReportingToMasters(boolean reportingToMaster) {
        this.reportingToMasters = reportingToMaster;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public void setJoining(boolean joining) {
        this.joining = joining;
    }
}

