/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.append;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.append.Append;
import org.pentaho.di.trans.steps.append.AppendData;
import org.pentaho.di.trans.steps.append.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String headStepName;
    private StepMeta headStepMeta;
    private String tailStepName;
    private StepMeta tailStepMeta;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public String getTailStepName() {
        if (this.tailStepMeta != null && this.tailStepMeta.getName() != null && this.tailStepMeta.getName().length() > 0) {
            return this.tailStepMeta.getName();
        }
        return null;
    }

    public String getHeadStepName() {
        if (this.headStepMeta != null && this.headStepMeta.getName() != null && this.headStepMeta.getName().length() > 0) {
            return this.headStepMeta.getName();
        }
        return null;
    }

    public void setTailStepName(String tailStepname) {
        this.tailStepName = tailStepname;
    }

    public void setHeadStepName(String headStepname) {
        this.headStepName = headStepname;
    }

    public StepMeta getTailStepMeta() {
        return this.tailStepMeta;
    }

    public StepMeta getHeadStepMeta() {
        return this.headStepMeta;
    }

    public void setTailStepMeta(StepMeta tailStep) {
        this.tailStepMeta = tailStep;
    }

    public void setHeadStepMeta(StepMeta headStep) {
        this.headStepMeta = headStep;
    }

    @Override
    public Object clone() {
        AppendMeta retval = (AppendMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append(XMLHandler.addTagValue((String)"head_name", (String)this.getHeadStepName()));
        retval.append(XMLHandler.addTagValue((String)"tail_name", (String)this.getTailStepName()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.headStepName = XMLHandler.getTagValue((Node)stepnode, (String)"head_name");
            this.tailStepName = XMLHandler.getTagValue((Node)stepnode, (String)"tail_name");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("AppendMeta.Exception.UnableToLoadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String[] getInfoSteps() {
        return new String[]{this.headStepName, this.tailStepName};
    }

    @Override
    public void setInfoSteps(StepMeta[] infoSteps) {
        if (infoSteps != null && infoSteps.length == 2) {
            this.headStepMeta = infoSteps[0];
            this.tailStepMeta = infoSteps[1];
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.headStepName = rep.getStepAttributeString(id_step, "head_name");
            this.tailStepName = rep.getStepAttributeString(id_step, "tail_name");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("AppendMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "head_name", this.getHeadStepName());
            rep.saveStepAttribute(id_transformation, id_step, "tail_name", this.getTailStepName());
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("AppendMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.headStepMeta = StepMeta.findStep(steps, this.headStepName);
        this.tailStepMeta = StepMeta.findStep(steps, this.tailStepName);
    }

    @Override
    public boolean chosesTargetSteps() {
        return false;
    }

    @Override
    public String[] getTargetSteps() {
        return null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (info != null && info.length > 0) {
            r.mergeRowMeta(info[0]);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.getHeadStepName() != null && this.getTailStepName() != null) {
            CheckResult cr = new CheckResult(1, Messages.getString("AppendMeta.CheckResult.SourceStepsOK"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else if (this.getHeadStepName() == null && this.getTailStepName() == null) {
            CheckResult cr = new CheckResult(4, Messages.getString("AppendMeta.CheckResult.SourceStepsMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, Messages.getString("AppendMeta.CheckResult.OneSourceStepMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Append(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AppendData();
    }
}

