/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.zipfile.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.FileDoesNotExistValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryZipFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String zipFilename;
    public int compressionrate;
    public int ifzipfileexists;
    public int afterzip;
    private String wildcard;
    private String wildcardexclude;
    private String sourcedirectory;
    private String movetodirectory;
    private boolean addfiletoresult;
    private boolean isfromprevious;
    private boolean createparentfolder;
    private boolean adddate;
    private boolean addtime;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean createMoveToDirectory;

    public JobEntryZipFile(String n) {
        super(n, "");
        this.date_time_format = null;
        this.zipFilename = null;
        this.ifzipfileexists = 2;
        this.afterzip = 0;
        this.compressionrate = 1;
        this.wildcard = null;
        this.wildcardexclude = null;
        this.sourcedirectory = null;
        this.movetodirectory = null;
        this.addfiletoresult = false;
        this.isfromprevious = false;
        this.createparentfolder = false;
        this.adddate = false;
        this.addtime = false;
        this.SpecifyFormat = false;
        this.createMoveToDirectory = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.ZIP_FILE);
    }

    public JobEntryZipFile() {
        this("");
    }

    public JobEntryZipFile(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryZipFile je = (JobEntryZipFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compressionrate", (int)this.compressionrate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifzipfileexists", (int)this.ifzipfileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourcedirectory", (String)this.sourcedirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterzip", (int)this.afterzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isfromprevious", (boolean)this.isfromprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createparentfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createMoveToDirectory", (boolean)this.createMoveToDirectory));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.zipFilename = XMLHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.compressionrate = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"compressionrate"), (int)-1);
            this.ifzipfileexists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"ifzipfileexists"), (int)-1);
            this.afterzip = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"afterzip"), (int)-1);
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.sourcedirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sourcedirectory");
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isfromprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createparentfolder"));
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createMoveToDirectory"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryZipFile.UnableLoadJobEntryXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zipfilename");
            this.compressionrate = (int)rep.getJobEntryAttributeInteger(id_jobentry, "compressionrate");
            this.ifzipfileexists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "ifzipfileexists");
            this.afterzip = (int)rep.getJobEntryAttributeInteger(id_jobentry, "afterzip");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.sourcedirectory = rep.getJobEntryAttributeString(id_jobentry, "sourcedirectory");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.isfromprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "isfromprevious");
            this.createparentfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createparentfolder");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.createMoveToDirectory = rep.getJobEntryAttributeBoolean(id_jobentry, "createMoveToDirectory");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryZipFile.UnableLoadJobEntryRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "zipfilename", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "compressionrate", this.compressionrate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "ifzipfileexists", this.ifzipfileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "afterzip", this.afterzip);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getID(), "sourcedirectory", this.sourcedirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isfromprevious", this.isfromprevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createparentfolder", this.createparentfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createMoveToDirectory", this.createMoveToDirectory);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryZipFile.UnableSaveJobEntryRep", "" + id_job), (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean result = false;
        LogWriter log = LogWriter.getInstance();
        parentfolder = KettleVFS.getFileObject((String)filename).getParent();
        if (!parentfolder.exists()) {
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryZipFile.CanNotFindFolder", "" + parentfolder.getName()), new Object[0]);
            }
            parentfolder.createFolder();
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryZipFile.FolderCreated", "" + parentfolder.getName()), new Object[0]);
            }
        } else if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryZipFile.FolderExists", "" + parentfolder.getName()), new Object[0]);
        }
        result = true;
        Object var7_5 = null;
        if (parentfolder == null) return result;
        try {
            parentfolder.close();
            parentfolder = null;
            return result;
        }
        catch (Exception ex) {}
        return result;
        {
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("JobEntryZipFile.CanNotCreateFolder", "" + parentfolder.getName()), new Object[0]);
                Object var7_6 = null;
                if (parentfolder == null) return result;
                try {
                    parentfolder.close();
                    parentfolder = null;
                    return result;
                }
                catch (Exception ex) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (parentfolder == null) throw throwable;
            try {
                parentfolder.close();
                parentfolder = null;
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean processRowFile(Job parentJob, Result result, String realZipfilename, String realWildcard, String realWildcardExclude, String realSourceDirectoryOrFile, String realMovetodirectory, boolean createparentfolder) {
        block91: {
            block93: {
                block90: {
                    block89: {
                        block88: {
                            log = LogWriter.getInstance();
                            Fileexists = false;
                            tempFile = null;
                            fileZip = null;
                            resultat = false;
                            renameOk = false;
                            orginexist = false;
                            OriginFile = null;
                            zin = null;
                            buffer = null;
                            dest = null;
                            buff = null;
                            out = null;
                            entry = null;
                            localSourceFilename = realSourceDirectoryOrFile;
                            try {
                                OriginFile = KettleVFS.getFileObject((String)realSourceDirectoryOrFile);
                                localSourceFilename = KettleVFS.getFilename((FileObject)OriginFile);
                                orginexist = OriginFile.exists();
                                var26_24 = null;
                                ** if (OriginFile == null) goto lbl-1000
                            }
                            catch (Throwable var25_31) {
                                var26_25 = null;
                                if (OriginFile != null) {
                                    try {
                                        OriginFile.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                throw var25_31;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    OriginFile.close();
                                }
                                catch (IOException ex) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block88;
                                catch (Exception e) {
                                    var26_24 = null;
                                    if (OriginFile != null) {
                                        try {
                                            OriginFile.close();
                                        }
                                        catch (IOException ex) {}
                                    }
                                }
                            }
                        }
                        localrealZipfilename = realZipfilename;
                        if (realZipfilename == null || !orginexist) break block93;
                        fileObject = null;
                        fileObject = KettleVFS.getFileObject((String)localrealZipfilename);
                        localrealZipfilename = KettleVFS.getFilename((FileObject)fileObject);
                        if (fileObject.exists()) {
                            Fileexists = true;
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobZipFiles.Zip_FileExists1.Label") + localrealZipfilename + Messages.getString("JobZipFiles.Zip_FileExists2.Label"), new Object[0]);
                            }
                        }
                        if (createparentfolder) {
                            this.createParentFolder(localrealZipfilename);
                        }
                        if (this.ifzipfileexists == 3 && Fileexists) {
                            resultat = false;
                            break block89;
                        }
                        if (this.ifzipfileexists == 2 && Fileexists) {
                            if (this.addfiletoresult) {
                                resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                            }
                            resultat = true;
                            break block89;
                        }
                        if (this.afterzip == 2 && realMovetodirectory == null) {
                            resultat = false;
                            log.logError(this.toString(), Messages.getString("JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label"), new Object[0]);
                            break block89;
                        }
                        filelist = null;
                        f = new File(localSourceFilename);
                        filelist = f.isDirectory() != false ? f.list() : new String[]{f.getName()};
                        if (filelist.length == 0) {
                            resultat = false;
                            log.logError(this.toString(), Messages.getString("JobZipFiles.Log.FolderIsEmpty", localSourceFilename), new Object[0]);
                            break block89;
                        }
                        if (!this.checkContainsFile(localSourceFilename, filelist, f.isDirectory())) {
                            resultat = false;
                            log.logError(this.toString(), Messages.getString("JobZipFiles.Log.NoFilesInFolder", localSourceFilename), new Object[0]);
                            break block89;
                        }
                        if (this.ifzipfileexists == 0 && Fileexists) {
                            if (localrealZipfilename.toLowerCase().endsWith(".zip")) {
                                localrealZipfilename = localrealZipfilename.substring(0, localrealZipfilename.length() - 4);
                            }
                            localrealZipfilename = localrealZipfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + ".zip";
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobZipFiles.Zip_FileNameChange1.Label") + localrealZipfilename + Messages.getString("JobZipFiles.Zip_FileNameChange1.Label"), new Object[0]);
                            }
                        } else if (this.ifzipfileexists == 1 && Fileexists) {
                            fileZip = new File(localrealZipfilename);
                            tempFile = File.createTempFile(fileZip.getName(), null);
                            tempFile.delete();
                            renameOk = fileZip.renameTo(tempFile);
                            if (!renameOk) {
                                log.logError(this.toString(), Messages.getString("JobZipFiles.Cant_Rename_Temp1.Label") + fileZip.getAbsolutePath() + Messages.getString("JobZipFiles.Cant_Rename_Temp2.Label") + tempFile.getAbsolutePath() + Messages.getString("JobZipFiles.Cant_Rename_Temp3.Label"), new Object[0]);
                            }
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobZipFiles.Zip_FileAppend1.Label") + localrealZipfilename + Messages.getString("JobZipFiles.Zip_FileAppend2.Label"), new Object[0]);
                            }
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobZipFiles.Files_Found1.Label") + filelist.length + Messages.getString("JobZipFiles.Files_Found2.Label") + localSourceFilename + Messages.getString("JobZipFiles.Files_Found3.Label"), new Object[0]);
                        }
                        pattern = null;
                        patternexclude = null;
                        if (f.isDirectory()) {
                            if (!Const.isEmpty((String)realWildcard)) {
                                pattern = Pattern.compile(realWildcard);
                            }
                            if (!Const.isEmpty((String)realWildcardExclude)) {
                                patternexclude = Pattern.compile(realWildcardExclude);
                            }
                        }
                        buffer = new byte[18024];
                        dest = new FileOutputStream(localrealZipfilename);
                        buff = new BufferedOutputStream(dest);
                        out = new ZipOutputStream(buff);
                        fileSet = new HashSet<String>();
                        if (renameOk) {
                            zin = new ZipInputStream(new FileInputStream(tempFile));
                            entry = zin.getNextEntry();
                            while (entry != null) {
                                name = entry.getName();
                                if (!fileSet.contains(name)) {
                                    out.putNextEntry(new ZipEntry(name));
                                    while ((len = zin.read(buffer)) > 0) {
                                        out.write(buffer, 0, len);
                                    }
                                    fileSet.add(name);
                                }
                                entry = zin.getNextEntry();
                            }
                            zin.close();
                        }
                        out.setMethod(8);
                        if (this.compressionrate == 0) {
                            out.setLevel(0);
                        } else if (this.compressionrate == 1) {
                            out.setLevel(-1);
                        }
                        if (this.compressionrate == 2) {
                            out.setLevel(9);
                        }
                        if (this.compressionrate == 3) {
                            out.setLevel(1);
                        }
                        zippedFiles = new String[filelist.length];
                        fileNum = 0;
                        for (i = 0; i < filelist.length && !parentJob.isStopped(); ++i) {
                            getIt = true;
                            getItexclude = false;
                            if (f.isDirectory()) {
                                if (pattern != null) {
                                    matcher = pattern.matcher(filelist[i]);
                                    getIt = matcher.matches();
                                }
                                if (patternexclude != null) {
                                    matcherexclude = patternexclude.matcher(filelist[i]);
                                    getItexclude = matcherexclude.matches();
                                }
                            }
                            targetFilename = localSourceFilename + Const.FILE_SEPARATOR + filelist[i];
                            if (f.isFile()) {
                                targetFilename = localSourceFilename;
                            }
                            file = new File(targetFilename);
                            if (!getIt || getItexclude || file.isDirectory() || fileSet.contains(filelist[i])) continue;
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobZipFiles.Add_FilesToZip1.Label") + filelist[i] + Messages.getString("JobZipFiles.Add_FilesToZip2.Label") + localSourceFilename + Messages.getString("JobZipFiles.Add_FilesToZip3.Label"), new Object[0]);
                            }
                            in = new FileInputStream(targetFilename);
                            out.putNextEntry(new ZipEntry(filelist[i]));
                            while ((len = in.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                            out.flush();
                            out.closeEntry();
                            in.close();
                            zippedFiles[fileNum] = filelist[i];
                            ++fileNum;
                        }
                        out.close();
                        buff.close();
                        dest.close();
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), Messages.getString("JobZipFiles.Log.TotalZippedFiles", "" + zippedFiles.length), new Object[0]);
                        }
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        if (this.afterzip == 1 || this.afterzip == 2) {
                            for (i = 0; i < zippedFiles.length; ++i) {
                                if (zippedFiles[i] == null) continue;
                                fileObjectd = KettleVFS.getFileObject((String)(localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i]));
                                if (f.isFile()) {
                                    fileObjectd = KettleVFS.getFileObject((String)localSourceFilename);
                                }
                                System.gc();
                                if (this.afterzip == 1) {
                                    deleted = fileObjectd.delete();
                                    if (!deleted) {
                                        resultat = false;
                                        log.logError(this.toString(), Messages.getString("JobZipFiles.Cant_Delete_File1.Label") + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + Messages.getString("JobZipFiles.Cant_Delete_File2.Label"), new Object[0]);
                                    }
                                    if (!log.isDebug()) continue;
                                    log.logDebug(this.toString(), Messages.getString("JobZipFiles.File_Deleted1.Label") + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + Messages.getString("JobZipFiles.File_Deleted2.Label"), new Object[0]);
                                    continue;
                                }
                                if (this.afterzip != 2) continue;
                                try {
                                    fileObjectm = KettleVFS.getFileObject((String)(realMovetodirectory + Const.FILE_SEPARATOR + zippedFiles[i]));
                                    fileObjectd.moveTo(fileObjectm);
                                }
                                catch (IOException e) {
                                    log.logError(this.toString(), Messages.getString("JobZipFiles.Cant_Move_File1.Label") + zippedFiles[i] + Messages.getString("JobZipFiles.Cant_Move_File2.Label") + e.getMessage(), new Object[0]);
                                    resultat = false;
                                }
                                if (!log.isDebug()) continue;
                                log.logDebug(this.toString(), Messages.getString("JobZipFiles.File_Moved1.Label") + zippedFiles[i] + Messages.getString("JobZipFiles.File_Moved2.Label"), new Object[0]);
                            }
                        }
                        if (this.addfiletoresult) {
                            resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        resultat = true;
                    }
                    var41_52 = null;
                    if (fileObject == null) break block90;
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (buff != null) {
                        buff.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (zin != null) {
                        zin.close();
                    }
                    if (entry != null) {
                        entry = null;
                    }
                    break block91;
                }
                catch (IOException ex) {}
                break block91;
                {
                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobZipFiles.Cant_CreateZipFile1.Label") + localrealZipfilename + Messages.getString("JobZipFiles.Cant_CreateZipFile2.Label") + e.getMessage(), new Object[0]);
                        resultat = false;
                        var41_53 = null;
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                                fileObject = null;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        try {
                            if (out != null) {
                                out.close();
                            }
                            if (buff != null) {
                                buff.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                            if (zin != null) {
                                zin.close();
                            }
                            if (entry != null) {
                                entry = null;
                            }
                            break block91;
                        }
                        catch (IOException ex) {}
                        break block91;
                    }
                }
                catch (Throwable var40_58) {
                    var41_54 = null;
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                            fileObject = null;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (buff != null) {
                            buff.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                        if (zin != null) {
                            zin.close();
                        }
                        if (entry != null) {
                            entry = null;
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var40_58;
                }
            }
            resultat = true;
            if (localrealZipfilename == null) {
                log.logError(this.toString(), Messages.getString("JobZipFiles.No_ZipFile_Defined.Label"), new Object[0]);
            }
            if (!orginexist) {
                log.logError(this.toString(), Messages.getString("JobZipFiles.No_FolderCible_Defined.Label", localSourceFilename), new Object[0]);
            }
        }
        return resultat;
    }

    private boolean checkContainsFile(String realSourceDirectoryOrFile, String[] filelist, boolean isDirectory) {
        boolean retval = false;
        for (int i = 0; i < filelist.length; ++i) {
            File file = isDirectory ? new File(realSourceDirectoryOrFile + Const.FILE_SEPARATOR + filelist[i]) : new File(realSourceDirectoryOrFile);
            if (!file.exists() || !file.isFile()) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block36: {
            log = LogWriter.getInstance();
            result = previousResult;
            rows = result.getRows();
            realZipfilename = null;
            realWildcard = null;
            realWildcardExclude = null;
            realTargetdirectory = null;
            realMovetodirectory = this.environmentSubstitute(this.movetodirectory);
            SanityControlOK = true;
            if (this.afterzip == 2) {
                if (Const.isEmpty((String)realMovetodirectory)) {
                    SanityControlOK = false;
                    log.logError(this.toString(), Messages.getString("JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label"), new Object[0]);
                } else {
                    moveToDirectory = null;
                    try {
                        block35: {
                            moveToDirectory = KettleVFS.getFileObject((String)realMovetodirectory);
                            if (moveToDirectory.exists()) {
                                if (moveToDirectory.getType() == FileType.FOLDER) {
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobZipFiles.Log.MoveToFolderExist", realMovetodirectory), new Object[0]);
                                    }
                                } else {
                                    SanityControlOK = false;
                                    log.logError(this.toString(), Messages.getString("JobZipFiles.Log.MoveToFolderNotFolder", realMovetodirectory), new Object[0]);
                                }
                                break block35;
                            }
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobZipFiles.Log.MoveToFolderNotNotExist", realMovetodirectory), new Object[0]);
                            }
                            if (this.createMoveToDirectory) {
                                moveToDirectory.createFolder();
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobZipFiles.Log.MoveToFolderCreaterd", realMovetodirectory), new Object[0]);
                                }
                                break block35;
                            }
                            SanityControlOK = false;
                            log.logError(this.toString(), Messages.getString("JobZipFiles.Log.MoveToFolderNotNotExist", realMovetodirectory), new Object[0]);
                        }
                        var17_17 = null;
                        ** if (moveToDirectory == null) goto lbl-1000
                    }
                    catch (Throwable var16_23) {
                        var17_18 = null;
                        if (moveToDirectory != null) {
                            realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                            try {
                                moveToDirectory.close();
                                moveToDirectory = null;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var16_23;
                    }
lbl-1000:
                    // 1 sources

                    {
                        realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                        try {
                            moveToDirectory.close();
                            moveToDirectory = null;
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (Exception e) {
                            SanityControlOK = false;
                            log.logError(this.toString(), Messages.getString("JobZipFiles.ErrorGettingMoveToFolder.Label", realMovetodirectory), new Object[0]);
                            var17_17 = null;
                            if (moveToDirectory != null) {
                                realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                                try {
                                    moveToDirectory.close();
                                    moveToDirectory = null;
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
        }
        if (!SanityControlOK) {
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        if (this.isfromprevious && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobZipFiles.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
        }
        if (this.isfromprevious && rows != null) {
            try {
                for (iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    realTargetdirectory = resultRow.getString(0, null);
                    if (!Const.isEmpty((String)realTargetdirectory)) {
                        if (!Const.isEmpty((String)resultRow.getString(1, null))) {
                            realWildcard = resultRow.getString(1, null);
                        }
                        if (!Const.isEmpty((String)resultRow.getString(2, null))) {
                            realWildcardExclude = resultRow.getString(2, null);
                        }
                        if (!Const.isEmpty((String)(realZipfilename = resultRow.getString(3, null)))) {
                            if (this.processRowFile(parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createparentfolder)) continue;
                            result.setResult(false);
                            return result;
                        }
                        log.logError(this.toString(), "destination zip filename is empty! Ignoring row...", new Object[0]);
                        continue;
                    }
                    log.logError(this.toString(), "Target directory is empty! Ignoring row...", new Object[0]);
                }
            }
            catch (Exception e) {
                log.logError(this.toString(), "Erreur during process!", new Object[0]);
            }
        } else if (!this.isfromprevious) {
            if (!Const.isEmpty((String)this.sourcedirectory)) {
                realZipfilename = this.getFullFilename(this.environmentSubstitute(this.zipFilename), this.adddate, this.addtime, this.SpecifyFormat, this.date_time_format);
                realWildcard = this.environmentSubstitute(this.wildcard);
                realWildcardExclude = this.environmentSubstitute(this.wildcardexclude);
                realTargetdirectory = this.environmentSubstitute(this.sourcedirectory);
                result.setResult(this.processRowFile(parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createparentfolder));
            } else {
                log.logError(this.toString(), "Source folder/file is empty! Ignoring row...", new Object[0]);
            }
        }
        return result;
    }

    public String getFullFilename(String filename, boolean add_date, boolean add_time, boolean specify_format, String datetime_folder) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        String realfilename = this.environmentSubstitute(filename);
        int lenstring = realfilename.length();
        int lastindexOfDot = realfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = realfilename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (specify_format && !Const.isEmpty((String)datetime_folder)) {
            daf.applyPattern(datetime_folder);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (add_date) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (add_time) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + realfilename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setSourceDirectory(String sourcedirectory) {
        this.sourcedirectory = sourcedirectory;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetodirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.sourcedirectory;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setcreateparentfolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean getcreateparentfolder() {
        return this.createparentfolder;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isfromprevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isfromprevious;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx1, this.getVariables());
        AndValidator.putValidators(ctx1, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        if (3 == this.ifzipfileexists) {
            FileDoesNotExistValidator.putFailIfExists(ctx1, true);
        }
        JobEntryValidatorUtils.andValidator().validate(this, "zipFilename", remarks, ctx1);
        if (2 == this.afterzip) {
            JobEntryValidatorUtils.andValidator().validate(this, "moveToDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "sourceDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

