/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.enterprise.JSONMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.security.AccessDeniedException;

public class JSONResponseHandler
implements ResponseHandler<JSONMessage> {
    private static final Logger logger = Logger.getLogger(JSONResponseHandler.class);

    public JSONMessage handleResponse(HttpResponse response) {
        try {
            int status = response.getStatusLine().getStatusCode();
            if (status == 401) {
                throw new AccessDeniedException("Access Denied");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            return this.handleResponse(reader, status);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JSONMessage handleResponse(String json, int status) {
        return this.handleResponse(new StringReader(json), status);
    }

    public JSONMessage handleResponse(Reader reader, int status) {
        if (status == 404) {
            throw new RuntimeException("Server resource is not available.");
        }
        JSONTokener tokener = new JSONTokener(reader);
        try {
            JSONObject message = (JSONObject)tokener.nextValue();
            if (message.getString("responseKind").equals("data")) {
                return new JSONMessage(message.getString("data"), status);
            }
            if (message.getString("responseKind").equals("unsuccessful")) {
                return new JSONMessage(message.getString("data"), status);
            }
            if (message.getString("responseKind").equals("exceptionStackTrace")) {
                JSONArray stackTraceStrings = new JSONArray(message.getString("data"));
                StringBuffer stackTraceMessage = new StringBuffer();
                for (int i = 0; i < stackTraceStrings.length(); ++i) {
                    stackTraceMessage.append("\n").append(stackTraceStrings.get(i));
                }
                throw new SPPersistenceException(null, stackTraceMessage.toString());
            }
            throw new Exception("Unable to parse response ");
        }
        catch (Exception ex) {
            throw new RuntimeException("Server returned status " + status + "\n" + tokener, ex);
        }
    }
}

