/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.ResolverUtil;

public class LifecycleSupport
implements LifecycleListener {
    private Set<LifecycleListener> lifeListeners;
    private static LogWriter log = LogWriter.getInstance();

    public LifecycleSupport() {
        ResolverUtil listeners = new ResolverUtil();
        listeners.find(new ResolverUtil.IsA(LifecycleListener.class), "org.pentaho.di.core.lifecycle.pdi");
        Set listenerClasses = listeners.getClasses();
        this.lifeListeners = new HashSet<LifecycleListener>(listenerClasses.size());
        for (Class clazz : listenerClasses) {
            try {
                this.lifeListeners.add((LifecycleListener)clazz.newInstance());
            }
            catch (Throwable e) {
                log.logError("Spoon", "Unable to init listener:" + e.getMessage(), new Object[0]);
            }
        }
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onStart(handler);
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onExit(handler);
        }
    }
}

