%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/parenthesize-singlenotes-chords-rests.ly"
\sourcefileline 0

\header {
  texidoc = "The @code{\parenthesize} function should also work on single
notes (not inside chords), rests, and on whole chords.  Also,
parenthesizing articulations, dynamics and text markup is possible.
On all other music expressions, @code{\parenthesize} does not have
an effect.

Measure 1: Three parenthesized notes (staccato not parenthesized), one
note with staccato in parentheses; Measure 2: Chord and two rests in
parentheses (accent and markup not); Measure 3: note (no parentheses)
with @code{\p} in parentheses, with text in parentheses, and note in
parentheses with @code{\p} not in parentheses, rest (no parentheses);
Measure 4: shows that @code{\parenthesize} does not apply to other
expressions like @code{SequentialMusic}."
}


\paper {
  ragged-right = ##t
}

\version "2.23.4"


\relative c'' {
  % parentheses on single notes (with articulations), inside chord and articulation
  \parenthesize c \parenthesize c-. <\parenthesize c> c-\parenthesize-. |
  % parenthesized rests and whole chords
  \tweak Parentheses.font-size 0 \parenthesize <c e g>4-> \parenthesize r \parenthesize r2^"rest" |
  % parenthesizing dynamics and text markup
  c4-\parenthesize\p c-\parenthesize-"Text" \parenthesize c\p r4 |
  % parenthesizing other music expressions does nothing
  \parenthesize {c4 c-. <c e g> r} \parenthesize|
}



% ****************************************************************
% end ly snippet
% ****************************************************************
