/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.cipher;

import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.cipher.DecryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.EncryptionCipher;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class JavaCipher
implements EncryptionCipher,
DecryptionCipher {
    private final CipherAlgorithm algorithm;
    private byte[] iv;
    private byte[] key;
    private Cipher cipher = null;

    public JavaCipher(CipherAlgorithm algorithm, byte[] key) {
        this.algorithm = algorithm;
        this.key = key;
    }

    @Override
    public int getBlocksize() {
        return this.algorithm.getBlocksize();
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] someBytes) throws CryptoException {
        IvParameterSpec encryptIv = new IvParameterSpec(iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not initialize JavaCipher. Did you forget to use UnlimitedStrengthEnabler/add BouncyCastleProvider?", ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] someBytes) throws CryptoException {
        try {
            if (this.cipher == null) {
                this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
                String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
                this.cipher.init(1, new SecretKeySpec(this.key, keySpecAlgorithm));
            }
            return this.cipher.doFinal(someBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not encrypt data", ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] someBytes) throws CryptoException {
        GCMParameterSpec encryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not encrypt data", ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] additionAuthenticatedData, byte[] someBytes) throws CryptoException {
        GCMParameterSpec encryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            this.cipher.updateAAD(additionAuthenticatedData);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not enrypt data", ex);
        }
    }

    @Override
    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] someBytes) throws CryptoException {
        IvParameterSpec decryptIv = new IvParameterSpec(iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(someBytes, someBytes.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] someBytes) throws CryptoException {
        try {
            if (this.cipher == null) {
                this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
                String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
                this.cipher.init(2, new SecretKeySpec(this.key, keySpecAlgorithm));
            }
            byte[] result = this.cipher.doFinal(someBytes);
            return result;
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] someBytes) throws CryptoException {
        GCMParameterSpec decryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(someBytes, someBytes.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] additionalAuthenticatedData, byte[] cipherText) throws CryptoException {
        GCMParameterSpec decryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            this.cipher.updateAAD(additionalAuthenticatedData);
            byte[] result = this.cipher.doFinal(cipherText);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(cipherText, cipherText.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", ex);
        }
    }
}

