/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.tracking;

import org.aesh.readline.terminal.impl.WinSysTerminal;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;

abstract class CliProgressTracker<T>
implements ProgressCallback<T> {
    final String msgStart;
    final String msgComplete;
    PmCommandInvocation invocation;
    private final Printer printer;

    CliProgressTracker(PmSession session, String msgStart, String msgComplete) {
        this.msgStart = msgStart;
        this.msgComplete = msgComplete;
        this.printer = Config.isWindows() ? (WinSysTerminal.isVTSupported() ? new ANSIPrinter() : new BasicPrinter()) : (session.isAnsiSupported() ? new ANSIPrinter() : new BasicPrinter());
    }

    void commandStart(PmCommandInvocation invocation) {
        this.invocation = invocation;
    }

    void commandEnd(PmCommandInvocation invocation) {
        this.invocation = invocation;
    }

    @Override
    public void starting(ProgressTracker<T> tracker) {
        this.printer.starting();
    }

    @Override
    public void processing(ProgressTracker<T> tracker) {
        String content = this.processingContent(tracker);
        if (content != null) {
            this.printer.processing(this.msgStart + " " + content);
        }
    }

    @Override
    public void pulse(ProgressTracker<T> tracker) {
    }

    @Override
    public void complete(ProgressTracker<T> tracker) {
        Object content = this.msgComplete;
        if (content != null) {
            String completedContent = this.completeContent(tracker);
            content = this.msgComplete + (String)(completedContent == null ? "" : " " + completedContent);
        }
        this.printer.complete((String)content);
    }

    protected abstract String processingContent(ProgressTracker<T> var1);

    protected abstract String completeContent(ProgressTracker<T> var1);

    private class ANSIPrinter
    implements Printer {
        private ANSIPrinter() {
        }

        void print(String content) {
            CliProgressTracker.this.invocation.getShell().write("\u001b[?25l");
            CliProgressTracker.this.invocation.getShell().write(ANSI.CURSOR_RESTORE);
            CliProgressTracker.this.invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
            CliProgressTracker.this.invocation.getShell().write(ANSI.CURSOR_SAVE);
            CliProgressTracker.this.invocation.getShell().write(content);
            CliProgressTracker.this.invocation.getShell().write("\u001b[?25h");
        }

        @Override
        public void complete(String content) {
            if (content != null) {
                this.print(content + Config.getLineSeparator());
            } else {
                CliProgressTracker.this.invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
            }
            CliProgressTracker.this.invocation.getShell().write(ANSI.CURSOR_RESTORE);
        }

        @Override
        public void starting() {
            CliProgressTracker.this.invocation.getShell().write(ANSI.CURSOR_SAVE);
            this.print(CliProgressTracker.this.msgStart);
        }

        @Override
        public void processing(String content) {
            this.print(content);
        }
    }

    private class BasicPrinter
    implements Printer {
        private BasicPrinter() {
        }

        @Override
        public void complete(String content) {
            if (content != null) {
                CliProgressTracker.this.invocation.println(content);
            }
        }

        @Override
        public void starting() {
            CliProgressTracker.this.invocation.println(CliProgressTracker.this.msgStart + "...");
        }

        @Override
        public void processing(String content) {
        }
    }

    private static interface Printer {
        public void starting();

        public void processing(String var1);

        public void complete(String var1);
    }
}

