/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public final class UpdaterDispatcher
implements Runnable {
    private Boolean disable = null;
    private Boolean install = null;
    private Boolean uninstall = null;
    public static final String UPDATE_DIR = "update";
    public static final String DEACTIVATE_DIR = "deactivate";
    public static final String NEW_UPDATER_DIR = "new_updater";
    public static final String DEACTIVATE_LATER = "deactivate_later.txt";
    public static final String LAST_MODIFIED = ".lastModified";

    UpdaterDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            if (this.isUninstallScheduled()) {
                ModuleDeactivator.delete();
            }
            if (this.isDisableScheduled()) {
                ModuleDeactivator.disable();
            }
            if (this.isInstallScheduled()) {
                try {
                    ModuleUpdater moduleUpdater = new ModuleUpdater(null);
                    moduleUpdater.start();
                    moduleUpdater.join();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Error: " + interruptedException);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Handling delete throws " + exception);
        }
        finally {
            UpdaterFrame.getUpdaterFrame().unpackingFinished();
        }
    }

    private boolean isDisableScheduled() {
        if (this.disable == null) {
            this.exploreUpdateDir();
        }
        return this.disable;
    }

    private boolean isUninstallScheduled() {
        if (this.uninstall == null) {
            this.exploreUpdateDir();
        }
        return this.uninstall;
    }

    private boolean isInstallScheduled() {
        if (this.install == null) {
            this.exploreUpdateDir();
        }
        return this.install;
    }

    private void exploreUpdateDir() {
        this.install = false;
        this.uninstall = false;
        this.disable = false;
        for (File file : UpdateTracking.clusters(true)) {
            File file2 = new File(file, UPDATE_DIR);
            if (!file2.exists() || !file2.isDirectory()) continue;
            if (this.install == null || !this.install.booleanValue()) {
                this.install = !ModuleUpdater.getModulesToInstall(file).isEmpty();
            }
            if (this.uninstall == null || !this.uninstall.booleanValue()) {
                this.uninstall = ModuleDeactivator.hasModulesForDelete(file2);
            }
            if (this.disable != null && this.disable.booleanValue()) continue;
            this.disable = ModuleDeactivator.hasModulesForDisable(file2);
        }
    }

    public void run() {
        this.dispatch();
        UpdaterFrame.disposeSplash();
    }

    public static void touchLastModified(File file) {
        try {
            File file2 = new File(file, LAST_MODIFIED);
            if (!file2.createNewFile()) {
                file2.setLastModified(System.currentTimeMillis());
                if (!file2.setLastModified(System.currentTimeMillis())) {
                    file2.delete();
                    file2 = new File(file, LAST_MODIFIED);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

