/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class ChildrenSupport {
    static final int NO_CHILDREN_CACHED = 0;
    static final int SOME_CHILDREN_CACHED = 1;
    static final int ALL_CHILDREN_CACHED = 2;
    private Set notExistingChildren;
    private Set existingChildren;
    private int status = 0;

    public Set getCachedChildren() {
        return this.getExisting(false);
    }

    public synchronized Set getChildren(FileNaming fileNaming, boolean bl) {
        if (bl || !this.isStatus(2)) {
            this.rescanChildren(fileNaming);
            this.setStatus(2);
        }
        return this.getExisting(false);
    }

    public boolean isCacheInitialized() {
        return !this.isStatus(0);
    }

    public synchronized FileNaming getChild(String string, FileNaming fileNaming, boolean bl) {
        FileNaming fileNaming2 = null;
        if (bl || this.isStatus(0)) {
            fileNaming2 = this.rescanChild(fileNaming, string);
        } else if (this.isStatus(1)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
            if (fileNaming2 == null && this.lookupChildInCache(fileNaming, string, false) == null) {
                fileNaming2 = this.rescanChild(fileNaming, string);
            }
        } else if (this.isStatus(2)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
        }
        this.setStatus(1);
        return fileNaming2;
    }

    public synchronized void removeChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        assert (fileNaming2.getParent().equals(fileNaming));
        this.getExisting().remove(fileNaming2);
        this.getNotExisting().add(fileNaming2);
    }

    private synchronized void addChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        assert (fileNaming2.getParent().equals(fileNaming));
        this.getExisting().add(fileNaming2);
        this.getNotExisting().remove(fileNaming2);
    }

    public synchronized Map refresh(FileNaming fileNaming) {
        Map<FileNaming, Integer> map = new HashMap();
        HashSet hashSet = new HashSet(this.getExisting(false));
        HashSet hashSet2 = new HashSet(this.getNotExisting(false));
        if (this.isStatus(1)) {
            FileNaming fileNaming2;
            Object object2;
            HashSet hashSet3 = new HashSet(hashSet);
            for (Object object2 : hashSet3) {
                fileNaming2 = this.rescanChild(fileNaming, object2.getName());
                if (fileNaming2 != null) continue;
                map.put((FileNaming)object2, ChildrenCache.REMOVED_CHILD);
            }
            HashSet hashSet4 = new HashSet(hashSet2);
            object2 = hashSet4.iterator();
            while (object2.hasNext()) {
                fileNaming2 = (FileNaming)object2.next();
                assert (fileNaming2 != null);
                FileNaming fileNaming3 = this.rescanChild(fileNaming, fileNaming2.getName());
                if (fileNaming3 == null) continue;
                map.put(fileNaming2, ChildrenCache.ADDED_CHILD);
            }
        } else if (this.isStatus(2)) {
            map = this.rescanChildren(fileNaming);
        }
        return map;
    }

    public String toString() {
        return this.getExisting(false).toString();
    }

    boolean isStatus(int n) {
        return this.status == n;
    }

    private void setStatus(int n) {
        if (this.status < n) {
            this.status = n;
        }
    }

    private FileNaming rescanChild(FileNaming fileNaming, String string) {
        FileNaming fileNaming2;
        File file = fileNaming.getFile();
        File file2 = new File(file, string);
        FileInfo fileInfo = new FileInfo(file2);
        FileNaming fileNaming3 = fileNaming2 = fileInfo.isConvertibleToFileObject() ? NamingFactory.fromFile(fileNaming, file2) : null;
        if (fileNaming2 != null) {
            this.addChild(fileNaming, fileNaming2);
        } else {
            FileName fileName = new FileName(fileNaming, file2){

                public boolean isDirectory() {
                    return false;
                }

                public boolean isFile() {
                    return false;
                }
            };
            this.removeChild(fileNaming, fileName);
        }
        return fileNaming2;
    }

    private Map rescanChildren(FileNaming fileNaming) {
        Object object3;
        Object object2;
        HashMap<FileNaming, Integer> hashMap = new HashMap<FileNaming, Integer>();
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        File file = fileNaming.getFile();
        assert (fileNaming.getFile().getAbsolutePath().equals(fileNaming.toString()));
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                object2 = new FileInfo(fileArray[i], 1);
                if (!((FileInfo)object2).isConvertibleToFileObject()) continue;
                object3 = NamingFactory.fromFile(fileNaming, fileArray[i]);
                linkedHashSet.add((FileNaming)object3);
            }
        } else if (file.exists()) {
            return hashMap;
        }
        HashSet hashSet = new HashSet(this.getExisting(false));
        hashSet.removeAll(linkedHashSet);
        for (Object object3 : hashSet) {
            this.removeChild(fileNaming, (FileNaming)object3);
            hashMap.put((FileNaming)object3, ChildrenCache.REMOVED_CHILD);
        }
        object2 = new HashSet(linkedHashSet);
        object2.removeAll(this.getExisting(false));
        object3 = object2.iterator();
        while (object3.hasNext()) {
            FileNaming fileNaming2 = (FileNaming)object3.next();
            this.addChild(fileNaming, fileNaming2);
            hashMap.put(fileNaming2, ChildrenCache.ADDED_CHILD);
        }
        return hashMap;
    }

    private FileNaming lookupChildInCache(final FileNaming fileNaming, final String string, boolean bl) {
        Set set;
        final File file = new File(fileNaming.getFile(), string);
        final Integer n = NamingFactory.createID(file);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FakeNaming
        implements FileNaming {
            public FileNaming lastEqual;

            FakeNaming() {
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public FileNaming getParent() {
                return fileNaming;
            }

            @Override
            public boolean isRoot() {
                return false;
            }

            @Override
            public File getFile() {
                return file;
            }

            @Override
            public Integer getId() {
                return n;
            }

            @Override
            public boolean rename(String string2) {
                throw new IllegalStateException();
            }

            @Override
            public boolean rename(String string2, ProvidedExtensions.IOHandler iOHandler) {
                throw new IllegalStateException();
            }

            public boolean equals(Object object) {
                if (this.hashCode() == object.hashCode()) {
                    assert (this.lastEqual == null) : "Just one can be there";
                    if (object instanceof FileNaming) {
                        this.lastEqual = (FileNaming)object;
                    }
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return n;
            }

            @Override
            public Integer getId(boolean bl) {
                return n;
            }

            @Override
            public boolean isFile() {
                return this.getFile().isFile();
            }

            @Override
            public boolean isDirectory() {
                return !this.isFile();
            }
        }
        FakeNaming fakeNaming = new FakeNaming();
        Set set2 = set = bl ? this.getExisting(false) : this.getNotExisting(false);
        if (set.contains(fakeNaming)) {
            assert (fakeNaming.lastEqual != null) : "If cache contains the object, we set lastEqual";
            return fakeNaming.lastEqual;
        }
        return null;
    }

    private synchronized Set getExisting() {
        return this.getExisting(true);
    }

    private synchronized Set getExisting(boolean bl) {
        if (bl && this.existingChildren == null) {
            this.existingChildren = new HashSet();
        }
        return this.existingChildren != null ? this.existingChildren : new HashSet();
    }

    private synchronized Set getNotExisting() {
        return this.getNotExisting(true);
    }

    private synchronized Set getNotExisting(boolean bl) {
        if (bl && this.notExistingChildren == null) {
            this.notExistingChildren = new HashSet();
        }
        return this.notExistingChildren != null ? this.notExistingChildren : new HashSet();
    }
}

