/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import java.util.List;

public class MouseOnlySortingStrategyWithUndo
implements SortingStrategy {
    private final SortingStrategy decorated = new MouseOnlySortingStrategy(true);

    public void columnClicked(SortingState sortingState, int column, int clicks, boolean shift, boolean control) {
        boolean isLastComparatorForPrimarySortColumn;
        SortingState.SortingColumn clickedColumn = sortingState.getColumns().get(column);
        if (clickedColumn.getComparators().isEmpty()) {
            return;
        }
        List<SortingState.SortingColumn> recentlyClickedColumns = sortingState.getRecentlyClickedColumns();
        boolean wasPrimarySortColumnClicked = !recentlyClickedColumns.isEmpty() && clickedColumn == recentlyClickedColumns.get(0);
        boolean isPrimarySortColumnReversed = clickedColumn.isReverse();
        boolean bl = isLastComparatorForPrimarySortColumn = clickedColumn.getComparatorIndex() == clickedColumn.getComparators().size() - 1;
        if (wasPrimarySortColumnClicked && isPrimarySortColumnReversed && isLastComparatorForPrimarySortColumn) {
            sortingState.clearComparators();
            sortingState.fireSortingChanged();
            return;
        }
        this.decorated.columnClicked(sortingState, column, clicks, shift, control);
    }
}

