# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.firewall.sections.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Rules(VapiInterface):
    """
    
    """
    CREATE_OPERATION_TOP = "insert_top"
    """
    Possible value for ``operation`` of method :func:`Rules.create`.

    """
    CREATE_OPERATION_BOTTOM = "insert_bottom"
    """
    Possible value for ``operation`` of method :func:`Rules.create`.

    """
    CREATE_OPERATION_AFTER = "insert_after"
    """
    Possible value for ``operation`` of method :func:`Rules.create`.

    """
    CREATE_OPERATION_BEFORE = "insert_before"
    """
    Possible value for ``operation`` of method :func:`Rules.create`.

    """
    CREATEMULTIPLE_OPERATION_TOP = "insert_top"
    """
    Possible value for ``operation`` of method :func:`Rules.createmultiple`.

    """
    CREATEMULTIPLE_OPERATION_BOTTOM = "insert_bottom"
    """
    Possible value for ``operation`` of method :func:`Rules.createmultiple`.

    """
    CREATEMULTIPLE_OPERATION_AFTER = "insert_after"
    """
    Possible value for ``operation`` of method :func:`Rules.createmultiple`.

    """
    CREATEMULTIPLE_OPERATION_BEFORE = "insert_before"
    """
    Possible value for ``operation`` of method :func:`Rules.createmultiple`.

    """
    LIST_FILTER_TYPE_FILTER = "FILTER"
    """
    Possible value for ``filterType`` of method :func:`Rules.list`.

    """
    LIST_FILTER_TYPE_SEARCH = "SEARCH"
    """
    Possible value for ``filterType`` of method :func:`Rules.list`.

    """
    REVISE_OPERATION_TOP = "insert_top"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_BOTTOM = "insert_bottom"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_AFTER = "insert_after"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_BEFORE = "insert_before"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.firewall.sections.rules'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RulesStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               section_id,
               firewall_rule,
               id=None,
               operation=None,
               ):
        """
        Adds a new firewall rule in existing firewall section. Adding firewall
        rule to a section modifies parent section entity and simultaneous
        update (modify) operations on same section are not allowed to prevent
        overwriting stale content to firewall section. If a concurrent update
        is performed, HTTP response code 409 will be returned to the client
        operating on stale data. That client should retrieve the firewall
        section again and re-apply its update. 
         
         Use the following Policy API - 
        PUT|PATCH
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  firewall_rule: :class:`com.vmware.nsx.model_client.FirewallRule`
        :param firewall_rule: (required)
        :type  id: :class:`str` or ``None``
        :param id: Identifier of the anchor rule or section. This is a required field
            in case operation like 'insert_before' and 'insert_after'.
            (optional)
        :type  operation: :class:`str` or ``None``
        :param operation: Operation (optional, default to insert_top)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRule`
        :return: com.vmware.nsx.model.FirewallRule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'section_id': section_id,
                            'firewall_rule': firewall_rule,
                            'id': id,
                            'operation': operation,
                            })

    def createmultiple(self,
                       section_id,
                       firewall_rule_list,
                       id=None,
                       operation=None,
                       ):
        """
        Create multiple firewall rules in existing firewall section bounded by
        limit of 1000 firewall rules per section. Adding multiple firewall
        rules in a section modifies parent section entity and simultaneous
        update (modify) operations on same section are not allowed to prevent
        overwriting stale contents to firewall section. If a concurrent update
        is performed, HTTP response code 409 will be returned to the client
        operating on stale data. That client should retrieve the firewall
        section again and re-apply its update. 
         
         Use the following Policy API - 
        PUT|PATCH
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  firewall_rule_list: :class:`com.vmware.nsx.model_client.FirewallRuleList`
        :param firewall_rule_list: (required)
        :type  id: :class:`str` or ``None``
        :param id: Identifier of the anchor rule or section. This is a required field
            in case operation like 'insert_before' and 'insert_after'.
            (optional)
        :type  operation: :class:`str` or ``None``
        :param operation: Operation (optional, default to insert_top)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRuleList`
        :return: com.vmware.nsx.model.FirewallRuleList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.createmultiple is deprecated.', DeprecationWarning)
        return self._invoke('createmultiple',
                            {
                            'section_id': section_id,
                            'firewall_rule_list': firewall_rule_list,
                            'id': id,
                            'operation': operation,
                            })

    def delete(self,
               section_id,
               rule_id,
               ):
        """
        Delete existing firewall rule in a firewall section. Deleting firewall
        rule in a section modifies parent section and simultaneous update
        (modify) operations on same section are not allowed to prevent
        overwriting stale contents to firewall section. If a concurrent update
        is performed, HTTP response code 409 will be returned to the client
        operating on stale data. That client should retrieve the firewall
        section again and re-apply its update. 
         
         Use the following Policy API - 
        DELETE
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'section_id': section_id,
                            'rule_id': rule_id,
                            })

    def get(self,
            section_id,
            rule_id,
            ):
        """
        Return existing firewall rule information in a firewall section. 
         
         Use the following Policy API - 
        GET
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRule`
        :return: com.vmware.nsx.model.FirewallRule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'section_id': section_id,
                            'rule_id': rule_id,
                            })

    def list(self,
             section_id,
             applied_tos=None,
             context_profiles=None,
             cursor=None,
             deep_search=None,
             destinations=None,
             extended_sources=None,
             filter_type=None,
             included_fields=None,
             page_size=None,
             search_invalid_references=None,
             services=None,
             sort_ascending=None,
             sort_by=None,
             sources=None,
             ):
        """
        Return all firewall rule(s) information for a given firewall section. 
         
         Use the following Policy API - 
        GET
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  applied_tos: :class:`str` or ``None``
        :param applied_tos: AppliedTo's referenced by this section or section's Distributed
            Service Rules . (optional)
        :type  context_profiles: :class:`str` or ``None``
        :param context_profiles: Limits results to sections having rules with specific Context
            Profiles. (optional)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  deep_search: :class:`bool` or ``None``
        :param deep_search: Toggle to search with direct or indirect references. (optional,
            default to false)
        :type  destinations: :class:`str` or ``None``
        :param destinations: Destinations referenced by this section's Distributed Service Rules
            . (optional)
        :type  extended_sources: :class:`str` or ``None``
        :param extended_sources: Limits results to sections having rules with specific Extended
            Sources. (optional)
        :type  filter_type: :class:`str` or ``None``
        :param filter_type: Filter type (optional, default to FILTER)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  search_invalid_references: :class:`bool` or ``None``
        :param search_invalid_references: Return invalid references in results. (optional, default to false)
        :type  services: :class:`str` or ``None``
        :param services: NSService referenced by this section's Distributed Service Rules .
            (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  sources: :class:`str` or ``None``
        :param sources: Sources referenced by this section's Distributed Service Rules .
            (optional)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRuleListResult`
        :return: com.vmware.nsx.model.FirewallRuleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'section_id': section_id,
                            'applied_tos': applied_tos,
                            'context_profiles': context_profiles,
                            'cursor': cursor,
                            'deep_search': deep_search,
                            'destinations': destinations,
                            'extended_sources': extended_sources,
                            'filter_type': filter_type,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'search_invalid_references': search_invalid_references,
                            'services': services,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'sources': sources,
                            })

    def revise(self,
               section_id,
               rule_id,
               firewall_rule,
               id=None,
               operation=None,
               ):
        """
        Modifies existing firewall rule along with relative position among
        other firewall rules inside a firewall section. Revising firewall rule
        in a section modifies parent section entity and simultaneous update
        (modify) operations on same section are not allowed to prevent
        overwriting stale contents to firewall section. If a concurrent update
        is performed, HTTP response code 409 will be returned to the client
        operating on stale data. That client should retrieve the firewall
        section again and re-apply its update. 
         
         Use the following Policy API - 
        POST
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>?action=revise

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :type  firewall_rule: :class:`com.vmware.nsx.model_client.FirewallRule`
        :param firewall_rule: (required)
        :type  id: :class:`str` or ``None``
        :param id: Identifier of the anchor rule or section. This is a required field
            in case operation like 'insert_before' and 'insert_after'.
            (optional)
        :type  operation: :class:`str` or ``None``
        :param operation: Operation (optional, default to insert_top)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRule`
        :return: com.vmware.nsx.model.FirewallRule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.revise is deprecated.', DeprecationWarning)
        return self._invoke('revise',
                            {
                            'section_id': section_id,
                            'rule_id': rule_id,
                            'firewall_rule': firewall_rule,
                            'id': id,
                            'operation': operation,
                            })

    def update(self,
               section_id,
               rule_id,
               firewall_rule,
               ):
        """
        Modifies existing firewall rule in a firewall section. Updating
        firewall rule in a section modifies parent section entity and
        simultaneous update (modify) operations on same section are not allowed
        to prevent overwriting stale contents to firewall section. If a
        concurrent update is performed, HTTP response code 409 will be returned
        to the client operating on stale data. That client should retrieve the
        firewall section again and re-apply its update. 
         
         Use the following Policy API - 
        PUT|PATCH
        /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :type  firewall_rule: :class:`com.vmware.nsx.model_client.FirewallRule`
        :param firewall_rule: (required)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallRule`
        :return: com.vmware.nsx.model.FirewallRule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.Rules.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'section_id': section_id,
                            'rule_id': rule_id,
                            'firewall_rule': firewall_rule,
                            })
class State(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.firewall.sections.state'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StateStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            section_id,
            barrier_id=None,
            request_id=None,
            ):
        """
        Return realized state information of a firewall section. 
         
         Use the following Policy APIs - 
        GET
        /policy/api/v1/infra/realized-state/realized-entities?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>
        GET
        /policy/api/v1/infra/realized-state/status?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>

        .. deprecated:: unknown

        :type  section_id: :class:`str`
        :param section_id: (required)
        :type  barrier_id: :class:`long` or ``None``
        :param barrier_id: (optional)
        :type  request_id: :class:`str` or ``None``
        :param request_id: Realization request ID (optional)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallSectionState`
        :return: com.vmware.nsx.model.FirewallSectionState
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.firewall.sections.State.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'section_id': section_id,
                            'barrier_id': barrier_id,
                            'request_id': request_id,
                            })
class Summary(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Summary.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Summary.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.firewall.sections.summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            source=None,
            ):
        """
        List the summary of number of sections and number of rules for each
        firewall category (L2DFW, L3DFW).

        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx.model_client.FirewallSectionsSummaryList`
        :return: com.vmware.nsx.model.FirewallSectionsSummaryList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'source': source,
                            })
class _RulesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'firewall_rule': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
            'id': type.OptionalType(type.StringType()),
            'operation': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        create_output_validator_list = [
            HasFieldsOfValidator()
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/firewall/sections/{section-id}/rules',
            request_body_parameter='firewall_rule',
            path_variables={
                'section_id': 'section-id',
            },
             header_parameters={
                     },
            query_parameters={
                'id': 'id',
                'operation': 'operation',
            },
            content_type='application/json'
        )

        # properties for createmultiple operation
        createmultiple_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'firewall_rule_list': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRuleList'),
            'id': type.OptionalType(type.StringType()),
            'operation': type.OptionalType(type.StringType()),
        })
        createmultiple_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        createmultiple_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        createmultiple_output_validator_list = [
            HasFieldsOfValidator()
        ]
        createmultiple_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/firewall/sections/{section-id}/rules?action=create_multiple',
            request_body_parameter='firewall_rule_list',
            path_variables={
                'section_id': 'section-id',
            },
             header_parameters={
                     },
            query_parameters={
                'id': 'id',
                'operation': 'operation',
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'rule_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/firewall/sections/{section-id}/rules/{rule-id}',
            path_variables={
                'section_id': 'section-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'rule_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/firewall/sections/{section-id}/rules/{rule-id}',
            path_variables={
                'section_id': 'section-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'applied_tos': type.OptionalType(type.StringType()),
            'context_profiles': type.OptionalType(type.StringType()),
            'cursor': type.OptionalType(type.StringType()),
            'deep_search': type.OptionalType(type.BooleanType()),
            'destinations': type.OptionalType(type.StringType()),
            'extended_sources': type.OptionalType(type.StringType()),
            'filter_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'search_invalid_references': type.OptionalType(type.BooleanType()),
            'services': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'sources': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/firewall/sections/{section-id}/rules',
            path_variables={
                'section_id': 'section-id',
            },
             header_parameters={
                                           },
            query_parameters={
                'applied_tos': 'applied_tos',
                'context_profiles': 'context_profiles',
                'cursor': 'cursor',
                'deep_search': 'deep_search',
                'destinations': 'destinations',
                'extended_sources': 'extended_sources',
                'filter_type': 'filter_type',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'search_invalid_references': 'search_invalid_references',
                'services': 'services',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'sources': 'sources',
            },
            content_type='application/json'
        )

        # properties for revise operation
        revise_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'rule_id': type.StringType(),
            'firewall_rule': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
            'id': type.OptionalType(type.StringType()),
            'operation': type.OptionalType(type.StringType()),
        })
        revise_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        revise_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        revise_output_validator_list = [
            HasFieldsOfValidator()
        ]
        revise_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/firewall/sections/{section-id}/rules/{rule-id}?action=revise',
            request_body_parameter='firewall_rule',
            path_variables={
                'section_id': 'section-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                       },
            query_parameters={
                'id': 'id',
                'operation': 'operation',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'rule_id': type.StringType(),
            'firewall_rule': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/firewall/sections/{section-id}/rules/{rule-id}',
            request_body_parameter='firewall_rule',
            path_variables={
                'section_id': 'section-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'createmultiple': {
                'input_type': createmultiple_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRuleList'),
                'errors': createmultiple_error_dict,
                'input_value_validator_list': createmultiple_input_value_validator_list,
                'output_validator_list': createmultiple_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRuleListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'revise': {
                'input_type': revise_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
                'errors': revise_error_dict,
                'input_value_validator_list': revise_input_value_validator_list,
                'output_validator_list': revise_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallRule'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'createmultiple': createmultiple_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'revise': revise_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.firewall.sections.rules',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'section_id': type.StringType(),
            'barrier_id': type.OptionalType(type.IntegerType()),
            'request_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/firewall/sections/{section-id}/state',
            path_variables={
                'section_id': 'section-id',
            },
             header_parameters={
                   },
            query_parameters={
                'barrier_id': 'barrier_id',
                'request_id': 'request_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallSectionState'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.firewall.sections.state',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _SummaryStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'source': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/firewall/sections/summary',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FirewallSectionsSummaryList'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.firewall.sections.summary',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Rules': Rules,
        'State': State,
        'Summary': Summary,
        'rules': 'com.vmware.nsx.firewall.sections.rules_client.StubFactory',
    }

