/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.TimeUnit;

final class RecurrenceUtility {
    private static final TimeUnit[] DURATION_UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.WEEKS, TimeUnit.HOURS, TimeUnit.MINUTES};
    private static final Map<TimeUnit, Integer> UNITS_MAP = new HashMap<TimeUnit, Integer>();
    private static final Map<Integer, RecurrenceType> RECURRENCE_TYPE_MAP;
    private static final Map<RecurrenceType, Integer> RECURRENCE_VALUE_MAP;
    private static final Day[] DAY_ARRAY;
    private static final Map<Day, Integer> DAY_MAP;
    public static final int[] RECURRING_TASK_DAY_MASKS;

    private RecurrenceUtility() {
    }

    public static Duration getDuration(ProjectProperties projectProperties, Integer n, Integer n2) {
        Duration duration;
        if (n == null) {
            duration = null;
        } else {
            duration = Duration.getInstance(n, TimeUnit.MINUTES);
            TimeUnit timeUnit = RecurrenceUtility.getDurationUnits(n2);
            if (duration.getUnits() != timeUnit) {
                duration = duration.convertUnits(timeUnit, projectProperties);
            }
        }
        return duration;
    }

    public static Integer getDurationValue(ProjectProperties projectProperties, Duration duration) {
        Integer n;
        if (duration == null) {
            n = null;
        } else {
            if (duration.getUnits() != TimeUnit.MINUTES) {
                duration = duration.convertUnits(TimeUnit.MINUTES, projectProperties);
            }
            n = (int)duration.getDuration();
        }
        return n;
    }

    public static Integer getDurationUnits(RecurringTask recurringTask) {
        Duration duration = recurringTask.getDuration();
        Integer n = null;
        if (duration != null) {
            n = UNITS_MAP.get(duration.getUnits());
        }
        return n;
    }

    private static TimeUnit getDurationUnits(Integer n) {
        int n2;
        TimeUnit timeUnit = null;
        if (n != null && (n2 = n.intValue()) >= 0 && n2 < DURATION_UNITS.length) {
            timeUnit = DURATION_UNITS[n2];
        }
        if (timeUnit == null) {
            timeUnit = TimeUnit.DAYS;
        }
        return timeUnit;
    }

    public static RecurrenceType getRecurrenceType(Integer n) {
        return RECURRENCE_TYPE_MAP.get(n);
    }

    public static Integer getRecurrenceValue(RecurrenceType recurrenceType) {
        return RECURRENCE_VALUE_MAP.get(recurrenceType);
    }

    public static Integer getDays(String string) {
        Integer n = null;
        if (string != null) {
            n = Integer.parseInt(string, 2);
        }
        return n;
    }

    public static String getDays(RecurringTask recurringTask) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Day day : Day.values()) {
            stringBuilder.append(recurringTask.getWeeklyDay(day) ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public static Day getDay(Integer n) {
        Day day = null;
        if (n != null) {
            day = DAY_ARRAY[n];
        }
        return day;
    }

    public static Integer getDay(Day day) {
        Integer n = null;
        if (day != null) {
            n = DAY_MAP.get(day);
        }
        return n;
    }

    public static Date getYearlyAbsoluteAsDate(RecurringData recurringData) {
        Date date;
        Integer n = recurringData.getDayNumber();
        Integer n2 = recurringData.getMonthNumber();
        Date date2 = recurringData.getStartDate();
        if (n == null || n2 == null || date2 == null) {
            date = null;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            calendar.set(2, n2 - 1);
            calendar.set(5, n);
            date = calendar.getTime();
        }
        return date;
    }

    static {
        for (int i = 0; i < DURATION_UNITS.length; ++i) {
            UNITS_MAP.put(DURATION_UNITS[i], i);
        }
        RECURRENCE_TYPE_MAP = new HashMap<Integer, RecurrenceType>();
        RECURRENCE_TYPE_MAP.put(1, RecurrenceType.DAILY);
        RECURRENCE_TYPE_MAP.put(4, RecurrenceType.WEEKLY);
        RECURRENCE_TYPE_MAP.put(8, RecurrenceType.MONTHLY);
        RECURRENCE_TYPE_MAP.put(16, RecurrenceType.YEARLY);
        RECURRENCE_VALUE_MAP = new HashMap<RecurrenceType, Integer>();
        RECURRENCE_VALUE_MAP.put(RecurrenceType.DAILY, 1);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.WEEKLY, 4);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.MONTHLY, 8);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.YEARLY, 16);
        DAY_ARRAY = new Day[]{null, Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY, Day.SATURDAY, Day.SUNDAY};
        DAY_MAP = new HashMap<Day, Integer>();
        DAY_MAP.put(Day.MONDAY, 1);
        DAY_MAP.put(Day.TUESDAY, 2);
        DAY_MAP.put(Day.WEDNESDAY, 3);
        DAY_MAP.put(Day.THURSDAY, 4);
        DAY_MAP.put(Day.FRIDAY, 5);
        DAY_MAP.put(Day.SATURDAY, 6);
        DAY_MAP.put(Day.SUNDAY, 7);
        RECURRING_TASK_DAY_MASKS = new int[]{0, 64, 32, 16, 8, 4, 2, 1};
    }
}

