/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CalendarFactory;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

abstract class AbstractCalendarFactory
implements CalendarFactory {
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private final ProjectFile m_file;

    public AbstractCalendarFactory(ProjectFile projectFile) {
        this.m_file = projectFile;
    }

    @Override
    public void processCalendarData(DirectoryEntry directoryEntry, Props props, DocumentInputStreamFactory documentInputStreamFactory, HashMap<Integer, ProjectCalendar> hashMap) throws IOException {
        DirectoryEntry directoryEntry2 = (DirectoryEntry)directoryEntry.getEntry("TBkndCal");
        VarMeta varMeta = this.getCalendarVarMeta(directoryEntry2);
        Var2Data var2Data = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, documentInputStreamFactory.getInstance(directoryEntry2, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> hashMap2 = new HashMap<Integer, ProjectCalendar>();
        int n = fixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> linkedList = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] byArray = props.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar projectCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(byArray, null, projectCalendar, true);
        EventManager eventManager = this.m_file.getEventManager();
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = fixedData.getByteArrayValue(i);
            if (byArray2 == null || byArray2.length < 8) continue;
            int n2 = 0;
            while (n2 + 12 <= byArray2.length) {
                Integer n3 = MPPUtility.getInt(byArray2, n2 + this.getCalendarIDOffset());
                int n4 = MPPUtility.getInt(byArray2, n2 + this.getBaseIDOffset());
                if (n3 > 0 && !hashMap2.containsKey(n3)) {
                    ProjectCalendar projectCalendar2;
                    byte[] byArray3 = var2Data.getByteArray(n3, this.getCalendarDataVarDataType());
                    if (n4 == 0 || n4 == -1 || n4 == n3) {
                        if (byArray3 != null || byArray != null) {
                            projectCalendar2 = this.m_file.addCalendar();
                            if (byArray3 == null) {
                                byArray3 = byArray;
                            }
                        } else {
                            projectCalendar2 = this.m_file.addDefaultBaseCalendar();
                        }
                        projectCalendar2.setName(var2Data.getUnicodeString(n3, this.getCalendarNameVarDataType()));
                    } else {
                        projectCalendar2 = byArray3 != null ? this.m_file.addCalendar() : this.m_file.addDefaultDerivedCalendar();
                        linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar2, n4));
                        Integer n5 = MPPUtility.getInt(byArray2, n2 + this.getResourceIDOffset());
                        hashMap.put(n5, projectCalendar2);
                    }
                    projectCalendar2.setUniqueID(n3);
                    if (byArray3 != null) {
                        this.processCalendarHours(byArray3, projectCalendar, projectCalendar2, n4 == -1);
                        this.processCalendarExceptions(byArray3, projectCalendar2);
                    }
                    hashMap2.put(n3, projectCalendar2);
                    eventManager.fireCalendarReadEvent(projectCalendar2);
                }
                n2 += 12;
            }
        }
        this.updateBaseCalendarNames(linkedList, hashMap2);
    }

    private void processCalendarHours(byte[] byArray, ProjectCalendar projectCalendar, ProjectCalendar projectCalendar2, boolean bl) {
        ArrayList<DateRange> arrayList = new ArrayList<DateRange>(5);
        for (int i = 0; i < 7; ++i) {
            int n;
            ProjectCalendarHours projectCalendarHours;
            int n2 = this.getCalendarHoursOffset() + 60 * i;
            int n3 = byArray == null ? 1 : MPPUtility.getShort(byArray, n2);
            Day day = Day.getInstance(i + 1);
            if (n3 == 1) {
                if (bl) {
                    if (projectCalendar == null) {
                        projectCalendar2.setWorkingDay(day, DEFAULT_WORKING_WEEK[i]);
                        if (!projectCalendar2.isWorkingDay(day)) continue;
                        projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    n = projectCalendar.isWorkingDay(day);
                    projectCalendar2.setWorkingDay(day, n != 0);
                    if (n == 0) continue;
                    projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                    for (Comparable<DateRange> comparable : projectCalendar.getHours(day)) {
                        projectCalendarHours.addRange((DateRange)comparable);
                    }
                    continue;
                }
                projectCalendar2.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            arrayList.clear();
            int n4 = MPPUtility.getShort(byArray, n2 + 2);
            for (int j = 0; j < n4; ++j) {
                Comparable<DateRange> comparable;
                n = n2 + 8 + j * 2;
                Date date = MPPUtility.getTime(byArray, n);
                int n5 = n2 + 20 + j * 4;
                long l = MPPUtility.getDuration(byArray, n5);
                comparable = new Date(date.getTime() + l);
                arrayList.add(new DateRange(date, (Date)comparable));
            }
            if (arrayList.isEmpty()) {
                projectCalendar2.setWorkingDay(day, false);
                continue;
            }
            projectCalendar2.setWorkingDay(day, true);
            projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
            for (DateRange dateRange : arrayList) {
                projectCalendarHours.addRange(dateRange);
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> list, HashMap<Integer, ProjectCalendar> hashMap) {
        for (Pair<ProjectCalendar, Integer> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = hashMap.get(n);
            if (projectCalendar2 != null && projectCalendar2.getName() != null) {
                projectCalendar.setParent(projectCalendar2);
                continue;
            }
            this.m_file.removeCalendar(projectCalendar);
        }
    }

    protected abstract int getCalendarIDOffset();

    protected abstract int getBaseIDOffset();

    protected abstract int getResourceIDOffset();

    protected abstract VarMeta getCalendarVarMeta(DirectoryEntry var1) throws IOException;

    protected abstract int getCalendarHoursOffset();

    protected abstract Integer getCalendarNameVarDataType();

    protected abstract Integer getCalendarDataVarDataType();

    protected abstract void processCalendarExceptions(byte[] var1, ProjectCalendar var2);
}

