/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.network;

import com.projectlibre1.pm.graphic.graph.GraphRenderer;
import com.projectlibre1.pm.graphic.graph.GraphUI;
import com.projectlibre1.pm.graphic.graph.GraphZone;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.network.Network;
import com.projectlibre1.pm.graphic.network.NetworkRenderer;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.List;
import java.util.ListIterator;

public abstract class NetworkUI
extends GraphUI {
    public NetworkUI(Network network, GraphRenderer graphRenderer) {
        super(network, graphRenderer);
    }

    public int getZoom() {
        return ((Network)this.getGraph()).getZoom();
    }

    void resetForms() {
        ((NetworkRenderer)this.graphRenderer).resetForms();
    }

    @Override
    public boolean isEditing(GraphicNode graphicNode) {
        return ((NetworkRenderer)this.graphRenderer).getEditor().isEditing(graphicNode);
    }

    public void editNode(GraphicNode graphicNode) {
        ((NetworkRenderer)this.graphRenderer).getEditor().initEditorComponent(graphicNode, this.getZoom(), graphicNode == null ? null : ((NetworkRenderer)this.graphRenderer).getBounds(graphicNode));
    }

    public List getEditorChange() {
        return ((NetworkRenderer)this.graphRenderer).getEditor().getCellEditorChange();
    }

    public GraphicNode getEditorNode() {
        return ((NetworkRenderer)this.graphRenderer).getEditor().getNode();
    }

    @Override
    public GraphZone getNodeAt(double d, double d2) {
        ListIterator listIterator = this.graph.getModel().getNodeIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            GeneralPath generalPath = ((NetworkRenderer)this.graphRenderer).getShape(graphicNode);
            if (generalPath == null || !generalPath.contains(d, d2)) continue;
            return graphicNode == null ? null : new GraphZone(graphicNode);
        }
        return null;
    }

    public boolean isOnBarEdge(GraphicNode graphicNode, double d, double d2) {
        double d3 = this.config.getNetworkCellSelectionSquare();
        GeneralPath generalPath = ((NetworkRenderer)this.graphRenderer).getShape(graphicNode);
        double d4 = -1.0;
        double d5 = -1.0;
        double d6 = -1.0;
        double d7 = -1.0;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(this.segment);
            switch (n) {
                case 0: {
                    d6 = this.segment[0];
                    d7 = this.segment[1];
                    d4 = d6;
                    d5 = d7;
                }
                case 1: 
                case 4: {
                    double d8 = n == 4 ? d6 : this.segment[0];
                    double d9 = n == 4 ? d7 : this.segment[1];
                    if (!(Line2D.ptSegDist(d4, d5, d8, d9, d, d2) <= d3)) break;
                    return true;
                }
            }
            d4 = this.segment[0];
            d5 = this.segment[1];
            pathIterator.next();
        }
        return false;
    }

    @Override
    public void updateShapes() {
    }
}

