/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.job;

import com.projectlibre1.job.ExtendedProgressMonitor;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobQueueEvent;
import com.projectlibre1.job.JobQueueListener;
import com.projectlibre1.util.Environment;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.commons.collections.Closure;

public class JobQueue
extends ThreadGroup {
    public static final int MAX_PROGRESS = 10000;
    protected boolean documentBased = false;
    private Set<String> executingJobs = Collections.synchronizedSet(new HashSet());
    protected EventListenerList queueListenerList = new EventListenerList();
    protected Object criticalSectionMutex = new Object();
    protected Job criticalSectionOwner;
    private static final String GRAPHIC_MANAGER = "com.projectlibre1.pm.graphic.frames.GraphicManager";

    public JobQueue(String string, boolean bl) {
        super(string);
        this.documentBased = bl;
    }

    public boolean hasNext() {
        return this.activeCount() != 0;
    }

    public synchronized void startNext() {
        Thread[] threadArray;
        if (this.hasNext() && this.enumerate(threadArray = new Thread[1]) == 1) {
            threadArray[0].start();
        }
    }

    public synchronized void cancel() {
        int n = this.activeCount();
        if (n == 0) {
            return;
        }
        Thread[] threadArray = new Thread[n];
        n = this.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!(threadArray[i] instanceof Job)) continue;
            ((Job)threadArray[i]).cancel();
        }
    }

    public void addExecutingJob(Job job) {
        this.executingJobs.add(job.getName());
    }

    public void removeExecutingJob(Job job) {
        this.executingJobs.remove(job.getName());
    }

    public void schedule(Job job) {
        if (this.executingJobs.contains(job.getName())) {
            return;
        }
        job.execute();
    }

    public ExtendedProgressMonitor getProgressMonitor(String string, Component component) {
        if (component == null) {
            component = this.getComponent();
        }
        if (component == null) {
            return null;
        }
        ExtendedProgressMonitor extendedProgressMonitor = new ExtendedProgressMonitor(component, string, "", 0, 10000);
        extendedProgressMonitor.setProgress(0);
        extendedProgressMonitor.setMillisToPopup(0);
        extendedProgressMonitor.setMillisToDecideToPopup(0);
        return extendedProgressMonitor;
    }

    protected void enableComponent(boolean bl) {
        if (this.getComponent() == null) {
            return;
        }
        this.getComponent().setEnabled(bl);
    }

    public void addListener(JobQueueListener jobQueueListener) {
        this.queueListenerList.add(JobQueueListener.class, jobQueueListener);
    }

    public void removeListener(JobQueueListener jobQueueListener) {
        this.queueListenerList.remove(JobQueueListener.class, jobQueueListener);
    }

    public JobQueueListener[] getListeners() {
        return (JobQueueListener[])this.queueListenerList.getListeners(JobQueueListener.class);
    }

    public EventListener[] getListeners(Class clazz) {
        return this.queueListenerList.getListeners(clazz);
    }

    protected void fireProgressChanged(Object object, float f) {
        Object[] objectArray = this.queueListenerList.getListenerList();
        JobQueueEvent jobQueueEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JobQueueListener.class) continue;
            if (jobQueueEvent == null) {
                jobQueueEvent = new JobQueueEvent(object, f);
            }
            ((JobQueueListener)objectArray[i + 1]).progressChanged(jobQueueEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCriticalSectionClosure(Job job, Closure closure, Object object) {
        Object object2 = this.criticalSectionMutex;
        synchronized (object2) {
            if (this.criticalSectionOwner == job) {
                closure.execute(object);
                return true;
            }
            System.out.println(job.getName() + " can execute, lost critical section");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCriticalSection(Job job) {
        Object object = this.criticalSectionMutex;
        synchronized (object) {
            while (this.criticalSectionOwner != null && this.criticalSectionOwner.isQueued()) {
                try {
                    this.criticalSectionMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.criticalSectionOwner = job;
            job.logBegin("Critical section");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCriticalSection(Job job) {
        Object object = this.criticalSectionMutex;
        synchronized (object) {
            job.logEnd("Critical section");
            if (this.criticalSectionOwner == job) {
                this.criticalSectionOwner = null;
                this.criticalSectionMutex.notify();
            }
        }
    }

    public Component getComponent() {
        if (!Environment.isVisible()) {
            return null;
        }
        String string = this.documentBased ? "getDocumentFrameInstance" : "getFrameInstance";
        try {
            return (Frame)Class.forName(GRAPHIC_MANAGER).getMethod(string, null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

