/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class TwoItemIterator
implements SequenceIterator,
LookaheadIterator,
GroundedIterator,
LastPositionFinder {
    private final Item one;
    private final Item two;
    private int pos = 0;

    public TwoItemIterator(Item one, Item two) {
        this.one = one;
        this.two = two;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.pos < 2;
    }

    @Override
    public Item next() {
        switch (this.pos++) {
            case 0: {
                return this.one;
            }
            case 1: {
                return this.two;
            }
        }
        return null;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public GroundedValue getResidue() {
        switch (this.pos) {
            case 0: {
                return new SequenceExtent.Of(new Item[]{this.one, this.two});
            }
            case 1: {
                return this.two;
            }
        }
        return EmptySequence.getInstance();
    }
}

