/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.regex.charclass.IntSetCharacterClass;
import net.sf.saxon.regex.charclass.SingletonCharacterClass;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonIterator;

public class OpAtom
extends Operation {
    private final UnicodeString atom;
    private final int len;

    OpAtom(UnicodeString atom) {
        this.atom = atom;
        this.len = atom.length32();
    }

    UnicodeString getAtom() {
        return this.atom;
    }

    @Override
    public int getMatchLength() {
        return this.len;
    }

    @Override
    public int matchesEmptyString() {
        return this.len == 0 ? 7 : 1024;
    }

    @Override
    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        int ch;
        int[] variants;
        if (this.len == 0) {
            return EmptyCharacterClass.getInstance();
        }
        if (caseBlind && (variants = CaseVariants.getCaseVariants(ch = this.atom.codePointAt(0L))).length > 0) {
            IntHashSet set = new IntHashSet(variants.length);
            ((IntSet)set).add(ch);
            for (int v : variants) {
                ((IntSet)set).add(v);
            }
            return new IntSetCharacterClass(set);
        }
        return new SingletonCharacterClass(this.atom.codePointAt(0L));
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        UnicodeString in = matcher.search;
        if ((long)(position + this.len) > in.length()) {
            return EmptyIntIterator.getInstance();
        }
        if (matcher.program.flags.isCaseIndependent()) {
            for (int i = 0; i < this.len; ++i) {
                if (matcher.equalCaseBlind(in.codePointAt(position + i), this.atom.codePointAt(i))) continue;
                return EmptyIntIterator.getInstance();
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                if (in.codePointAt(position + i) == this.atom.codePointAt(i)) continue;
                return EmptyIntIterator.getInstance();
            }
        }
        return new IntSingletonIterator(position + this.len);
    }

    @Override
    public String display() {
        return this.atom.toString();
    }
}

