/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class Translate
extends SystemFunction
implements Callable,
StatefulSystemFunction {
    private IntToIntMap staticMap = null;

    @Override
    public Expression fixArguments(Expression ... arguments) {
        if (arguments[1] instanceof StringLiteral && arguments[2] instanceof StringLiteral) {
            this.staticMap = Translate.buildMap(((StringLiteral)arguments[1]).getGroundedValue(), ((StringLiteral)arguments[2]).getGroundedValue());
        }
        return null;
    }

    public IntToIntMap getStaticMap() {
        return this.staticMap;
    }

    public static StringValue translate(StringValue sv0, StringValue sv1, StringValue sv2) {
        if (sv0.length() * sv1.length() > 1000L) {
            return Translate.translateUsingMap(sv0, Translate.buildMap(sv1, sv2));
        }
        UnicodeBuilder sb = new UnicodeBuilder(sv0.length32());
        long s2len = sv2.length();
        IntIterator iter = sv0.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            long j = sv1.getContent().indexOf(c, 0L);
            if (j >= s2len) continue;
            sb.append(j < 0L ? c : sv2.getContent().codePointAt(j));
        }
        return new StringValue(sb.toUnicodeString());
    }

    private static IntToIntMap buildMap(StringValue arg1, StringValue arg2) {
        IntToIntHashMap map = new IntToIntHashMap(arg1.length32(), 0.5);
        IntIterator iter = arg1.codePoints();
        long arg2len = arg2.length();
        long i = 0L;
        while (iter.hasNext()) {
            int ch = iter.next();
            if (!map.contains(ch)) {
                map.put(ch, i >= arg2len ? -1 : arg2.getContent().codePointAt(i));
            }
            ++i;
        }
        return map;
    }

    public static StringValue translateUsingMap(StringValue in, IntToIntMap map) {
        UnicodeBuilder builder = new UnicodeBuilder(in.length32());
        IntIterator iter = in.codePoints();
        while (iter.hasNext()) {
            int c = iter.next();
            int newchar = map.get(c);
            if (newchar == Integer.MAX_VALUE) {
                newchar = c;
            }
            if (newchar == -1) continue;
            builder.append(newchar);
        }
        return new StringValue(builder.toUnicodeString());
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue sv0 = (StringValue)arguments[0].head();
        if (sv0 == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.staticMap != null) {
            return Translate.translateUsingMap(sv0, this.staticMap);
        }
        StringValue sv1 = (StringValue)arguments[1].head();
        StringValue sv2 = (StringValue)arguments[2].head();
        return Translate.translate(sv0, sv1, sv2);
    }

    @Override
    public String getCompilerName() {
        return "TranslateCompiler";
    }

    @Override
    public Translate copy() {
        Translate copy = (Translate)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        copy.staticMap = this.staticMap;
        return copy;
    }
}

