#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD6',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::ShotInfoZ7II',
	'Image::ExifTool::Nikon::ShotInfoZ9',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 500 => 'about' },
	'aboutcvterm' => { 492 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 492 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 492 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 492 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 492 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 506 => 'absPeakAudioFilePath' },
	'academicfield' => { 496 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 487 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 392 => 0x3 },
	'accelerometerdata' => { 382 => 'vrot' },
	'accelerometerx' => { 322 => 0x8d },
	'accelerometery' => { 322 => 0x8e },
	'accelerometerz' => { 322 => 0x8c },
	'accessoryserialnumber' => { 322 => 0x54 },
	'accessorytype' => { 322 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 227 => 0x22, 272 => 0x24 },
	'actived-lightingmode' => { 272 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 492 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 399 => 0x15 },
	'adlbracketingstep' => { 250 => 0x883 },
	'adlbracketingtype' => { 250 => 0x884 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 309 => 'AdultContentWarning', 499 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 274 => 0x76a43203 },
	'advancedscenetype' => { 322 => 0x3d },
	'advisory' => { 504 => 'Advisory' },
	'ae_iso' => { 330 => 0x2, 331 => 0x4, 332 => 0x12 },
	'aeaperture' => { 330 => 0x1, 331 => 0x3, 332 => 0x11 },
	'aeaperturesteps' => { 330 => 0x8, 331 => 0xb },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 249 => 0x174c, 250 => 0x87b, 259 => 0x1756 },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 330 => 0x4, 331 => 0x6 },
	'aeerror' => { 331 => 0x8 },
	'aeexposuretime' => { 330 => 0x0, 331 => 0x2, 332 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 283 => '4.2', 292 => '4.2', 299 => 0x201, 357 => 0x48, 409 => 0x40, 410 => 0x40, 411 => [0x86,0x286] },
	'aelockbutton' => { 281 => '16.1', 283 => '4.1', 286 => '15.1', 287 => '16.1', 288 => '16.1', 290 => '30.1', 291 => '16.1', 292 => '4.1', 294 => '17.1', 296 => '17.1' },
	'aelockbuttonplusdials' => { 281 => '16.2', 290 => '32.1', 294 => '44.1' },
	'aelockformb-d80' => { 296 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aemaxaperture' => { 330 => 0x9, 331 => 0x10, 332 => 0x1c },
	'aemaxaperture2' => { 330 => 0xa, 331 => 0x11, 332 => 0x1d },
	'aemeteringmode' => { 330 => 0xc },
	'aemeteringmode2' => { 330 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 357 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 330 => 0xb, 331 => 0x12, 332 => 0x1e },
	'aeminexposuretime' => { 330 => 0x5, 331 => 0x13, 332 => 0x1f },
	'aeprogrammode' => { 330 => 0x6 },
	'aeprojectlink' => { 481 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 481 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 481 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 481 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 481 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 481 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 330 => 0xd },
	'aexv' => { 330 => 0x3, 331 => 0x5 },
	'af-assistilluminator' => { 297 => 0x19 },
	'af-cfocusdisplay' => { 297 => 0x234 },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 281 => '1.1', 282 => '1.1', 284 => '1.1', 285 => '1.1', 287 => '0.1', 288 => '0.1', 289 => '0.1', 290 => '1.1', 291 => '0.1', 294 => '1.1', 295 => '1.1', 297 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 284 => '70.1', 285 => '70.1', 295 => '70.1' },
	'af-onformb-d10' => { 281 => '3.3', 290 => '3.2' },
	'af-onformb-d11' => { 291 => '2.2' },
	'af-onformb-d12' => { 294 => '50.1' },
	'af-onoutoffocusrelease' => { 297 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 281 => '1.2', 282 => '1.2', 284 => '1.2', 285 => '1.2', 289 => '0.2', 290 => '1.2', 291 => '0.2', 294 => '1.2', 295 => '1.2', 297 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 281 => '2.1', 282 => '2.1', 284 => '78.3', 285 => '78.3', 290 => '2.1', 294 => '2.1', 295 => '78.3', 297 => 0xf },
	'afadjustment' => { 357 => 0x72, 366 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 220 => 0x5, 221 => 0x5, 225 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 292 => '15.3' },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 230 => 0x210, 322 => 0xf, 389 => 0x1205, 402 => [0xa,0x3a], 409 => 0x11, 410 => 0x10, 411 => 0x24, 422 => 0xb043, 447 => 0x17 },
	'afareamodesetting' => { 283 => '11.1', 286 => '0.1', 292 => '16.1', 296 => '2.1', 422 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 299 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 389 => 0x1203 },
	'afareaxposition1' => { 389 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 389 => 0x1204 },
	'afareayposition1' => { 389 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 281 => '2.5', 283 => '0.2', 286 => '0.2', 287 => '1.1', 288 => '1.1', 289 => '1.3', 290 => '2.4', 291 => '1.3', 292 => '0.2', 294 => '2.4', 296 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 322 => 0x31 },
	'afbuttonpressed' => { 411 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 333 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 474 => 'AffineA' },
	'affineb' => { 474 => 'AffineB' },
	'affinec' => { 474 => 'AffineC' },
	'affined' => { 474 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 230 => 0x5b0, 299 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 242 => 0x2d1, 243 => 0x2dc, 299 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 474 => 'AffineX' },
	'affiney' => { 474 => 'AffineY' },
	'affocuspointxposition' => { 193 => 0x2f },
	'affocuspointyposition' => { 193 => 0x31 },
	'afhold' => { 333 => 0x1fd },
	'afilluminator' => { 409 => 0x29, 422 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 333 => 0x7 },
	'afmicroadj' => { 402 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 406 => 0x131 },
	'afmicroadjregisteredlenses' => { 406 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 406 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 399 => 0x5 },
	'afmoderestrictions' => { 282 => '50.3', 284 => '48.3', 285 => '48.3', 294 => '48.3', 295 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 281 => '3.1', 282 => '47.1', 297 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 302 => 0x308, 399 => 0x1f, 402 => [0x37,0x7], 406 => 0x19, 407 => 0x18, 408 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 402 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 281 => '2.4', 282 => '46.5', 284 => '2.2', 285 => '2.2', 294 => '2.3', 295 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 281 => '2.3', 282 => '46.2', 284 => '47.2', 285 => '47.2', 289 => '1.2', 290 => '2.3', 291 => '1.2', 294 => '47.2', 295 => '47.2', 296 => '2.4' },
	'afpointinfocus' => { 402 => [0x38,0x8] },
	'afpointmode' => { 338 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 322 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 297 => 0xb },
	'afpointselected' => { 184 => 0xd, 299 => 0x305, 357 => 0xe, 406 => 0x15, 407 => 0x14, 408 => [0x14,0x1c], 422 => 0x201e },
	'afpointselected2' => { 338 => 0x4 },
	'afpointselection' => { 83 => 0xb, 281 => '1.3', 282 => '1.3', 290 => '1.3', 294 => '1.3', 295 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 409 => 0x12, 410 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 333 => 0xb, 334 => 0x4, 357 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 334 => '4.1', 455 => 0x4 },
	'afpointsspecial' => { 334 => '4.2' },
	'afpointsunknown1' => { 333 => 0x0 },
	'afpointsunknown2' => { 333 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 402 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 333 => 0x4 },
	'afresponse' => { 227 => 0xad },
	'afresult' => { 304 => 0x1038 },
	'afsearch' => { 299 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstatus' => { 389 => 0x1200 },
	'afstatus_00_b4' => { 405 => 0x0 },
	'afstatus_01_c4' => { 405 => 0x2 },
	'afstatus_02_d4' => { 405 => 0x4 },
	'afstatus_03_e4' => { 405 => 0x6 },
	'afstatus_04_f4' => { 405 => 0x8 },
	'afstatus_05_g4' => { 405 => 0xa },
	'afstatus_06_h4' => { 405 => 0xc },
	'afstatus_07_b3' => { 405 => 0xe },
	'afstatus_08_c3' => { 405 => 0x10 },
	'afstatus_09_d3' => { 405 => 0x12 },
	'afstatus_10_e3' => { 405 => 0x14 },
	'afstatus_11_f3' => { 405 => 0x16 },
	'afstatus_12_g3' => { 405 => 0x18 },
	'afstatus_13_h3' => { 405 => 0x1a },
	'afstatus_14_b2' => { 405 => 0x1c },
	'afstatus_15_c2' => { 405 => 0x1e },
	'afstatus_16_d2' => { 405 => 0x20 },
	'afstatus_17_e2' => { 405 => 0x22 },
	'afstatus_18_f2' => { 405 => 0x24 },
	'afstatus_19_g2' => { 405 => 0x26 },
	'afstatus_20_h2' => { 405 => 0x28 },
	'afstatus_21_c1' => { 405 => 0x2a },
	'afstatus_22_d1' => { 405 => 0x2c },
	'afstatus_23_e1' => { 405 => 0x2e },
	'afstatus_24_f1' => { 405 => 0x30 },
	'afstatus_25_g1' => { 405 => 0x32 },
	'afstatus_26_a7_vertical' => { 405 => 0x34 },
	'afstatus_27_a6_vertical' => { 405 => 0x36 },
	'afstatus_28_a5_vertical' => { 405 => 0x38 },
	'afstatus_29_c7_vertical' => { 405 => 0x3a },
	'afstatus_30_c6_vertical' => { 405 => 0x3c },
	'afstatus_31_c5_vertical' => { 405 => 0x3e },
	'afstatus_32_e7_vertical' => { 405 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 405 => 0x42 },
	'afstatus_34_e5_vertical' => { 405 => 0x44 },
	'afstatus_35_g7_vertical' => { 405 => 0x46 },
	'afstatus_36_g6_vertical' => { 405 => 0x48 },
	'afstatus_37_g5_vertical' => { 405 => 0x4a },
	'afstatus_38_i7_vertical' => { 405 => 0x4c },
	'afstatus_39_i6_vertical' => { 405 => 0x4e },
	'afstatus_40_i5_vertical' => { 405 => 0x50 },
	'afstatus_41_a7' => { 405 => 0x52 },
	'afstatus_42_b7' => { 405 => 0x54 },
	'afstatus_43_c7' => { 405 => 0x56 },
	'afstatus_44_d7' => { 405 => 0x58 },
	'afstatus_45_e7' => { 405 => 0x5a },
	'afstatus_46_f7' => { 405 => 0x5c },
	'afstatus_47_g7' => { 405 => 0x5e },
	'afstatus_48_h7' => { 405 => 0x60 },
	'afstatus_49_i7' => { 405 => 0x62 },
	'afstatus_50_a6' => { 405 => 0x64 },
	'afstatus_51_b6' => { 405 => 0x66 },
	'afstatus_52_c6' => { 405 => 0x68 },
	'afstatus_53_d6' => { 405 => 0x6a },
	'afstatus_54_e6_center' => { 405 => 0x6c },
	'afstatus_55_f6' => { 405 => 0x6e },
	'afstatus_56_g6' => { 405 => 0x70 },
	'afstatus_57_h6' => { 405 => 0x72 },
	'afstatus_58_i6' => { 405 => 0x74 },
	'afstatus_59_a5' => { 405 => 0x76 },
	'afstatus_60_b5' => { 405 => 0x78 },
	'afstatus_61_c5' => { 405 => 0x7a },
	'afstatus_62_d5' => { 405 => 0x7c },
	'afstatus_63_e5' => { 405 => 0x7e },
	'afstatus_64_f5' => { 405 => 0x80 },
	'afstatus_65_g5' => { 405 => 0x82 },
	'afstatus_66_h5' => { 405 => 0x84 },
	'afstatus_67_i5' => { 405 => 0x86 },
	'afstatus_68_c11' => { 405 => 0x88 },
	'afstatus_69_d11' => { 405 => 0x8a },
	'afstatus_70_e11' => { 405 => 0x8c },
	'afstatus_71_f11' => { 405 => 0x8e },
	'afstatus_72_g11' => { 405 => 0x90 },
	'afstatus_73_b10' => { 405 => 0x92 },
	'afstatus_74_c10' => { 405 => 0x94 },
	'afstatus_75_d10' => { 405 => 0x96 },
	'afstatus_76_e10' => { 405 => 0x98 },
	'afstatus_77_f10' => { 405 => 0x9a },
	'afstatus_78_g10' => { 405 => 0x9c },
	'afstatus_79_h10' => { 405 => 0x9e },
	'afstatus_80_b9' => { 405 => 0xa0 },
	'afstatus_81_c9' => { 405 => 0xa2 },
	'afstatus_82_d9' => { 405 => 0xa4 },
	'afstatus_83_e9' => { 405 => 0xa6 },
	'afstatus_84_f9' => { 405 => 0xa8 },
	'afstatus_85_g9' => { 405 => 0xaa },
	'afstatus_86_h9' => { 405 => 0xac },
	'afstatus_87_b8' => { 405 => 0xae },
	'afstatus_88_c8' => { 405 => 0xb0 },
	'afstatus_89_d8' => { 405 => 0xb2 },
	'afstatus_90_e8' => { 405 => 0xb4 },
	'afstatus_91_f8' => { 405 => 0xb6 },
	'afstatus_92_g8' => { 405 => 0xb8 },
	'afstatus_93_h8' => { 405 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 405 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 402 => [0x4,0x3b], 406 => 0x1e, 407 => 0x1b, 408 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 406 => 0x2a, 407 => 0x21, 408 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 407 => 0x2b, 408 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 407 => 0x1f, 408 => 0x1f },
	'afstatusbottomassist-left' => { 406 => 0x28 },
	'afstatusbottomassist-right' => { 406 => 0x2c },
	'afstatusbottomhorizontal' => { 403 => 0x10, 404 => 0x1c },
	'afstatusbottomvertical' => { 403 => 0x16, 404 => 0x26 },
	'afstatuscenter-10' => { 406 => 0x34 },
	'afstatuscenter-11' => { 406 => 0x36 },
	'afstatuscenter-12' => { 406 => 0x38 },
	'afstatuscenter-14' => { 406 => 0x3c },
	'afstatuscenter-7' => { 406 => 0x2e },
	'afstatuscenter-9' => { 406 => 0x32 },
	'afstatuscenter-horizontal' => { 406 => 0x30 },
	'afstatuscenter-vertical' => { 406 => 0x3a },
	'afstatuscenterf2-8' => { 406 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 403 => 0xc, 404 => 0x18, 407 => 0x2f, 408 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 403 => 0x14, 404 => 0x22, 407 => 0x25, 408 => 0x25 },
	'afstatusfarleft' => { 403 => 0x6, 406 => 0x26 },
	'afstatusfarlefthorizontal' => { 404 => 0x4 },
	'afstatusfarleftvertical' => { 404 => 0x12 },
	'afstatusfarright' => { 403 => 0x18, 406 => 0x44 },
	'afstatusfarrighthorizontal' => { 404 => 0x2c },
	'afstatusfarrightvertical' => { 404 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 403 => 0x2, 406 => 0x22, 407 => 0x2d, 408 => 0x2d },
	'afstatuslefthorizontal' => { 404 => 0x6 },
	'afstatusleftvertical' => { 404 => 0xe },
	'afstatuslower-left' => { 403 => 0x4, 406 => 0x24 },
	'afstatuslower-lefthorizontal' => { 404 => 0xa },
	'afstatuslower-leftvertical' => { 404 => 0x10 },
	'afstatuslower-middle' => { 403 => 0x22, 404 => 0x24 },
	'afstatuslower-right' => { 403 => 0x1e, 406 => 0x4a },
	'afstatuslower-righthorizontal' => { 404 => 0x32 },
	'afstatuslower-rightvertical' => { 404 => 0x3a },
	'afstatuslowerfarleft' => { 404 => 0x8 },
	'afstatuslowerfarright' => { 404 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 407 => 0x23, 408 => 0x23 },
	'afstatusnearleft' => { 403 => 0xe, 404 => 0x1a },
	'afstatusnearright' => { 403 => 0xa, 404 => 0x16 },
	'afstatusright' => { 180 => 0x31, 403 => 0x1c, 406 => 0x48, 407 => 0x31, 408 => 0x31 },
	'afstatusrighthorizontal' => { 404 => 0x2e },
	'afstatusrightvertical' => { 404 => 0x38 },
	'afstatustop' => { 180 => 0xe, 406 => 0x40, 407 => 0x27, 408 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 407 => 0x29, 408 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 407 => 0x1d, 408 => 0x1d },
	'afstatustopassist-left' => { 406 => 0x3e },
	'afstatustopassist-right' => { 406 => 0x42 },
	'afstatustophorizontal' => { 403 => 0x8, 404 => 0x14 },
	'afstatustopvertical' => { 403 => 0x12, 404 => 0x1e },
	'afstatusupper-left' => { 403 => 0x0, 406 => 0x20 },
	'afstatusupper-lefthorizontal' => { 404 => 0x2 },
	'afstatusupper-leftvertical' => { 404 => 0xc },
	'afstatusupper-middle' => { 403 => 0x20, 404 => 0x20 },
	'afstatusupper-right' => { 403 => 0x1a, 406 => 0x46 },
	'afstatusupper-righthorizontal' => { 404 => 0x2a },
	'afstatusupper-rightvertical' => { 404 => 0x36 },
	'afstatusupperfarleft' => { 404 => 0x0 },
	'afstatusupperfarright' => { 404 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 422 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 402 => 0x2 },
	'afwithshutter' => { 409 => 0x2a },
	'aggregateissuenumber' => { 496 => 'aggregateIssueNumber' },
	'aggregationtype' => { 496 => 'aggregationType' },
	'agreement' => { 499 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 230 => 0x624 },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'aisubjecttrackingmode' => { 299 => 0x309 },
	'album' => { 374 => ['albm',"\xa9alb"], 376 => 'album', 382 => ['albm',"\xa9alb"], 506 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 374 => 'aART', 382 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'albumtitleid' => { 374 => 'atID' },
	'alreadyapplied' => { 480 => 'AlreadyApplied', 482 => 'AlreadyApplied' },
	'alternatetitle' => { 496 => 'alternateTitle' },
	'alternatetitlea-lang' => { 496 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 496 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 496 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 196 => 0x6 },
	'alttapename' => { 506 => 'altTapeName' },
	'alttextaccessibility' => { 491 => 'AltTextAccessibility' },
	'alttimecode' => { 506 => 'altTimecode' },
	'alttimecodetimeformat' => { 506 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 506 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 506 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 385 => 0x5c },
	'ambientlight' => { 385 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 383 => 0x14, 384 => 0x46, 385 => 0x50, 447 => 0x4, 487 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 383 => 0x13, 384 => 0x44, 385 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 376 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 476 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 476 => 'AngleInfoYaw' },
	'anti-blur' => { 422 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 282 => '38.2', 284 => '38.2', 285 => '38.2', 294 => '38.2', 295 => '38.2', 297 => 0xb8 },
	'aperturemode' => { 382 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 338 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 409 => 0x30, 410 => 0x29, 411 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 304 => 0x1002, 366 => 0x401, 486 => 'ApertureValue' },
	'appinfo' => { 460 => 'AppInfo' },
	'appinfoapplication' => { 460 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 460 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 460 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 308 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 376 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 374 => 'apID' },
	'applestoreaccounttype' => { 374 => 'akID' },
	'applestorecatalogid' => { 374 => 'cnID' },
	'applestorecountry' => { 374 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 327 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 488 => 'Approved' },
	'approvedby' => { 488 => 'ApprovedBy' },
	'approximatefnumber' => { 317 => 0x313, 324 => 0x3406 },
	'approximatefocusdistance' => { 477 => 'ApproximateFocusDistance' },
	'appversion' => { 490 => 'AppVersion' },
	'aps-csizecapture' => { 441 => 0x114, 442 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 374 => "\xa9arg", 382 => "\xa9arg" },
	'arrangerkeywords' => { 382 => "\xa9ark" },
	'artdirector' => { 374 => "\xa9ard" },
	'artfilter' => { 299 => 0x529 },
	'artfiltereffect' => { 299 => 0x52f },
	'artist' => { 119 => 0x13b, 312 => 'Artist', 357 => 0x22e, 374 => "\xa9ART", 376 => 'artist', 382 => "\xa9ART", 502 => 'Artist', 506 => 'artist' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 376 => 'artwork' },
	'artworkcircadatecreated' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 492 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 492 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 303 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 303 => 0x1112, 357 => 0x80, 409 => 0x55, 410 => 0x55, 411 => 0xa },
	'assetid' => { 470 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 281 => '4.2', 282 => '16.1', 284 => '16.1', 285 => '16.1', 294 => '16.1', 295 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 285 => '79.1' },
	'assignmb-d17funcbutton' => { 285 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 285 => '68.1' },
	'assignmb-d18af-onbutton' => { 295 => '79.1' },
	'assignmb-d18funcbutton' => { 295 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 295 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 284 => '75.1', 285 => '75.1', 295 => '75.1' },
	'assignmoviefunc2button' => { 284 => '82.1', 285 => '82.1', 295 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 284 => '75.2', 285 => '75.2', 295 => '75.2' },
	'assignmovierecordbutton' => { 282 => '43.2', 294 => '45.1', 297 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 284 => '45.1', 285 => '45.1', 295 => '45.1' },
	'assignmoviesubselector' => { 284 => '74.1', 285 => '74.1', 295 => '74.1' },
	'assignmoviesubselectorplusdials' => { 284 => '76.1', 285 => '76.1', 295 => '76.1' },
	'assignremotefnbutton' => { 282 => '54.1', 294 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 478 => 'attributionName' },
	'attributionurl' => { 478 => 'attributionURL' },
	'audio' => { 322 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 492 => 'audioBitRate' },
	'audiobitratemode' => { 492 => 'audioBitRateMode' },
	'audiobitspersample' => { 492 => 'audioBitsPerSample' },
	'audiobutton' => { 297 => 0x17b },
	'audiobuttonplaybackmode' => { 297 => 0x1b9 },
	'audiochannelcount' => { 492 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 506 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 506 => 'audioCompressor' },
	'audiodata' => { 462 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 376 => 'player.movie.audio.gain' },
	'audiomimetype' => { 462 => 'Mime' },
	'audiomoddate' => { 506 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 506 => 'audioSampleRate' },
	'audiosampletype' => { 506 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 308 => 'Author', 312 => 'Author', 373 => 'Author', 374 => ['auth',"\xa9aut"], 376 => 'author', 382 => 'auth', 475 => 'author', 493 => 'Author', 504 => 'Author' },
	'authorsposition' => { 494 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 348 => '0.1' },
	'autobracket' => { 399 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 357 => 0x18, 389 => 0x1007 },
	'autobracketingmode' => { 293 => '12.3' },
	'autobracketingset' => { 293 => '12.1' },
	'autobracketmodem' => { 281 => '21.2', 282 => '13.3', 284 => '13.2', 285 => '13.2', 290 => '26.2', 294 => '13.3', 295 => '13.2', 297 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 281 => '21.3', 282 => '13.2', 284 => '13.1', 285 => '13.1', 290 => '26.3', 291 => '12.2', 292 => '2.2', 293 => '12.2', 294 => '13.2', 295 => '13.1', 296 => '13.2', 297 => 0x61 },
	'autobracketset' => { 281 => '21.1', 282 => '13.1', 286 => '11.1', 287 => '12.1', 288 => '12.1', 290 => '26.1', 291 => '12.1', 292 => '2.1', 294 => '13.1', 296 => '13.1' },
	'autobrightness' => { 480 => 'AutoBrightness', 482 => 'AutoBrightness' },
	'autocontrast' => { 480 => 'AutoContrast', 482 => 'AutoContrast' },
	'autodistortioncontrol' => { 206 => 0x4, 229 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 480 => 'AutoExposure', 482 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 284 => '38.5', 285 => '38.5', 295 => '38.5', 297 => 0x5b },
	'autofocus' => { 302 => 0x209 },
	'autofocusmoderestrictions' => { 297 => 0x107 },
	'autofp' => { 292 => '7.3', 296 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 230 => 0x142, 283 => '1.1', 292 => '1.1' },
	'autoisomax' => { 283 => '1.2', 292 => '1.2' },
	'autoisominshutterspeed' => { 283 => '1.3', 292 => '1.3' },
	'autolateralca' => { 480 => 'AutoLateralCA', 482 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 422 => 0x2016 },
	'autoredeye' => { 274 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 480 => 'AutoShadows', 482 => 'AutoShadows' },
	'autotone' => { 480 => 'AutoTone', 482 => 'AutoTone' },
	'autotonedigest' => { 480 => 'AutoToneDigest', 482 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 480 => 'AutoToneDigestNoSat', 482 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 480 => 'AutoWhiteVersion', 482 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 227 => 0x82 },
	'avaperturesetting' => { 338 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 322 => [0x8010,0x33] },
	'babyname' => { 322 => 0x66 },
	'backgroundalpha' => { 501 => 'bgalpha' },
	'balance' => { 376 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 338 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 324 => 0x312a, 453 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baseurl' => { 504 => 'BaseURL' },
	'bass' => { 376 => 'player.movie.audio.bass' },
	'batterylevel' => { 322 => 0x38, 409 => 0x51, 413 => 0xc, 414 => 0x4, 415 => 0x4, 454 => 0x7 },
	'batterylevelgrip1' => { 454 => 0x6 },
	'batterylevelgrip2' => { 454 => 0x8 },
	'batteryorder' => { 281 => '12.5', 290 => '13.2', 291 => '2.1', 294 => '3.1' },
	'batterystate' => { 184 => 0x60, 409 => 0x50, 415 => 0x14 },
	'batterytemperature' => { 413 => 0x1, 415 => 0x2, 454 => 0x5 },
	'batterytype' => { 64 => 0x38, 385 => 0x66 },
	'batteryunknown' => { 413 => 0x2, 415 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 383 => 0x2a, 384 => 0x49, 385 => 0x62, 413 => 0x8 },
	'batteryvoltage1' => { 415 => 0x6 },
	'batteryvoltage2' => { 415 => 0x8 },
	'batteryvoltageavg' => { 385 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 374 => 'tmpo' },
	'beatspliceparams' => { 506 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 506 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 506 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 506 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 506 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 506 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 281 => '13.1', 282 => '5.4', 283 => '0.1', 286 => '2.1', 287 => '3.1', 288 => '3.1', 290 => '10.1', 292 => '0.1', 294 => '5.5', 296 => '4.1' },
	'beeppitch' => { 291 => '3.1' },
	'beepvolume' => { 291 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 239 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 327 => 0xa, 502 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => 0xc61a, 204 => 0x20, 227 => 0x3d, 304 => [0x401,0x1012], 366 => 0x21d, 429 => [0x7300,0x7310] },
	'blacklevel2' => { 303 => 0x600, 307 => 0x600 },
	'blacklevelblue' => { 327 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 366 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 327 => 0x1d },
	'blacklevelred' => { 327 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 357 => 0x200 },
	'blacks2012' => { 480 => 'Blacks2012', 482 => 'Blacks2012' },
	'blacksadj' => { 457 => 0x9018 },
	'bleachbypasstoning' => { 357 => 0x7f },
	'blockshotafresponse' => { 284 => '1.5', 285 => '1.5', 295 => '1.5', 297 => 0x7 },
	'blogtitle' => { 496 => 'blogTitle' },
	'blogurl' => { 496 => 'blogURL' },
	'bluebalance' => { 304 => 0x1018, 327 => 0x12, 357 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 480 => 'BlueHue', 482 => 'BlueHue' },
	'bluesaturation' => { 480 => 'BlueSaturation', 482 => 'BlueSaturation' },
	'bluratinfinity' => { 466 => 'BlurAtInfinity' },
	'blurcontrol' => { 357 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 336 => 0x3 },
	'bodybatteryadnoload' => { 336 => 0x2 },
	'bodybatterystate' => { 336 => '1.1' },
	'bodybatteryvoltage1' => { 336 => 0x2 },
	'bodybatteryvoltage2' => { 336 => 0x4 },
	'bodybatteryvoltage3' => { 336 => 0x6 },
	'bodybatteryvoltage4' => { 336 => 0x8 },
	'bodyfirmware' => { 390 => 0x0 },
	'bodyfirmwareversion' => { 300 => 0x104, 301 => 0x100, 304 => 0x104 },
	'bodyserialnumber' => { 390 => 0x10 },
	'bookedition' => { 496 => 'bookEdition' },
	'bootloaderversion' => { 384 => 0x26 },
	'bracketincrement' => { 230 => 0x21a },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 230 => 0x218 },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 230 => 0x216 },
	'bracketsettings' => { 322 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 338 => 0x9, 420 => 0x2b },
	'bracketshotnumber2' => { 420 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 233 => 0x34, 234 => 0x39, 235 => 0x41, 376 => 'player.movie.visual.brightness', 383 => 0x25, 385 => 0x54, 409 => 0x22, 422 => 0x2007, 480 => 'Brightness', 482 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 267 => 0x0, 277 => 0x2d, 457 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 304 => 0x1003, 427 => 0x1e, 431 => 0x1140, 432 => 0x1140, 433 => 0x111c, 434 => 0x1198, 435 => 0x1174, 436 => 0x102c, 437 => 0x224, 438 => 0x224, 439 => 0x219, 486 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstid' => { 463 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 322 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 463 => 'BurstPrimary' },
	'burstshot' => { 399 => 0x34 },
	'burstspeed' => { 322 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmode' => { 304 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 496 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 399 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 470 => 'CallForImage' },
	'camera' => { 460 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 382 => 'angl', 506 => 'cameraAngle' },
	'cameraappinfo' => { 460 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 460 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 460 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 460 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 464 => 'CameraBurstID' },
	'cameracalibration' => { 399 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 460 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 460 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 460 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 460 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 460 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 460 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 460 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 460 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 460 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 460 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 460 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 460 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 376 => 'direction.facing' },
	'camerae-mountversion' => { 456 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 487 => 'CameraElevationAngle' },
	'camerafilename' => { 470 => 'CameraFilename' },
	'cameraid' => { 304 => 0x209, 382 => 'cmid', 398 => 0x209 },
	'cameraidentifier' => { 376 => 'camera.identifier' },
	'cameraimage' => { 460 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 460 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 460 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 460 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 460 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 460 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 460 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 460 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 460 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 460 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 460 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 460 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 460 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 460 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 506 => 'cameraLabel' },
	'cameralightestimate' => { 460 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 460 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 460 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 460 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 460 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 470 => 'CameraMakeModel' },
	'cameramodel' => { 366 => 0x410, 506 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 480 => 'CameraModelRestriction', 482 => 'CameraModelRestriction' },
	'cameramotion' => { 376 => 'direction.motion' },
	'cameramove' => { 506 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 322 => 0x8f, 361 => 0x1, 366 => 0x100, 415 => [0x16,0x18], 444 => 0x28, 445 => 0x24, 446 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 304 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 382 => "\xa9gpt" },
	'camerapointcloud' => { 460 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 460 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 460 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 460 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 460 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 460 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 460 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 460 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 460 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 460 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 460 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 460 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 460 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 480 => 'CameraProfile', 482 => 'CameraProfile' },
	'cameraprofiledigest' => { 480 => 'CameraProfileDigest', 482 => 'CameraProfileDigest' },
	'cameraprofiles' => { 494 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 494 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 494 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 494 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 494 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 494 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 494 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 494 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 494 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 494 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 494 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 494 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 494 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 494 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 494 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 494 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 382 => "\xa9grl" },
	'cameras' => { 460 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 470 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 299 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 303 => 0x1306, 317 => 0x320, 324 => 0x3402, 357 => 0x47, 396 => 0x43, 448 => 0x5 },
	'cameratemperature4' => { 362 => 0x14 },
	'cameratemperature5' => { 362 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 460 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 304 => 0x207 },
	'cameratype2' => { 300 => 0x100 },
	'cameravendorinfo' => { 460 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 460 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 460 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 460 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 382 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 475 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 485 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 485 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 494 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 376 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 468 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 461 => 'CatalogSets', 473 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 475 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 298 => 0x30, 374 => 'catg', 494 => 'Category' },
	'cbcrgain' => { 396 => 0xa036 },
	'cbcrgaindefault' => { 396 => 0xa035 },
	'cbcrmatrix' => { 396 => 0xa034 },
	'cbcrmatrixdefault' => { 396 => 0xa033 },
	'ccdboardversion' => { 317 => 0x331 },
	'ccdscanmode' => { 304 => 0x1039 },
	'ccdsensitivity' => { 264 => 0x6 },
	'ccdversion' => { 317 => 0x330 },
	'cellglobalid' => { 479 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 479 => 'r' },
	'celltowerid' => { 479 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 292 => '15.1' },
	'centerfocuspoint' => { 296 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 281 => '7.1', 282 => '8.1', 284 => '8.1', 285 => '8.1', 289 => '7.1', 290 => '5.1', 291 => '7.1', 292 => '6.3', 294 => '8.1', 295 => '8.1', 296 => '8.1', 297 => 0x1f },
	'certificate' => { 510 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 327 => 0x9, 486 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 486 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 486 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 486 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 496 => 'channel' },
	'channela-lang' => { 496 => [\'channel','channelA-lang'] },
	'channelchannel' => { 496 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 496 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 496 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 496 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 496 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 382 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 511 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 281 => '10.3', 282 => '11.2', 297 => 0x10b },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 396 => 0xa051 },
	'chromaticaberrationb' => { 480 => 'ChromaticAberrationB', 482 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 347 => 0x1, 457 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 452 => 0x66a, 453 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 480 => 'ChromaticAberrationR', 482 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 399 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 492 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 480 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 480 => 'CircularGradientBasedCorrections', 482 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 322 => 0x6d, 494 => 'City' },
	'city2' => { 322 => 0x80 },
	'clarity' => { 127 => 0x100f, 234 => 0x35, 235 => 0x3d, 422 => 0x2036, 480 => 'Clarity', 482 => 'Clarity' },
	'clarity2012' => { 480 => 'Clarity2012', 482 => 'Clarity2012' },
	'claritycontrol' => { 357 => 0x96 },
	'classification' => { 382 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 322 => 0x7c },
	'clearretouchvalue' => { 322 => 0xa3 },
	'client' => { 506 => 'client' },
	'clientname' => { 488 => 'ClientName' },
	'clipboardaspectratio' => { 480 => 'ClipboardAspectRatio', 482 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 480 => 'ClipboardOrientation', 482 => 'ClipboardOrientation' },
	'clipfilename' => { 382 => 'clfn' },
	'clipid' => { 382 => 'clid' },
	'clmodeshootingspeed' => { 281 => '10.2', 282 => '11.3', 284 => '11.2', 285 => '11.2', 290 => '11.2', 291 => '10.2', 294 => '11.2', 295 => '11.2', 296 => '11.1', 297 => 0x3b },
	'cluster' => { 480 => 'Cluster', 482 => 'Cluster' },
	'cmcontrast' => { 307 => 0x2022 },
	'cmddialsreverserotation' => { 297 => 0xba },
	'cmexposurecompensation' => { 307 => 0x2000 },
	'cmhue' => { 307 => 0x2021 },
	'cmsaturation' => { 307 => 0x2020 },
	'cmsharpness' => { 307 => 0x2023 },
	'cmwhitebalance' => { 307 => 0x2001 },
	'cmwhitebalancecomp' => { 307 => 0x2002 },
	'cmwhitebalancegraypoint' => { 307 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 382 => 'cver' },
	'collection' => { 312 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 382 => 'coll' },
	'collections' => { 170 => 'Collections', 475 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 376 => 'player.movie.visual.color', 495 => 'color' },
	'coloraberrationcontrol' => { 274 => 0xc89224b },
	'coloradjustment' => { 399 => 0x14 },
	'coloradjustmentmode' => { 398 => 0x210 },
	'coloranta' => { 511 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 511 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 511 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 511 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 511 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 511 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 511 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 511 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 511 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 511 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 511 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 511 => 'Colorants' },
	'colorantswatchname' => { 511 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 511 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 511 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 511 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 274 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 203 => 0x4, 204 => 0x4, 205 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 274 => 0x5f0e7d23 },
	'colorboostlevel' => { 268 => 0x1 },
	'colorboosttype' => { 268 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 368 => 0xde, 369 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 422 => 0xb022 },
	'colorcompensationfiltercustom' => { 409 => 0xd, 410 => 0xc },
	'colorcompensationfilterset' => { 409 => 0x8, 410 => 0x7, 411 => 0x18, 427 => 0xf },
	'colorcontrol' => { 304 => 0x102b },
	'colorcorrection' => { 457 => 0x8015 },
	'colorcreatoreffect' => { 299 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 322 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 364 => 0x17 },
	'colorgain' => { 239 => 0x51 },
	'colorgradeblending' => { 480 => 'ColorGradeBlending', 482 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 480 => 'ColorGradeGlobalHue', 482 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 480 => 'ColorGradeGlobalLum', 482 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 480 => 'ColorGradeGlobalSat', 482 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 480 => 'ColorGradeHighlightLum', 482 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 480 => 'ColorGradeMidtoneHue', 482 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 480 => 'ColorGradeMidtoneLum', 482 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 480 => 'ColorGradeMidtoneSat', 482 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 480 => 'ColorGradeShadowLum', 482 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 227 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 485 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 303 => 0x200, 304 => 0x1011, 396 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 366 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 307 => 0x200, 366 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 357 => 0x203 },
	'colormatrixa2' => { 357 => 0x21c },
	'colormatrixadobergb' => { 396 => 0xa032 },
	'colormatrixb' => { 357 => 0x204 },
	'colormatrixb2' => { 357 => 0x21d },
	'colormatrixnumber' => { 304 => 0x1019 },
	'colormatrixsrgb' => { 396 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 227 => 0x3, 264 => 0x4, 322 => 0x32, 399 => 0x2c, 422 => 0xb029, 494 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 275 => 0x15 },
	'colormoirereductionmode' => { 275 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 457 => 0x8029, 480 => 'ColorNoiseReduction', 482 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 480 => 'ColorNoiseReductionDetail', 482 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 275 => 0x18 },
	'colornoisereductionsharpness' => { 275 => 0x1c },
	'colornoisereductionsmoothness' => { 480 => 'ColorNoiseReductionSmoothness', 482 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 299 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 227 => 0x1e, 299 => 0x507, 357 => 0x37, 396 => 0xa011, 399 => 0xb, 409 => 0x1b, 410 => 0x83, 411 => 0xe, 427 => 0x6, 486 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 357 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 357 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 317 => 0x321, 357 => 0x50, 389 => 0x1308, 422 => 0xb021, 480 => 'Temperature', 482 => 'Temperature' },
	'colortemperatureadj' => { 457 => 0x8013 },
	'colortemperatureauto' => { 227 => 0x4f },
	'colortemperaturebg' => { 304 => 0x1013 },
	'colortemperaturecustom' => { 409 => 0xc, 410 => 0xb },
	'colortemperaturerg' => { 304 => 0x1014 },
	'colortemperatureset' => { 409 => 0x7, 410 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 411 => 0x17, 427 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 357 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 357 => 0x57 },
	'colortempfluorescentn' => { 357 => 0x58 },
	'colortempfluorescentw' => { 357 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 322 => 0x44, 389 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 357 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 357 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 321 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 297 => 0x1cb },
	'commanddials' => { 292 => '5.1' },
	'commanddialsaperturesetting' => { 281 => '17.3', 282 => '18.3', 284 => '18.3', 285 => '18.3', 290 => '33.3', 291 => '17.3', 294 => '18.3', 295 => '18.3' },
	'commanddialschangemainsub' => { 281 => '17.2', 282 => '18.1', 284 => '18.1', 285 => '18.1', 290 => '33.2', 291 => '17.2', 294 => '18.1', 295 => '18.1' },
	'commanddialsmenuandplayback' => { 281 => '17.4', 282 => '18.2', 284 => '18.2', 285 => '18.2', 290 => '33.4', 291 => '17.4', 294 => '18.2', 295 => '18.2' },
	'commanddialsreverserotation' => { 281 => '17.1', 282 => '6.4', 284 => '6.2', 285 => '6.2', 286 => '16.2', 287 => '17.2', 290 => '33.1', 291 => '17.1', 294 => '6.2', 295 => '6.2', 296 => '18.1' },
	'commanderchannel' => { 292 => '10.2', 293 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 292 => '13.1', 293 => '31.1' },
	'commandergroupa_ttlcomp' => { 296 => '32.1' },
	'commandergroupamanualoutput' => { 292 => '13.2', 293 => '28.2' },
	'commandergroupamode' => { 292 => '11.2', 293 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 292 => '14.1', 293 => '32.1' },
	'commandergroupb_ttlcomp' => { 296 => '33.1' },
	'commandergroupbmanualoutput' => { 292 => '14.2', 293 => '29.2' },
	'commandergroupbmode' => { 292 => '11.3', 293 => '29.1' },
	'commanderinternalflash' => { 292 => '11.1', 293 => '27.1' },
	'commanderinternalmanualoutput' => { 292 => '12.2', 293 => '27.2' },
	'commanderinternalttlchannel' => { 290 => '18.2' },
	'commanderinternalttlcomp' => { 292 => '12.1', 293 => '30.2', 296 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 290 => '20.1', 291 => '26.1' },
	'commanderinternalttlcompgroupa' => { 290 => '21.1', 291 => '27.1' },
	'commanderinternalttlcompgroupb' => { 290 => '22.1', 291 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 312 => 'Comment', 374 => "\xa9cmt", 376 => 'comment', 382 => "\xa9cmt" },
	'compass' => { 392 => 0x4 },
	'compatibleversion' => { 480 => 'CompatibleVersion', 482 => 'CompatibleVersion' },
	'compilation' => { 374 => 'cpil' },
	'compimageimagespersequence' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 487 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 496 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 486 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 374 => ["\xa9com","\xa9wrt"], 382 => ["\xa9com","\xa9wrt"], 506 => 'composer' },
	'composerkeywords' => { 382 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 487 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 487 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 487 => 'CompositeImageExposureTimes' },
	'composition' => { 470 => 'Composition' },
	'compositionadjust' => { 356 => '0.1' },
	'compositionadjustrotation' => { 356 => 0x7 },
	'compositionadjustx' => { 356 => 0x5 },
	'compositionadjusty' => { 356 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 486 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 304 => 0x40 },
	'compression' => { 119 => 0x103, 327 => 0xb, 502 => 'Compression' },
	'compressionfactor' => { 299 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 304 => 0x1034 },
	'compressorversion' => { 382 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 374 => "\xa9con" },
	'confidence' => { 465 => 'Confidence' },
	'confidencelevel' => { 476 => 'ConfidenceLevel' },
	'confidencemime' => { 465 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 368 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 368 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 480 => 'ContactInfo', 482 => 'ContactInfo', 495 => 'contactInfo' },
	'container' => { 460 => 'Container' },
	'containerdirectory' => { 460 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 460 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 460 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 460 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 460 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 460 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 492 => 'ContainerFormat' },
	'containerformatidentifier' => { 492 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 492 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 374 => "\xa9day", 382 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 382 => 'cdis' },
	'contentid' => { 382 => 'ccid' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 496 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 297 => 0x51 },
	'continuousmodeliveview' => { 295 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 233 => 0x33, 234 => 0x37, 235 => 0x3f, 304 => 0x1029, 322 => 0x39, 324 => 0x300a, 357 => 0x20, 364 => 0xc, 376 => 'player.movie.visual.contrast', 383 => 0x24, 385 => 0x52, 389 => 0x1012, 399 => 0xd, 409 => 0x1d, 410 => 0x1a, 422 => 0x2004, 480 => 'Contrast', 482 => 'Contrast', 486 => 'Contrast' },
	'contrast2012' => { 480 => 'Contrast2012', 482 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 277 => 0x2c, 457 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 227 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 357 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 357 => 0x6d },
	'contrasthighlightshadowadj' => { 357 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 322 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 299 => 0x505, 307 => 0x1012, 411 => 0x10, 427 => 0x8 },
	'contrastshadow' => { 357 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 506 => 'contributedMedia' },
	'contributedmediaduration' => { 506 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 506 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 506 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 506 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 506 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 506 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 506 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 506 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 506 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 506 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 483 => 'contributor', 492 => 'Contributor' },
	'contributoridentifier' => { 492 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 492 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 492 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 492 => 'CVterm' },
	'controllerboardversion' => { 317 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 297 => 0x1d5 },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 300 => 0x403, 322 => 0x35 },
	'converter' => { 119 => 0xfe4d, 264 => 0xb, 480 => 'Converter', 482 => 'Converter' },
	'converttograyscale' => { 480 => 'ConvertToGrayscale', 482 => 'ConvertToGrayscale' },
	'cookingequipment' => { 498 => 'cookingEquipment' },
	'cookingmethod' => { 498 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 312 => 'Copyright', 357 => 0x22f, 373 => 'Copyright', 374 => ['cprt',"\xa9cpy"], 376 => 'copyright', 382 => ['cprt',"\xa9cpy"], 480 => 'Copyright', 482 => 'Copyright', 493 => 'Copyright', 499 => 'copyright', 502 => 'Copyright', 506 => 'copyright' },
	'copyrightflag' => { 371 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 309 => 'CopyrightOwner' },
	'copyrightownerid' => { 309 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 309 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 309 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 309 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 309 => 'CopyrightStatus' },
	'copyrightyear' => { 492 => 'CopyrightYear', 496 => 'copyrightYear' },
	'coringfilter' => { 303 => 0x310, 304 => 0x102d, 307 => 0x310 },
	'coringvalues' => { 303 => 0x311, 307 => 0x311 },
	'corporateentity' => { 496 => 'corporateEntity' },
	'correlatedcolortemp' => { 321 => 0x35b },
	'country' => { 161 => 'Country', 322 => 0x69, 494 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 226 => 0x5, 369 => 'CountryCode', 491 => 'CountryCode' },
	'course' => { 498 => 'course' },
	'coverage' => { 483 => 'coverage' },
	'coverart' => { 374 => 'covr' },
	'coverdate' => { 496 => 'coverDate' },
	'coverdisplaydate' => { 496 => 'coverDisplayDate' },
	'coveruri' => { 382 => 'cvru' },
	'cpufirmwareversion' => { 357 => 0x28 },
	'crc32' => { 484 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 308 => 'CreationDate', 312 => 'create-date', 373 => 'CreationDate', 379 => 0x1, 504 => 'CreateDate' },
	'creationdate' => { 376 => 'creationdate', 493 => 'CreationDate', 496 => 'creationDate' },
	'creationtime' => { 312 => 'Creation Time' },
	'creativestyle' => { 409 => 0x1a, 410 => 0x18, 420 => 0x41, 422 => 0xb020, 453 => 0x4a },
	'creativestylesetting' => { 411 => 0xf, 427 => 0x7 },
	'creativestylewaschanged' => { 457 => 0x8001 },
	'creator' => { 308 => 'Creator', 373 => 'Creator', 483 => 'creator', 492 => 'Creator', 493 => 'Creator' },
	'creatoraddress' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 491 => 'CreatorContactInfo' },
	'creatorcountry' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 492 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 492 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 492 => [\'Creator','CreatorRole'] },
	'creatortool' => { 504 => 'CreatorTool' },
	'creatorworkemail' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 491 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 494 => 'Credit' },
	'creditline' => { 499 => 'creditLine' },
	'creditlinereq' => { 509 => 'CreditLineReq' },
	'creditlinerequired' => { 309 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 480 => 'CropAngle', 482 => 'CropAngle' },
	'croparea' => { 227 => 0x45, 457 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 269 => 0x36, 327 => 0x31, 368 => 0xdc, 480 => 'CropBottom', 482 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 480 => 'CropConstrainToWarp', 482 => 'CropConstrainToWarp' },
	'croph' => { 474 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 303 => 0x615, 307 => 0x615, 480 => 'CropHeight', 482 => 'CropHeight' },
	'crophispeed' => { 227 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 269 => 0x1e, 303 => 0x612, 307 => 0x612, 327 => 0x30, 368 => 0xd9, 480 => 'CropLeft', 482 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 389 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 269 => 0xce },
	'cropoutputheightinches' => { 269 => 0x96 },
	'cropoutputpixels' => { 269 => 0xd6 },
	'cropoutputresolution' => { 269 => 0xb6 },
	'cropoutputscale' => { 269 => 0xbe },
	'cropoutputwidth' => { 269 => 0xc6 },
	'cropoutputwidthinches' => { 269 => 0x8e },
	'croppedareaimageheightpixels' => { 468 => 'CroppedAreaImageHeightPixels', 469 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 468 => 'CroppedAreaImageWidthPixels', 469 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 468 => 'CroppedAreaLeftPixels', 469 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 468 => 'CroppedAreaTopPixels', 469 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 389 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 389 => 0x1603 },
	'cropping' => { 457 => 0x9010 },
	'cropright' => { 123 => 0x8, 269 => 0x2e, 327 => 0x32, 368 => 0xdb, 480 => 'CropRight', 482 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 269 => 0x9e },
	'cropsourceresolution' => { 269 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 269 => 0x26, 303 => 0x613, 307 => 0x613, 327 => 0x2f, 368 => 0xda, 480 => 'CropTop', 482 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 480 => 'CropUnit', 482 => 'CropUnit' },
	'cropunits' => { 480 => 'CropUnits', 482 => 'CropUnits' },
	'cropw' => { 474 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 303 => 0x614, 307 => 0x614, 480 => 'CropWidth', 482 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 474 => 'CropX' },
	'cropy' => { 101 => 0x4, 474 => 'CropY' },
	'crossprocess' => { 357 => 0x7b },
	'crossprocessparams' => { 357 => 0x235 },
	'cuisine' => { 498 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 457 => 0xd000 },
	'curve0x' => { 474 => 'Curve0x' },
	'curve0y' => { 474 => 'Curve0y' },
	'curve1x' => { 474 => 'Curve1x' },
	'curve1y' => { 474 => 'Curve1y' },
	'curve2x' => { 474 => 'Curve2x' },
	'curve2y' => { 474 => 'Curve2y' },
	'curve3x' => { 474 => 'Curve3x' },
	'curve3y' => { 474 => 'Curve3y' },
	'curve4x' => { 474 => 'Curve4x' },
	'curve4y' => { 474 => 'Curve4y' },
	'curves' => { 274 => 0x76a43201 },
	'custom1' => { 309 => 'Custom1' },
	'custom10' => { 309 => 'Custom10' },
	'custom2' => { 309 => 'Custom2' },
	'custom3' => { 309 => 'Custom3' },
	'custom4' => { 309 => 'Custom4' },
	'custom5' => { 309 => 'Custom5' },
	'custom6' => { 309 => 'Custom6' },
	'custom7' => { 309 => 'Custom7' },
	'custom8' => { 309 => 'Custom8' },
	'custom9' => { 309 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 191 => 0x6420, 486 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 299 => 0x503 },
	'customsettingsalldefault' => { 281 => '0.2', 290 => '0.2' },
	'customsettingsbank' => { 281 => '0.1', 282 => '0.1', 284 => '0.1', 285 => '0.1', 290 => '0.1', 294 => '0.2', 295 => '0.2', 297 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 427 => 0x1a },
	'customwb_rgblevels' => { 410 => 0x8, 411 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 382 => '_cx_' },
	'cy' => { 382 => '_cy_' },
	'd-lightinghq' => { 274 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 270 => 0x2 },
	'd-lightinghqhighlight' => { 270 => 0x1 },
	'd-lightinghqselected' => { 274 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 270 => 0x0 },
	'd-lightinghs' => { 274 => 0xce5554aa },
	'd-lightinghsadjustment' => { 271 => 0x0 },
	'd-lightinghscolorboost' => { 271 => 0x1 },
	'd-rangeoptimizerhighlight' => { 457 => 0x8024 },
	'd-rangeoptimizermode' => { 457 => 0x8022 },
	'd-rangeoptimizershadow' => { 457 => 0x802d },
	'd-rangeoptimizervalue' => { 457 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 322 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 492 => 'DataOnScreen' },
	'dataonscreenregion' => { 492 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 492 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 492 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 492 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 492 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 492 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 492 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 492 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 357 => 0x3d },
	'date' => { 357 => 0x6, 483 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 494 => 'DateCreated' },
	'datedisplayformat' => { 266 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 286 => '4.2' },
	'daterecieved' => { 496 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 227 => 0x9d },
	'datetime' => { 475 => 'datetime', 502 => 'DateTime' },
	'datetimedigitized' => { 486 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 377 => 'IDIT', 382 => 'date', 383 => 0xb, 384 => 0x3b, 385 => 0x3e, 486 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 299 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 266 => 0x2 },
	'dayofweek' => { 384 => 0x42, 385 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 118 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 480 => 'DefaultAutoGray', 482 => 'DefaultAutoGray' },
	'defaultautotone' => { 480 => 'DefaultAutoTone', 482 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 480 => 'DefaultsSpecificToISO', 482 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 480 => 'DefaultsSpecificToSerial', 482 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 480 => 'Defringe', 482 => 'Defringe' },
	'defringegreenamount' => { 480 => 'DefringeGreenAmount', 482 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 480 => 'DefringeGreenHueHi', 482 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 480 => 'DefringeGreenHueLo', 482 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 480 => 'DefringePurpleAmount', 482 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 480 => 'DefringePurpleHueHi', 482 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 480 => 'DefringePurpleHueLo', 482 => 'DefringePurpleHueLo' },
	'dehaze' => { 480 => 'Dehaze', 482 => 'Dehaze' },
	'deletedimagecount' => { 227 => 0xa6, 240 => 0x6e },
	'deprecatedon' => { 478 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 465 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 507 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 507 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 507 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 507 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 507 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 507 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 507 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 507 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 507 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 507 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 507 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 507 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 507 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 507 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 507 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 507 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 507 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 507 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 507 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 507 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 507 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 507 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 507 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 507 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 312 => 'Description', 374 => ['desc','dscp',"\xa9des"], 376 => 'description', 382 => 'dscp', 480 => 'Description', 482 => 'Description', 483 => 'description', 504 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 357 => 0x24, 363 => 0x3 },
	'destinationcitycode' => { 364 => 0x1001 },
	'destinationdst' => { 357 => 0x26, 363 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 496 => 'device' },
	'devicesettingdescription' => { 486 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 486 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 486 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 486 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 396 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 498 => 'dietaryNeeds' },
	'diffractioncompensation' => { 229 => 0x142, 230 => 0x1a2, 254 => 0xc4a0 },
	'diffractioncorrection' => { 322 => 0xbc, 347 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 239 => 0x202 },
	'digitaldeeshadowadj' => { 239 => 0x200 },
	'digitaldeethreshold' => { 239 => 0x201 },
	'digitalfilter' => { 399 => 0x59 },
	'digitalfilter01' => { 344 => 0x5 },
	'digitalfilter02' => { 344 => 0x16 },
	'digitalfilter03' => { 344 => 0x27 },
	'digitalfilter04' => { 344 => 0x38 },
	'digitalfilter05' => { 344 => 0x49 },
	'digitalfilter06' => { 344 => 0x5a },
	'digitalfilter07' => { 344 => 0x6b },
	'digitalfilter08' => { 344 => 0x7c },
	'digitalfilter09' => { 344 => 0x8d },
	'digitalfilter10' => { 344 => 0x9e },
	'digitalfilter11' => { 344 => 0xaf },
	'digitalfilter12' => { 344 => 0xc0 },
	'digitalfilter13' => { 344 => 0xd1 },
	'digitalfilter14' => { 344 => 0xe2 },
	'digitalfilter15' => { 344 => 0xf3 },
	'digitalfilter16' => { 344 => 0x104 },
	'digitalfilter17' => { 344 => 0x115 },
	'digitalfilter18' => { 344 => 0x126 },
	'digitalfilter19' => { 344 => 0x137 },
	'digitalfilter20' => { 344 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 215 => 0x0 },
	'digitalice' => { 239 => 0x100 },
	'digitalimageguid' => { 492 => 'DigImageGUID' },
	'digitalroc' => { 237 => 0x0 },
	'digitalsourcefiletype' => { 492 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 492 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 227 => 0x86, 264 => 0xa, 304 => 0x204, 357 => 0x1e, 364 => 0xa, 398 => 0x204, 444 => 0x12, 445 => 0x12 },
	'digitalzoomon' => { 398 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 433 => 0x200, 435 => 0x21c, 486 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 374 => "\xa9dir", 376 => 'director', 382 => "\xa9dir", 506 => 'director' },
	'directorphotography' => { 506 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 208 => 0x3, 385 => 0x12 },
	'disableautocreation' => { 463 => 'DisableAutoCreation' },
	'disclaimer' => { 312 => 'Disclaimer' },
	'discnumber' => { 506 => 'discNumber' },
	'dishtype' => { 498 => 'dishType' },
	'disknumber' => { 374 => 'disk' },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 372 => 0x2 },
	'displayedunitsy' => { 372 => 0x6 },
	'displayname' => { 376 => 'displayname', 495 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 396 => 0xa050 },
	'distortioncompensation' => { 457 => 0x8040 },
	'distortioncontrol' => { 240 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 299 => 0x50b, 326 => '7.1', 347 => 0x0, 452 => 0x601, 453 => 0x5b },
	'distortioncorrection2' => { 303 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 477 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 422 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 432 => 0x1a23, 435 => 0x1870, 437 => 0x189c, 438 => 0x18cc, 439 => 0x17d0, 452 => 0x6ca, 453 => 0x64 },
	'distortioncorrparamsnumber' => { 435 => 0x1899, 437 => 0x18c5, 438 => 0x18f5, 439 => 0x17f9 },
	'distortioncorrparamspresent' => { 435 => 0x1898, 437 => 0x18c4, 438 => 0x18f4, 439 => 0x17f8, 441 => 0x10b, 442 => 0x10b, 452 => 0x600, 453 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 326 => 0xc },
	'distortionparam02' => { 326 => 0x2 },
	'distortionparam04' => { 326 => 0x4 },
	'distortionparam08' => { 326 => 0x8 },
	'distortionparam09' => { 326 => 0x9 },
	'distortionparam11' => { 326 => 0xb },
	'distortionscale' => { 326 => 0x5 },
	'distributor' => { 496 => 'distributor' },
	'distributorproductid' => { 495 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 506 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 480 => 'DNGIgnoreSidecars', 482 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 312 => 'Document' },
	'documentancestors' => { 494 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 507 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 496 => 'doi' },
	'dopesheet' => { 492 => 'Dopesheet' },
	'dopesheetlink' => { 492 => 'DopesheetLink' },
	'dopesheetlinklink' => { 492 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 492 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 475 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 191 => 0x64d0, 299 => 0x600, 357 => 0x34, 389 => 0x1002, 399 => 0x3, 409 => 0x4, 410 => 0x7e, 411 => 0x34 },
	'drivemode2' => { 184 => 0xa, 338 => 0x7, 420 => 0xe, 427 => 0x1 },
	'drivemodesetting' => { 411 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 357 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 498 => 'duration', 506 => 'duration' },
	'durationscale' => { 506 => [\'duration','durationScale'] },
	'durationvalue' => { 506 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 230 => 0x23c },
	'dynamicafarea' => { 281 => '1.4', 290 => '1.4' },
	'dynamicareaafassist' => { 297 => 0x18 },
	'dynamicareaafdisplay' => { 282 => '46.1', 284 => '47.1', 285 => '47.1', 294 => '47.1', 295 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeboost' => { 322 => 0xee },
	'dynamicrangeexpansion' => { 357 => 0x69, 389 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 422 => [0xb025,0xb04f], 431 => 0x1144, 432 => [0x1144,0x324], 433 => [0x1120,0x300], 434 => [0x119c,0x37c], 435 => [0x1178,0x328], 436 => [0x1030,0x50], 437 => [0x228,0x50], 438 => [0x228,0x50], 439 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 420 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 409 => 0x19, 410 => 0x17, 411 => 0xd, 420 => 0x79, 427 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 409 => 0x18, 410 => 0x16, 420 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 411 => 0xc, 427 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 338 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 460 => 'EarthPos' },
	'earthposaltitude' => { 460 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 460 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 460 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 460 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 460 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 460 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 460 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 460 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 296 => '6.1' },
	'easyexposurecompensation' => { 281 => '6.4', 282 => '6.5', 284 => '6.3', 285 => '6.3', 289 => '5.1', 290 => '4.4', 291 => '5.2', 294 => '6.3', 295 => '6.3', 297 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 275 => 0x4, 457 => 0x8028 },
	'edit1' => { 382 => "\xa9ed1" },
	'edit2' => { 382 => "\xa9ed2" },
	'edit3' => { 382 => "\xa9ed3" },
	'edit4' => { 382 => "\xa9ed4" },
	'edit5' => { 382 => "\xa9ed5" },
	'edit6' => { 382 => "\xa9ed6" },
	'edit7' => { 382 => "\xa9ed7" },
	'edit8' => { 382 => "\xa9ed8" },
	'edit9' => { 382 => "\xa9ed9" },
	'edition' => { 496 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 369 => 'EditStatus', 475 => 'EditStatus' },
	'editversionname' => { 274 => 0x3d136244 },
	'effectivelv' => { 357 => 0x2d },
	'effectivemaxaperture' => { 220 => 0x12, 221 => 0x13, 225 => 0x14 },
	'eissn' => { 496 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 284 => '5.2', 285 => '5.2', 294 => '5.3', 295 => '5.2' },
	'electronicfrontcurtainshutter' => { 422 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 499 => 'embargoDate' },
	'embdencrightsexpr' => { 492 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 492 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 492 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 492 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 494 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 230 => 0x625 },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 374 => "\xa9enc" },
	'encodedwith' => { 376 => 'Encoded_With' },
	'encoder' => { 374 => "\xa9too", 382 => "\xa9too" },
	'encoderid' => { 382 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 396 => 0xa020 },
	'endingpage' => { 496 => 'endingPage' },
	'enduser' => { 309 => 'EndUser' },
	'enduserid' => { 309 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 309 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 230 => 0x648 },
	'engineer' => { 506 => 'engineer' },
	'enhancedarktones' => { 267 => 0x8 },
	'enhancedetailsalreadyapplied' => { 477 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 477 => 'EnhanceDetailsVersion' },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 303 => 0x300 },
	'enhancervalues' => { 303 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 477 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 477 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 477 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 492 => 'Episode' },
	'episodeglobaluniqueid' => { 374 => 'egid' },
	'episodeidentifier' => { 492 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 492 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 492 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 304 => 0x20c },
	'epsonimagewidth' => { 304 => 0x20b },
	'epsonsoftware' => { 304 => 0x20d },
	'equipmentinstitution' => { 459 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 459 => 'EquipmentManufacturer' },
	'equipmentversion' => { 300 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 461 => 'Event', 473 => 'Event', 492 => 'Event', 496 => 'event' },
	'eventalias' => { 495 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 495 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 492 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 383 => 0x9, 384 => 0x37, 385 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 495 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 495 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 495 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 297 => 0x165 },
	'evfimageframe' => { 297 => 0x164 },
	'evfreleaseindicator' => { 297 => 0x24f },
	'evfwarmdisplaybrightness' => { 297 => 0x24d },
	'evfwarmdisplaymode' => { 297 => 0x24b },
	'evsteps' => { 338 => '1.2', 340 => 0x0 },
	'evstepsize' => { 286 => '5.1', 287 => '6.1', 288 => '6.1', 292 => '0.7' },
	'exclusivecoverage' => { 470 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 499 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 374 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 486 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 486 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 486 => 'ExifVersion' },
	'exitpupilposition' => { 220 => 0x4, 221 => 0x4, 225 => 0x4 },
	'expirationdate' => { 131 => 0x25, 499 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 480 => 'Exposure', 482 => 'Exposure' },
	'exposure2012' => { 480 => 'Exposure2012', 482 => 'Exposure2012' },
	'exposureadj' => { 272 => 0x0 },
	'exposureadj2' => { 272 => 0x12 },
	'exposureadjust' => { 399 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 420 => 0x2f },
	'exposurebracketstepsize' => { 338 => 0x8 },
	'exposurebracketvalue' => { 227 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 304 => 0x1006, 357 => 0x16, 366 => 0x402, 396 => 0xa013, 399 => [0xc,0x35,0x4d], 431 => 0x114c, 432 => 0x114c, 433 => 0x1128, 435 => 0x1180, 436 => 0x1038, 437 => 0x230, 438 => 0x230, 439 => 0x223, 486 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 427 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 409 => 0x3, 410 => 0x3, 411 => 0x3, 427 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 281 => '6.3', 282 => '7.3', 284 => '7.3', 285 => '7.3', 290 => '4.3', 294 => '7.3', 295 => '7.3' },
	'exposurecontrolstep' => { 289 => '6.1', 291 => '6.1' },
	'exposurecontrolstepsize' => { 281 => '6.2', 282 => '7.1', 284 => '7.1', 285 => '7.1', 290 => '4.2', 294 => '7.1', 295 => '7.1', 296 => '7.1', 297 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelaymode' => { 281 => '10.1', 282 => '11.1', 284 => '11.1', 285 => '11.1', 286 => '9.1', 287 => '10.1', 288 => '10.1', 290 => '10.4', 291 => '10.1', 292 => '6.4', 294 => '11.1', 295 => '11.1', 296 => '11.2' },
	'exposuredifference' => { 227 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 486 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 409 => 0x58, 410 => 0x58 },
	'exposurelockused' => { 468 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 299 => 0x200, 319 => 0x40d, 399 => 0x8, 422 => 0xb041, 486 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 389 => 0x1001, 402 => [0x17e,0x43], 409 => 0x3c, 410 => 0x3c, 411 => 0x5, 415 => 0x14, 420 => 0x3f, 427 => 0x2, 431 => 0x1175, 432 => 0x1179, 433 => 0x1155, 434 => 0x11d1, 435 => 0x11ad, 436 => 0x1065, 437 => 0x25d, 438 => 0x25d, 439 => 0x24c, 449 => 0xb, 450 => 0xc, 451 => 0xb, 453 => 0x48, 486 => 'ExposureProgram' },
	'exposureshift' => { 299 => 0x203 },
	'exposurestandardadjustment' => { 422 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 357 => 0x12, 396 => 0xa018, 399 => [0x32,0x4a], 409 => 0x0, 410 => 0x0, 427 => [0x21,0x23,0x27], 453 => 0x10, 486 => 'ExposureTime' },
	'exposuretime2' => { 399 => [0x33,0x4b] },
	'exposuretuning' => { 227 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 491 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 230 => 0x114 },
	'extendedshutterspeeds' => { 297 => 0x102 },
	'extendedwbdetect' => { 299 => 0x902 },
	'extender' => { 300 => 0x301 },
	'extenderfirmwareversion' => { 300 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 300 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 300 => 0x302 },
	'extenderstatus' => { 355 => 0x3 },
	'externalflash' => { 302 => 0x1201 },
	'externalflashae1' => { 304 => 0x101f },
	'externalflashae1_0' => { 304 => 0x101b },
	'externalflashae2' => { 304 => 0x1020 },
	'externalflashae2_0' => { 304 => 0x101c },
	'externalflashbounce' => { 302 => 0x1204, 304 => 0x1026, 345 => 0x1a },
	'externalflashcompensation' => { 211 => 0x1b },
	'externalflashexposurecomp' => { 227 => 0x17, 345 => 0x19 },
	'externalflashfirmware' => { 209 => 0x6, 210 => 0x6, 211 => 0x6, 212 => 0x6, 213 => 0x6, 214 => 0x6 },
	'externalflashflags' => { 209 => 0x8, 210 => 0x8, 211 => 0x8, 212 => 0x8 },
	'externalflashguidenumber' => { 302 => 0x1203, 345 => '24.1' },
	'externalflashgvalue' => { 304 => 0x1025 },
	'externalflashmode' => { 304 => 0x1028, 345 => 0x2 },
	'externalflashreadystate' => { 213 => '9.1' },
	'externalflashstatus' => { 213 => '8.2' },
	'externalflashzoom' => { 302 => 0x1205, 304 => 0x1027 },
	'externalflashzoomoverride' => { 213 => '8.1' },
	'externalmetadatalink' => { 492 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 317 => 0x311, 320 => 0x311, 321 => 0x311, 324 => 0x3408 },
	'extrainfoversion' => { 413 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 207 => 0x28, 342 => 0x12 },
	'face10size' => { 343 => 0x12 },
	'face11position' => { 207 => 0x2c, 342 => 0x14 },
	'face11size' => { 343 => 0x14 },
	'face12position' => { 207 => 0x30, 342 => 0x16 },
	'face12size' => { 343 => 0x16 },
	'face13position' => { 342 => 0x18 },
	'face13size' => { 343 => 0x18 },
	'face14position' => { 342 => 0x1a },
	'face14size' => { 343 => 0x1a },
	'face15position' => { 342 => 0x1c },
	'face15size' => { 343 => 0x1c },
	'face16position' => { 342 => 0x1e },
	'face16size' => { 343 => 0x1e },
	'face17position' => { 342 => 0x20 },
	'face17size' => { 343 => 0x20 },
	'face18position' => { 342 => 0x22 },
	'face18size' => { 343 => 0x22 },
	'face19position' => { 342 => 0x24 },
	'face19size' => { 343 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 207 => 0x4, 314 => 0x1, 342 => 0x0, 386 => 0xbc, 416 => 0x1, 417 => 0x0, 418 => 0x0, 419 => 0x5b },
	'face1size' => { 343 => 0x0 },
	'face20position' => { 342 => 0x26 },
	'face20size' => { 343 => 0x26 },
	'face21position' => { 342 => 0x28 },
	'face21size' => { 343 => 0x28 },
	'face22position' => { 342 => 0x2a },
	'face22size' => { 343 => 0x2a },
	'face23position' => { 342 => 0x2c },
	'face23size' => { 343 => 0x2c },
	'face24position' => { 342 => 0x2e },
	'face24size' => { 343 => 0x2e },
	'face25position' => { 342 => 0x30 },
	'face25size' => { 343 => 0x30 },
	'face26position' => { 342 => 0x32 },
	'face26size' => { 343 => 0x32 },
	'face27position' => { 342 => 0x34 },
	'face27size' => { 343 => 0x34 },
	'face28position' => { 342 => 0x36 },
	'face28size' => { 343 => 0x36 },
	'face29position' => { 342 => 0x38 },
	'face29size' => { 343 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 207 => 0x8, 314 => 0x5, 342 => 0x2, 386 => 0xc8, 416 => 0x6, 417 => 0x20, 418 => 0x25, 419 => 0x65 },
	'face2size' => { 343 => 0x2 },
	'face30position' => { 342 => 0x3a },
	'face30size' => { 343 => 0x3a },
	'face31position' => { 342 => 0x3c },
	'face31size' => { 343 => 0x3c },
	'face32position' => { 342 => 0x3e },
	'face32size' => { 343 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 207 => 0xc, 314 => 0x9, 342 => 0x4, 386 => 0xd4, 416 => 0xb, 417 => 0x40, 418 => 0x4a, 419 => 0x6f },
	'face3size' => { 343 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 207 => 0x10, 314 => 0xd, 342 => 0x6, 386 => 0xe0, 416 => 0x10, 417 => 0x60, 418 => 0x6f, 419 => 0x79 },
	'face4size' => { 343 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 207 => 0x14, 314 => 0x11, 342 => 0x8, 386 => 0xec, 416 => 0x15, 417 => 0x80, 418 => 0x94 },
	'face5size' => { 343 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 207 => 0x18, 342 => 0xa, 386 => 0xf8, 416 => 0x1a, 417 => 0xa0, 418 => 0xb9 },
	'face6size' => { 343 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 207 => 0x1c, 342 => 0xc, 386 => 0x104, 416 => 0x1f, 417 => 0xc0, 418 => 0xde },
	'face7size' => { 343 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 207 => 0x20, 342 => 0xe, 386 => 0x110, 416 => 0x24, 417 => 0xe0, 418 => 0x103 },
	'face8size' => { 343 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 207 => 0x24, 342 => 0x10 },
	'face9size' => { 343 => 0x10 },
	'facebalanceorigi' => { 474 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 474 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 474 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 474 => 'FaceBalanceWarmth' },
	'facedetect' => { 357 => 0x76, 396 => 0x100 },
	'facedetectarea' => { 303 => 0x1201 },
	'facedetectframecrop' => { 303 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 207 => 0x1, 303 => 0x1203, 357 => 0x77, 386 => 0xb6 },
	'facedetection' => { 411 => 0x30, 427 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 476 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 396 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 341 => 0x2, 397 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 396 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 207 => 0x3, 303 => 0x1200, 322 => 0x3f, 341 => 0x0, 386 => 0xb5, 397 => 0x0, 416 => 0x0, 419 => 0x3, 430 => 0x30 },
	'facesrecognized' => { 315 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 422 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 465 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 492 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 484 => 'ffid' },
	'field' => { 495 => 'field' },
	'fieldcount' => { 304 => 0x103f },
	'fieldofview' => { 382 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 506 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 399 => [0x22,0x26], 422 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 323 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 309 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 208 => 0x4, 385 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 281 => '12.2', 286 => '3.1', 287 => '4.1', 288 => '4.1', 290 => '11.1', 291 => '4.3', 296 => '5.2', 297 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 486 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 480 => 'FillLight', 482 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 299 => 0x538 },
	'filmmode' => { 127 => 0x1401, 319 => 0x412, 322 => 0x42 },
	'filmtype' => { 239 => 0x2 },
	'filtereffect' => { 57 => 0xe, 233 => 0x37, 234 => 0x3f, 235 => 0x47, 322 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 357 => 0x70 },
	'finetuneoptcenterweighted' => { 281 => '7.2', 282 => '9.1', 284 => '9.1', 285 => '9.1', 289 => '8.1', 294 => '9.1', 295 => '9.1', 296 => '9.1', 297 => 0x23 },
	'finetuneopthighlightweighted' => { 284 => '46.1', 285 => '46.1', 294 => '46.1', 295 => '46.1', 297 => 0x27 },
	'finetuneoptmatrixmetering' => { 281 => '8.1', 282 => '8.2', 284 => '8.2', 285 => '8.2', 289 => '7.2', 290 => '6.1', 294 => '8.2', 295 => '8.2', 296 => '8.2', 297 => 0x21 },
	'finetuneoptspotmetering' => { 281 => '8.2', 282 => '9.2', 284 => '9.2', 285 => '9.2', 289 => '8.2', 290 => '6.2', 294 => '9.2', 295 => '9.2', 296 => '9.2', 297 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 304 => 0x405, 399 => [0x8c,0x17,0x3b], 477 => 'Firmware' },
	'firmware2' => { 399 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 383 => 0x4, 385 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 396 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 387 => 0x0 },
	'firmwarerevision2' => { 387 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 320 => 0x320, 322 => 0x2, 324 => 0x3109, 357 => 0x230, 382 => ['CNFV','FIRM'], 384 => 0x18, 385 => 0x2a, 389 => 0x2 },
	'firmwareversions' => { 366 => 0x301 },
	'firstphotodate' => { 468 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 309 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 475 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 385 => 0x5a, 486 => 'Flash' },
	'flashaction' => { 409 => 0x3e, 410 => 0x3e, 422 => 0x2017, 427 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 409 => 0x4c, 410 => 0x4c, 427 => 0x77 },
	'flashactionexternal' => { 427 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 322 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 297 => 0x111 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 304 => 0x1010 },
	'flashcolorfilter' => { 211 => 0x10, 212 => 0x10 },
	'flashcommandermode' => { 209 => '9.1', 210 => '9.1', 211 => '9.1', 212 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 213 => 0xa, 214 => 0xa, 477 => 'FlashCompensation' },
	'flashcontrol' => { 409 => 0x23, 410 => 0x1f, 411 => 0x21 },
	'flashcontrolbuilt-in' => { 290 => '16.1', 291 => '23.1', 293 => '23.1', 294 => '24.1' },
	'flashcontrolmode' => { 209 => '9.2', 210 => '9.2', 211 => '9.2', 212 => '9.2', 229 => 0x148, 230 => 0x1a8, 254 => 0xc4a6, 299 => 0x404 },
	'flashcurtain' => { 322 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 304 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 486 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 227 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 227 => 0x12, 299 => 0x401, 304 => 0x1023, 357 => 0x4d, 389 => 0x100b, 399 => [0x3a,0x56], 422 => 0x104 },
	'flashexposurecomp2' => { 258 => 0x4d2 },
	'flashexposurecomp3' => { 211 => 0x1d },
	'flashexposurecomp4' => { 211 => 0x27 },
	'flashexposurecomparea' => { 282 => '38.4', 284 => '38.4', 285 => '38.4', 294 => '38.4', 295 => '38.4', 297 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 330 => 0xe, 409 => 0x14, 410 => 0x12, 411 => 0x23, 427 => 0x1f },
	'flashexposurecompset2' => { 427 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 257 => '590.3', 486 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 300 => 0x1002 },
	'flashfocallength' => { 209 => 0xb, 210 => 0xc, 211 => 0xc, 212 => 0xc, 213 => 0xc },
	'flashfunction' => { 187 => 0x31, 486 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 209 => 0xe, 210 => 0xf, 211 => 0xf, 212 => 0xf, 213 => 0xf, 229 => 0x14e, 230 => 0x1ae, 254 => 0xc4ac },
	'flashgroupacompensation' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28 },
	'flashgroupacontrolmode' => { 209 => 0xf, 210 => '16.1', 211 => '17.1', 212 => '17.1', 213 => '17.1' },
	'flashgroupaoutput' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28 },
	'flashgroupbcompensation' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29 },
	'flashgroupbcontrolmode' => { 209 => 0x10, 210 => '17.1', 211 => '18.1', 212 => '18.1', 213 => '18.1' },
	'flashgroupboutput' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29 },
	'flashgroupccompensation' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a },
	'flashgroupccontrolmode' => { 210 => '17.2', 211 => '18.2', 212 => '18.2', 213 => '18.2' },
	'flashgroupcoutput' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashintensity' => { 112 => [0x19,0x5], 299 => 0x405 },
	'flashlevel' => { 283 => 0x9, 422 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 229 => 0x162, 230 => 0x1aa, 254 => 0xc4c0 },
	'flashmastercontrolmode' => { 229 => 0x160, 254 => 0xc4be },
	'flashmasteroutput' => { 229 => 0x166, 254 => 0xc4c4 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 357 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 227 => 0x87, 299 => 0x400, 304 => 0x1004, 357 => 0xc, 364 => 0x4, 388 => 0x20, 389 => 0x100a, 398 => 0x225, 409 => 0x13, 410 => 0x7f, 411 => 0x20, 427 => 0x10, 431 => 0x1138, 432 => 0x1138, 433 => 0x1114, 434 => 0x1190, 435 => 0x116c, 436 => 0x1024, 437 => 0x21c, 438 => 0x21c, 439 => 0x211, 486 => [\'Flash','FlashMode'] },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 300 => 0x1001 },
	'flashoptions' => { 338 => 0x2 },
	'flashoptions2' => { 338 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 229 => 0x152, 230 => 0x1b2, 254 => 0xc4b0 },
	'flashpixversion' => { 119 => 0xa000, 486 => 'FlashpixVersion' },
	'flashredeyemode' => { 486 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 229 => 0x15c, 230 => 0x1bc, 254 => 0xc4ba, 299 => 0x403 },
	'flashreturn' => { 486 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 300 => 0x1003 },
	'flashsetting' => { 227 => 0x8 },
	'flashshutterspeed' => { 281 => '20.2', 282 => '23.2', 284 => '23.2', 285 => '23.2', 290 => '15.2', 291 => '22.2', 292 => '7.2', 293 => '22.2', 294 => '23.2', 295 => '23.2', 296 => '23.1', 297 => 0x57 },
	'flashsource' => { 209 => 0x4, 210 => 0x4, 211 => 0x4, 212 => 0x4, 213 => 0x4, 214 => 0x4 },
	'flashstatus' => { 345 => 0x0, 427 => [0x82,0x86], 441 => 0x31, 442 => 0x39, 443 => 0x39 },
	'flashstatusbuilt-in' => { 411 => [0x87,0x287] },
	'flashstatusexternal' => { 411 => [0x88,0x288] },
	'flashsyncspeed' => { 281 => '20.1', 282 => '23.1', 284 => '23.1', 285 => '23.1', 290 => '15.1', 291 => '22.1', 293 => '22.1', 294 => '23.1', 295 => '23.1', 297 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 227 => 0x9, 300 => 0x1000 },
	'flashwarning' => { 291 => '30.1', 292 => '7.1', 296 => '31.1', 322 => 0x62 },
	'flashwirelessoption' => { 229 => 0x15a, 230 => 0x1c8, 254 => 0xc4c6 },
	'flexiblespotposition' => { 422 => 0x201d },
	'flickadvancedirection' => { 297 => 0x25f },
	'flickerreduce' => { 398 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 250 => 0xe84 },
	'flickerreductionindicator' => { 250 => 0x5e2 },
	'flickerreductionshooting' => { 230 => 0x1a4 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 274 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 225 => 0x38, 321 => 0x35a, 357 => 0x13, 396 => 0xa019, 399 => [0x31,0x49], 409 => 0x1, 410 => 0x1, 427 => [0x20,0x22,0x26], 486 => 'FNumber' },
	'focaldistance' => { 466 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 220 => 0xa, 221 => 0xb, 225 => [0xc,0x3c], 316 => 0x1, 357 => 0x1d, 366 => 0x403, 389 => 0x1500, 408 => 0xe, 435 => 0x1278, 436 => 0x1134, 437 => 0x32c, 438 => 0x32c, 439 => 0x30a, 486 => 'FocalLength' },
	'focallength2' => { 427 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 396 => 0xa01a, 486 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 408 => 0x10 },
	'focalplaneafpointarea' => { 440 => 0x2 },
	'focalplaneafpointlocation1' => { 440 => 0x6 },
	'focalplaneafpointlocation10' => { 440 => 0x2a },
	'focalplaneafpointlocation11' => { 440 => 0x2e },
	'focalplaneafpointlocation12' => { 440 => 0x32 },
	'focalplaneafpointlocation13' => { 440 => 0x36 },
	'focalplaneafpointlocation14' => { 440 => 0x3a },
	'focalplaneafpointlocation15' => { 440 => 0x3e },
	'focalplaneafpointlocation2' => { 440 => 0xa },
	'focalplaneafpointlocation3' => { 440 => 0xe },
	'focalplaneafpointlocation4' => { 440 => 0x12 },
	'focalplaneafpointlocation5' => { 440 => 0x16 },
	'focalplaneafpointlocation6' => { 440 => 0x1a },
	'focalplaneafpointlocation7' => { 440 => 0x1e },
	'focalplaneafpointlocation8' => { 440 => 0x22 },
	'focalplaneafpointlocation9' => { 440 => 0x26 },
	'focalplaneafpointsused' => { 440 => 0x1 },
	'focalplanediagonal' => { 300 => 0x103, 304 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 486 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 486 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 486 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 466 => 'FocalPointX' },
	'focalpointy' => { 466 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 264 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 292 => '15.2' },
	'focusbracket' => { 322 => 0xbd },
	'focusbracketstepsize' => { 299 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 220 => 0x9, 221 => 0xa, 225 => [0xb,0x4e], 302 => 0x305, 316 => 0x0, 320 => 0x304, 321 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 225 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 302 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 422 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 227 => 0x7, 299 => 0x301, 304 => 0x100b, 322 => 0x7, 357 => 0xd, 364 => 0x3, 389 => 0x1006, 402 => [0xb,0x5], 408 => [0x15,0x1d], 409 => 0x4d, 410 => 0x4d, 422 => [0xb042,0xb04e,0x201b], 427 => 0x13, 447 => 0x16 },
	'focusmode2' => { 126 => '0.1', 338 => '3.1', 427 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 283 => '10.1', 406 => 0x14, 407 => 0x15, 409 => 0x10, 410 => 0xf, 411 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 409 => 0x2e },
	'focuspeakingdisplay' => { 297 => 0x235 },
	'focuspeakinghighlightcolor' => { 297 => 0x4b },
	'focuspeakinglevel' => { 297 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 297 => 0x1d3 },
	'focuspointpersistence' => { 297 => 0x105 },
	'focuspointwrap' => { 281 => '2.2', 282 => '2.2', 284 => '2.1', 285 => '2.1', 289 => '1.1', 290 => '2.2', 291 => '1.1', 294 => '2.2', 295 => '2.1', 296 => '2.5', 297 => 0x16 },
	'focusposition' => { 220 => 0x8, 221 => 0x8, 357 => 0x10, 420 => 0x9bb },
	'focusposition2' => { 427 => [0x29,0x2b,0x2f], 447 => 0x2d, 450 => 0x20 },
	'focuspositionhorizontal' => { 194 => 0x43 },
	'focuspositionvertical' => { 194 => 0x45 },
	'focusprocess' => { 299 => 0x302 },
	'focusrange' => { 34 => 0x12, 304 => 0x100a },
	'focusrangeindex' => { 348 => '3.1' },
	'focusresult' => { 194 => 0x4a },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 399 => 0x6 },
	'focusshiftexposurelock' => { 229 => 0xe8, 230 => 0xf4, 254 => 0xc446 },
	'focusshiftinterval' => { 229 => 0xe4, 230 => 0xf0, 254 => 0xc442 },
	'focusshiftnumbershots' => { 229 => 0xdc, 230 => 0xe8, 254 => 0xc43a },
	'focusshiftshooting' => { 263 => 0x6c90 },
	'focusshiftstepwidth' => { 229 => 0xe0, 230 => 0xec, 254 => 0xc43e },
	'focusstatus' => { 408 => 0x19, 409 => 0x53, 410 => 0x53 },
	'focusstepcount' => { 302 => 0x301, 304 => 0x100e },
	'focusstepinfinity' => { 302 => 0x303, 304 => 0x103b },
	'focusstepnear' => { 302 => 0x304, 304 => 0x103c },
	'focustrackinglockon' => { 281 => ['1.5','4.1'], 282 => '1.4', 289 => '0.4', 290 => '3.1', 291 => '0.4', 294 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 409 => 0x9a, 411 => [0x402,0x114,0x316] },
	'fontcomposite' => { 511 => [\'Fonts','FontsComposite'] },
	'fontface' => { 511 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 511 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 511 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 511 => [\'Fonts','FontsFontName'] },
	'fonts' => { 511 => 'Fonts' },
	'fonttype' => { 511 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 511 => [\'Fonts','FontsVersionString'] },
	'for' => { 373 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 382 => "\xa9fmt", 465 => 'Format', 483 => 'format', 504 => 'Format' },
	'forwardlock' => { 501 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 368 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 357 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 376 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 495 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fujimodel' => { 127 => 0x1447 },
	'fujimodel2' => { 127 => 0x1448 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 422 => 0xb02b },
	'fullpanoheightpixels' => { 468 => 'FullPanoHeightPixels', 469 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 468 => 'FullPanoWidthPixels', 469 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 389 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 284 => '14.1', 285 => '14.1', 295 => '14.1', 297 => 0x63 },
	'func1buttonplaybackmode' => { 297 => 0x1a5 },
	'func1buttonplusdials' => { 284 => '42.1', 285 => '42.1', 295 => '42.1' },
	'func2button' => { 284 => '80.1', 285 => '80.1', 295 => '80.1', 297 => 0x73 },
	'func2buttonplaybackmode' => { 297 => 0x1a7 },
	'func2buttonplusdials' => { 284 => '81.1' },
	'func3button' => { 284 => '83.1', 297 => 0x119 },
	'func3buttonplaybackmode' => { 297 => 0x1a9 },
	'func4button' => { 297 => 0x175 },
	'func4buttonplaybackmode' => { 297 => 0x1af },
	'funcbutton' => { 281 => ['14.1','15.1'], 282 => '14.1', 290 => '28.1', 291 => '13.1', 294 => '14.1', 296 => '14.1' },
	'funcbuttonplusdials' => { 281 => ['14.2','15.2'], 282 => '14.2', 290 => '31.1', 294 => '42.1' },
	'functionbutton' => { 288 => '13.1', 292 => '5.2' },
	'gainbase' => { 303 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 486 => 'GainControl' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 310 => 'gAMA', 327 => 0x11c, 487 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 382 => 'pmcc' },
	'garminsoftware' => { 382 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 374 => ['gnre',"\xa9gen"], 376 => 'genre', 382 => ['gnre',"\xa9gen"], 492 => 'Genre', 496 => 'genre', 506 => 'genre' },
	'genrecvid' => { 492 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 492 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 492 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 492 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 374 => 'geID' },
	'geography' => { 497 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 470 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 371 => 0x419 },
	'globalangle' => { 371 => 0x40d },
	'good' => { 506 => 'good' },
	'googlehostheader' => { 374 => 'gshh' },
	'googlepingmessage' => { 374 => 'gspm' },
	'googlepingurl' => { 374 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 374 => 'gssd' },
	'googlestarttime' => { 374 => 'gsst' },
	'googletrackduration' => { 374 => 'gstd' },
	'goprotype' => { 382 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 486 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 486 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 486 => 'GPSAreaInformation' },
	'gpscoordinates' => { 374 => "\xa9xyz", 376 => 'location.ISO6709', 382 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 486 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 486 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 486 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 486 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 486 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 486 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 486 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 486 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 486 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 486 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 486 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 486 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GPS-GPSLatitude', 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 486 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 114 => 'GPS-GPSLongitude', 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 486 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 486 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 486 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 486 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 486 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 486 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 486 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 486 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 486 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 486 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 486 => 'GPSVersionID' },
	'gradation' => { 299 => 0x50f },
	'gradientbasedcorractive' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 480 => 'GradientBasedCorrections', 482 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 480 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 480 => 'GrainAmount', 482 => 'GrainAmount' },
	'graineffectroughness' => { 127 => 0x1047 },
	'graineffectsize' => { 127 => 0x104c },
	'grainfrequency' => { 480 => 'GrainFrequency', 482 => 'GrainFrequency' },
	'grainseed' => { 480 => 'GrainSeed', 482 => 'GrainSeed' },
	'grainsize' => { 480 => 'GrainSize', 482 => 'GrainSize' },
	'graymixeraqua' => { 480 => 'GrayMixerAqua', 482 => 'GrayMixerAqua' },
	'graymixerblue' => { 480 => 'GrayMixerBlue', 482 => 'GrayMixerBlue' },
	'graymixergreen' => { 480 => 'GrayMixerGreen', 482 => 'GrayMixerGreen' },
	'graymixermagenta' => { 480 => 'GrayMixerMagenta', 482 => 'GrayMixerMagenta' },
	'graymixerorange' => { 480 => 'GrayMixerOrange', 482 => 'GrayMixerOrange' },
	'graymixerpurple' => { 480 => 'GrayMixerPurple', 482 => 'GrayMixerPurple' },
	'graymixerred' => { 480 => 'GrayMixerRed', 482 => 'GrayMixerRed' },
	'graymixeryellow' => { 480 => 'GrayMixerYellow', 482 => 'GrayMixerYellow' },
	'graypoint' => { 457 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 480 => 'GreenHue', 482 => 'GreenHue' },
	'greensaturation' => { 480 => 'GreenSaturation', 482 => 'GreenSaturation' },
	'griddisplay' => { 281 => '13.3', 282 => '4.3', 284 => '4.2', 285 => '4.2', 286 => '2.2', 290 => '10.5', 291 => '3.4', 292 => '6.1', 294 => '4.4', 295 => '4.2', 296 => '4.2' },
	'gripbatteryadload' => { 336 => 0x5 },
	'gripbatteryadnoload' => { 336 => 0x4 },
	'gripbatterystate' => { 336 => '1.2' },
	'group' => { 480 => 'Group', 482 => 'Group' },
	'groupareaafillumination' => { 282 => '46.4', 285 => '47.4', 294 => '47.4' },
	'grouping' => { 374 => ['grup',"\xa9grp"], 382 => "\xa9grp" },
	'guid' => { 374 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 496 => 'hasAlternative' },
	'hascorrection' => { 496 => 'hasCorrection' },
	'hascorrectiona-lang' => { 496 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 496 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 496 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 480 => 'HasCrop', 482 => 'HasCrop' },
	'hasextendedxmp' => { 508 => 'HasExtendedXMP' },
	'hassettings' => { 480 => 'HasSettings', 482 => 'HasSettings' },
	'hastranslation' => { 496 => 'hasTranslation' },
	'hasvisibleoverprint' => { 511 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 511 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 229 => 0x35a },
	'hdmioutputresolution' => { 230 => 0x610 },
	'hdmiviewassist' => { 297 => 0x20f },
	'hdr' => { 60 => 0x1, 216 => 0x4, 217 => 0x4, 322 => 0x9e, 357 => 0x85, 422 => 0x200a },
	'hdreffect' => { 60 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 216 => 0x5, 217 => 0x5, 411 => 0x2e, 427 => 0x17 },
	'hdrlevel2' => { 216 => 0x7 },
	'hdrpmakernote' => { 463 => 'hdrp_makernote' },
	'hdrsetting' => { 411 => 0x2d, 427 => 0x16, 431 => 0x1148, 432 => 0x1148, 433 => 0x1124, 434 => 0x11a0, 435 => 0x117c, 436 => 0x1034, 437 => 0x22c, 438 => 0x22c, 439 => 0x21f },
	'hdrshot' => { 322 => 0x76 },
	'hdrsmoothing' => { 216 => 0x6 },
	'hdvideo' => { 374 => 'hdvd' },
	'headline' => { 131 => 0x69, 492 => 'Headline', 494 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 472 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 327 => 0x1a },
	'highisomultipliergreen' => { 327 => 0x19 },
	'highisomultiplierred' => { 327 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 227 => 0xb1, 357 => 0x71, 409 => 0x2c, 410 => 0x26, 411 => 0x26, 422 => 0x2009, 427 => 0x12, 453 => 0x42 },
	'highisonoisereduction2' => { 422 => 0xb050 },
	'highlight' => { 399 => 0xf },
	'highlight2012' => { 480 => 'Highlight2012', 482 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 457 => 0x8026 },
	'highlightlinearitylimit' => { 396 => 0xa025 },
	'highlightprotection' => { 273 => 0x6 },
	'highlightrecovery' => { 480 => 'HighlightRecovery', 482 => 'HighlightRecovery' },
	'highlights' => { 422 => 0x2033, 474 => 'Highlights' },
	'highlights2012' => { 480 => 'Highlights2012', 482 => 'Highlights2012' },
	'highlightsadj' => { 457 => 0x9019 },
	'highlightshadow' => { 322 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 322 => 0x8002 },
	'highlowkeyadj' => { 357 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 297 => 0x55, 409 => 0x2, 410 => 0x2 },
	'hintversion' => { 382 => 'hinv' },
	'histogramxml' => { 274 => 0x83a1a25 },
	'history' => { 494 => 'History', 507 => 'History' },
	'historyaction' => { 507 => [\'History','HistoryAction'] },
	'historychanged' => { 507 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 507 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 507 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 507 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 507 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 357 => 0x23, 363 => 0x2 },
	'hometowncitycode' => { 364 => 0x1000 },
	'hometowndst' => { 357 => 0x25, 363 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 234 => 0x3d, 235 => 0x45, 357 => 0x67 },
	'hueadj' => { 277 => 0x2f, 457 => 0x8019 },
	'hueadjust' => { 389 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 227 => 0x92, 233 => 0x36 },
	'hueadjustmentaqua' => { 480 => 'HueAdjustmentAqua', 482 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 480 => 'HueAdjustmentBlue', 482 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 480 => 'HueAdjustmentGreen', 482 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 480 => 'HueAdjustmentMagenta', 482 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 480 => 'HueAdjustmentOrange', 482 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 480 => 'HueAdjustmentPurple', 482 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 480 => 'HueAdjustmentRed', 482 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 480 => 'HueAdjustmentYellow', 482 => 'HueAdjustmentYellow' },
	'huesetting' => { 307 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 487 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 494 => 'ICCProfile' },
	'iconuri' => { 382 => 'icnu' },
	'idccreativestyle' => { 457 => 0x8000 },
	'idcpreviewlength' => { 457 => 0x202 },
	'idcpreviewstart' => { 457 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 118 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 483 => 'identifier', 504 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 292 => '0.5', 384 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 227 => 0x80, 264 => 0x5 },
	'imagealterationconstraints' => { 309 => 'ImageAlterationConstraints' },
	'imagearea' => { 244 => 0x10, 247 => 0x10 },
	'imageareaoffset' => { 357 => 0x38 },
	'imageauthentication' => { 227 => 0x20 },
	'imageboundary' => { 227 => 0x16 },
	'imagecount' => { 127 => 0x1438, 227 => 0xa5, 425 => 0x11b },
	'imagecreator' => { 309 => 'ImageCreator' },
	'imagecreatorid' => { 309 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 309 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 309 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 467 => 'Data' },
	'imagedatasize' => { 227 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 502 => 'ImageDescription' },
	'imageduplicationconstraints' => { 309 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 274 => 0xfe443a45 },
	'imageeditcount' => { 357 => 0x41 },
	'imageediting' => { 357 => 0x32 },
	'imageeffects' => { 389 => 0x1010 },
	'imagefileconstraints' => { 309 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 309 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 309 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 366 => 0x10d, 465 => 'ImageHeight', 502 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 485 => 'ImageHistory' },
	'imageidnumber' => { 317 => 0x340 },
	'imagemimetype' => { 467 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 366 => 0x113, 409 => 0x9b, 411 => [0x400,'276.1',0x314], 477 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 227 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 227 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingversion' => { 303 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 246 => '723.2', 247 => '732.2', 257 => '708.1', 322 => 0x1 },
	'imagequality2' => { 299 => 0x603 },
	'imagerank' => { 470 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 490 => 'ImageRef' },
	'imageregion' => { 492 => 'ImageRegion' },
	'imageregionboundary' => { 492 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 492 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 492 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 492 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 492 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 492 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 492 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 492 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 492 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 492 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 283 => '0.4', 292 => '0.4' },
	'imagereviewmonitorofftime' => { 282 => '21.1', 284 => '21.1', 285 => '21.1', 289 => '20.1', 294 => '21.1', 295 => '21.1', 297 => 0x39 },
	'imagereviewtime' => { 281 => '25.1', 283 => '2.1', 286 => '19.1', 287 => '20.1', 288 => '20.1', 290 => '9.2', 291 => '20.1', 296 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 227 => 0x3e },
	'imagesizerestriction' => { 499 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 227 => 0xac, 299 => 0x604, 302 => 0x1600, 322 => 0x1a, 414 => 0x12, 415 => 0x11, 422 => 0xb026 },
	'imagestabilization2' => { 413 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 409 => 0x3d, 410 => 0x3d, 420 => 0x14 },
	'imagestyle' => { 409 => 0x2d, 410 => 0x27 },
	'imagesupplier' => { 309 => 'ImageSupplier' },
	'imagesupplierid' => { 309 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 309 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 309 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 357 => 0x4f },
	'imagetype' => { 131 => 0x82, 309 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 485 => 'ImageUniqueID', 486 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 366 => 0x10c, 465 => 'ImageWidth', 502 => 'ImageWidth' },
	'inclinationangle' => { 457 => 0x900f },
	'inclinationcorrection' => { 457 => 0x900e },
	'incrementaltemperature' => { 480 => 'IncrementalTemperature', 482 => 'IncrementalTemperature' },
	'incrementaltint' => { 480 => 'IncrementalTint', 482 => 'IncrementalTint' },
	'industry' => { 496 => 'industry', 497 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 376 => 'information', 382 => "\xa9inf" },
	'infourl' => { 382 => 'infu' },
	'infraredilluminator' => { 383 => 0x28 },
	'ingredientexclusion' => { 498 => 'ingredientExclusion' },
	'ingredients' => { 507 => 'Ingredients' },
	'ingredientsalternatepaths' => { 507 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 507 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 507 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 507 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 507 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 507 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 507 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 507 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 507 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 507 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 507 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 507 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 507 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 507 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 507 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 507 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 507 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 507 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 507 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 507 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 507 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 507 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 507 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 468 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 468 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 468 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 468 => 'InitialViewHeadingDegrees', 469 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 468 => 'InitialViewPitchDegrees', 469 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 468 => 'InitialViewRollDegrees', 469 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 281 => '4.4' },
	'initialzoomsetting' => { 281 => '9.3', 290 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 507 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 494 => 'Instructions' },
	'instrument' => { 506 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 491 => 'IntellectualGenre' },
	'intelligentauto' => { 422 => 0xb052, 449 => 0xd, 450 => 0xe, 451 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 322 => 0x79 },
	'intelligentexposure' => { 322 => 0x5d },
	'intelligentresolution' => { 322 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 281 => '23.1', 283 => '8.1', 286 => '22.1', 288 => '23.1', 292 => '8.1', 296 => '24.1', 302 => 0x1208 },
	'internalflashae1' => { 304 => 0x1021 },
	'internalflashae1_0' => { 304 => 0x101d },
	'internalflashae2' => { 304 => 0x1022 },
	'internalflashae2_0' => { 304 => 0x101e },
	'internalflashmode' => { 345 => 0x1 },
	'internalflashstrength' => { 345 => 0x3 },
	'internalflashtable' => { 304 => 0x1024 },
	'internallensserialnumber' => { 396 => 0xa005 },
	'internalndfilter' => { 322 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 298 => 0x18, 300 => 0x102, 319 => 0x500, 322 => 0x25, 337 => 0x4, 389 => 0x5, 441 => [0x7c,0xf0], 442 => 0x88, 443 => [0x88,0x8a] },
	'interopindex' => { 119 => 0x1, 487 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 250 => 0xd0 },
	'intervaldurationhours' => { 229 => 0xa0 },
	'intervaldurationminutes' => { 229 => 0xa4 },
	'intervaldurationseconds' => { 229 => 0xa8 },
	'intervalexposuresmoothing' => { 229 => 0xb8, 254 => 0xc416 },
	'intervalframe' => { 250 => 0xd4 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 229 => 0xba, 254 => 0xc418 },
	'intervals' => { 229 => 0xb0, 230 => 0xbc, 254 => 0xc40e },
	'intervalshooting' => { 254 => 0x760c, 262 => 0x760c, 263 => 0x6c98, 357 => 0x92 },
	'introtime' => { 506 => 'introTime' },
	'introtimescale' => { 506 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 506 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 327 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 371 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 492 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 496 => 'isAlternativeOf' },
	'isbn' => { 496 => 'isbn' },
	'iscorrectionof' => { 496 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 477 => 'IsMergedHDR' },
	'ismergedpanorama' => { 477 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 218 => 0x0, 227 => 0x2, 322 => 0xd1, 327 => 0x17, 357 => [0x8b,0x14], 364 => 0x14, 366 => 0x105, 396 => 0xa014, 399 => 0x86, 420 => 0x6f, 427 => [0x1f,0x21,0x25], 486 => 'ISOSpeedRatings' },
	'iso2' => { 218 => 0x6, 241 => 0x265, 242 => 0x25c, 243 => 0x265, 244 => 0x221, 245 => 0x25d, 246 => 0x256, 247 => 0x25d, 251 => 0x2b5, 255 => 0x265, 261 => 0x2b5 },
	'isoauto' => { 338 => '14.4' },
	'isoautoflashlimit' => { 230 => 0x146 },
	'isoautohilimit' => { 230 => 0x144, 249 => 0x18eb, 250 => 0xe82, 259 => 0x185d },
	'isoautomax' => { 421 => 0x4 },
	'isoautomin' => { 421 => 0x2 },
	'isoautoparameters' => { 357 => 0x7a },
	'isoautoshuttertime' => { 230 => 0x14e, 249 => 0x18ea, 250 => 0xe81, 259 => 0x185c },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 284 => '4.1', 285 => '4.1', 286 => '2.3', 287 => '3.3', 288 => '3.3', 291 => '3.3', 294 => '4.3', 295 => '4.1', 296 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 218 => 0x4 },
	'isoexpansion2' => { 218 => 0xa },
	'isofloor' => { 338 => 0x6 },
	'isoselected' => { 321 => 0x359 },
	'isoselection' => { 227 => 0xf },
	'isosensitivitystep' => { 289 => '6.2', 291 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 227 => 0x13, 338 => '17.3', 388 => 0x27, 409 => 0x16, 410 => 0x14, 411 => 0x2, 420 => 0x6d, 421 => 0x0 },
	'isospeed' => { 119 => 0x8833, 487 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 487 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 487 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 281 => '6.1', 282 => '7.2', 284 => '7.2', 285 => '7.2', 290 => '4.1', 294 => '7.2', 295 => '7.2', 297 => 0x15d },
	'isovalue' => { 304 => 0x1001 },
	'isrccode' => { 382 => "\xa9isr" },
	'issn' => { 496 => 'issn' },
	'issueidentifier' => { 496 => 'issueIdentifier' },
	'issuename' => { 496 => 'issueName' },
	'issueteaser' => { 496 => 'issueTeaser' },
	'issuetype' => { 496 => 'issueType' },
	'istranslationof' => { 496 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 374 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 488 => 'JobName' },
	'jobref' => { 505 => 'JobRef' },
	'jobrefid' => { 505 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 505 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 505 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 488 => 'JobStatus' },
	'jpeg-heifswitch' => { 422 => 0x2039 },
	'jpeghandling' => { 480 => 'JPEGHandling', 482 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 322 => 0x43, 324 => 0x3034, 422 => 0xb047 },
	'jpegsize' => { 324 => 0x303a },
	'jpgcompression' => { 250 => 0x7d4 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 327 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 338 => '14.1' },
	'jurisdiction' => { 478 => 'jurisdiction' },
	'keepexposure' => { 297 => 0x237 },
	'kelvinwb_01' => { 346 => 0x5 },
	'kelvinwb_02' => { 346 => 0x9 },
	'kelvinwb_03' => { 346 => 0xd },
	'kelvinwb_04' => { 346 => 0x11 },
	'kelvinwb_05' => { 346 => 0x15 },
	'kelvinwb_06' => { 346 => 0x19 },
	'kelvinwb_07' => { 346 => 0x1d },
	'kelvinwb_08' => { 346 => 0x21 },
	'kelvinwb_09' => { 346 => 0x25 },
	'kelvinwb_10' => { 346 => 0x29 },
	'kelvinwb_11' => { 346 => 0x2d },
	'kelvinwb_12' => { 346 => 0x31 },
	'kelvinwb_13' => { 346 => 0x35 },
	'kelvinwb_14' => { 346 => 0x39 },
	'kelvinwb_15' => { 346 => 0x3d },
	'kelvinwb_16' => { 346 => 0x41 },
	'kelvinwb_daylight' => { 346 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 506 => 'key' },
	'keystonecompensation' => { 303 => 0x1900 },
	'keystonedirection' => { 303 => 0x1901 },
	'keystonevalue' => { 303 => 0x1906 },
	'keyword' => { 374 => 'keyw', 496 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 308 => 'Keywords', 373 => 'Keywords', 376 => 'keywords', 475 => 'keywords', 493 => 'Keywords', 504 => 'Keywords' },
	'killdate' => { 496 => 'killDate' },
	'killdatea-platform' => { 496 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 496 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 312 => 'Label', 504 => 'Label' },
	'labelname1' => { 490 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 490 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 322 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 230 => 0x592, 483 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 468 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 468 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 468 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 468 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 468 => 'LastPhotoDate' },
	'lasturl' => { 507 => 'LastURL' },
	'lateralchromaticaberration' => { 422 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 477 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 348 => 0x2 },
	'lc10' => { 348 => 0xb },
	'lc11' => { 348 => 0xc },
	'lc12' => { 348 => 0xd },
	'lc14' => { 348 => 0xf },
	'lc15' => { 348 => 0x10 },
	'lc3' => { 348 => 0x4 },
	'lc4' => { 348 => 0x5 },
	'lc5' => { 348 => 0x6 },
	'lc6' => { 348 => 0x7 },
	'lc7' => { 348 => 0x8 },
	'lc8' => { 348 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 281 => '17.5', 282 => '5.2', 284 => '5.1', 285 => '5.1', 290 => '10.3', 291 => '4.2', 294 => '5.2', 295 => '5.1', 296 => '5.4', 297 => 0x101 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 274 => 0x8ae85e },
	'legacyiptcdigest' => { 494 => 'LegacyIPTCDigest' },
	'legalcode' => { 478 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 227 => 0x84, 477 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 399 => [0x30,0x48] },
	'lenscontrolring' => { 297 => 0xad },
	'lenscorrectionsettings' => { 485 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 477 => 'LensDistortInfo' },
	'lensdistortionparams' => { 304 => 0x206 },
	'lensdriveend' => { 225 => 0x56 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 411 => 0x3f0, 456 => 0xd },
	'lensfirmware' => { 390 => 0x20, 396 => 0xa004 },
	'lensfirmwareversion' => { 300 => 0x204, 322 => 0x60, 411 => 0x3f3, 456 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 348 => 0x9 },
	'lensfocalrange' => { 399 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 282 => '55.1', 284 => '52.1', 285 => '52.1', 294 => '52.1', 295 => '52.1' },
	'lensformat' => { 435 => 0x1891, 437 => 0x18bd, 438 => 0x18ed, 439 => 0x17f1, 441 => 0x106, 442 => 0x106, 452 => 0x603, 453 => 0x5d },
	'lensfstops' => { 219 => 0x7, 220 => 0xc, 221 => 0xd, 225 => 0xe, 227 => 0x8b, 348 => '0.3' },
	'lensfunc1button' => { 297 => 0x9f },
	'lensfunc2button' => { 297 => 0xa7 },
	'lensid' => { 225 => 0x30, 477 => 'LensID' },
	'lensidnumber' => { 219 => 0x6, 220 => 0xb, 221 => 0xc, 225 => 0xd },
	'lensinfo' => { 119 => 0xa432, 354 => 0x2a, 477 => 'LensInfo', 487 => 'LensSpecification' },
	'lenskind' => { 348 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 487 => 'LensMake' },
	'lensmanualdistortionamount' => { 480 => 'LensManualDistortionAmount', 482 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 399 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 222 => 0x18a, 223 => 0x18b, 224 => 0x2ac, 300 => 0x203, 354 => 0xc, 366 => 0x412, 487 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 411 => 0x99, 435 => 0x1892, 437 => 0x18be, 438 => 0x18ee, 439 => 0x17f2, 441 => 0x105, 442 => 0x105, 452 => 0x604, 453 => 0x5e },
	'lensmount2' => { 456 => 0x8 },
	'lensmounttype' => { 225 => 0x35 },
	'lenspositionabsolute' => { 225 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 480 => 'LensProfileChromaticAberrationScale', 482 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 480 => 'LensProfileDigest', 482 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 480 => 'LensProfileDistortionScale', 482 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 480 => 'LensProfileEnable', 482 => 'LensProfileEnable' },
	'lensprofilefilename' => { 480 => 'LensProfileFilename', 482 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 480 => 'LensProfileIsEmbedded', 482 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 480 => 'LensProfileMatchKeyCameraModelName', 482 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 480 => 'LensProfileMatchKeyExifMake', 482 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 480 => 'LensProfileMatchKeyExifModel', 482 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 480 => 'LensProfileMatchKeyIsRaw', 482 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 480 => 'LensProfileMatchKeyLensID', 482 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 480 => 'LensProfileMatchKeyLensInfo', 482 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 480 => 'LensProfileMatchKeyLensName', 482 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 480 => 'LensProfileMatchKeySensorFormatFactor', 482 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 480 => 'LensProfileName', 482 => 'LensProfileName' },
	'lensprofilesetup' => { 480 => 'LensProfileSetup', 482 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 480 => 'LensProfileVignettingScale', 482 => 'LensProfileVignettingScale' },
	'lensproperties' => { 300 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 300 => 0x202, 320 => 0x321, 322 => 0x52, 382 => 'LENS', 390 => 0x30, 477 => 'LensSerialNumber', 487 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 406 => 0x0, 407 => 0x0, 408 => 0x0, 422 => 0xb02a },
	'lensspecfeatures' => { 441 => [0x115,0x116], 442 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 304 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 227 => 0x83, 300 => 0x201, 313 => 0x16, 317 => 0x310, 319 => 0x303, 320 => 0x303, 322 => 0x51, 324 => 0x3405, 349 => 0x0, 350 => 0x0, 351 => 0x1, 352 => 0x1, 353 => 0x1, 355 => 0x0, 396 => 0xa003, 399 => 0x27, 422 => 0xb027, 435 => 0x1896, 437 => 0x18c2, 438 => 0x18f2, 439 => 0x17f6, 441 => 0x109, 442 => 0x109, 452 => 0x608, 453 => 0x62 },
	'lenstype2' => { 411 => 0x3f7, 435 => 0x1893, 437 => 0x18bf, 438 => 0x18ef, 439 => 0x17f3, 441 => 0x107, 442 => 0x107, 452 => 0x605, 453 => 0x60 },
	'lenstype3' => { 456 => 0x9 },
	'lenstypemake' => { 322 => 0xc4 },
	'lenstypemodel' => { 322 => [0xc5,0xe4] },
	'lenszoomposition' => { 449 => 0x19, 450 => 0x1e, 453 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 330 => 0x15 },
	'levelmeter' => { 382 => ['Lvlm','lvlm'] },
	'levelorientation' => { 356 => 0x0 },
	'license' => { 478 => 'license' },
	'licensee' => { 309 => 'Licensee' },
	'licenseeid' => { 309 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 309 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 309 => 'LicenseeImageNotes' },
	'licenseename' => { 309 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 309 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 309 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 309 => 'LicenseeTransactionID' },
	'licenseid' => { 309 => 'LicenseID' },
	'licensestartdate' => { 309 => 'LicenseStartDate' },
	'licensetransactiondate' => { 309 => 'LicenseTransactionDate' },
	'licensetype' => { 484 => 'licensetype' },
	'licensor' => { 309 => 'Licensor' },
	'licensorcity' => { 309 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 309 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 309 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 309 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 309 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 309 => 'LicensorImageID' },
	'licensorname' => { 309 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 309 => 'LicensorNotes' },
	'licensorpostalcode' => { 309 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 309 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 309 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 309 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 309 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 309 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 309 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 309 => 'LicensorTransactionID' },
	'licensorurl' => { 309 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 304 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 357 => 0x15 },
	'lightsource' => { 119 => 0x9208, 227 => 0x90, 307 => 0x1000, 486 => 'LightSource' },
	'lightsourcespecial' => { 398 => 0x21d },
	'lightswitch' => { 294 => '0.1', 296 => '0.1' },
	'lightvaluecenter' => { 304 => 0x103d },
	'lightvalueperiphery' => { 304 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 297 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 297 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 297 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 297 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 297 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 297 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 297 => 0x13 },
	'limitafareamodeselauto' => { 297 => 0x15 },
	'limitafareamodeselection' => { 282 => '51.1', 284 => '49.1', 285 => '49.1', 294 => '49.1', 295 => '49.1' },
	'limitreleasemodeselc120' => { 297 => '269.4' },
	'limitreleasemodeselc30' => { 297 => '269.3' },
	'limitreleasemodeselch' => { 297 => '269.2' },
	'limitreleasemodeselcl' => { 297 => '269.1' },
	'limitreleasemodeselself' => { 297 => '269.5' },
	'limitselectableimagearea16to9' => { 297 => 0x47 },
	'limitselectableimagearea1to1' => { 297 => 0x46 },
	'limitselectableimageareadx' => { 297 => 0x45 },
	'linearitylimitblue' => { 327 => 0x10 },
	'linearitylimitgreen' => { 327 => 0xf },
	'linearitylimitred' => { 327 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 496 => 'link' },
	'linkaetoafpoint' => { 338 => '14.2' },
	'linkedencodedrightsexpr' => { 492 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 492 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 492 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 492 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 376 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 376 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 376 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 286 => '32.1', 296 => '34.1' },
	'liveviewafareamode' => { 291 => '34.1' },
	'liveviewafmethod' => { 427 => 0x20 },
	'liveviewafmode' => { 291 => '34.2' },
	'liveviewafsetting' => { 411 => 0x36 },
	'liveviewbuttonoptions' => { 282 => '50.2', 284 => '48.2', 285 => '48.2', 294 => '48.2', 295 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 411 => [0x8b,0x28b] },
	'liveviewmetering' => { 411 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 282 => '21.2', 284 => '21.2', 285 => '21.2', 287 => '20.2', 288 => '20.2', 289 => '20.2', 291 => '20.2', 294 => '21.2', 295 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 396 => 0x30 },
	'location' => { 226 => 0x9, 322 => 0x67, 473 => 'Location', 491 => 'Location', 495 => 'location', 496 => 'location' },
	'locationaccuracyhorizontal' => { 376 => 'location.accuracy.horizontal' },
	'locationareacode' => { 479 => 'lac' },
	'locationbody' => { 376 => 'location.body' },
	'locationcreated' => { 492 => 'LocationCreated' },
	'locationcreatedcity' => { 492 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 492 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 492 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 492 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 492 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 492 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 492 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 492 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 492 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 492 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 492 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 492 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 376 => 'location.date' },
	'locationinformation' => { 382 => 'loci' },
	'locationinfoversion' => { 226 => 0x0 },
	'locationname' => { 376 => 'location.name', 396 => 0x31 },
	'locationnote' => { 376 => 'location.note' },
	'locationrole' => { 376 => 'location.role' },
	'locationshown' => { 492 => 'LocationShown' },
	'locationshowncity' => { 492 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 492 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 492 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 492 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 492 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 492 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 492 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 492 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 492 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 492 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 492 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 492 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 506 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 374 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 322 => 0x49, 409 => 0x2b, 410 => 0x25, 411 => 0x25, 422 => 0x2008, 427 => 0x11, 453 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 322 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 480 => 'Look', 482 => 'Look' },
	'lookamount' => { 480 => [\'Look','LookAmount'], 482 => [\'Look','LookAmount'] },
	'lookcluster' => { 480 => [\'Look','LookCluster'], 482 => [\'Look','LookCluster'] },
	'lookcopyright' => { 480 => [\'Look','LookCopyright'], 482 => [\'Look','LookCopyright'] },
	'lookgroup' => { 480 => [\'Look','LookGroup'], 482 => [\'Look','LookGroup'] },
	'lookname' => { 480 => 'LookName', 482 => 'LookName' },
	'lookparameters' => { 480 => [\'Look','LookParameters'], 482 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 480 => [\'Look','LookParametersCameraProfile'], 482 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 480 => [\'Look','LookParametersClarity2012'], 482 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 480 => [\'Look','LookParametersConvertToGrayscale'], 482 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 480 => [\'Look','LookParametersLookTable'], 482 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 480 => [\'Look','LookParametersProcessVersion'], 482 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 480 => [\'Look','LookParametersToneCurvePV2012'], 482 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 480 => [\'Look','LookParametersToneCurvePV2012Blue'], 482 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 480 => [\'Look','LookParametersToneCurvePV2012Green'], 482 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 480 => [\'Look','LookParametersToneCurvePV2012Red'], 482 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 480 => [\'Look','LookParametersVersion'], 482 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 480 => [\'Look','LookSupportsAmount'], 482 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 480 => [\'Look','LookSupportsMonochrome'], 482 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 480 => [\'Look','LookSupportsOutputReferred'], 482 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 480 => [\'Look','LookUUID'], 482 => [\'Look','LookUUID'] },
	'loop' => { 506 => 'loop' },
	'loopstyle' => { 382 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 480 => 'LuminanceAdjustmentAqua', 482 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 480 => 'LuminanceAdjustmentBlue', 482 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 480 => 'LuminanceAdjustmentGreen', 482 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 480 => 'LuminanceAdjustmentMagenta', 482 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 480 => 'LuminanceAdjustmentOrange', 482 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 480 => 'LuminanceAdjustmentPurple', 482 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 480 => 'LuminanceAdjustmentRed', 482 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 480 => 'LuminanceAdjustmentYellow', 482 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 399 => 0x1b },
	'luminancenoisereductioncontrast' => { 480 => 'LuminanceNoiseReductionContrast', 482 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 480 => 'LuminanceNoiseReductionDetail', 482 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 480 => 'LuminanceSmoothing', 482 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 374 => "\xa9lyr", 382 => "\xa9lyr", 506 => 'lyrics' },
	'lyricsuri' => { 382 => 'lrcu' },
	'm16cversion' => { 317 => 0x333 },
	'macatom' => { 481 => 'macAtom' },
	'macatomapplicationcode' => { 481 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 481 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 481 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 304 => 0x202, 388 => 0x21, 398 => 0x202, 422 => 0xb040 },
	'macroled' => { 302 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 299 => 0x300, 322 => 0x1c, 389 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 299 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 292 => '0.6' },
	'mainingredient' => { 498 => 'mainIngredient' },
	'majorversion' => { 471 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 312 => 'Make', 327 => 0x10f, 376 => 'make', 382 => ['@mak',"\xa9mak"], 495 => 'make', 502 => 'Make' },
	'makernote' => { 486 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedjiinfo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 398 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 382 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 389 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 186 => 0x0, 227 => 0x1, 304 => 0x0, 322 => 0x8000, 393 => 0x0, 396 => 0x1, 399 => [0x1d,0x1f], 412 => 0x2000 },
	'makerurl' => { 382 => "\xa9mal" },
	'managedfrom' => { 507 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 507 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 507 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 507 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 507 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 507 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 507 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 507 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 507 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 507 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 507 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 507 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 507 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 507 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 507 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 507 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 507 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 507 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 507 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 507 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 507 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 507 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 507 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 507 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 507 => 'Manager' },
	'managervariant' => { 507 => 'ManagerVariant' },
	'manageto' => { 507 => 'ManageTo' },
	'manageui' => { 507 => 'ManageUI' },
	'manifest' => { 507 => 'Manifest' },
	'manifestlinkform' => { 507 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 507 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 507 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 507 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 507 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 507 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 507 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 507 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 507 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 507 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 507 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 507 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 507 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 507 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 507 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 507 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 507 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 507 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 507 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 507 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 507 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 507 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 507 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 507 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 507 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 507 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 507 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 507 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 299 => 0x900, 322 => 0x86 },
	'manometerreading' => { 299 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 302 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 283 => '8.2', 286 => '22.2', 287 => '23.1', 288 => '23.2', 290 => '16.2', 291 => '23.2', 292 => '8.2', 293 => '23.2', 296 => '24.2', 389 => 0x100c },
	'manualflashstrength' => { 299 => 0x406 },
	'manualfocusdistance' => { 227 => 0x85, 304 => 0x100c, 398 => 0x223 },
	'manualfocuspointillumination' => { 297 => 0x17 },
	'manualfocusringinafmode' => { 297 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 337 => 0x1 },
	'manufacturedate1' => { 391 => 0x4 },
	'manufacturedate2' => { 391 => 0x5 },
	'manufacturer' => { 465 => 'Manufacturer', 495 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 493 => 'Marked', 510 => 'Marked' },
	'markers' => { 506 => 'markers' },
	'markerscomment' => { 506 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 506 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 506 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 506 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 506 => [\'markers','markersCuePointType'] },
	'markersduration' => { 506 => [\'markers','markersDuration'] },
	'markerslocation' => { 506 => [\'markers','markersLocation'] },
	'markersname' => { 506 => [\'markers','markersName'] },
	'markersprobability' => { 506 => [\'markers','markersProbability'] },
	'markersspeaker' => { 506 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 506 => [\'markers','markersStartTime'] },
	'markerstarget' => { 506 => [\'markers','markersTarget'] },
	'markerstype' => { 506 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 480 => 'MaskGroupBasedCorrections', 482 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 480 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 239 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 282 => '50.1', 284 => '48.1', 285 => '48.1', 294 => '48.1', 295 => '48.1', 297 => 0x233 },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 381 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 225 => 0x36, 300 => 0x20a, 348 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 219 => 0xb, 220 => 0x10, 221 => 0x11, 225 => 0x12, 300 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 219 => 0xa, 220 => 0xf, 221 => 0x10, 225 => 0x11, 300 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 366 => 0x414, 486 => 'MaxApertureValue' },
	'maxavailheight' => { 492 => 'MaxAvailHeight' },
	'maxavailwidth' => { 492 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 281 => 0xb, 282 => 0xc, 284 => '12.1', 285 => '12.1', 290 => 0xc, 291 => 0xb, 294 => '12.1', 295 => '12.1', 297 => 0x3d },
	'maxfaces' => { 303 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 219 => 0x9, 220 => 0xe, 221 => 0xf, 225 => 0x10, 300 => 0x208, 435 => 0x127c, 436 => 0x1138, 437 => 0x330, 438 => 0x330, 439 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 511 => 'MaxPageSize' },
	'maxpagesizeh' => { 511 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 511 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 511 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 501 => 'maxstorage' },
	'mb-d10batteries' => { 281 => '12.6' },
	'mb-d10batterytype' => { 290 => '13.3' },
	'mb-d11batterytype' => { 291 => '2.3' },
	'mb-d12batterytype' => { 294 => '3.2' },
	'mb-d80batteries' => { 292 => '6.5' },
	'mb-d80batterytype' => { 296 => '3.2' },
	'mcuversion' => { 219 => 0xc, 220 => 0x11, 221 => 0x12, 225 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 498 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 317 => 0x312, 320 => 0x312, 321 => 0x312, 324 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 465 => 'MeasureType' },
	'mechanicalshuttercount' => { 227 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 309 => 'MediaConstraints' },
	'mediacreatedate' => { 378 => 0x1 },
	'mediaeventiddate' => { 470 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 378 => 0x2 },
	'mediasummarycode' => { 309 => 'MediaSummaryCode' },
	'mediatype' => { 374 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 415 => 0x16 },
	'memorycardnumber' => { 208 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 281 => '26.1', 282 => '22.1', 284 => '22.1', 285 => '22.1', 289 => '21.1', 290 => '8.2', 291 => '21.1', 294 => '22.1', 295 => '22.1', 296 => '22.1', 297 => 0x35 },
	'menusettingsz7iioffset' => { 262 => 0xceb6 },
	'metadataauthority' => { 492 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 492 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 492 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 504 => 'MetadataDate' },
	'metadatalastedited' => { 492 => 'metadataLastEdited' },
	'metadatalasteditor' => { 492 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 492 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 492 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 506 => 'metadataModDate' },
	'metaversion' => { 430 => 0x34 },
	'meterinfo1row1' => { 423 => 0x0, 424 => 0x0 },
	'meterinfo1row2' => { 423 => 0x6c, 424 => 0x5a },
	'meterinfo1row3' => { 423 => 0xd8, 424 => 0xb4 },
	'meterinfo1row4' => { 423 => 0x144, 424 => 0x10e },
	'meterinfo1row5' => { 423 => 0x1b0, 424 => 0x168 },
	'meterinfo1row6' => { 423 => 0x21c, 424 => 0x1c2 },
	'meterinfo1row7' => { 423 => 0x288, 424 => 0x21c },
	'meterinfo2row1' => { 423 => 0x2f4, 424 => 0x276 },
	'meterinfo2row2' => { 423 => 0x378, 424 => 0x2e4 },
	'meterinfo2row3' => { 423 => 0x3fc, 424 => 0x352 },
	'meterinfo2row4' => { 423 => 0x480, 424 => 0x3c0 },
	'meterinfo2row5' => { 423 => 0x504, 424 => 0x42e },
	'meterinfo2row6' => { 423 => 0x588, 424 => 0x49c },
	'meterinfo2row7' => { 423 => 0x60c, 424 => 0x50a },
	'meterinfo2row8' => { 423 => 0x690, 424 => 0x578 },
	'meterinfo2row9' => { 423 => 0x714, 424 => 0x5e6 },
	'metering' => { 283 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 299 => 0x202, 357 => 0x17, 399 => 0x9, 409 => 0x15, 410 => 0x13, 411 => 0x7, 427 => 0x3, 431 => 0x1174, 432 => 0x1178, 433 => 0x1154, 434 => 0x11d0, 435 => 0x11ac, 436 => 0x1064, 437 => 0x25c, 438 => 0x25c, 439 => 0x24b, 486 => 'MeteringMode' },
	'meteringmode2' => { 338 => '2.1', 422 => 0x202c },
	'meteringmode3' => { 338 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 281 => '22.2', 283 => '3.2', 286 => '17.1', 287 => '18.1', 290 => '7.3', 291 => '18.1', 292 => '3.2', 296 => '19.1' },
	'micro1version' => { 384 => 0x1f },
	'micro2version' => { 384 => 0x2d },
	'microphoneattenuator' => { 230 => 0x2d2 },
	'microphonefrequencyresponse' => { 230 => 0x2d4 },
	'microphonejackpower' => { 230 => 0x2fa },
	'microphonesensitivity' => { 230 => 0x2d0 },
	'microvideo' => { 463 => 'MicroVideo' },
	'microvideooffset' => { 463 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 463 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 463 => 'MicroVideoVersion' },
	'midrangesharpness' => { 235 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 465 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 348 => '0.2' },
	'minaperturevalue' => { 366 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 219 => 0x8, 220 => 0xd, 221 => 0xe, 225 => 0xf, 300 => 0x207, 435 => 0x127a, 436 => 0x1136, 437 => 0x32e, 438 => 0x32e, 439 => 0x30c },
	'minfocusdistance' => { 348 => 0x3 },
	'minimumiso' => { 322 => 0xe8 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 309 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 471 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 479 => 'mcc' },
	'mobilenetworkcode' => { 479 => 'mnc' },
	'moddate' => { 312 => 'modify-date', 493 => 'ModDate' },
	'modedialposition' => { 415 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 312 => 'Model', 327 => 0x110, 357 => 0x23f, 376 => 'model', 382 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 399 => 0x84, 465 => 'Model', 495 => 'model', 502 => 'Model' },
	'modelage' => { 492 => 'ModelAge' },
	'modelid' => { 298 => 0x0 },
	'modelingflash' => { 281 => '21.4', 282 => '31.1', 284 => '31.1', 285 => '31.1', 290 => '26.4', 291 => '30.2', 292 => '7.4', 293 => '30.1', 294 => '31.1', 295 => '31.1', 296 => '31.3', 297 => 0x5d },
	'modelreleaseid' => { 309 => 'ModelReleaseID' },
	'modelreleasestatus' => { 309 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 444 => 0x52, 445 => 0x46, 446 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 495 => 'modelYear' },
	'modificationdate' => { 496 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 299 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 308 => 'ModDate', 310 => 'tIME', 373 => 'ModDate', 379 => 0x2, 504 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 480 => 'MoireFilter', 482 => 'MoireFilter' },
	'monitorbrightness' => { 230 => 0x59a },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 281 => '18.2', 283 => '3.1', 292 => '3.1' },
	'monochromecolor' => { 299 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 322 => 0xac, 357 => 0x73 },
	'monochromegraineffect' => { 322 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 299 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 357 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 299 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 383 => 0x12, 384 => 0x43, 385 => 0x4c },
	'morepermissions' => { 478 => 'morePermissions' },
	'motionsensitivity' => { 383 => 0x29, 385 => 0x60 },
	'movementcount' => { 374 => "\xa9mvc" },
	'movementname' => { 374 => "\xa9mvn" },
	'movementnumber' => { 374 => "\xa9mvi" },
	'movieactived-lighting' => { 229 => 0x238, 230 => 0x2b8 },
	'movieaelockbuttonassignment' => { 294 => '40.1' },
	'movieaf-onbutton' => { 297 => 0xcb },
	'movieafareamode' => { 230 => 0x2c6, 297 => 0x203 },
	'movieafspeed' => { 297 => 0xdd },
	'movieafspeedapply' => { 297 => 0xdf },
	'movieaftrackingsensitivity' => { 297 => 0xe1 },
	'movieaperturelock' => { 297 => 0x259 },
	'movieautodistortioncontrol' => { 229 => 0x242 },
	'moviediffractioncompensation' => { 229 => 0x241 },
	'moviedxcropalert' => { 230 => 0x2fb },
	'movieelectronicvr' => { 230 => 0x2cc },
	'movieevfgrid' => { 297 => 0x21d },
	'movieflickerreduction' => { 230 => 0x2c0 },
	'moviefocusmode' => { 229 => 0x248, 230 => 0x2c4 },
	'moviefocuspointlock' => { 297 => 0x226 },
	'movieframerate' => { 229 => 0x1f8, 230 => 0x2f4 },
	'movieframesize' => { 229 => 0x1f6, 230 => 0x2f2 },
	'moviefunc1button' => { 284 => '41.1', 285 => '41.1', 295 => '41.1', 297 => 0xc3 },
	'moviefunc3button' => { 297 => 0x127 },
	'moviefunctionbutton' => { 282 => '41.1', 294 => '41.1' },
	'moviefunctionbuttonplusdials' => { 282 => '52.1' },
	'moviehighisonoisereduction' => { 229 => 0x23c, 230 => 0x2ba },
	'moviehighlightdisplaythreshold' => { 297 => 0x215 },
	'movieimagearea' => { 230 => 0x25c },
	'movieisoautocontrolmanualmode' => { 230 => 0x26a },
	'movieisoautohilimit' => { 230 => 0x268 },
	'movieisoautomanualmode' => { 229 => 0x204, 230 => 0x26c },
	'moviemeteringmode' => { 230 => 0x2c2 },
	'moviemidtonedisplayrange' => { 297 => 0x219 },
	'moviemidtonedisplayvalue' => { 297 => 0x217 },
	'moviemultiselector' => { 297 => 0xd9 },
	'moviepreviewbutton' => { 282 => '41.2', 284 => '41.2', 285 => '41.2', 294 => '41.2', 295 => '41.2' },
	'moviepreviewbuttonplusdials' => { 282 => '52.2' },
	'movierecordbuttonplaybackmode' => { 297 => 0x1b5 },
	'movieshutterbutton' => { 282 => '38.3', 284 => '38.3', 285 => '38.3', 294 => '38.3', 295 => '38.3' },
	'movieshutterspeedlock' => { 297 => 0x225 },
	'movieslowmotion' => { 229 => 0x1fa },
	'moviesoundrecording' => { 230 => 0x2ce },
	'moviesubjectdetection' => { 230 => 0x2fc },
	'moviesubselectorassignment' => { 282 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 282 => '53.1' },
	'movietonemap' => { 230 => 0x2ec },
	'movietype' => { 229 => 0x1fe, 230 => 0x266, 254 => 0xc55c },
	'movievibrationreduction' => { 229 => 0x24e },
	'movievibrationreductionsameasphoto' => { 229 => 0x24f },
	'movievignettecontrol' => { 229 => 0x23e, 230 => 0x1a0 },
	'movievignettecontrolsameasphoto' => { 229 => 0x240 },
	'movievrmode' => { 230 => 0x2c8 },
	'moviezebrapattern' => { 297 => 0x213 },
	'multiburstimageheight' => { 422 => 0x1002 },
	'multiburstimagewidth' => { 422 => 0x1001 },
	'multiburstmode' => { 422 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 322 => 0xb4 },
	'multiexposureautogain' => { 231 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 231 => 0x1, 232 => 0x1 },
	'multiexposureoverlaymode' => { 232 => 0x3 },
	'multiexposureshots' => { 68 => 0x3, 230 => 0x8e, 231 => 0x2, 232 => 0x2 },
	'multiframenoisereduction' => { 411 => 0x35, 422 => 0x200b, 427 => 0x15 },
	'multiframenreffect' => { 422 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 230 => 0x8c, 303 => 0x101c },
	'multipleexposureset' => { 338 => '10.1' },
	'multisample' => { 239 => 0x40 },
	'multiselector' => { 281 => '9.4', 282 => '10.3', 284 => '10.3', 285 => '10.3', 290 => '27.4', 294 => '10.3', 295 => '10.3' },
	'multiselectorliveview' => { 281 => '4.3', 284 => '37.1', 285 => '37.1', 294 => '37.1', 295 => '37.1' },
	'multiselectorliveviewmode' => { 249 => 0x18c2 },
	'multiselectorplaybackmode' => { 281 => ['13.5','9.2'], 282 => '10.2', 285 => '10.2', 290 => '27.2', 294 => '10.2', 295 => '10.2', 297 => 0xb3 },
	'multiselectorshootmode' => { 281 => '9.1', 282 => '10.1', 284 => '10.1', 285 => '10.1', 290 => '27.1', 294 => '10.1', 295 => '10.1', 297 => 0xaf },
	'multishot' => { 327 => 0x121 },
	'mute' => { 376 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 382 => 'name', 480 => 'Name', 482 => 'Name' },
	'narrator' => { 374 => "\xa9nrt" },
	'nationalcatalognumber' => { 496 => 'nationalCatalogNumber' },
	'nativedigest' => { 486 => 'NativeDigest', 502 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 299 => 0x204, 389 => 0x1019 },
	'near' => { 465 => 'Near' },
	'nefbitdepth' => { 227 => 0xe22 },
	'nefcompression' => { 227 => 0x93, 228 => 0xa },
	'neflinearizationtable' => { 227 => 0x96 },
	'negativecachelargepreviewsize' => { 480 => 'NegativeCacheLargePreviewSize', 482 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 480 => 'NegativeCacheMaximumSize', 482 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 480 => 'NegativeCachePath', 482 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 477 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 357 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 504 => 'Nickname' },
	'nikoncapturedata' => { 227 => 0xe01 },
	'nikoncaptureeditversions' => { 227 => 0xe13 },
	'nikoncaptureoffsets' => { 227 => 0xe0e },
	'nikoncaptureoutput' => { 227 => 0xe1e },
	'nikoncaptureversion' => { 227 => 0xe09 },
	'nikoniccprofile' => { 227 => 0xe1d },
	'nikonimagesize' => { 246 => '723.1', 247 => '732.1', 257 => 0x2c4 },
	'nikonmeteringmode' => { 229 => 0x146, 250 => 0x2ea4, 259 => 0x175e },
	'nikonsettings' => { 227 => 0x4e },
	'noisefilter' => { 299 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 227 => 0x95, 274 => 0x753dcbc0, 275 => 0x17, 299 => 0x50a, 304 => 0x103a, 322 => 0x2d, 357 => 0x49, 389 => 0x100f, 391 => 0x2a },
	'noisereduction2' => { 303 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 275 => 0x9 },
	'noisereductionmethod' => { 275 => 0x11 },
	'noisereductionmode' => { 457 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 327 => 0x1b },
	'noisereductionsharpness' => { 275 => 0xd },
	'noisereductionstrength' => { 322 => 0xd6 },
	'noisereductionvalue' => { 457 => 0x8027 },
	'nomemorycard' => { 281 => '22.1', 282 => '4.2', 283 => '0.3', 286 => '2.4', 287 => '3.2', 288 => '3.2', 290 => '33.7', 291 => '3.2', 292 => '0.3', 294 => '4.2', 296 => '4.5' },
	'nominalmaxaperture' => { 348 => 0xa },
	'nominalminaperture' => { 348 => '10.1' },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 458 => 'Notes', 475 => 'notes' },
	'npages' => { 511 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 334 => 0x2 },
	'number' => { 496 => 'number' },
	'numberofbeats' => { 506 => 'numberOfBeats' },
	'numberoffocuspoints' => { 284 => '1.3', 285 => '1.3', 288 => '0.2', 289 => '0.3', 291 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 314 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 328 => 0x0, 329 => 0x0 },
	'object' => { 496 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 475 => 'ObjectCycle' },
	'objectdescription' => { 495 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 495 => 'objectSubtype' },
	'objecttype' => { 495 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 118 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 118 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 118 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 118 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 486 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 486 => [\'OECF','OECFNames'] },
	'oecfrows' => { 486 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 486 => [\'OECF','OECFValues'] },
	'offsaledate' => { 496 => 'offSaleDate' },
	'offsaledatea-platform' => { 496 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 496 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsetschema' => { 119 => 0xea1d },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'okbutton' => { 291 => '15.1', 296 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 304 => 0x102f },
	'olympusimagewidth' => { 304 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 304 => 0x302 },
	'onsaledate' => { 496 => 'onSaleDate' },
	'onsaledatea-platform' => { 496 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 496 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 496 => 'onSaleDay' },
	'onsaledaya-platform' => { 496 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 496 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 322 => 0x34 },
	'opticalzoomon' => { 398 => 0x219 },
	'optionenddate' => { 499 => 'optionEndDate' },
	'opto-electricconvfactor' => { 486 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 492 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 492 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 496 => 'organization' },
	'orientation' => { 119 => 0x112, 327 => 0x112, 495 => 'orientation', 502 => 'Orientation' },
	'orientation2' => { 427 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 374 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 470 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 319 => 0x408 },
	'originaldocumentid' => { 507 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 319 => 0x407, 470 => 'OriginalFilename' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagesize' => { 162 => 'OriginalImageSize' },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 475 => 'OriginatingProgram' },
	'originplatform' => { 496 => 'originPlatform' },
	'os' => { 484 => 'os' },
	'otherconditions' => { 309 => 'OtherConditions' },
	'otherconstraints' => { 309 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 309 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 309 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 309 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 309 => 'OtherLicenseRequirements' },
	'outcue' => { 506 => 'outCue' },
	'outcuescale' => { 506 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 506 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 197 => 0x3 },
	'outputimagewidth' => { 197 => 0x2 },
	'outputlut' => { 322 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 197 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 480 => 'OverrideLookVignette', 482 => 'OverrideLookVignette' },
	'owner' => { 510 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 477 => 'OwnerName', 487 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 496 => 'pageCount' },
	'pageimage' => { 504 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 504 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 504 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 504 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 504 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 504 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 496 => 'pageProgressionDirection' },
	'pagerange' => { 496 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 480 => 'PaintBasedCorrections', 482 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 480 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 325 => 0x0 },
	'panasonicexifversion' => { 322 => 0x26 },
	'panasonicimageheight' => { 322 => 0x4c },
	'panasonicimagewidth' => { 322 => 0x4b },
	'panasonicrawversion' => { 327 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 428 => 0x7 },
	'panoramacropleft' => { 428 => 0x4 },
	'panoramacropright' => { 428 => 0x6 },
	'panoramacroptop' => { 428 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 428 => 0x3 },
	'panoramaframeheight' => { 428 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 428 => 0x8 },
	'panoramafullheight' => { 428 => 0x2 },
	'panoramafullwidth' => { 428 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 299 => 0x601 },
	'panoramasize3d' => { 411 => 0x38 },
	'panoramasourceheight' => { 428 => 0xb },
	'panoramasourcewidth' => { 428 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 507 => 'Pantry' },
	'pantryinstanceid' => { 507 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 298 => 0x28 },
	'parametricdarks' => { 480 => 'ParametricDarks', 482 => 'ParametricDarks' },
	'parametrichighlights' => { 480 => 'ParametricHighlights', 482 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 480 => 'ParametricHighlightSplit', 482 => 'ParametricHighlightSplit' },
	'parametriclights' => { 480 => 'ParametricLights', 482 => 'ParametricLights' },
	'parametricmidtonesplit' => { 480 => 'ParametricMidtoneSplit', 482 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 480 => 'ParametricShadows', 482 => 'ParametricShadows' },
	'parametricshadowsplit' => { 480 => 'ParametricShadowSplit', 482 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentid' => { 492 => 'parentId' },
	'parentmediaeventid' => { 470 => 'ParentMediaEventID' },
	'parentmeid' => { 470 => 'ParentMEID' },
	'parentproductid' => { 374 => '@ppi' },
	'parentreference1' => { 490 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 490 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 374 => '@PST' },
	'parenttitle' => { 374 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 506 => 'partOfCompilation' },
	'patientbirthdate' => { 459 => 'PatientDOB' },
	'patientid' => { 459 => 'PatientID' },
	'patientname' => { 459 => 'PatientName' },
	'patientsex' => { 459 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 493 => 'PDFVersion' },
	'pentaximagesize' => { 357 => 0x9 },
	'pentaxmodelid' => { 337 => 0x0, 357 => 0x5 },
	'pentaxmodeltype' => { 357 => 0x1 },
	'pentaxversion' => { 357 => 0x0 },
	'people' => { 461 => 'People', 473 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 374 => 'perf', 382 => 'perf' },
	'performerkeywords' => { 382 => "\xa9prk" },
	'performers' => { 382 => "\xa9prf" },
	'performerurl' => { 382 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 457 => 0x8030 },
	'peripheralillumcentralvalue' => { 457 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 347 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 457 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 499 => 'permissions' },
	'permits' => { 478 => 'permits' },
	'person' => { 496 => 'person' },
	'personality' => { 470 => 'Personality' },
	'personheard' => { 492 => 'PersonHeard' },
	'personheardidentifier' => { 492 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 492 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 492 => 'PersonInImage' },
	'personinimagecharacteristic' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 492 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 492 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 480 => 'PerspectiveAspect', 482 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 480 => 'PerspectiveHorizontal', 482 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 480 => 'PerspectiveRotate', 482 => 'PerspectiveRotate' },
	'perspectivescale' => { 480 => 'PerspectiveScale', 482 => 'PerspectiveScale' },
	'perspectiveupright' => { 480 => 'PerspectiveUpright', 482 => 'PerspectiveUpright' },
	'perspectivevertical' => { 480 => 'PerspectiveVertical', 482 => 'PerspectiveVertical' },
	'perspectivex' => { 480 => 'PerspectiveX', 482 => 'PerspectiveX' },
	'perspectivey' => { 480 => 'PerspectiveY', 482 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 274 => 0xe9651831 },
	'photoeffects' => { 274 => 0xab5eca5e },
	'photoeffectsblue' => { 276 => 0x8 },
	'photoeffectsgreen' => { 276 => 0x6 },
	'photoeffectsred' => { 276 => 0x4 },
	'photoeffectstype' => { 276 => 0x0 },
	'photographicsensitivity' => { 487 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 281 => '17.6', 290 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 502 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 230 => 0x112, 250 => 0xe7d, 260 => 0xfbd },
	'photoshootingmenubankimagearea' => { 230 => 0x134, 250 => '3716.1', 260 => 0x791 },
	'photoshopbgrthumbnail' => { 371 => 0x409 },
	'photoshopquality' => { 370 => 0x0 },
	'photoshopthumbnail' => { 371 => 0x40c },
	'photostyle' => { 322 => 0x89 },
	'picasawebgphotoid' => { 485 => 'picasawebGPhotoId' },
	'picklabel' => { 485 => 'PickLabel' },
	'pictinfo' => { 398 => 0x208 },
	'picturecontrol' => { 274 => 0xe2173c47 },
	'picturecontrolactive' => { 277 => 0x0 },
	'picturecontroladjust' => { 233 => 0x30, 234 => 0x30, 235 => 0x36 },
	'picturecontrolbase' => { 233 => 0x18, 234 => 0x18, 235 => 0x1c },
	'picturecontroldata' => { 227 => [0xbd,0x23] },
	'picturecontrolmode' => { 277 => 0x13 },
	'picturecontrolname' => { 233 => 0x4, 234 => 0x4, 235 => 0x8 },
	'picturecontrolquickadjust' => { 233 => 0x31, 234 => 0x31, 235 => 0x37 },
	'pictureeffect' => { 422 => 0x200e },
	'pictureeffect2' => { 431 => 0x1163, 432 => 0x1167, 433 => 0x1143, 434 => 0x11bf, 435 => 0x119b, 436 => 0x1053, 437 => 0x24b, 438 => 0x24b, 439 => 0x23c, 453 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 299 => 0x520, 357 => [0xb,0x33], 399 => 0x3d },
	'picturemode2' => { 338 => 0x0 },
	'picturemodebwfilter' => { 299 => 0x525 },
	'picturemodecontrast' => { 299 => 0x523 },
	'picturemodeeffect' => { 299 => 0x52d },
	'picturemodehue' => { 299 => 0x522 },
	'picturemodesaturation' => { 299 => 0x521 },
	'picturemodesharpness' => { 299 => 0x524 },
	'picturemodetone' => { 299 => 0x526 },
	'pictureprofile' => { 431 => [0x115e,0x115f], 432 => [0x1162,0x1163], 433 => [0x113e,0x113f], 434 => [0x11ba,0x11bb], 435 => [0x1196,0x1197], 436 => [0x104e,0x104f], 437 => [0x246,0x247], 438 => [0x246,0x247], 439 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 396 => 0x21 },
	'picturewizardcolor' => { 395 => 0x1 },
	'picturewizardcontrast' => { 395 => 0x4 },
	'picturewizardmode' => { 395 => 0x0 },
	'picturewizardsaturation' => { 395 => 0x2 },
	'picturewizardsharpness' => { 395 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 282 => '4.1', 294 => '4.1', 382 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 249 => 0x350f, 250 => 0x2c28, 254 => 0xc21e, 259 => 0x36f8, 260 => 0x2eff, 262 => 0xce36, 263 => 0xeaef, 299 => 0x904, 322 => 0x91, 356 => 0x2, 394 => 0x1 },
	'pitchshift' => { 376 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 375 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 422 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 358 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 311 => 0x0 },
	'pixelsperunity' => { 311 => 0x4 },
	'pixelunits' => { 311 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 502 => 'PlanarConfiguration' },
	'plane' => { 460 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 460 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 460 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 460 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 460 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 460 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 460 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 460 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 460 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 460 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 460 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 460 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 460 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 460 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 460 => 'Planes' },
	'planningref' => { 492 => 'PlanningRef' },
	'planningrefidentifier' => { 492 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 492 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 492 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 511 => 'PlateNames' },
	'platform' => { 496 => 'platform' },
	'playallframes' => { 382 => 'AllF' },
	'playbackflickdown' => { 297 => 0x159 },
	'playbackflickup' => { 297 => 0x155 },
	'playbackmenustime' => { 286 => '20.1', 287 => '21.1', 288 => '21.1' },
	'playbackmonitorofftime' => { 281 => '25.2', 282 => '36.1', 284 => '36.1', 285 => '36.1', 289 => '35.1', 290 => '8.1', 291 => '35.1', 294 => '36.1', 295 => '36.1', 296 => '21.1', 297 => 0x33 },
	'playbackzoom' => { 282 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 376 => 'player.version' },
	'playgap' => { 374 => 'pgap' },
	'playlistid' => { 374 => 'plID' },
	'playmode' => { 382 => 'SDLN' },
	'playselection' => { 382 => 'SelO' },
	'plusversion' => { 309 => 'Version' },
	'pmversion' => { 369 => 'PMVersion' },
	'pngwarning' => { 312 => 'Warning' },
	'podcast' => { 374 => 'pcst' },
	'podcasturl' => { 374 => 'purl' },
	'poilevel' => { 226 => 0x8 },
	'portraitimpressionbalance' => { 262 => 0x7fa0 },
	'portraitnote' => { 463 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 463 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 463 => 'PortraitVersion' },
	'pose' => { 460 => 'Pose' },
	'poseheadingdegrees' => { 468 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 468 => 'PosePitchDegrees' },
	'posepositionx' => { 460 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 460 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 460 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 468 => 'PoseRollDegrees' },
	'poserotationw' => { 460 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 460 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 460 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 460 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 460 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 495 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 480 => 'PostCropVignetteAmount', 482 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 480 => 'PostCropVignetteFeather', 482 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 480 => 'PostCropVignetteHighlightContrast', 482 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 480 => 'PostCropVignetteMidpoint', 482 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 480 => 'PostCropVignetteRoundness', 482 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 480 => 'PostCropVignetteStyle', 482 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 322 => 0xbf },
	'potentialface1position' => { 419 => 0xb },
	'potentialface2position' => { 419 => 0x15 },
	'potentialface3position' => { 419 => 0x1f },
	'potentialface4position' => { 419 => 0x29 },
	'potentialface5position' => { 419 => 0x33 },
	'potentialface6position' => { 419 => 0x3d },
	'potentialface7position' => { 419 => 0x47 },
	'potentialface8position' => { 419 => 0x51 },
	'powersource' => { 336 => '0.1' },
	'poweruptime' => { 227 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 304 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 247 => 0x28a },
	'prefs' => { 131 => 0xdd, 369 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'preservedfilename' => { 507 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 480 => 'PresetType', 482 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 457 => 0x8002 },
	'presetwhitebalanceadj' => { 457 => 0x8014 },
	'pressure' => { 119 => 0x9402, 487 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 281 => ['14.1','15.1'], 282 => '15.1', 284 => '15.1', 285 => '15.1', 290 => '29.1', 291 => '14.1', 294 => '15.1', 295 => '15.1' },
	'previewbuttonplusdials' => { 281 => ['14.2','15.2'], 282 => '15.2', 284 => '43.1', 285 => '43.1', 290 => '31.2', 294 => '43.1', 295 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 368 => 0xef },
	'previewcropleft' => { 368 => 0xec },
	'previewcropright' => { 368 => 0xee },
	'previewcroptop' => { 368 => 0xed },
	'previewdate' => { 380 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 304 => 0x280, 320 => 0x300, 382 => 'mcvr', 422 => 0x2001 },
	'previewimageborders' => { 357 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 236 => 0x202, 299 => 0x102, 304 => 0x1037, 357 => 0x3, 388 => 0x1e, 393 => 0x3, 399 => [0x1b,0x1d], 412 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 357 => 0x2, 399 => [0x1c,0x1e], 422 => 0xb02c, 457 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 236 => 0x201, 299 => 0x101, 304 => 0x1036, 357 => 0x4, 388 => 0x1c, 393 => 0x2, 399 => [0x1a,0x1c], 412 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 299 => 0x100, 304 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 119 => 0x13f, 502 => 'PrimaryChromaticities' },
	'primaryftp' => { 470 => 'PrimaryFTP' },
	'primaryslot' => { 250 => 0xe7f, 260 => 0xfbf },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 422 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 409 => 0x28 },
	'privatertkinfo' => { 472 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 480 => 'ProcessVersion', 482 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 308 => 'Producer', 374 => "\xa9prd", 376 => 'producer', 382 => "\xa9prd", 493 => 'Producer' },
	'producerkeywords' => { 382 => "\xa9pdk" },
	'productcode' => { 496 => 'productCode' },
	'productid' => { 132 => 0x32, 374 => 'prID', 495 => 'productID' },
	'productidtype' => { 495 => 'productIDType' },
	'productinimage' => { 492 => 'ProductInImage' },
	'productinimagedescription' => { 492 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 492 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 492 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 492 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 337 => 0x2 },
	'productorserviceconstraints' => { 309 => 'ProductOrServiceConstraints' },
	'productversion' => { 374 => 'VERS' },
	'profession' => { 496 => 'profession' },
	'profile' => { 460 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 460 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 310 => 'iCCP-name' },
	'profiles' => { 460 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 460 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 322 => 0x3c },
	'programline' => { 338 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 227 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 478 => 'prohibits' },
	'projectiontype' => { 468 => 'ProjectionType', 469 => 'ProjectionType' },
	'projectname' => { 506 => 'projectName' },
	'projectref' => { 506 => 'projectRef' },
	'projectrefpath' => { 506 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 506 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 309 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 309 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 496 => 'publicationDate' },
	'publicationdatea-platform' => { 496 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 496 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 496 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 496 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 496 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 492 => 'PublicationEvent' },
	'publicationeventdate' => { 492 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 492 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 492 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 496 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 374 => "\xa9pub", 376 => 'publisher', 483 => 'publisher' },
	'publishingfrequency' => { 496 => 'publishingFrequency' },
	'pulldown' => { 506 => 'pullDown' },
	'purchasedate' => { 374 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 457 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 457 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 227 => 0x4, 264 => 0x3, 304 => 0x201, 317 => 0x300, 357 => 0x8, 364 => 0x2, 399 => 0x16, 409 => 0x56, 410 => 0x56, 411 => 0xb, 422 => [0x102,0x202e] },
	'quality2' => { 431 => 0x1170, 432 => 0x1174, 433 => 0x1150, 435 => 0x11a8, 436 => 0x1060, 437 => 0x258, 438 => 0x258, 439 => 0x247, 444 => 0x29, 445 => 0x25, 446 => 0x2a },
	'qualitybutton' => { 297 => 0x17d },
	'qualitybuttonplaybackmode' => { 297 => 0x1bf },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 277 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 274 => 0x416391c6 },
	'quickshot' => { 398 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 382 => 'rads' },
	'rangefinder' => { 286 => '4.1', 287 => '5.1', 288 => '5.1' },
	'rangemask' => { 480 => 'RangeMaskMapInfo', 482 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 480 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 368 => 0xdf, 374 => 'rtng', 382 => 'rtng', 422 => 0x2002, 475 => 'rating', 484 => 'rating', 492 => 'Rating', 496 => 'rating', 504 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 374 => 'rate', 504 => 'RatingPercent' },
	'ratingregion' => { 492 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 492 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 492 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 492 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 492 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 492 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 492 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 492 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 492 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 492 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 492 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 492 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 492 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 492 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 492 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 492 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 492 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 492 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 338 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 368 => 0xd4 },
	'rawcropleft' => { 368 => 0xd1 },
	'rawcropright' => { 368 => 0xd3 },
	'rawcroptop' => { 368 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 396 => 0xa048 },
	'rawdatabyteorder' => { 396 => 0x40 },
	'rawdatacfapattern' => { 396 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 306 => 0x121 },
	'rawdevautogradation' => { 306 => 0x119 },
	'rawdevcolorspace' => { 305 => 0x108, 306 => 0x109 },
	'rawdevcontrastvalue' => { 305 => 0x106, 306 => 0x105 },
	'rawdeveditstatus' => { 305 => 0x10b },
	'rawdevelopmentprocess' => { 357 => 0x62 },
	'rawdevengine' => { 305 => 0x109, 306 => 0x10b },
	'rawdevexposurebiasvalue' => { 305 => 0x100, 306 => 0x100 },
	'rawdevgradation' => { 306 => 0x112 },
	'rawdevgraypoint' => { 305 => 0x103, 306 => 0x104 },
	'rawdevmemorycoloremphasis' => { 305 => 0x105, 306 => 0x108 },
	'rawdevnoisereduction' => { 305 => 0x10a, 306 => 0x10a },
	'rawdevpicturemode' => { 306 => 0x10c },
	'rawdevpm_bwfilter' => { 306 => 0x110 },
	'rawdevpmcontrast' => { 306 => 0x10e },
	'rawdevpmnoisefilter' => { 306 => 0x120 },
	'rawdevpmpicturetone' => { 306 => 0x111 },
	'rawdevpmsaturation' => { 306 => 0x10d },
	'rawdevpmsharpness' => { 306 => 0x10f },
	'rawdevsaturation3' => { 306 => 0x113 },
	'rawdevsaturationemphasis' => { 305 => 0x104, 306 => 0x107 },
	'rawdevsettings' => { 305 => 0x10c },
	'rawdevsharpnessvalue' => { 305 => 0x107, 306 => 0x106 },
	'rawdevversion' => { 305 => 0x0, 306 => 0x0 },
	'rawdevwbfineadjustment' => { 305 => 0x102, 306 => 0x103 },
	'rawdevwhitebalance' => { 306 => 0x101 },
	'rawdevwhitebalancevalue' => { 305 => 0x101, 306 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 480 => 'RawFileName', 482 => 'RawFileName' },
	'rawfiletype' => { 422 => 0x2029 },
	'rawformat' => { 327 => 0x2d, 366 => 0x10e },
	'rawimagecenter' => { 227 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 357 => 0x39 },
	'rawinfoversion' => { 307 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 475 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 281 => '12.3', 282 => '6.2' },
	'recdevice' => { 492 => 'RecDevice' },
	'recdeviceattlensdescription' => { 492 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 492 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 492 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 492 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 492 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 498 => 'recipeEndingPage' },
	'recipepagerange' => { 498 => 'recipePageRange' },
	'recipesource' => { 498 => 'recipeSource' },
	'recipestartingpage' => { 498 => 'recipeStartingPage' },
	'recipetitle' => { 498 => 'recipeTitle' },
	'recognizedface1age' => { 315 => 0x20 },
	'recognizedface1name' => { 315 => 0x4 },
	'recognizedface1position' => { 315 => 0x18 },
	'recognizedface2age' => { 315 => 0x50 },
	'recognizedface2name' => { 315 => 0x34 },
	'recognizedface2position' => { 315 => 0x48 },
	'recognizedface3age' => { 315 => 0x80 },
	'recognizedface3name' => { 315 => 0x64 },
	'recognizedface3position' => { 315 => 0x78 },
	'recognizedfaceflags' => { 322 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 487 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 382 => "\xa9phg" },
	'recordingformat' => { 389 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 364 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 382 => "\xa9lab" },
	'recordlabelurl' => { 382 => "\xa9lal" },
	'recordlocationdata' => { 230 => 0x660 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 398 => 0x217 },
	'redbalance' => { 304 => 0x1017, 327 => 0x11, 357 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 278 => 0x0 },
	'redeyeinfo' => { 480 => 'RedEyeInfo', 482 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 409 => 0x6a, 411 => 0x28 },
	'redeyeremoval' => { 322 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 480 => 'RedHue', 482 => 'RedHue' },
	'redsaturation' => { 480 => 'RedSaturation', 482 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 382 => 'reel' },
	'reference1' => { 490 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 490 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 502 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 309 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 492 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 492 => 'RegistryId' },
	'registryitemid' => { 492 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 492 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 486 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 483 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 506 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 506 => 'relativeTimestamp' },
	'relativetimestampscale' => { 506 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 506 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 281 => '17.8', 282 => '18.5', 284 => '18.4', 285 => '18.4', 290 => '33.8', 291 => '17.6', 294 => '18.5', 295 => '18.4' },
	'releasedate' => { 131 => 0x1e, 374 => 'rldt', 475 => 'ReleaseDate', 506 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 249 => 0x184d, 422 => 0xb049 },
	'releasemode2' => { 431 => 0x112c, 432 => [0x112c,0x8], 433 => [0x1108,0x8], 434 => [0x1184,0x8], 435 => [0x1160,0x8], 436 => [0x4,0x1018], 437 => [0x4,0x210], 438 => [0x4,0x210], 439 => [0x4,0x208], 441 => [0x67,0x3f], 442 => [0x6b,0x6d,0x73,0x4b], 443 => [0x6b,0x4b], 444 => 0x10, 445 => 0x10, 446 => 0x9, 453 => 0x34 },
	'releasemode3' => { 431 => 0x1128, 432 => 0x1128, 433 => 0x1104, 434 => 0x1180, 435 => 0x115c, 436 => 0x1014, 437 => 0x20c, 438 => 0x20c, 439 => 0x204 },
	'releaseready' => { 492 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 475 => 'ReleaseTime' },
	'remoteonduration' => { 283 => '3.4', 286 => '17.2', 287 => '18.2', 288 => '18.2', 289 => '18.2', 291 => '18.2', 292 => '4.3', 296 => '19.2' },
	'renditionclass' => { 507 => 'RenditionClass' },
	'renditionof' => { 507 => 'RenditionOf' },
	'renditionofalternatepaths' => { 507 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 507 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 507 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 507 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 507 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 507 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 507 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 507 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 507 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 507 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 507 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 507 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 507 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 507 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 507 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 507 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 507 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 507 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 507 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 507 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 507 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 507 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 507 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 507 => 'RenditionParams' },
	'repeatingflashcount' => { 209 => 0xd, 210 => 0xe, 211 => 0xe, 212 => 0xe, 213 => 0xe, 290 => '17.2', 291 => '24.2', 292 => '9.2', 293 => '24.2', 296 => '25.2' },
	'repeatingflashcountbuilt-in' => { 258 => 0x4db },
	'repeatingflashcountexternal' => { 258 => 0x4c3 },
	'repeatingflashoutput' => { 290 => '17.1', 291 => '24.1', 292 => '9.1', 293 => '24.1', 296 => '25.1' },
	'repeatingflashoutputexternal' => { 258 => 0x4c0 },
	'repeatingflashrate' => { 209 => 0xc, 210 => 0xd, 211 => 0xd, 212 => 0xd, 213 => 0xd, 290 => '18.1', 291 => '25.1', 292 => '10.1', 293 => '25.1', 296 => '26.1' },
	'repeatingflashratebuilt-in' => { 258 => 0x4da },
	'repeatingflashrateexternal' => { 258 => 0x4c2 },
	'requirements' => { 382 => "\xa9req" },
	'requires' => { 478 => 'requires' },
	'resampleparams' => { 506 => 'resampleParams' },
	'resampleparamsquality' => { 506 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 398 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 399 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 502 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 499 => 'restrictions' },
	'retouchareafeather' => { 480 => [\'RetouchAreas','RetouchAreasFeather'], 482 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 480 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 482 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 480 => [\'RetouchAreas','RetouchAreasMasksAngle'], 482 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 480 => [\'RetouchAreas','RetouchAreasMasksBottom'], 482 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 482 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 480 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 482 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 480 => [\'RetouchAreas','RetouchAreasMasksDabs'], 482 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 480 => [\'RetouchAreas','RetouchAreasMasksFeather'], 482 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 480 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 482 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 480 => [\'RetouchAreas','RetouchAreasMasksFlow'], 482 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 480 => [\'RetouchAreas','RetouchAreasMasksFullX'], 482 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 480 => [\'RetouchAreas','RetouchAreasMasksFullY'], 482 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 480 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 482 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 480 => [\'RetouchAreas','RetouchAreasMasksLeft'], 482 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasks'], 482 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 480 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 482 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 480 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 482 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 480 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 482 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 482 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 480 => [\'RetouchAreas','RetouchAreasMasksRadius'], 482 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 480 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 480 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 482 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 480 => [\'RetouchAreas','RetouchAreasMasksRight'], 482 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 480 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 482 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 480 => [\'RetouchAreas','RetouchAreasMasks'], 482 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 480 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 482 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 480 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 482 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 480 => [\'RetouchAreas','RetouchAreasMasksTop'], 482 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 480 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 482 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 480 => [\'RetouchAreas','RetouchAreasMasksVersion'], 482 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 480 => [\'RetouchAreas','RetouchAreasMasksWhat'], 482 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 480 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 482 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 480 => [\'RetouchAreas','RetouchAreasMasksX'], 482 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 480 => [\'RetouchAreas','RetouchAreasMasksY'], 482 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 480 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 482 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 480 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 482 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 480 => [\'RetouchAreas','RetouchAreasMethod'], 482 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 480 => [\'RetouchAreas','RetouchAreasOffsetY'], 482 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 480 => [\'RetouchAreas','RetouchAreasOpacity'], 482 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 480 => 'RetouchAreas', 482 => 'RetouchAreas' },
	'retouchareaseed' => { 480 => [\'RetouchAreas','RetouchAreasSeed'], 482 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 480 => [\'RetouchAreas','RetouchAreasSourceState'], 482 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 480 => [\'RetouchAreas','RetouchAreasSourceX'], 482 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 480 => [\'RetouchAreas','RetouchAreasSpotType'], 482 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 227 => 0x9e },
	'retouchinfo' => { 480 => 'RetouchInfo', 482 => 'RetouchInfo' },
	'retouchnefprocessing' => { 238 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 309 => 'Reuse' },
	'reuseallowed' => { 509 => 'ReuseAllowed' },
	'reuseprohibited' => { 499 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 288 => '5.2' },
	'reversefocusring' => { 297 => 0x163 },
	'reverseindicators' => { 281 => '12.1', 282 => '6.1', 284 => '6.1', 285 => '6.1', 286 => '4.3', 287 => '5.2', 288 => '5.4', 290 => '33.5', 291 => '5.1', 294 => '6.1', 295 => '6.1', 296 => '6.2', 297 => 0xc1 },
	'reverseshutterspeedaperture' => { 288 => '5.3' },
	'revision' => { 484 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 489 => 'RichTextComment' },
	'ricohdate' => { 388 => 0x6 },
	'ricohimageheight' => { 388 => 0x2 },
	'ricohimagewidth' => { 388 => 0x0 },
	'rightalbedo' => { 471 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 483 => 'rights' },
	'rightsagent' => { 499 => 'rightsAgent' },
	'rightsowner' => { 499 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 382 => ['roll',"\xa9frl"] },
	'rollangle' => { 249 => 0x350b, 250 => 0x2c24, 254 => 0xc21a, 259 => 0x36f4, 260 => 0x2efb, 262 => 0xce32, 263 => 0xeaeb, 299 => 0x903, 322 => 0x90, 356 => 0x1, 394 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 249 => 0x3693, 250 => 0xca, 257 => '590.1', 274 => 0x76a43207, 322 => 0x30, 338 => '17.2', 368 => 0xd8, 375 => 'irot', 409 => 0x3f, 410 => 0x3f, 420 => 0x10 },
	'routedto' => { 488 => 'RoutedTo' },
	'routing' => { 373 => 'Routing' },
	'routingdestinations' => { 470 => 'RoutingDestinations' },
	'routingexclusions' => { 470 => 'RoutingExclusions' },
	'routingnotes' => { 488 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 475 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 496 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 327 => 0x8, 502 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 396 => 0x3 },
	'sanyoquality' => { 398 => 0x201 },
	'sanyothumbnail' => { 398 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 227 => 0xaa, 233 => 0x35, 234 => 0x3b, 235 => 0x43, 322 => 0x40, 324 => 0x300d, 357 => 0x1f, 364 => 0xd, 383 => 0x27, 385 => 0x58, 388 => 0x28, 389 => 0x1013, 399 => 0x10, 409 => 0x1e, 410 => 0x1b, 422 => 0x2005, 480 => 'Saturation', 482 => 'Saturation', 486 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 227 => 0x94, 273 => 0x1, 277 => 0x2e, 457 => 0x8016 },
	'saturationadjustmentaqua' => { 480 => 'SaturationAdjustmentAqua', 482 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 480 => 'SaturationAdjustmentBlue', 482 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 480 => 'SaturationAdjustmentGreen', 482 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 480 => 'SaturationAdjustmentMagenta', 482 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 480 => 'SaturationAdjustmentOrange', 482 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 480 => 'SaturationAdjustmentPurple', 482 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 480 => 'SaturationAdjustmentRed', 482 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 480 => 'SaturationAdjustmentYellow', 482 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 307 => 0x1010, 411 => 0x11, 427 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 507 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 506 => 'scaleType' },
	'scanimageenhancer' => { 239 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 382 => 'scen', 491 => 'Scene', 506 => 'scene' },
	'scenearea' => { 302 => 0x211, 304 => 0x1031 },
	'sceneassist' => { 227 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 486 => 'SceneCaptureType' },
	'scenedetect' => { 302 => 0x210, 304 => 0x1030 },
	'scenedetectdata' => { 302 => 0x212, 304 => 0x1033 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 227 => 0x8f, 299 => 0x509, 304 => 0x403, 322 => 0x8001, 331 => 0xf, 422 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'sceneselect' => { 398 => 0x21f },
	'scenetype' => { 119 => 0xa301, 486 => 'SceneType' },
	'screentips' => { 281 => '12.7', 282 => '5.3', 290 => '13.1', 291 => '4.4', 294 => '5.4', 296 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'season' => { 492 => 'Season', 495 => 'season' },
	'seasonidentifier' => { 492 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 492 => [\'Season','SeasonName'] },
	'seasonnumber' => { 492 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 470 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 230 => 0x22c, 249 => 0x1d0, 259 => 0x1d0 },
	'section' => { 496 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 322 => 0x2e, 398 => 0x214, 431 => 0x1134, 432 => 0x1134, 433 => 0x1110, 434 => 0x118c, 435 => 0x1168, 436 => 0x1020, 437 => 0x218, 438 => 0x218, 439 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 291 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 282 => '20.2', 284 => '20.3', 285 => '20.3', 286 => '18.2', 287 => '19.2', 288 => '19.2', 289 => '19.3', 291 => '19.3', 294 => '20.3', 295 => '20.3', 296 => '20.2', 297 => 0x2d },
	'selftimershotinterval' => { 282 => '20.3', 284 => '20.2', 285 => '20.2', 289 => '19.2', 294 => '20.2', 295 => '20.2', 297 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 281 => '18.1', 282 => '20.1', 283 => '3.3', 284 => '20.1', 285 => '20.1', 286 => '18.1', 287 => '19.1', 288 => '19.1', 289 => '19.1', 290 => '7.2', 291 => '19.1', 292 => '3.3', 294 => '20.1', 295 => '20.1', 296 => '20.1', 297 => 0x2b },
	'sellingagency' => { 496 => 'sellingAgency' },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 486 => 'SensingMethod' },
	'sensitivityadjust' => { 357 => 0x40 },
	'sensitivitysteps' => { 338 => ['14.3','17.4'], 340 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 487 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 304 => 0x400 },
	'sensorareas' => { 396 => 0xa010 },
	'sensorbitdepth' => { 324 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 303 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 324 => 0x312c, 366 => 0x109, 389 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 366 => 0x10a },
	'sensorpixelsize' => { 227 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 230 => 0x66d },
	'sensorsize' => { 156 => 'SensorSize', 357 => 0x35 },
	'sensortemperature' => { 302 => 0x1500, 304 => 0x1007, 362 => 0xc, 366 => 0x210, 399 => [0x39,0x55] },
	'sensortemperature2' => { 362 => 0xe, 366 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 366 => 0x10b },
	'sensortype' => { 322 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 324 => 0x312b, 366 => 0x108, 389 => 0x1601 },
	'sequence' => { 383 => 0x7, 384 => 0x35, 385 => 0x36 },
	'sequencefilenumber' => { 432 => 0x4, 433 => 0x4, 434 => 0x4, 435 => 0x4, 444 => 0xc, 445 => 0xc, 446 => 0x1a },
	'sequenceimagenumber' => { 432 => 0x0, 433 => 0x0, 434 => 0x0, 435 => 0x0, 444 => 0x8, 445 => 0x8, 446 => 0x12, 453 => 0x24 },
	'sequencelength' => { 444 => 0x22, 445 => 0x1e, 446 => [0x16,0x1e] },
	'sequencename' => { 495 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 258 => 0x51c, 322 => 0x2b, 411 => [0x10c,0x30c], 422 => 0xb04a, 495 => 'sequenceNumber' },
	'sequenceshotinterval' => { 398 => 0x224 },
	'sequencetotalnumber' => { 495 => 'sequenceTotalNumber' },
	'sequentialshot' => { 398 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 227 => [0xa0,0x1d], 300 => 0x101, 304 => [0x404,0x101a], 317 => 0x303, 319 => 0x305, 324 => 0x3103, 357 => 0x229, 366 => 0x102, 367 => 0x407, 382 => ['SNum','slno'], 383 => 0x15, 384 => 0x4b, 385 => 0x7e, 389 => 0x5, 396 => 0xa002, 399 => 0x2, 422 => 0x2031, 477 => 'SerialNumber', 487 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 382 => 'CAME' },
	'series' => { 492 => 'Series' },
	'seriesdatetime' => { 459 => 'SeriesDateTime' },
	'seriesdescription' => { 459 => 'SeriesDescription' },
	'seriesidentifier' => { 492 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 459 => 'SeriesModality' },
	'seriesname' => { 492 => [\'Series','SeriesName'] },
	'seriesnumber' => { 459 => 'SeriesNumber', 496 => 'seriesNumber' },
	'seriestitle' => { 496 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 498 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 230 => 0x61d },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 495 => 'setting' },
	'shadingcompensation' => { 299 => 0x50c, 322 => 0x8a },
	'shadingcompensation2' => { 303 => 0x1012 },
	'shadow' => { 399 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 357 => 0x79 },
	'shadowprotection' => { 273 => 0x0 },
	'shadows' => { 119 => 0xfe52, 422 => 0x2032, 474 => 'Shadows', 480 => 'Shadows', 482 => 'Shadows' },
	'shadows2012' => { 480 => 'Shadows2012', 482 => 'Shadows2012' },
	'shadowsadj' => { 457 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 480 => 'ShadowTint', 482 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 359 => 0x1, 360 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 480 => 'SharpenDetail', 482 => 'SharpenDetail' },
	'sharpenedgemasking' => { 480 => 'SharpenEdgeMasking', 482 => 'SharpenEdgeMasking' },
	'sharpening' => { 324 => 0x300b },
	'sharpeningadj' => { 277 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 480 => 'SharpenRadius', 482 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 227 => 0x6, 233 => 0x32, 234 => 0x33, 235 => 0x39, 304 => 0x100f, 322 => 0x41, 357 => 0x21, 364 => 0xb, 383 => 0x26, 385 => 0x56, 388 => 0x22, 389 => [0x1003,0x1014], 399 => 0x11, 409 => 0x1c, 410 => 0x19, 422 => 0x2006, 453 => 0x52, 480 => 'Sharpness', 482 => 'Sharpness', 486 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 457 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 304 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 457 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 422 => 0x2035 },
	'sharpnesssetting' => { 299 => 0x506, 307 => 0x1013, 411 => 0x12, 427 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 457 => 0x801d },
	'sharpnessundershoot' => { 457 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 495 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 281 => '13.2', 282 => '5.1', 290 => '10.2', 291 => '4.1', 294 => '5.1', 296 => '5.3' },
	'shootinginfomonitorofftime' => { 281 => '26.2', 282 => '22.2', 284 => '22.2', 285 => '22.2', 289 => '21.2', 290 => '9.1', 291 => '21.2', 294 => '22.2', 295 => '22.2', 296 => '22.2', 297 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 227 => 0x89, 322 => 0x1f },
	'shootingmodesetting' => { 283 => '5.1' },
	'shortdescription' => { 484 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 480 => 'ShortName', 482 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 374 => '@sti' },
	'shotdate' => { 506 => 'shotDate' },
	'shotday' => { 506 => 'shotDay' },
	'shotlocation' => { 506 => 'shotLocation' },
	'shotlogdata' => { 463 => 'shot_log_data' },
	'shotname' => { 382 => 'shot', 506 => 'shotName' },
	'shotnumber' => { 506 => 'shotNumber' },
	'shotnumbersincepowerup' => { 426 => 0x44e, 444 => 0x1a, 445 => 0x16, 446 => 0xa },
	'shotnumbersincepowerup2' => { 411 => 0x200 },
	'shotsize' => { 506 => 'shotSize' },
	'shotsperinterval' => { 229 => 0xb4, 230 => 0xc0, 254 => 0xc412 },
	'showmovement' => { 374 => 'shwm' },
	'shownevent' => { 492 => 'EventExt' },
	'showneventidentifier' => { 492 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 492 => [\'EventExt','EventExtName'] },
	'shutter' => { 441 => 0x20, 442 => 0x26, 443 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 227 => 0xa7, 240 => [0x6a,0x157,0x24d], 241 => 0x286, 242 => 0x279, 243 => 0x284, 244 => 0x242, 245 => 0x280, 246 => 0x276, 247 => [0x27d,0x27f], 248 => 0x246, 251 => 0x2d6, 252 => 0x321, 253 => 0xbd8, 255 => 0x287, 256 => 0x320, 257 => 0x24a, 258 => 0x5fb, 261 => 0x2d5, 357 => 0x5d, 420 => 0x846, 425 => [0x125,0x14a], 441 => 0x32, 442 => 0x3a, 443 => 0x3a },
	'shuttercount2' => { 441 => 0x4c, 442 => [0x50,0x52,0x58], 443 => 0x50 },
	'shuttercount3' => { 441 => [0x1a0,0x1aa,0x1bd], 442 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 227 => 0x34 },
	'shutterreleasebuttonae-l' => { 281 => '17.7', 282 => '18.4', 284 => '78.4', 285 => '78.4', 286 => '16.1', 287 => '17.1', 288 => '17.1', 289 => '17.1', 290 => '7.1', 291 => '17.5', 294 => '18.4', 295 => '78.4', 296 => '18.2', 297 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 282 => '38.1', 284 => '38.1', 285 => '38.1', 294 => '38.1', 295 => '38.1', 297 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 409 => 0x2f, 410 => 0x28, 411 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 304 => 0x1000, 366 => 0x400, 486 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 322 => 0x9f, 357 => 0x87 },
	'sidecarforextension' => { 494 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'silentphotography' => { 227 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 498 => 'skillLevel' },
	'skintonecorrection' => { 357 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 357 => 0x20b },
	'slideshowname' => { 495 => 'slideshowName' },
	'slideshownumber' => { 495 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 495 => 'slideshowTotalNumber' },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 396 => 0x20 },
	'smartrange' => { 396 => 0xa012 },
	'smileshutter' => { 411 => 0x31 },
	'smileshuttermode' => { 411 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 480 => 'Smoothness', 482 => 'Smoothness' },
	'snapshot' => { 492 => 'SnapshotLink' },
	'snapshotformat' => { 492 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 492 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 492 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 492 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 492 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 475 => 'Snapshots' },
	'snapshotusedvideoframe' => { 492 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 492 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 492 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 492 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 492 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 422 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 312 => 'Software', 366 => 0x203, 376 => 'software', 399 => 0x18, 465 => 'Software', 502 => 'Software' },
	'softwareversion' => { 382 => ['@swr',"\xa9swr"], 398 => 0x207 },
	'soloist' => { 374 => "\xa9sol" },
	'songwriter' => { 382 => "\xa9swf" },
	'songwriterkeywords' => { 382 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 430 => 0x6, 432 => 0x1b6, 433 => 0x210, 434 => 0x1fe, 435 => 0x22c },
	'sonydatetime2' => { 441 => 0x51 },
	'sonyexposuretime' => { 441 => 0x3a, 442 => 0x46, 443 => [0x66,0x46] },
	'sonyexposuretime2' => { 453 => 0xe },
	'sonyfnumber' => { 441 => 0x3c, 442 => 0x48, 443 => [0x68,0x48], 453 => 0x14 },
	'sonyimageheight' => { 430 => 0x1a, 444 => 0x44, 445 => 0x3f, 446 => 0x47 },
	'sonyimageheightmax' => { 453 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 409 => 0x54, 410 => 0x54, 411 => 0x9 },
	'sonyimagewidth' => { 430 => 0x1c },
	'sonyimagewidthmax' => { 453 => 0x3e },
	'sonyiso' => { 432 => 0x1218, 433 => 0x11f4, 434 => 0x1270, 435 => [0x1254,0x1258,0x1280], 436 => 0x113c, 437 => 0x344, 438 => 0x346, 439 => 0x320, 453 => 0x4 },
	'sonymaxaperture' => { 441 => 0x0, 442 => 0x0 },
	'sonymaxaperturevalue' => { 453 => 0x16 },
	'sonyminaperture' => { 441 => 0x1, 442 => 0x1 },
	'sonymodelid' => { 422 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonytimeminsec' => { 442 => 0x61 },
	'sortalbum' => { 374 => 'soal' },
	'sortalbumartist' => { 374 => 'soaa' },
	'sortartist' => { 374 => 'soar' },
	'sortcomposer' => { 374 => 'soco' },
	'sortname' => { 374 => 'sonm', 480 => 'SortName', 482 => 'SortName' },
	'sortshow' => { 374 => 'sosn' },
	'soundengineer' => { 374 => "\xa9sne" },
	'source' => { 131 => 0x73, 312 => 'Source', 483 => 'source', 484 => 'source', 494 => 'Source' },
	'sourcecount' => { 469 => 'SourceCount' },
	'sourcecredits' => { 382 => "\xa9src" },
	'sourcedirectoryindex' => { 344 => 0x0 },
	'sourcefileindex' => { 344 => 0x2 },
	'sourcephotoscount' => { 468 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 486 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 486 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 486 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 486 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 486 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 506 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 304 => 0x200, 398 => 0x200 },
	'specialoccasion' => { 498 => 'specialOccasion' },
	'specialtypeid' => { 463 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 486 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 382 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 382 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 382 => "\xa9zsp" },
	'spherical' => { 469 => 'Spherical' },
	'splitcolumn' => { 366 => 0x222 },
	'splittoningbalance' => { 480 => 'SplitToningBalance', 482 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 480 => 'SplitToningHighlightHue', 482 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 480 => 'SplitToningHighlightSaturation', 482 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 480 => 'SplitToningShadowHue', 482 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 480 => 'SplitToningShadowSaturation', 482 => 'SplitToningShadowSaturation' },
	'sport' => { 496 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 338 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 359 => 0x3 },
	'srgbrendering' => { 310 => 'sRGB' },
	'srhalfpresstime' => { 359 => 0x2 },
	'srresult' => { 359 => 0x0, 360 => 0x0 },
	'stackedimage' => { 299 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 487 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 282 => '19.1', 284 => '19.1', 285 => '19.1', 288 => '18.1', 289 => '18.1', 294 => '19.1', 295 => '19.1' },
	'starlightview' => { 297 => 0x249 },
	'startingpage' => { 496 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 382 => "\xa9TIM", 506 => 'startTimecode' },
	'starttimecodetimeformat' => { 506 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 506 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 506 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 382 => "\xa9TSZ", 506 => 'startTimeSampleSize' },
	'starttimescale' => { 382 => "\xa9TSC", 506 => 'startTimeScale' },
	'state' => { 161 => 'State', 322 => 0x6b, 494 => 'State' },
	'status' => { 461 => 'Status', 473 => 'Status' },
	'stereomode' => { 469 => 'StereoMode' },
	'stitched' => { 469 => 'Stitched' },
	'stitchingsoftware' => { 468 => 'StitchingSoftware', 469 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 431 => 0x113e, 432 => 0x113e, 433 => 0x111a, 434 => 0x1196, 435 => 0x1172, 436 => 0x102a, 437 => 0x222, 438 => 0x222, 439 => 0x217, 453 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 282 => '46.3', 284 => '47.3', 285 => '47.3', 294 => '47.3', 295 => '47.3', 297 => 0xd },
	'storedescription' => { 374 => 'sdes' },
	'storylineidentifier' => { 492 => 'StorylineIdentifier' },
	'straightenangle' => { 274 => 0x2fc08431 },
	'streamready' => { 492 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 506 => 'stretchMode' },
	'studydatetime' => { 459 => 'StudyDateTime' },
	'studydescription' => { 459 => 'StudyDescription' },
	'studyid' => { 459 => 'StudyID' },
	'studyphysician' => { 459 => 'StudyPhysician' },
	'styleperiod' => { 492 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 297 => 0x1cf },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 308 => 'Subject', 373 => 'Subject', 483 => 'subject', 493 => 'Subject', 507 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 486 => 'SubjectArea' },
	'subjectcode' => { 491 => 'SubjectCode' },
	'subjectdetection' => { 230 => 0x23e },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 486 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 486 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 486 => 'SubjectLocation' },
	'subjectmotion' => { 284 => '78.2', 285 => '78.2', 295 => '78.2', 297 => 0x103 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 490 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 490 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 496 => 'subsection1' },
	'subsection2' => { 496 => 'subsection2' },
	'subsection3' => { 496 => 'subsection3' },
	'subsection4' => { 496 => 'subsection4' },
	'subselector' => { 282 => '49.1', 284 => '71.1', 285 => '71.1', 295 => '71.1', 297 => 0x8f },
	'subselectorassignment' => { 282 => '48.1' },
	'subselectorcenter' => { 284 => '72.1', 285 => '72.1', 295 => '72.1' },
	'subselectorplusdials' => { 282 => '49.2', 284 => '73.1', 285 => '73.1', 295 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 374 => "\xa9st3", 382 => "\xa9snm", 496 => 'subtitle' },
	'subtitlekeywords' => { 382 => "\xa9snk" },
	'subversionfilename' => { 490 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 490 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 490 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 494 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 496 => 'supplementDisplayID' },
	'supplementstartingpage' => { 496 => 'supplementStartingPage' },
	'supplementtitle' => { 496 => 'supplementTitle' },
	'supplychainsource' => { 492 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 492 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 492 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 480 => 'SupportsAmount', 482 => 'SupportsAmount' },
	'supportscolor' => { 480 => 'SupportsColor', 482 => 'SupportsColor' },
	'supportshighdynamicrange' => { 480 => 'SupportsHighDynamicRange', 482 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 480 => 'SupportsMonochrome', 482 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 480 => 'SupportsNormalDynamicRange', 482 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 480 => 'SupportsOutputReferred', 482 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 480 => 'SupportsSceneReferred', 482 => 'SupportsSceneReferred' },
	'svisosetting' => { 338 => 0x14 },
	'swatchcoloranta' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 511 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 511 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 511 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 511 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 511 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 322 => 0x93, 411 => 0x33 },
	'sweeppanoramafieldofview' => { 322 => 0x94 },
	'sweeppanoramasize' => { 411 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 284 => '77.1', 285 => '77.1', 295 => '77.1', 297 => 0x41 },
	'system' => { 366 => 0x204 },
	'tagged' => { 368 => 0xdd, 369 => 'Tagged', 475 => 'tagged' },
	'tagslist' => { 485 => 'TagsList' },
	'tagstructure' => { 490 => 'TagStructure' },
	'takenumber' => { 506 => 'takeNumber' },
	'tapename' => { 506 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 118 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 496 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 422 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 506 => 'tempo' },
	'temporalcoverage' => { 492 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 492 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 492 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 309 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 309 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 226 => 0x4 },
	'textlayername' => { 494 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 494 => 'TextLayers' },
	'textlayertext' => { 494 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 322 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 480 => 'Texture', 482 => 'Texture' },
	'three-dtrackingfacedetection' => { 284 => '1.4', 285 => '1.4', 295 => '1.4' },
	'three-dtrackingwatcharea' => { 284 => '78.1', 285 => '78.1', 295 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 504 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 504 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 304 => 0x100, 382 => 'thmb', 504 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 382 => 'thmb' },
	'thumbnails' => { 504 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 504 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 496 => 'ticker' },
	'tiffhandling' => { 480 => 'TIFFHandling', 482 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 420 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 357 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 369 => 'TimeCreated' },
	'timelapseshotnumber' => { 325 => 0x10 },
	'timeperiod' => { 496 => 'timePeriod' },
	'timerfunctionbutton' => { 283 => '5.2', 286 => '12.1', 287 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 322 => 0x96 },
	'timescaleparams' => { 506 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 506 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 506 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 506 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 470 => 'TimeShot' },
	'timesignature' => { 506 => 'timeSignature' },
	'timesincepoweron' => { 322 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 298 => 0x8, 312 => 'TimeStamp', 322 => 0xaf, 469 => 'Timestamp', 476 => 'Timestamp', 490 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 230 => 0x594, 266 => 0x0, 392 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 376 => 'player.movie.visual.tint', 480 => 'Tint', 482 => 'Tint' },
	'title' => { 157 => 'Title', 308 => 'Title', 312 => 'Title', 322 => 0x65, 373 => 'Title', 374 => ['titl',"\xa9nam"], 376 => 'title', 382 => ['titl',"\xa9nam"], 483 => 'title', 493 => 'Title', 504 => 'Title' },
	'togglestyleamount' => { 480 => 'ToggleStyleAmount', 482 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 480 => 'ToggleStyleDigest', 482 => 'ToggleStyleDigest' },
	'tonecomp' => { 227 => 0x81 },
	'tonecurve' => { 74 => 0x1, 357 => 0x402, 480 => 'ToneCurve', 482 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 396 => 0xa043 },
	'tonecurveadobergbdefault' => { 396 => 0xa041 },
	'tonecurveblue' => { 480 => 'ToneCurveBlue', 482 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 457 => 0x9003 },
	'tonecurvebluey' => { 457 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 457 => 0x9000 },
	'tonecurvebrightnessy' => { 457 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 480 => 'ToneCurveGreen', 482 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 457 => 0x9002 },
	'tonecurvegreeny' => { 457 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 480 => 'ToneCurveName', 482 => 'ToneCurveName' },
	'tonecurvename2012' => { 480 => 'ToneCurveName2012', 482 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 480 => 'ToneCurvePV2012', 482 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 480 => 'ToneCurvePV2012Blue', 482 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 480 => 'ToneCurvePV2012Green', 482 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 480 => 'ToneCurvePV2012Red', 482 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 480 => 'ToneCurveRed', 482 => 'ToneCurveRed' },
	'tonecurveredx' => { 457 => 0x9001 },
	'tonecurveredy' => { 457 => 0x9005 },
	'tonecurves' => { 357 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 396 => 0xa042 },
	'tonecurvesrgbdefault' => { 396 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 299 => 0x52e },
	'tonemapstrength' => { 480 => 'ToneMapStrength', 482 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 227 => 0xb3, 233 => 0x38, 234 => 0x40, 235 => 0x48, 389 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 233 => 0x39, 234 => 0x41, 235 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 322 => 0xab },
	'track' => { 374 => "\xa9trk", 382 => "\xa9trk" },
	'trackcreatedate' => { 381 => 0x1 },
	'trackmodifydate' => { 381 => 0x2 },
	'tracknumber' => { 374 => 'trkn', 506 => 'trackNumber' },
	'tracks' => { 506 => 'Tracks' },
	'tracksframerate' => { 506 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 506 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 506 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 506 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 506 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 506 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 506 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 506 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 506 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 506 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 506 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 506 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 506 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 506 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 506 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 506 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 506 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 382 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 492 => 'Transcript' },
	'transcriptlink' => { 492 => 'TranscriptLink' },
	'transcriptlinklink' => { 492 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 492 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 502 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 322 => [0x8012,0x59] },
	'transmissionreference' => { 494 => 'TransmissionReference' },
	'trapped' => { 308 => 'Trapped', 493 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 322 => 0x36 },
	'treble' => { 376 => 'player.movie.audio.treble' },
	'triggermode' => { 383 => 0x6, 384 => 0x34, 385 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 345 => 0x5 },
	'ttl_da_aup' => { 345 => 0x4 },
	'ttl_da_bdown' => { 345 => 0x7 },
	'ttl_da_bup' => { 345 => 0x6 },
	'tungstenawb' => { 335 => 0x1 },
	'tvepisode' => { 374 => 'tves' },
	'tvepisodeid' => { 374 => 'tven' },
	'tvexposuretimesetting' => { 338 => 0x12 },
	'tvnetworkname' => { 374 => 'tvnn' },
	'tvseason' => { 374 => 'tvsn' },
	'tvshow' => { 374 => 'tvsh' },
	'type' => { 464 => 'Type', 483 => 'type', 501 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 465 => 'Units' },
	'unknown_aacr' => { 374 => 'AACR' },
	'unknown_cdek' => { 374 => 'CDEK' },
	'unknown_cdet' => { 374 => 'CDET' },
	'unknownblock' => { 357 => 0x405 },
	'unknownblock1' => { 303 => 0x635 },
	'unknownblock2' => { 303 => 0x636 },
	'unknownblock3' => { 303 => 0x1103 },
	'unknownblock4' => { 303 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 366 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 382 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 382 => 'thmb' },
	'unsharp1color' => { 279 => 0x13 },
	'unsharp1halowidth' => { 279 => 0x19 },
	'unsharp1intensity' => { 279 => 0x17 },
	'unsharp1threshold' => { 279 => 0x1b },
	'unsharp2color' => { 279 => 0x2e },
	'unsharp2halowidth' => { 279 => 0x34 },
	'unsharp2intensity' => { 279 => 0x32 },
	'unsharp2threshold' => { 279 => 0x36 },
	'unsharp3color' => { 279 => 0x49 },
	'unsharp3halowidth' => { 279 => 0x4f },
	'unsharp3intensity' => { 279 => 0x4d },
	'unsharp3threshold' => { 279 => 0x51 },
	'unsharp4color' => { 279 => 0x64 },
	'unsharp4halowidth' => { 279 => 0x6a },
	'unsharp4intensity' => { 279 => 0x68 },
	'unsharp4threshold' => { 279 => 0x6c },
	'unsharpcount' => { 279 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 274 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 480 => 'UprightCenterMode', 482 => 'UprightCenterMode' },
	'uprightcenternormx' => { 480 => 'UprightCenterNormX', 482 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 480 => 'UprightCenterNormY', 482 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 480 => 'UprightDependentDigest', 482 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 480 => 'UprightFocalLength35mm', 482 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 480 => 'UprightFocalMode', 482 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 480 => 'UprightFourSegments_0', 482 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 480 => 'UprightFourSegments_1', 482 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 480 => 'UprightFourSegments_2', 482 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 480 => 'UprightFourSegments_3', 482 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 480 => 'UprightFourSegmentsCount', 482 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 480 => 'UprightGuidedDependentDigest', 482 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 480 => 'UprightPreview', 482 => 'UprightPreview' },
	'uprighttransform_0' => { 480 => 'UprightTransform_0', 482 => 'UprightTransform_0' },
	'uprighttransform_1' => { 480 => 'UprightTransform_1', 482 => 'UprightTransform_1' },
	'uprighttransform_2' => { 480 => 'UprightTransform_2', 482 => 'UprightTransform_2' },
	'uprighttransform_3' => { 480 => 'UprightTransform_3', 482 => 'UprightTransform_3' },
	'uprighttransform_4' => { 480 => 'UprightTransform_4', 482 => 'UprightTransform_4' },
	'uprighttransform_5' => { 480 => 'UprightTransform_5', 482 => 'UprightTransform_5' },
	'uprighttransformcount' => { 480 => 'UprightTransformCount', 482 => 'UprightTransformCount' },
	'uprightversion' => { 480 => 'UprightVersion', 482 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 494 => 'Urgency' },
	'url' => { 157 => 'URL', 312 => 'URL', 371 => 0x40b, 496 => 'url' },
	'url_list' => { 371 => 0x41e },
	'urla-platform' => { 496 => [\'url','urlA-platform'] },
	'urlurl' => { 496 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 497 => 'usage' },
	'usageterms' => { 510 => 'UsageTerms' },
	'usbpowerdelivery' => { 230 => 0x664 },
	'usedialwithouthold' => { 297 => 0xbf },
	'useguidelines' => { 478 => 'useGuidelines' },
	'usepanoramaviewer' => { 468 => 'UsePanoramaViewer' },
	'usercollection' => { 376 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 486 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 473 => 'UserFields' },
	'userlabel' => { 383 => 0x2b, 384 => 0x5a, 385 => 0x68 },
	'userprofile' => { 317 => 0x302, 321 => 0x34c, 324 => 0x3038 },
	'userrating' => { 376 => 'rating.user', 382 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 496 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 480 => 'UUID', 482 => 'UUID' },
	'uv-irfiltercorrection' => { 317 => 0x325 },
	'validbits' => { 303 => 0x611, 304 => 0x102c },
	'validpixeldepth' => { 307 => 0x611 },
	'variablelowpassfilter' => { 422 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 227 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 382 => 'vndr' },
	'vendorinfo' => { 460 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 460 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 460 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 460 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 118 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 127 => 0x0, 373 => 'Version', 376 => 'version', 480 => 'Version', 482 => 'Version' },
	'versioncreatedate' => { 457 => 0xd100 },
	'versionid' => { 507 => 'VersionID' },
	'versionidentifier' => { 496 => 'versionIdentifier' },
	'versionmodifydate' => { 457 => 0xd101 },
	'versions' => { 507 => 'Versions' },
	'versionscomments' => { 507 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 507 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 507 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 507 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 507 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 507 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 507 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 507 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 507 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 507 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 507 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 281 => '3.2', 282 => '47.2', 284 => '79.1', 297 => 0x11d },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 282 => '42.2', 284 => '67.1', 297 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 297 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 282 => '43.1' },
	'verticalfuncplusdials' => { 284 => '68.1' },
	'verticalmovieafonbutton' => { 297 => 0x1f9 },
	'verticalmoviefuncbutton' => { 297 => 0x1e1 },
	'verticalmultiselector' => { 282 => '42.1', 284 => '66.1', 285 => '66.1', 295 => '66.1', 297 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 297 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 474 => 'Vibrance', 480 => 'Vibrance', 482 => 'Vibrance' },
	'vibrationreduction' => { 240 => [0x75,0x82,0x1ae], 248 => '586.1', 257 => '590.2', 265 => 0x4 },
	'videoalphamode' => { 506 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 506 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 506 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 506 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 492 => 'videoBitRate' },
	'videobitratemode' => { 492 => 'videoBitRateMode' },
	'videoburstmode' => { 322 => 0xbb },
	'videoburstresolution' => { 322 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 506 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 506 => 'videoCompressor' },
	'videodisplayaspectratio' => { 492 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 492 => 'videoEncodingProfile' },
	'videofieldorder' => { 506 => 'videoFieldOrder' },
	'videoframerate' => { 322 => 0x27, 506 => 'videoFrameRate' },
	'videoframesize' => { 506 => 'videoFrameSize' },
	'videoframesizeh' => { 506 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 506 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 506 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 506 => 'videoModDate' },
	'videopixelaspectratio' => { 506 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 506 => 'videoPixelDepth' },
	'videopreburst' => { 322 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 492 => 'VideoShotType' },
	'videoshottypeidentifier' => { 492 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 492 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 492 => 'videoStreamsCount' },
	'viewfinder' => { 366 => 0x455 },
	'viewfinderdisplay' => { 281 => '12.4', 282 => '6.3' },
	'viewfinderwarning' => { 281 => '13.4', 291 => '3.5', 292 => '6.2', 296 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 411 => 0x2f, 427 => 0x18 },
	'viewingmode2' => { 411 => [0x85,0x285] },
	'viewpoint' => { 495 => 'viewpoint' },
	'vignetteamount' => { 480 => 'VignetteAmount', 482 => 'VignetteAmount' },
	'vignettecontrol' => { 227 => 0x2a, 274 => 0x76a43205 },
	'vignettecontrolintensity' => { 274 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 477 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 480 => 'VignetteMidpoint', 482 => 'VignetteMidpoint' },
	'vignetting' => { 389 => 0x1011, 396 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 396 => 0xa053, 422 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 452 => 0x64a, 453 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 396 => 0xa054 },
	'virtualhorizonstyle' => { 297 => 0x167 },
	'visualcolor' => { 492 => 'VisualColour' },
	'visualtechnique' => { 495 => 'visualTechnique' },
	'voicememo' => { 398 => 0x216 },
	'volume' => { 496 => 'volume' },
	'vr_0x66' => { 240 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 230 => 0x212, 265 => 0x6 },
	'vrtype' => { 265 => 0x8 },
	'waterdepth' => { 119 => 0x9403, 487 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 303 => 0x11f },
	'wb_glevel3000k' => { 303 => 0x113 },
	'wb_glevel3300k' => { 303 => 0x114 },
	'wb_glevel3600k' => { 303 => 0x115 },
	'wb_glevel3900k' => { 303 => 0x116 },
	'wb_glevel4000k' => { 303 => 0x117 },
	'wb_glevel4300k' => { 303 => 0x118 },
	'wb_glevel4500k' => { 303 => 0x119 },
	'wb_glevel4800k' => { 303 => 0x11a },
	'wb_glevel5300k' => { 303 => 0x11b },
	'wb_glevel6000k' => { 303 => 0x11c },
	'wb_glevel6600k' => { 303 => 0x11d },
	'wb_glevel7500k' => { 303 => 0x11e },
	'wb_grbglevels' => { 201 => 0x0, 429 => 0x7303 },
	'wb_grbglevelsauto' => { 81 => 0x2, 429 => 0x7302 },
	'wb_grbglevelscloudy' => { 81 => 0x12 },
	'wb_grbglevelscustom1' => { 81 => 0x42 },
	'wb_grbglevelscustom2' => { 81 => 0x4a },
	'wb_grbglevelsdaylight' => { 81 => 0xa },
	'wb_grbglevelsflash' => { 81 => 0x32 },
	'wb_grbglevelsfluorescent' => { 81 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 81 => 0x2a },
	'wb_grbglevelstungsten' => { 81 => 0x1a },
	'wb_grbglevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 198 => 0x0 },
	'wb_rblevels' => { 202 => 0x270, 227 => 0xc, 303 => 0x100 },
	'wb_rblevels1' => { 328 => 0x2 },
	'wb_rblevels2' => { 328 => 0x5 },
	'wb_rblevels3' => { 328 => 0x8 },
	'wb_rblevels3000k' => { 303 => 0x102 },
	'wb_rblevels3300k' => { 303 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 303 => 0x104 },
	'wb_rblevels3900k' => { 303 => 0x105 },
	'wb_rblevels4' => { 328 => 0xb },
	'wb_rblevels4000k' => { 303 => 0x106 },
	'wb_rblevels4300k' => { 303 => 0x107 },
	'wb_rblevels4500k' => { 303 => 0x108 },
	'wb_rblevels4800k' => { 303 => 0x109 },
	'wb_rblevels5' => { 328 => 0xe },
	'wb_rblevels5300k' => { 303 => 0x10a },
	'wb_rblevels6' => { 328 => 0x11 },
	'wb_rblevels6000k' => { 303 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 303 => 0x10c },
	'wb_rblevels7' => { 328 => 0x14 },
	'wb_rblevels7500k' => { 303 => 0x10d },
	'wb_rblevelsauto' => { 202 => 0x272, 307 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 202 => 0x296, 307 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 307 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 303 => 0x10e },
	'wb_rblevelscwb2' => { 303 => 0x10f },
	'wb_rblevelscwb3' => { 303 => 0x110 },
	'wb_rblevelscwb4' => { 303 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 202 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 307 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 307 => 0x131 },
	'wb_rblevelseveningsunlight' => { 307 => 0x124 },
	'wb_rblevelsfineweather' => { 307 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 202 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 202 => 0x290 },
	'wb_rblevelsincandescent' => { 202 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 202 => 0x2b2, 307 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 307 => 0x123 },
	'wb_rblevelsused' => { 307 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 307 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 200 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 318 => 0xd, 319 => 0x413, 324 => 0x3036, 366 => 0x107, 431 => 0x117c, 432 => 0x1180, 433 => 0x115c, 434 => 0x11d8, 435 => 0x11b4, 436 => 0x106c, 437 => 0x264, 438 => 0x264, 439 => 0x252 },
	'wb_rgblevels1' => { 329 => 0x2 },
	'wb_rgblevels2' => { 329 => 0x6 },
	'wb_rgblevels2500k' => { 429 => 0x782d },
	'wb_rgblevels3' => { 329 => 0xa },
	'wb_rgblevels3200k' => { 429 => 0x782c },
	'wb_rgblevels4' => { 329 => 0xe },
	'wb_rgblevels4500k' => { 429 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 329 => 0x12 },
	'wb_rgblevels6' => { 329 => 0x16 },
	'wb_rgblevels6000k' => { 429 => 0x782b },
	'wb_rgblevels7' => { 329 => 0x1a },
	'wb_rgblevels8500k' => { 429 => 0x782a },
	'wb_rgblevelsauto' => { 400 => 0x0 },
	'wb_rgblevelscloudy' => { 429 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 400 => 0x15 },
	'wb_rgblevelscustom2' => { 400 => 0x18 },
	'wb_rgblevelscustom3' => { 400 => 0x1b },
	'wb_rgblevelsdaylight' => { 400 => 0x3, 429 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 400 => 0x12, 429 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 400 => 0xf, 429 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 429 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 429 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 429 => 0x7828 },
	'wb_rgblevelsincandescent' => { 400 => 0xc },
	'wb_rgblevelsovercast' => { 400 => 0x9 },
	'wb_rgblevelsshade' => { 400 => 0x6, 429 => 0x7825 },
	'wb_rgblevelstungsten' => { 429 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 401 => 0x0 },
	'wb_rgblevelsunknown1' => { 401 => 0x3 },
	'wb_rgblevelsunknown2' => { 401 => 0x6 },
	'wb_rgblevelsunknown3' => { 401 => 0x9 },
	'wb_rgblevelsunknown4' => { 401 => 0xc },
	'wb_rgblevelsunknown5' => { 401 => 0xf },
	'wb_rgblevelsunknown6' => { 401 => 0x12 },
	'wb_rgblevelsunknown7' => { 401 => 0x15 },
	'wb_rgblevelsunknown8' => { 401 => 0x18 },
	'wb_rgblevelsunknown9' => { 401 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 190 => 0x4, 199 => 0x0, 203 => 0x13e8, 204 => 0x38, 429 => 0x7313 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 203 => 0x1478, 204 => 0x114, 396 => 0xa022, 429 => 0x7312 },
	'wb_rggblevelsblack' => { 396 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 203 => 0x1408, 204 => 0x60, 357 => 0x20f, 365 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 203 => 0x1468, 204 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 203 => 0x13f8, 204 => 0x4c, 357 => 0x20d, 365 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 203 => 0x1448, 357 => 0x214, 365 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 204 => 0xc4, 357 => 0x211, 365 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 365 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 204 => 0xb0, 357 => 0x212, 365 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 203 => 0x1438, 204 => 0x9c, 357 => 0x213, 365 => 0x38 },
	'wb_rggblevelshtmercury' => { 204 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 396 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 396 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 204 => 0x74, 357 => 0x20e, 365 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 203 => 0x1428, 204 => 0x88, 357 => 0x210, 365 => 0x1d },
	'wb_rggblevelsuncorrected' => { 396 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 365 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 365 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 280 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 280 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 280 => 0x10 },
	'wbadjredbalance' => { 280 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 280 => 0x18 },
	'wbadjtint' => { 280 => 0x25 },
	'wbbluelevel' => { 317 => 0x324, 322 => 0x8006, 327 => 0x26 },
	'wbbracketingsteps' => { 249 => 0x174d, 250 => 0x87c, 259 => 0x1757 },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 389 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 317 => 0x323, 322 => 0x8005, 327 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 304 => 0x1015 },
	'wbredlevel' => { 317 => 0x322, 322 => 0x8004, 327 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 322 => 0x46, 339 => 0x10 },
	'wbshiftab_gm' => { 422 => 0x2014 },
	'wbshiftab_gm_precise' => { 422 => 0x2026 },
	'wbshiftcreativecontrol' => { 322 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 322 => 0x47, 339 => 0x11 },
	'wbshiftintelligentauto' => { 322 => 0x8b },
	'wbtype1' => { 328 => 0x1, 329 => 0x1 },
	'wbtype2' => { 328 => 0x4, 329 => 0x5 },
	'wbtype3' => { 328 => 0x7, 329 => 0x9 },
	'wbtype4' => { 328 => 0xa, 329 => 0xd },
	'wbtype5' => { 328 => 0xd, 329 => 0x11 },
	'wbtype6' => { 328 => 0x10, 329 => 0x15 },
	'wbtype7' => { 328 => 0x13, 329 => 0x19 },
	'webstatement' => { 510 => 'WebStatement' },
	'weightedflatsubject' => { 472 => 'weightedFlatSubject' },
	'what' => { 480 => 'What', 482 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 227 => 0x5, 264 => 0x7, 317 => 0x304, 322 => 0x3, 324 => 0x3033, 357 => 0x19, 364 => 0x7, 388 => 0x26, 389 => 0x1003, 399 => [0x88,0x3c,0x7,0x58], 409 => 0xf, 410 => 0xe, 422 => [0x115,0xb054], 480 => 'WhiteBalance', 482 => 'WhiteBalance', 486 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 299 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 274 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 335 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 304 => 0x304, 322 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 299 => 0x502, 304 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 420 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 297 => 0x1c5 },
	'whitebalancecomp' => { 307 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 227 => [0xb,0x3f], 389 => 0x1004, 409 => 0x6, 410 => 0x5, 422 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 357 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 338 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 409 => 0x5, 410 => 0x4, 411 => 0x16, 427 => 0xd },
	'whitebalancesetup' => { 396 => 0x41 },
	'whitebalancetemperature' => { 299 => 0x501 },
	'whiteboard' => { 304 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 357 => 0x7e, 429 => 0x787f },
	'whitepoint' => { 119 => 0x13e, 321 => 0x35d, 357 => 0x201, 502 => 'WhitePoint' },
	'whites2012' => { 480 => 'Whites2012', 482 => 'Whites2012' },
	'whitesadj' => { 457 => 0x9017 },
	'wideadapter' => { 389 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 398 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 230 => 0x2d6 },
	'windowlocation' => { 382 => 'WLOC' },
	'windowsatom' => { 481 => 'windowsAtom' },
	'windowsatomextension' => { 481 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 481 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 481 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 496 => 'wordCount' },
	'work' => { 374 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 492 => 'WorkflowTag' },
	'workflowtagcvid' => { 492 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 492 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 492 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 492 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 488 => 'WorkToDo' },
	'worldtimelocation' => { 322 => 0x3a, 357 => 0x22, 363 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 399 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 503 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 372 => 0x0, 502 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 382 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 249 => 0x3513, 250 => 0x2c2c, 254 => 0xc222, 259 => 0x36fc, 260 => 0x2f03, 262 => 0xce3a, 263 => 0xeaf3, 394 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 502 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 502 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 502 => 'YCbCrSubSampling' },
	'year' => { 374 => 'yrrc', 376 => 'year', 382 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 498 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 372 => 0x4, 502 => 'YResolution' },
	'zebrapatterntonerange' => { 297 => 0x211 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 422 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 409 => 0x1f },
	'zoomedpreviewlength' => { 304 => 0xf05 },
	'zoomedpreviewsize' => { 304 => 0xf06 },
	'zoomedpreviewstart' => { 304 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 302 => 0x300, 304 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menusettingsz7ii' => 1,
	'menusettingsz9' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'moviefunc2button' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2022, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
