/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @file  ap_config_layout.h
 * @brief Apache Config Layout
 */

#ifndef AP_CONFIG_LAYOUT_H
#define AP_CONFIG_LAYOUT_H

/* Configured Apache directory layout */
#define DEFAULT_PREFIX "/usr/local"
#define DEFAULT_EXP_EXEC_PREFIX "/usr/local"
#define DEFAULT_REL_EXEC_PREFIX ""
#define DEFAULT_EXP_BINDIR "/usr/local/bin"
#define DEFAULT_REL_BINDIR "bin"
#define DEFAULT_EXP_SBINDIR "/usr/local/sbin"
#define DEFAULT_REL_SBINDIR "sbin"
#define DEFAULT_EXP_LIBEXECDIR "/usr/local/lib/apache2"
#define DEFAULT_REL_LIBEXECDIR "lib/apache2"
#define DEFAULT_EXP_MANDIR "/usr/local/man"
#define DEFAULT_REL_MANDIR "man"
#define DEFAULT_EXP_SYSCONFDIR "/etc/apache2"
#define DEFAULT_REL_SYSCONFDIR "/etc/apache2"
#define DEFAULT_EXP_DATADIR "/usr/local"
#define DEFAULT_REL_DATADIR ""
#define DEFAULT_EXP_INSTALLBUILDDIR "/usr/local/share/apache2/build"
#define DEFAULT_REL_INSTALLBUILDDIR "share/apache2/build"
#define DEFAULT_EXP_ERRORDIR "/usr/local/error"
#define DEFAULT_REL_ERRORDIR "error"
#define DEFAULT_EXP_ICONSDIR "/usr/local/icons"
#define DEFAULT_REL_ICONSDIR "icons"
#define DEFAULT_EXP_HTDOCSDIR "/usr/local/htdocs"
#define DEFAULT_REL_HTDOCSDIR "htdocs"
#define DEFAULT_EXP_MANUALDIR "/usr/local/share/doc/apache2"
#define DEFAULT_REL_MANUALDIR "share/doc/apache2"
#define DEFAULT_EXP_CGIDIR "/usr/local/cgi-bin"
#define DEFAULT_REL_CGIDIR "cgi-bin"
#define DEFAULT_EXP_INCLUDEDIR "/usr/local/include/apache2"
#define DEFAULT_REL_INCLUDEDIR "include/apache2"
#define DEFAULT_EXP_LOCALSTATEDIR "/var"
#define DEFAULT_REL_LOCALSTATEDIR "/var"
#define DEFAULT_EXP_RUNTIMEDIR "/usr/local/logs"
#define DEFAULT_REL_RUNTIMEDIR "logs"
#define DEFAULT_EXP_LOGFILEDIR "/usr/local/logs"
#define DEFAULT_REL_LOGFILEDIR "logs"
#define DEFAULT_EXP_PROXYCACHEDIR "/usr/local/proxy"
#define DEFAULT_REL_PROXYCACHEDIR "proxy"

#endif /* AP_CONFIG_LAYOUT_H */
