/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import org.xml.sax.InputSource;

public class Parse
extends SystemFunction {
    String baseURI;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.baseURI == null) {
            super.checkArguments(visitor);
            this.baseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        Builder b;
        Controller controller = c.getController();
        AtomicValue content = (AtomicValue)this.argument[0].evaluateItem(c);
        StringReader sr = new StringReader(content.getStringValue());
        InputSource is = new InputSource(sr);
        is.setSystemId(this.baseURI);
        Source source = new SAXSource(is);
        source.setSystemId(this.baseURI);
        Receiver s = b = controller.makeBuilder();
        source = AugmentedSource.makeAugmentedSource(source);
        ((AugmentedSource)source).setStripSpace(4);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            s = controller.getConfiguration().getAnnotationStripper(s);
        }
        try {
            new Sender(controller.makePipelineConfiguration()).send(source, s);
            NodeInfo node = b.getCurrentRoot();
            b.reset();
            return node;
        }
        catch (XPathException err) {
            throw new XPathException(err);
        }
    }
}

