/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.gson;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class GsonGenerator
extends JsonGenerator {
    private final JsonWriter writer;
    private final GsonFactory factory;

    GsonGenerator(GsonFactory factory, JsonWriter writer) {
        this.factory = factory;
        this.writer = writer;
        writer.setLenient(true);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public JsonFactory getFactory() {
        return this.factory;
    }

    public void writeBoolean(boolean state) throws IOException {
        this.writer.value(state);
    }

    public void writeEndArray() throws IOException {
        this.writer.endArray();
    }

    public void writeEndObject() throws IOException {
        this.writer.endObject();
    }

    public void writeFieldName(String name) throws IOException {
        this.writer.name(name);
    }

    public void writeNull() throws IOException {
        this.writer.nullValue();
    }

    public void writeNumber(int v) throws IOException {
        this.writer.value((long)v);
    }

    public void writeNumber(long v) throws IOException {
        this.writer.value(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.writer.value((Number)v);
    }

    public void writeNumber(double v) throws IOException {
        this.writer.value(v);
    }

    public void writeNumber(float v) throws IOException {
        this.writer.value(v);
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this.writer.value((Number)v);
    }

    public void writeNumber(String encodedValue) throws IOException {
        this.writer.value((Number)new StringNumber(encodedValue));
    }

    public void writeStartArray() throws IOException {
        this.writer.beginArray();
    }

    public void writeStartObject() throws IOException {
        this.writer.beginObject();
    }

    public void writeString(String value) throws IOException {
        this.writer.value(value);
    }

    public void enablePrettyPrint() throws IOException {
        this.writer.setIndent("  ");
    }

    static final class StringNumber
    extends Number {
        private static final long serialVersionUID = 1L;
        private final String encodedValue;

        StringNumber(String encodedValue) {
            this.encodedValue = encodedValue;
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public float floatValue() {
            return 0.0f;
        }

        @Override
        public int intValue() {
            return 0;
        }

        @Override
        public long longValue() {
            return 0L;
        }

        public String toString() {
            return this.encodedValue;
        }
    }
}

