/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

class ChannelSession<StartT, ResultT, ChannelT> {
    private final Object channelInitSyncObj = new ChannelSessionInitLockObject();
    private final ApiFuture<StartT> startFuture;
    private final ApiFunction<StartT, ChannelT> f;
    private final SettableApiFuture<ResultT> resultFuture;
    private volatile ApiFuture<ChannelT> channelFuture;

    private ChannelSession(ApiFuture<StartT> startFuture, BiFunction<StartT, SettableApiFuture<ResultT>, ChannelT> f) {
        this.startFuture = startFuture;
        this.resultFuture = SettableApiFuture.create();
        this.f = s -> f.apply(s, this.resultFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<ChannelT> openAsync() {
        ApiFuture<ChannelT> result = this.channelFuture;
        if (result != null) {
            return result;
        }
        Object object = this.channelInitSyncObj;
        synchronized (object) {
            if (this.channelFuture == null) {
                this.channelFuture = ApiFutures.transform(this.startFuture, this.f, (Executor)MoreExecutors.directExecutor());
            }
            return this.channelFuture;
        }
    }

    public ApiFuture<ResultT> getResult() {
        return this.resultFuture;
    }

    private static final class ChannelSessionInitLockObject {
        private ChannelSessionInitLockObject() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    static final class BufferedWriteSession<S, R>
    extends ChannelSession<S, R, BufferedWritableByteChannelSession.BufferedWritableByteChannel>
    implements BufferedWritableByteChannelSession<R> {
        BufferedWriteSession(ApiFuture<S> startFuture, BiFunction<S, SettableApiFuture<R>, BufferedWritableByteChannelSession.BufferedWritableByteChannel> f) {
            super(startFuture, f);
        }
    }

    static final class UnbufferedWriteSession<S, R>
    extends ChannelSession<S, R, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel>
    implements UnbufferedWritableByteChannelSession<R> {
        UnbufferedWriteSession(ApiFuture<S> startFuture, BiFunction<S, SettableApiFuture<R>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> f) {
            super(startFuture, f);
        }
    }

    static final class BufferedReadSession<S, R>
    extends ChannelSession<S, R, BufferedReadableByteChannelSession.BufferedReadableByteChannel>
    implements BufferedReadableByteChannelSession<R> {
        BufferedReadSession(ApiFuture<S> startFuture, BiFunction<S, SettableApiFuture<R>, BufferedReadableByteChannelSession.BufferedReadableByteChannel> f) {
            super(startFuture, f);
        }
    }

    static final class UnbufferedReadSession<S, R>
    extends ChannelSession<S, R, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel>
    implements UnbufferedReadableByteChannelSession<R> {
        UnbufferedReadSession(ApiFuture<S> startFuture, BiFunction<S, SettableApiFuture<R>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
            super(startFuture, f);
        }
    }
}

