/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage.query;

import java.util.Iterator;
import java.util.List;
import org.traccar.model.GroupedModel;

public interface Condition {
    public static Condition merge(List<Condition> conditions) {
        Condition result = null;
        Iterator<Condition> iterator = conditions.iterator();
        if (iterator.hasNext()) {
            result = iterator.next();
            while (iterator.hasNext()) {
                result = new And(result, iterator.next());
            }
        }
        return result;
    }

    public static class And
    extends Binary {
        public And(Condition first, Condition second) {
            super(first, second, "AND");
        }
    }

    public static class LatestPositions
    implements Condition {
        private final long deviceId;

        public LatestPositions(long deviceId) {
            this.deviceId = deviceId;
        }

        public LatestPositions() {
            this(0L);
        }

        public long getDeviceId() {
            return this.deviceId;
        }
    }

    public static class Permission
    implements Condition {
        private final Class<?> ownerClass;
        private final long ownerId;
        private final Class<?> propertyClass;
        private final long propertyId;
        private final boolean excludeGroups;

        private Permission(Class<?> ownerClass, long ownerId, Class<?> propertyClass, long propertyId, boolean excludeGroups) {
            this.ownerClass = ownerClass;
            this.ownerId = ownerId;
            this.propertyClass = propertyClass;
            this.propertyId = propertyId;
            this.excludeGroups = excludeGroups;
        }

        public Permission(Class<?> ownerClass, long ownerId, Class<?> propertyClass) {
            this(ownerClass, ownerId, propertyClass, 0L, false);
        }

        public Permission(Class<?> ownerClass, Class<?> propertyClass, long propertyId) {
            this(ownerClass, 0L, propertyClass, propertyId, false);
        }

        public Permission excludeGroups() {
            return new Permission(this.ownerClass, this.ownerId, this.propertyClass, this.propertyId, true);
        }

        public Class<?> getOwnerClass() {
            return this.ownerClass;
        }

        public long getOwnerId() {
            return this.ownerId;
        }

        public Class<?> getPropertyClass() {
            return this.propertyClass;
        }

        public long getPropertyId() {
            return this.propertyId;
        }

        public boolean getIncludeGroups() {
            boolean ownerGroupModel = GroupedModel.class.isAssignableFrom(this.ownerClass);
            boolean propertyGroupModel = GroupedModel.class.isAssignableFrom(this.propertyClass);
            return (ownerGroupModel || propertyGroupModel) && !this.excludeGroups;
        }
    }

    public static class Binary
    implements Condition {
        private final Condition first;
        private final Condition second;
        private final String operator;

        public Binary(Condition first, Condition second, String operator) {
            this.first = first;
            this.second = second;
            this.operator = operator;
        }

        public Condition getFirst() {
            return this.first;
        }

        public Condition getSecond() {
            return this.second;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    public static class Or
    extends Binary {
        public Or(Condition first, Condition second) {
            super(first, second, "OR");
        }
    }

    public static class Between
    implements Condition {
        private final String column;
        private final String fromVariable;
        private final Object fromValue;
        private final String toVariable;
        private final Object toValue;

        public Between(String column, String fromVariable, Object fromValue, String toVariable, Object toValue) {
            this.column = column;
            this.fromVariable = fromVariable;
            this.fromValue = fromValue;
            this.toVariable = toVariable;
            this.toValue = toValue;
        }

        public String getColumn() {
            return this.column;
        }

        public String getFromVariable() {
            return this.fromVariable;
        }

        public Object getFromValue() {
            return this.fromValue;
        }

        public String getToVariable() {
            return this.toVariable;
        }

        public Object getToValue() {
            return this.toValue;
        }
    }

    public static class Compare
    implements Condition {
        private final String column;
        private final String operator;
        private final String variable;
        private final Object value;

        public Compare(String column, String operator, String variable, Object value) {
            this.column = column;
            this.operator = operator;
            this.variable = variable;
            this.value = value;
        }

        public String getColumn() {
            return this.column;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getVariable() {
            return this.variable;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class Equals
    extends Compare {
        public Equals(String column, Object value) {
            super(column, "=", column, value);
        }
    }
}

