/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;
import org.traccar.model.Device;

public class Minifinder2ProtocolEncoder
extends BaseProtocolEncoder {
    public Minifinder2ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(171);
        buf.writeByte(0);
        buf.writeShortLE(content.readableBytes());
        buf.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, content.nioBuffer()));
        buf.writeShortLE(1);
        buf.writeBytes(content);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        Device device = this.getCacheManager().getObject(Device.class, command.getDeviceId());
        if ("Nano".equalsIgnoreCase(device.getModel())) {
            ByteBuf content = Unpooled.buffer();
            if (command.getType().equals("firmwareUpdate")) {
                String url = command.getString("data");
                content.writeByte(4);
                content.writeByte(1 + url.length());
                content.writeByte(48);
                content.writeCharSequence((CharSequence)url, StandardCharsets.US_ASCII);
                return this.encodeContent(content);
            }
        }
        return null;
    }
}

