/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.MessagingErrorCode;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.SendResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class NotificatorFirebase
implements Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorFirebase.class);
    private final NotificationFormatter notificationFormatter;
    private final Storage storage;
    private final CacheManager cacheManager;

    @Inject
    public NotificatorFirebase(Config config, NotificationFormatter notificationFormatter, Storage storage, CacheManager cacheManager) throws IOException {
        this.notificationFormatter = notificationFormatter;
        this.storage = storage;
        this.cacheManager = cacheManager;
        ByteArrayInputStream serviceAccount = new ByteArrayInputStream(config.getString(Keys.NOTIFICATOR_FIREBASE_SERVICE_ACCOUNT).getBytes());
        FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).build();
        FirebaseApp.initializeApp((FirebaseOptions)options);
    }

    @Override
    public void send(org.traccar.model.Notification notification, User user, Event event, Position position) throws MessageException {
        if (user.hasAttribute("notificationTokens")) {
            NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
            ArrayList<String> registrationTokens = new ArrayList<String>(Arrays.asList(user.getString("notificationTokens").split("[, ]")));
            MulticastMessage message = MulticastMessage.builder().setNotification(Notification.builder().setTitle(shortMessage.getSubject()).setBody(shortMessage.getBody()).build()).setAndroidConfig(AndroidConfig.builder().setNotification(AndroidNotification.builder().setSound("default").build()).build()).setApnsConfig(ApnsConfig.builder().setAps(Aps.builder().setSound("default").build()).build()).addAllTokens(registrationTokens).putData("eventId", String.valueOf(event.getId())).build();
            try {
                BatchResponse result = FirebaseMessaging.getInstance().sendMulticast(message);
                LinkedList<String> failedTokens = new LinkedList<String>();
                ListIterator iterator = result.getResponses().listIterator();
                while (iterator.hasNext()) {
                    int index = iterator.nextIndex();
                    SendResponse response = (SendResponse)iterator.next();
                    if (response.isSuccessful()) continue;
                    MessagingErrorCode error = response.getException().getMessagingErrorCode();
                    if (error == MessagingErrorCode.INVALID_ARGUMENT || error == MessagingErrorCode.UNREGISTERED) {
                        failedTokens.add((String)registrationTokens.get(index));
                    }
                    LOGGER.warn("Firebase user {} error", (Object)user.getId(), (Object)response.getException());
                }
                if (!failedTokens.isEmpty()) {
                    registrationTokens.removeAll(failedTokens);
                    if (registrationTokens.isEmpty()) {
                        user.getAttributes().remove("notificationTokens");
                    } else {
                        user.set("notificationTokens", String.join((CharSequence)",", registrationTokens));
                    }
                    this.storage.updateObject(user, new Request((Columns)new Columns.Include("attributes"), new Condition.Equals("id", user.getId())));
                    this.cacheManager.updateOrInvalidate(true, user);
                }
            }
            catch (FirebaseMessagingException | StorageException e) {
                LOGGER.warn("Firebase error", e);
            }
        }
    }
}

