/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.helper.BitUtil;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static int readSignedMagnitudeInt(ByteBuf buffer) {
        long value = buffer.readUnsignedInt();
        int result = (int)BitUtil.to(value, 31);
        return BitUtil.check(value, 31) ? -result : result;
    }

    public static int indexOf(ByteBuf buffer, int fromIndex, int toIndex, byte value, int count) {
        int startIndex = fromIndex;
        for (int i = 0; i < count; ++i) {
            int result = buffer.indexOf(startIndex, toIndex, value);
            if (result < 0 || i == count - 1) {
                return result;
            }
            startIndex = result + 1;
        }
        return -1;
    }

    public static int indexOf(String needle, ByteBuf haystack) {
        return BufferUtil.indexOf(needle, haystack, haystack.readerIndex(), haystack.writerIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOf(String needle, ByteBuf haystack, int startIndex, int endIndex) {
        ByteBuf wrappedNeedle = Unpooled.wrappedBuffer((byte[])needle.getBytes(StandardCharsets.US_ASCII));
        try {
            int n = BufferUtil.indexOf(wrappedNeedle, haystack, startIndex, endIndex);
            return n;
        }
        finally {
            wrappedNeedle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOf(ByteBuf needle, ByteBuf haystack, int startIndex, int endIndex) {
        int originalReaderIndex = haystack.readerIndex();
        int originalWriterIndex = haystack.writerIndex();
        try {
            haystack.readerIndex(startIndex);
            haystack.writerIndex(endIndex);
            int n = ByteBufUtil.indexOf((ByteBuf)needle, (ByteBuf)haystack);
            return n;
        }
        finally {
            haystack.readerIndex(originalReaderIndex);
            haystack.writerIndex(originalWriterIndex);
        }
    }

    public static boolean isPrintable(ByteBuf buf, int length) {
        boolean printable = true;
        for (int i = 0; i < length; ++i) {
            byte b = buf.getByte(buf.readerIndex() + i);
            if (b >= 32 || b == 13 || b == 10) continue;
            printable = false;
            break;
        }
        return printable;
    }
}

