/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.apache.fop.layoutmgr.table.GridUnit;

public class CollapsingBorderModelEyeCatching
extends CollapsingBorderModel {
    public CommonBorderPaddingBackground.BorderInfo determineWinner(GridUnit currentGridUnit, GridUnit otherGridUnit, int side, int flags) {
        boolean vertical = this.isVerticalRelation(side);
        int otherSide = CollapsingBorderModelEyeCatching.getOtherSide(side);
        TableCell currentCell = currentGridUnit.getCell();
        TableCell otherCell = null;
        if (otherGridUnit != null) {
            otherCell = otherGridUnit.getCell();
        }
        TableRow currentRow = currentGridUnit.getRow();
        TableRow otherRow = null;
        if (vertical && otherCell != null) {
            otherRow = otherGridUnit.getRow();
        }
        TableBody currentBody = currentGridUnit.getBody();
        TableBody otherBody = null;
        if (otherRow != null) {
            otherBody = otherGridUnit.getBody();
        }
        TableColumn currentColumn = currentGridUnit.getColumn();
        TableColumn otherColumn = null;
        if (otherGridUnit != null) {
            otherColumn = otherGridUnit.getColumn();
        }
        Table table = currentGridUnit.getTable();
        CommonBorderPaddingBackground.BorderInfo[] current = new CommonBorderPaddingBackground.BorderInfo[6];
        CommonBorderPaddingBackground.BorderInfo[] other = new CommonBorderPaddingBackground.BorderInfo[6];
        current[0] = currentGridUnit.getOriginalBorderInfoForCell(side);
        if (otherGridUnit != null) {
            other[0] = otherGridUnit.getOriginalBorderInfoForCell(otherSide);
        }
        if (currentRow != null && (side == 0 || side == 1 || currentGridUnit.getFlag(0) && side == 2 || currentGridUnit.getFlag(1) && side == 3)) {
            current[1] = currentRow.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        if (otherRow != null) {
            other[1] = otherRow.getCommonBorderPaddingBackground().getBorderInfo(otherSide);
        }
        if (currentBody != null && (side == 0 && currentGridUnit.getFlag(3) || side == 1 && currentGridUnit.getFlag(4) || currentGridUnit.getFlag(0) && side == 2 || currentGridUnit.getFlag(1) && side == 3)) {
            current[2] = currentBody.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        if (otherGridUnit != null && otherBody != null && (otherSide == 0 && otherGridUnit.getFlag(3) || otherSide == 1 && otherGridUnit.getFlag(4))) {
            other[2] = otherBody.getCommonBorderPaddingBackground().getBorderInfo(otherSide);
        }
        if (side == 0 && otherGridUnit == null || side == 1 && otherGridUnit == null || side == 2 || side == 3) {
            current[3] = currentColumn.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        if (otherColumn != null) {
            other[3] = otherColumn.getCommonBorderPaddingBackground().getBorderInfo(otherSide);
        }
        if (otherGridUnit == null && (side == 0 && (flags & 1) > 0 || side == 1 && (flags & 1) > 0 || side == 2 || side == 3)) {
            current[5] = table.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        CommonBorderPaddingBackground.BorderInfo resolved = null;
        resolved = this.doRule1(current, other);
        if (resolved != null) {
            return resolved;
        }
        if (!this.doRule2(current, other)) {
            // empty if block
        }
        if ((resolved = this.doRule3(current, other)) != null) {
            return resolved;
        }
        resolved = this.doRule4(current, other);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.doRule5(current, other);
        if (resolved != null) {
            return resolved;
        }
        return null;
    }

    private CommonBorderPaddingBackground.BorderInfo doRule1(CommonBorderPaddingBackground.BorderInfo[] current, CommonBorderPaddingBackground.BorderInfo[] other) {
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != null && current[i].getStyle() == 57) {
                return current[i];
            }
            if (other[i] == null || other[i].getStyle() != 57) continue;
            return other[i];
        }
        return null;
    }

    private boolean doRule2(CommonBorderPaddingBackground.BorderInfo[] current, CommonBorderPaddingBackground.BorderInfo[] other) {
        boolean found = false;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != null && current[i].getStyle() != 95) {
                found = true;
                break;
            }
            if (other[i] == null || other[i].getStyle() == 95) continue;
            found = true;
            break;
        }
        return found;
    }

    private CommonBorderPaddingBackground.BorderInfo doRule3(CommonBorderPaddingBackground.BorderInfo[] current, CommonBorderPaddingBackground.BorderInfo[] other) {
        int width = 0;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != null && current[i].getRetainedWidth() > width) {
                width = current[i].getRetainedWidth();
            }
            if (other[i] == null || other[i].getRetainedWidth() <= width) continue;
            width = other[i].getRetainedWidth();
        }
        CommonBorderPaddingBackground.BorderInfo widest = null;
        int count = 0;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != null && current[i].getRetainedWidth() == width) {
                ++count;
                if (widest == null) {
                    widest = current[i];
                }
            } else {
                current[i] = null;
            }
            if (other[i] != null && other[i].getRetainedWidth() == width) {
                ++count;
                if (widest != null) continue;
                widest = other[i];
                continue;
            }
            other[i] = null;
        }
        if (count == 1) {
            return widest;
        }
        return null;
    }

    private CommonBorderPaddingBackground.BorderInfo doRule4(CommonBorderPaddingBackground.BorderInfo[] current, CommonBorderPaddingBackground.BorderInfo[] other) {
        int pref = this.getPreferenceValue(67);
        for (int i = 0; i < current.length; ++i) {
            int currPref;
            if (current[i] != null && (currPref = this.getPreferenceValue(current[i].getStyle())) > pref) {
                pref = currPref;
            }
            if (other[i] == null || (currPref = this.getPreferenceValue(other[i].getStyle())) <= pref) continue;
            pref = currPref;
        }
        CommonBorderPaddingBackground.BorderInfo preferred = null;
        int count = 0;
        for (int i = 0; i < current.length; ++i) {
            int currPref;
            if (current[i] != null) {
                currPref = this.getPreferenceValue(current[i].getStyle());
                if (currPref == pref) {
                    ++count;
                    if (preferred != null) break;
                    preferred = current[i];
                    break;
                }
            } else {
                current[i] = null;
            }
            if (other[i] != null) {
                currPref = this.getPreferenceValue(other[i].getStyle());
                if (currPref != pref) continue;
                ++count;
                if (preferred != null) break;
                preferred = other[i];
                break;
            }
            other[i] = null;
        }
        if (count == 1) {
            return preferred;
        }
        return null;
    }

    private CommonBorderPaddingBackground.BorderInfo doRule5(CommonBorderPaddingBackground.BorderInfo[] current, CommonBorderPaddingBackground.BorderInfo[] other) {
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != null) {
                return current[i];
            }
            if (other[i] == null) continue;
            return other[i];
        }
        return null;
    }
}

