# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Rules(VapiInterface):
    """
    
    """
    REVISE_OPERATION_TOP = "insert_top"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_BOTTOM = "insert_bottom"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_AFTER = "insert_after"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """
    REVISE_OPERATION_BEFORE = "insert_before"
    """
    Possible value for ``operation`` of method :func:`Rules.revise`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.rules'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RulesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               org_id,
               project_id,
               domain_id,
               security_policy_id,
               rule_id,
               ):
        """
        Delete rule

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'rule_id': rule_id,
                            })

    def get(self,
            org_id,
            project_id,
            domain_id,
            security_policy_id,
            rule_id,
            ):
        """
        Read rule

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Rule`
        :return: com.vmware.nsx_policy.model.Rule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'rule_id': rule_id,
                            })

    def list(self,
             org_id,
             project_id,
             domain_id,
             security_policy_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List rules

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.RuleListResult`
        :return: com.vmware.nsx_policy.model.RuleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              org_id,
              project_id,
              domain_id,
              security_policy_id,
              rule_id,
              rule,
              ):
        """
        Patch the rule. If Rule corresponding to the the given rule-id is not
        present, the object will get created and if it is present it will be
        updated. This is a full replace. Performance Note: If you want to edit
        several rules in a security policy, prefer below mentioned API for
        optimal performance. Pass all the rules which you wish to edit as
        embedded rules to it. Use this API - PATCH (or PUT)
        /infra/domains/<domain-id>/security-policies/<security-policy-id>

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :type  rule: :class:`com.vmware.nsx_policy.model_client.Rule`
        :param rule: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'rule_id': rule_id,
                            'rule': rule,
                            })

    def revise(self,
               org_id,
               project_id,
               domain_id,
               security_policy_id,
               rule_id,
               rule,
               anchor_path=None,
               operation=None,
               ):
        """
        This is used to re-order a rule within a security policy.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :type  rule: :class:`com.vmware.nsx_policy.model_client.Rule`
        :param rule: (required)
        :type  anchor_path: :class:`str` or ``None``
        :param anchor_path: The security policy/rule path if operation is 'insert_after' or
            'insert_before' (optional)
        :type  operation: :class:`str` or ``None``
        :param operation: Operation (optional, default to insert_top)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Rule`
        :return: com.vmware.nsx_policy.model.Rule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('revise',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'rule_id': rule_id,
                            'rule': rule,
                            'anchor_path': anchor_path,
                            'operation': operation,
                            })

    def update(self,
               org_id,
               project_id,
               domain_id,
               security_policy_id,
               rule_id,
               rule,
               ):
        """
        Update the rule. Create new rule if a rule with the rule-id is not
        already present. Performance Note: If you wish to edit several rules in
        a security policy, prefer below mentioned API for optimal performance.
        Pass all the rules which you wish to edit as embedded rules to it. Use
        this API - PATCH (or PUT)
        /infra/domains/<domain-id>/security-policies/<security-policy-id>

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: (required)
        :type  rule_id: :class:`str`
        :param rule_id: (required)
        :type  rule: :class:`com.vmware.nsx_policy.model_client.Rule`
        :param rule: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Rule`
        :return: com.vmware.nsx_policy.model.Rule
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'rule_id': rule_id,
                            'rule': rule,
                            })
class Statistics(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             org_id,
             project_id,
             domain_id,
             security_policy_id,
             container_cluster_path=None,
             enforcement_point_path=None,
             ):
        """
        Get statistics of a security policy. - no enforcement point path
        specified: Stats will be evaluated on each enforcement point. -
        {enforcement_point_path}: Stats are evaluated only on the given
        enforcement point.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  domain_id: :class:`str`
        :param domain_id: Domain id (required)
        :type  security_policy_id: :class:`str`
        :param security_policy_id: Security policy id (required)
        :type  container_cluster_path: :class:`str` or ``None``
        :param container_cluster_path: String Path of the Container Cluster entity (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SecurityPolicyStatisticsListResult`
        :return: com.vmware.nsx_policy.model.SecurityPolicyStatisticsListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'domain_id': domain_id,
                            'security_policy_id': security_policy_id,
                            'container_cluster_path': container_cluster_path,
                            'enforcement_point_path': enforcement_point_path,
                            })
class _RulesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'rule_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules/{rule-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'rule_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules/{rule-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'rule_id': type.StringType(),
            'rule': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules/{rule-id}',
            request_body_parameter='rule',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for revise operation
        revise_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'rule_id': type.StringType(),
            'rule': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
            'anchor_path': type.OptionalType(type.StringType()),
            'operation': type.OptionalType(type.StringType()),
        })
        revise_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        revise_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        revise_output_validator_list = [
            HasFieldsOfValidator()
        ]
        revise_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules/{rule-id}?action=revise',
            request_body_parameter='rule',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                             },
            query_parameters={
                'anchor_path': 'anchor_path',
                'operation': 'operation',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'rule_id': type.StringType(),
            'rule': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/rules/{rule-id}',
            request_body_parameter='rule',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
                'rule_id': 'rule-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'RuleListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'revise': {
                'input_type': revise_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
                'errors': revise_error_dict,
                'input_value_validator_list': revise_input_value_validator_list,
                'output_validator_list': revise_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Rule'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'revise': revise_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.rules',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'domain_id': type.StringType(),
            'security_policy_id': type.StringType(),
            'container_cluster_path': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra/domains/{domain-id}/security-policies/{security-policy-id}/statistics',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'domain_id': 'domain-id',
                'security_policy_id': 'security-policy-id',
            },
             header_parameters={
                         },
            query_parameters={
                'container_cluster_path': 'container_cluster_path',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'SecurityPolicyStatisticsListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Rules': Rules,
        'Statistics': Statistics,
        'rules': 'com.vmware.nsx_policy.orgs.projects.infra.domains.security_policies.rules_client.StubFactory',
    }

