# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.node.aaa.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class AuthPolicy(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.node.aaa.auth_policy'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AuthPolicyStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Returns information about the currently configured authentication
        policies and password complexity on the node.


        :rtype: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :return: com.vmware.nsx.model.AuthenticationPolicyProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def resetall(self):
        """
        Resets to default, currently configured authentication policy and
        password complexity on the node. Administrators need to enforce
        password change for existing user accounts in order to match newly
        configured complexity requirements in system. 
        
        **reset-all**: resets configured Authentication policy and Password
        complexity 
        
        **reset-auth-policies**: resets only configured Authentication policy
        *includes - {api_failed_auth_lockout_period,
        api_failed_auth_reset_period, api_max_auth_failures,
        cli_failed_auth_lockout_period, cli_max_auth_failures}* 
        
        **reset-pwd-complexity**: resets only configured Password complexity


        :rtype: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :return: com.vmware.nsx.model.AuthenticationPolicyProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('resetall', None)

    def resetauthpolicies(self):
        """
        Resets to default, currently configured authentication policy and
        password complexity on the node. Administrators need to enforce
        password change for existing user accounts in order to match newly
        configured complexity requirements in system. 
        
        **reset-all**: resets configured Authentication policy and Password
        complexity 
        
        **reset-auth-policies**: resets only configured Authentication policy
        *includes - {api_failed_auth_lockout_period,
        api_failed_auth_reset_period, api_max_auth_failures,
        cli_failed_auth_lockout_period, cli_max_auth_failures}* 
        
        **reset-pwd-complexity**: resets only configured Password complexity


        :rtype: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :return: com.vmware.nsx.model.AuthenticationPolicyProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('resetauthpolicies', None)

    def resetpwdcomplexity(self):
        """
        Resets to default, currently configured authentication policy and
        password complexity on the node. Administrators need to enforce
        password change for existing user accounts in order to match newly
        configured complexity requirements in system. 
        
        **reset-all**: resets configured Authentication policy and Password
        complexity 
        
        **reset-auth-policies**: resets only configured Authentication policy
        *includes - {api_failed_auth_lockout_period,
        api_failed_auth_reset_period, api_max_auth_failures,
        cli_failed_auth_lockout_period, cli_max_auth_failures}* 
        
        **reset-pwd-complexity**: resets only configured Password complexity


        :rtype: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :return: com.vmware.nsx.model.AuthenticationPolicyProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('resetpwdcomplexity', None)

    def update(self,
               authentication_policy_properties,
               ):
        """
        Update the currently configured authentication policy and password
        complexity on the node. If any of api_max_auth_failures,
        api_failed_auth_reset_period, or api_failed_auth_lockout_period are
        modified, the http service is automatically restarted. Whereas change
        in any password complexity will not be applicable on already configured
        user passwords. Administrators need to enforce password change for
        existing user accounts in order to match newly configured complexity
        requirements enforced in system. All values from
        AuthenticationPolicyProperties are in sync among the management cluster
        nodes.

        :type  authentication_policy_properties: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :param authentication_policy_properties: (required)
        :rtype: :class:`com.vmware.nsx.model_client.AuthenticationPolicyProperties`
        :return: com.vmware.nsx.model.AuthenticationPolicyProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'authentication_policy_properties': authentication_policy_properties,
                            })
class _AuthPolicyStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/node/aaa/auth-policy',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for resetall operation
        resetall_input_type = type.StructType('operation-input', {})
        resetall_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        resetall_input_value_validator_list = [
        ]
        resetall_output_validator_list = [
        ]
        resetall_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/node/aaa/auth-policy?action=reset-all',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for resetauthpolicies operation
        resetauthpolicies_input_type = type.StructType('operation-input', {})
        resetauthpolicies_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        resetauthpolicies_input_value_validator_list = [
        ]
        resetauthpolicies_output_validator_list = [
        ]
        resetauthpolicies_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/node/aaa/auth-policy?action=reset-auth-policies',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for resetpwdcomplexity operation
        resetpwdcomplexity_input_type = type.StructType('operation-input', {})
        resetpwdcomplexity_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        resetpwdcomplexity_input_value_validator_list = [
        ]
        resetpwdcomplexity_output_validator_list = [
        ]
        resetpwdcomplexity_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/node/aaa/auth-policy?action=reset-pwd-complexity',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'authentication_policy_properties': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/node/aaa/auth-policy',
            request_body_parameter='authentication_policy_properties',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'resetall': {
                'input_type': resetall_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
                'errors': resetall_error_dict,
                'input_value_validator_list': resetall_input_value_validator_list,
                'output_validator_list': resetall_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'resetauthpolicies': {
                'input_type': resetauthpolicies_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
                'errors': resetauthpolicies_error_dict,
                'input_value_validator_list': resetauthpolicies_input_value_validator_list,
                'output_validator_list': resetauthpolicies_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'resetpwdcomplexity': {
                'input_type': resetpwdcomplexity_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
                'errors': resetpwdcomplexity_error_dict,
                'input_value_validator_list': resetpwdcomplexity_input_value_validator_list,
                'output_validator_list': resetpwdcomplexity_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'AuthenticationPolicyProperties'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'resetall': resetall_rest_metadata,
            'resetauthpolicies': resetauthpolicies_rest_metadata,
            'resetpwdcomplexity': resetpwdcomplexity_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.node.aaa.auth_policy',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'AuthPolicy': AuthPolicy,
        'providers': 'com.vmware.nsx.node.aaa.providers_client.StubFactory',
    }

