# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.migration.vmgroup.actions.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class GetVmGroupExecutionDetails(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.migration.vmgroup.actions.get_vm_group_execution_details'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GetVmGroupExecutionDetailsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             group_id,
             federation_site_id=None,
             ):
        """
        The result includes a
        \"logical_switch_id_to_vm_instance_id_and_vnics_map\" list and an
        optional \"failedVmInstanceIds\" list which includes the uuids of VMs
        that are not found in the source VC. Construct a map of vmInstanceUuid
        to (vnic, ls_id) from the
        \"logical_switch_id_to_vm_instance_id_and_vnics_map\", then use the map
        to populate the relocate spec of each VM and migrate the VM as below:
        The VM object can be found in source VC by the vmInstanceUuid using VC
        API serviceinstance.content.searchIndex.FindByUuid(uuid=vmInstanceUuid,
        vmSearch=True, instanceUuid=True) For each VM vNIC, if the device key
        \"vnic\" is not found in the map of vmInstanceUuid to (vnic, ls_id),
        then skip the vNIC. Otherwise form a VIF-id for the vNIC by
        vmInstanceUuid + ':' + str(vnic), e.g.
        \"52630e5d-ce6f-fac0-424c-4aa4bdf6bd56:4001\", and use it to setup the
        vNIC's network backing. For VDS6.x migration, opaque-network backing in
        NVDS will be used; setup the vNIC device as below: - vdevice.backing =
        vim.vm.device.VirtualEthernetCard.OpaqueNetworkBackingInfo() -
        vdevice.backing.opaqueNetworkId = ls_id -
        vdevice.backing.opaqueNetworkType = 'nsx.LogicalSwitch' -
        vdevice.externalId = VIF-id For VDS 7.0 and later versions, \"nsx\"
        LogicalSwitch backing in VDS will be used. Go through all VDS DVPGs in
        the target VC to find each DVPG whose config.backingType is \"nsx\" and
        config.logicalSwitchUuid is not blank, build a map of
        dvpg.config.logicalSwitchUuid to [dvpg.key,
        dvpg.config.distributedVirtualSwitch.uuid] once. For each vNIC device,
        get the dvpg value from the map by the ls_id and then set it up as
        below: - vdsPgConn = vim.dvs.PortConnection() - vdsPgConn.portgroupKey
        = dvpg.key - vdsPgConn.switchUuid =
        dvpg.config.distributedVirtualSwitch.uuid - vdevice.backing =
        vim.vm.device.VirtualEthernetCard.DistributedVirtualPortBackingInfo() -
        vdevice.backing.port = vdsPgConn - vdevice.externalId = VIF-id

        :type  group_id: :class:`str`
        :param group_id: User defined VM group ID (required)
        :type  federation_site_id: :class:`str` or ``None``
        :param federation_site_id: ID of the site in NSX-T Federation (optional)
        :rtype: :class:`com.vmware.nsx.model_client.VmGroupExecutionDetails`
        :return: com.vmware.nsx.model.VmGroupExecutionDetails
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'group_id': group_id,
                            'federation_site_id': federation_site_id,
                            })
class _GetVmGroupExecutionDetailsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'group_id': type.StringType(),
            'federation_site_id': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/migration/vmgroup/actions/get_vm_group_execution_details',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'group_id': 'group_id',
                'federation_site_id': 'federation_site_id',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'VmGroupExecutionDetails'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.migration.vmgroup.actions.get_vm_group_execution_details',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'GetVmGroupExecutionDetails': GetVmGroupExecutionDetails,
    }

