%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/rhythmic-slashes.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.21.2"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
@qq{シンプルな} リード シートでは、実際の音符を書かずに、代わりに@c
@qq{リズム パターン} とコード ネームのみを書き、曲の構造を示すことがあります。@c
これは、@c
曲の構造だけを作成あるいは転写する際や、リード シートをギタリストやジャズ
ミュージシャンに共有する際などに有用です。@c
これを実現するために @code{\\repeat percent} を用いるのは不適切です。@c
@code{\\repeat percent} では、@c
最初の音符や休符として何かを指定しなければならないからです。@c
次の例では 2 つの解決法を示しています。どちらも通常の休符をスラッシュとして@c
表示するものです。(拍の長さを 4 分音符から変えたい場合は、定義中にある
@code{r4} を適切に変更してください。)

"
  doctitleja = "リズム スラッシュ"

%% Translation of GIT committish: 207d558daf542af3b09157662deb8a68731d4f41
  texidocfr = "
Il arrive, dans une feuille de chant « simple », que les notes soient
remplacées par une « pulsation » et que la structure de la chanson soit
indiquée par les accords au-dessus des mesures. Ceci peut être utile
lorsque l'on crée ou retranscrit la structure d'une chanson, ainsi que
pour donner au guitariste et musiciens de jazz une pseudo partition.

Le fonctionnement standard d'un @code{\\repeat percent} n'est pas ici
applicable puisque le premier temps doit être une note ou un silence.

Le code ci-dessous propose deux alternatives à ce problème en
redéfinissant l'aspect d'un silence. Si la durée d'un temps ne
correspond pas à la noire, le @code{r4} inclus dans la définition devra
être remplacé par un silence de durée appropriée.

"
  doctitlefr = "Barres rythmiques"

%% Translation of GIT committish: 00f0ca84dbb015617f8ce36dd13db59bbfef8f11
  texidoces = "
En las hojas guía de acordes o lead-sheets @qq{sencillas}, a veces no
se imprime realmente ninguna nota, y en su lugar se hace una notación
que tiene solamente @qq{patrones rítmicos} y acordes encima de los
compases, dando la estructura de la canción song. Tal funcionalidad es
útil, por ejemplo, al crear o transcribir la estructura de una canción
y también si se quieren compartir las hojas guía con guitarristas o
músicos de jazz.  La forma estándar en que está contemplada esta
funcionalidad empleando @code{\\repeat percent} no es adecuada aquí
porque el primer compás tendría que ser una nota o silencio normales.
Este ejemplo muestra dos soluciones al problema, redefiniendo los
silencios normales para que se impriman como barras inclinadas (si la
duración de cada pulso no es una negra, sustituiremos el @code{r4} que
aparece en las definiciones con un silencio de la duración adecuada).

"
  doctitlees = "Barras rítmicas"

  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
In @qq{simple} lead-sheets, sometimes no actual notes are written,
instead only @qq{rhythmic patterns} and chords above the measures are
notated giving the structure of a song. Such a feature is for example
useful while creating/transcribing the structure of a song and also
when sharing lead sheets with guitarists or jazz musicians.

The standard support for this using @code{\\repeat percent} is
unsuitable here since the first beat has to be an ordinary note or
rest.

This example shows two solutions to this problem, by redefining
ordinary rests to be printed as slashes. (If the duration of each beat
is not a quarter note, replace the @code{r4} in the definitions with a
rest of the appropriate duration).

"
  doctitle = "Rhythmic slashes"
} % begin verbatim

% Macro to print single slash
rs = {
  \once \override Rest.stencil = #ly:percent-repeat-item-interface::beat-slash
  \once \override Rest.thickness = #0.48
  \once \override Rest.slope = #1.7
  r4
}

% Function to print a specified number of slashes
comp = #(define-music-function (count) (integer?)
  #{
    \override Rest.stencil = #ly:percent-repeat-item-interface::beat-slash
    \override Rest.thickness = #0.48
    \override Rest.slope = #1.7
    \repeat unfold $count { r4 }
    \revert Rest.stencil
  #}
)

\score {
  \relative c' {
    c4 d e f |
    \rs \rs \rs \rs |
    \comp #4 |
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
