/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public final class ClassType
extends Type {
    public static final ClassType OBJECT_TYPE = new ClassType(DotName.OBJECT_NAME);

    public static ClassType create(DotName name) {
        return new ClassType(name);
    }

    public static ClassType create(String name) {
        return ClassType.create(DotName.createSimple(name));
    }

    public static ClassType create(Class<?> clazz) {
        return ClassType.create(DotName.createSimple(clazz.getName()));
    }

    public static Builder builder(DotName name) {
        return new Builder(name);
    }

    public static Builder builder(Class<?> clazz) {
        return ClassType.builder(DotName.createSimple(clazz.getName()));
    }

    ClassType(DotName name) {
        this(name, null);
    }

    ClassType(DotName name, AnnotationInstance[] annotations) {
        super(name, annotations);
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.CLASS;
    }

    @Override
    public ClassType asClassType() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new ClassType(this.name(), newAnnotations);
    }

    ParameterizedType toParameterizedType() {
        return new ParameterizedType(this.name(), null, null, this.annotationArray());
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        Builder(DotName name) {
            super(name);
        }

        public ClassType build() {
            return new ClassType(this.name, this.annotationsArray());
        }
    }
}

