/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.stream.Stream;

public class ClassLoaderUtil {
    public static ClassLoader resolveClassLoader(String libDir) {
        String[] stringArray;
        File[] jarsInDir = new File(libDir).listFiles(file -> file.getName().endsWith(".jar"));
        boolean bcFipsJarPresent = Stream.of(jarsInDir).anyMatch(file -> file.getName().startsWith("bc-fips"));
        if (bcFipsJarPresent) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "keycloak-crypto-fips1402";
            stringArray2[1] = "bc-fips";
            stringArray = stringArray2;
            stringArray2[2] = "bctls-fips";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "keycloak-crypto-default";
            stringArray = stringArray3;
            stringArray3[1] = "bcprov-jdk18on";
        }
        String[] validJarPrefixes = stringArray;
        URL[] usedJars = (URL[])Stream.of(jarsInDir).filter(file -> {
            for (String prefix : validJarPrefixes) {
                if (!file.getName().startsWith(prefix + "-")) continue;
                return true;
            }
            return false;
        }).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Error when converting file into URL. Please check the files in the directory " + jarsInDir, ex);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(usedJars, ClassLoaderUtil.class.getClassLoader());
    }
}

