/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.yaml;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

class RunOnlyOnce
implements Runnable {
    private final AtomicBoolean ran = new AtomicBoolean(false);
    private final Runnable preTask;
    private final Runnable postTask;

    public RunOnlyOnce(Runnable preTask, Runnable postTask) {
        this.preTask = preTask;
        this.postTask = postTask;
    }

    @Override
    public void run() {
        if (this.ran.compareAndSet(false, true) && this.preTask != null) {
            this.preTask.run();
        }
    }

    public void runPostTask() {
        if (this.hasRun() && this.postTask != null) {
            this.postTask.run();
        }
    }

    public boolean hasRun() {
        return this.ran.get();
    }

    public String toString() {
        return "RunOnlyOnce" + (this.hasRun() ? " - ran already" : "") + " " + this.preTask;
    }

    static class List
    extends LinkedList<RunOnlyOnce> {
        List() {
        }

        @Override
        public RunOnlyOnce removeLast() {
            RunOnlyOnce res = (RunOnlyOnce)super.removeLast();
            res.runPostTask();
            return res;
        }
    }
}

