/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.singleUseObject.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.singleUseObject.entity.JpaSingleUseObjectMetadata;
import org.keycloak.models.map.storage.jpa.singleUseObject.entity.JpaSingleUseObjectNoteEntity;

@Entity
@Table(name="kc_single_use_obj")
@EnhancementInfo(version="6.2.7.Final")
public class JpaSingleUseObjectEntity
extends MapSingleUseObjectEntity.AbstractSingleUseObjectEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaSingleUseObjectMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String objectKey;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Long expiration;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaSingleUseObjectNoteEntity> notes = new HashSet<JpaSingleUseObjectNoteEntity>();
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaSingleUseObjectEntity() {
        this.metadata = new JpaSingleUseObjectMetadata();
    }

    public JpaSingleUseObjectEntity(DeepCloner cloner) {
        this.metadata = new JpaSingleUseObjectMetadata(cloner);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getObjectKey() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getObjectKey();
        }
        return this.$$_hibernate_read_objectKey();
    }

    public void setObjectKey(String objectKey) {
        this.$$_hibernate_read_metadata().setObjectKey(objectKey);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_SINGLE_USE_OBJECT;
    }

    public Map<String, String> getNotes() {
        return this.$$_hibernate_read_notes().stream().collect(Collectors.toMap(JpaAttributeEntity::getName, JpaAttributeEntity::getValue));
    }

    public String getNote(String name) {
        return this.$$_hibernate_read_notes().stream().filter(note -> Objects.equals(note.getName(), name)).findFirst().map(JpaAttributeEntity::getValue).orElse(null);
    }

    public void setNotes(Map<String, String> notes) {
        this.$$_hibernate_read_notes().clear();
        if (notes != null) {
            notes.forEach(this::setNote);
        }
    }

    public void setNote(String name, String value) {
        if (name != null) {
            this.$$_hibernate_read_notes().removeIf(note -> Objects.equals(note.getName(), name));
            if (value != null && !value.trim().isEmpty()) {
                this.$$_hibernate_read_notes().add(new JpaSingleUseObjectNoteEntity(this, name, value));
            }
        }
    }

    public Long getExpiration() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getExpiration();
        }
        return this.$$_hibernate_read_expiration();
    }

    public void setExpiration(Long expiration) {
        this.$$_hibernate_read_metadata().setExpiration(expiration);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaSingleUseObjectEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaSingleUseObjectEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaSingleUseObjectMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaSingleUseObjectMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_objectKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.objectKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "objectKey", (Object)this.objectKey);
        }
        return this.objectKey;
    }

    public void $$_hibernate_write_objectKey(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.objectKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "objectKey", (Object)this.objectKey, (Object)string);
            return;
        }
        this.objectKey = string;
    }

    public Long $$_hibernate_read_expiration() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expiration = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "expiration", (Object)this.expiration);
        }
        return this.expiration;
    }

    public void $$_hibernate_write_expiration(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expiration = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "expiration", (Object)this.expiration, (Object)l);
            return;
        }
        this.expiration = l;
    }

    public Set $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", this.notes);
        }
        return this.notes;
    }
}

