/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class DeleteRelationsAction
extends AbstractRelationAction {
    public DeleteRelationsAction() {
        this.putValue("ShortDescription", I18n.tr("Delete the selected relation", new Object[0]));
        this.putValue("Name", I18n.tr("Delete", new Object[0]));
        new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
    }

    protected void deleteRelation(Collection<Relation> toDelete) {
        OsmDataLayer layer = MainApplication.getLayerManager().getEditLayer();
        if (toDelete == null || layer == null) {
            return;
        }
        DeleteAction.deleteRelations(layer, toDelete);
        MapFrame map = MainApplication.getMap();
        if (map.relationListDialog != null) {
            map.relationListDialog.selectRelations(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.deleteRelation(Utils.filteredCollection(this.relations, Relation.class));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(OsmUtils.isOsmCollectionEditable(this.relations));
    }
}

