/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.dsi.SpeakerRanking;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointConnectionStatusMonitor;
import org.jitsi.videobridge.LoudestConfig;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.colibri2.Colibri2ConferenceHandler;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.DominantSpeakerMessage;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;

public class Conference
implements AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler {
    private final ConcurrentHashMap<String, AbstractEndpoint> endpointsById = new ConcurrentHashMap();
    private final boolean isRtcStatsEnabled;
    private List<Endpoint> endpointsCache = Collections.emptyList();
    private final Object endpointsCacheLock = new Object();
    private ConcurrentHashMap<Long, AbstractEndpoint> endpointsBySsrc = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Relay> relaysById = new ConcurrentHashMap();
    private final AtomicBoolean expired = new AtomicBoolean(false);
    private final long localAudioSsrc = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
    private final long localVideoSsrc = Videobridge.RANDOM.nextLong() & 0xFFFFFFFFL;
    private final String id;
    @Nullable
    private final EntityBareJid conferenceName;
    private final ConferenceSpeechActivity speechActivity;
    private final Videobridge videobridge;
    private final Statistics statistics = new Statistics();
    private final Logger logger;
    private final long creationTime = System.currentTimeMillis();
    @NotNull
    private final Colibri2ConferenceHandler colibri2Handler;
    @NotNull
    private final PacketQueue<XmppConnection.ColibriRequest> colibriQueue;
    @NotNull
    private final EncodingsManager encodingsManager = new EncodingsManager();
    private ScheduledFuture<?> updateLastNEndpointsFuture;
    @NotNull
    private final EndpointConnectionStatusMonitor epConnectionStatusMonitor;
    @Nullable
    private final String meetingId;
    private static final Pattern uuidTrimmer = Pattern.compile("(\\p{XDigit}{8})[\\p{XDigit}-]*");

    public long getLocalAudioSsrc() {
        return this.localAudioSsrc;
    }

    public long getLocalVideoSsrc() {
        return this.localVideoSsrc;
    }

    public Conference(Videobridge videobridge, String id, @Nullable EntityBareJid conferenceName, @Nullable String meetingId, boolean isRtcStatsEnabled) {
        this.meetingId = meetingId;
        this.videobridge = Objects.requireNonNull(videobridge, "videobridge");
        this.isRtcStatsEnabled = isRtcStatsEnabled;
        HashMap<String, String> context = new HashMap<String, String>(Map.of("confId", id));
        if (conferenceName != null) {
            context.put("conf_name", conferenceName.toString());
        }
        if (meetingId != null) {
            context.put("meeting_id", uuidTrimmer.matcher(meetingId).replaceAll("$1"));
        }
        this.logger = new LoggerImpl(Conference.class.getName(), new LogContext(context));
        this.id = Objects.requireNonNull(id, "id");
        this.conferenceName = conferenceName;
        this.colibri2Handler = new Colibri2ConferenceHandler(this, this.logger);
        this.colibriQueue = new PacketQueue<XmppConnection.ColibriRequest>(Integer.MAX_VALUE, true, "colibri-queue", request -> {
            try {
                long start = System.currentTimeMillis();
                Pair<IQ, Boolean> p = this.colibri2Handler.handleConferenceModifyIQ(request.getRequest());
                IQ response2 = p.getFirst();
                boolean expire = p.getSecond();
                long end = System.currentTimeMillis();
                long processingDelay = end - start;
                long totalDelay = end - request.getReceiveTime();
                request.getProcessingDelayStats().addDelay(processingDelay);
                request.getTotalDelayStats().addDelay(totalDelay);
                if (processingDelay > 100L) {
                    this.logger.warn("Took " + processingDelay + " ms to process an IQ (total delay " + totalDelay + " ms): " + request.getRequest().toXML());
                }
                request.getCallback().invoke(response2);
                if (expire) {
                    videobridge.expireConference(this);
                }
            }
            catch (Throwable e) {
                this.logger.warn("Failed to handle colibri request: ", e);
                request.getCallback().invoke(ErrorUtilKt.createError(request.getRequest(), StanzaError.Condition.internal_server_error, e.getMessage()));
            }
            return true;
        }, TaskPools.IO_POOL, Clock.systemUTC(), false);
        this.speechActivity = new ConferenceSpeechActivity(new SpeechActivityListener());
        this.updateLastNEndpointsFuture = TaskPools.SCHEDULED_POOL.scheduleAtFixedRate(() -> {
            try {
                if (this.speechActivity.updateLastNEndpoints()) {
                    this.lastNEndpointsChangedAsync();
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to update lastN endpoints:", e);
            }
        }, 3L, 3L, TimeUnit.SECONDS);
        Videobridge.Statistics videobridgeStatistics = videobridge.getStatistics();
        videobridgeStatistics.conferencesCreated.inc();
        this.epConnectionStatusMonitor = new EndpointConnectionStatusMonitor(this, TaskPools.SCHEDULED_POOL, this.logger);
        this.epConnectionStatusMonitor.start();
    }

    public void enqueueColibriRequest(XmppConnection.ColibriRequest request) {
        this.colibriQueue.add(request);
    }

    public DiagnosticContext newDiagnosticContext() {
        if (this.conferenceName != null) {
            DiagnosticContext diagnosticContext = new DiagnosticContext();
            diagnosticContext.put("conf_name", this.conferenceName.toString());
            diagnosticContext.put("conf_creation_time_ms", this.creationTime);
            return diagnosticContext;
        }
        return new NoOpDiagnosticContext();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void sendMessage(BridgeChannelMessage msg, List<Endpoint> endpoints, boolean sendToRelays) {
        for (Endpoint endpoint : endpoints) {
            endpoint.sendMessage(msg);
        }
        if (sendToRelays) {
            for (Relay relay : this.relaysById.values()) {
                relay.sendMessage(msg);
            }
        }
    }

    public void sendMessageFromRelay(BridgeChannelMessage msg, boolean sendToEndpoints, @Nullable String meshId) {
        if (sendToEndpoints) {
            for (Endpoint endpoint : this.getLocalEndpoints()) {
                endpoint.sendMessage(msg);
            }
        }
        for (Relay relay : this.relaysById.values()) {
            if (Objects.equals(meshId, relay.getMeshId())) continue;
            relay.sendMessage(msg);
        }
    }

    public void broadcastMessage(BridgeChannelMessage msg, boolean sendToRelays) {
        this.sendMessage(msg, this.getLocalEndpoints(), sendToRelays);
    }

    public void broadcastMessage(BridgeChannelMessage msg) {
        this.broadcastMessage(msg, false);
    }

    public void requestKeyframe(String endpointID, long mediaSsrc) {
        AbstractEndpoint remoteEndpoint = this.getEndpoint(endpointID);
        if (remoteEndpoint != null) {
            remoteEndpoint.requestKeyframe(mediaSsrc);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot request keyframe because the endpoint was not found.");
        }
    }

    IQ handleConferenceModifyIQ(ConferenceModifyIQ conferenceModifyIQ) {
        Pair<IQ, Boolean> p = this.colibri2Handler.handleConferenceModifyIQ(conferenceModifyIQ);
        if (p.getSecond().booleanValue()) {
            this.videobridge.expireConference(this);
        }
        return p.getFirst();
    }

    private void lastNEndpointsChangedAsync() {
        TaskPools.IO_POOL.execute(() -> {
            try {
                this.lastNEndpointsChanged();
            }
            catch (Exception e) {
                this.logger.warn("Failed to handle change in last N endpoints: ", e);
            }
        });
    }

    private void lastNEndpointsChanged() {
        this.endpointsCache.forEach(Endpoint::lastNEndpointsChanged);
    }

    private void recentSpeakersChanged(List<AbstractEndpoint> recentSpeakers, boolean dominantSpeakerChanged, boolean silence) {
        if (!recentSpeakers.isEmpty()) {
            List<String> recentSpeakersIds = recentSpeakers.stream().map(AbstractEndpoint::getId).collect(Collectors.toList());
            this.logger.info("Recent speakers changed: " + recentSpeakersIds + ", dominant speaker changed: " + dominantSpeakerChanged + " silence:" + silence);
            this.broadcastMessage(new DominantSpeakerMessage(recentSpeakersIds, silence));
            if (dominantSpeakerChanged && !silence) {
                this.getVideobridge().getStatistics().dominantSpeakerChanges.inc();
                if (this.getEndpointCount() > 2) {
                    this.maybeSendKeyframeRequest(recentSpeakers.get(0));
                }
            }
        }
    }

    private void maybeSendKeyframeRequest(AbstractEndpoint dominantSpeaker) {
        if (dominantSpeaker == null) {
            return;
        }
        boolean anyEndpointInStageView = false;
        for (Endpoint otherEndpoint : this.getLocalEndpoints()) {
            if (otherEndpoint == dominantSpeaker || !otherEndpoint.isInStageView()) continue;
            anyEndpointInStageView = true;
            break;
        }
        if (!anyEndpointInStageView) {
            this.getVideobridge().getStatistics().preemptiveKeyframeRequestsSuppressed.inc();
            return;
        }
        this.getVideobridge().getStatistics().preemptiveKeyframeRequestsSent.inc();
        double senderRtt = this.getRtt(dominantSpeaker);
        double maxReceiveRtt = this.getMaxReceiverRtt(dominantSpeaker.getId());
        double keyframeDelay = maxReceiveRtt - senderRtt + 10.0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduling keyframe request from " + dominantSpeaker.getId() + " after a delay of " + keyframeDelay + "ms");
        }
        TaskPools.SCHEDULED_POOL.schedule(dominantSpeaker::requestKeyframe, (long)keyframeDelay, TimeUnit.MILLISECONDS);
    }

    private double getRtt(AbstractEndpoint endpoint) {
        if (endpoint instanceof Endpoint) {
            Endpoint localDominantSpeaker = (Endpoint)endpoint;
            return localDominantSpeaker.getRtt();
        }
        return 100.0;
    }

    private double getMaxReceiverRtt(String excludedEndpointId) {
        return this.endpointsCache.stream().filter(ep -> !ep.getId().equalsIgnoreCase(excludedEndpointId)).map(Endpoint::getRtt).mapToDouble(Double::valueOf).max().orElse(0.0);
    }

    void expire() {
        if (!this.expired.compareAndSet(false, true)) {
            return;
        }
        this.logger.info("Expiring.");
        this.colibriQueue.close();
        this.epConnectionStatusMonitor.stop();
        if (this.updateLastNEndpointsFuture != null) {
            this.updateLastNEndpointsFuture.cancel(true);
            this.updateLastNEndpointsFuture = null;
        }
        this.logger.debug(() -> "Expiring endpoints.");
        this.getEndpoints().forEach(AbstractEndpoint::expire);
        this.getRelays().forEach(Relay::expire);
        this.speechActivity.expire();
        this.updateStatisticsOnExpire();
    }

    private void updateStatisticsOnExpire() {
        long durationSeconds = Math.round((double)(System.currentTimeMillis() - this.creationTime) / 1000.0);
        Videobridge.Statistics videobridgeStatistics = this.getVideobridge().getStatistics();
        videobridgeStatistics.conferencesCompleted.incAndGet();
        videobridgeStatistics.totalConferenceSeconds.addAndGet(durationSeconds);
        videobridgeStatistics.totalBytesReceived.addAndGet(this.statistics.totalBytesReceived.get());
        videobridgeStatistics.totalBytesSent.addAndGet(this.statistics.totalBytesSent.get());
        videobridgeStatistics.packetsReceived.addAndGet(this.statistics.totalPacketsReceived.get());
        videobridgeStatistics.packetsSent.addAndGet(this.statistics.totalPacketsSent.get());
        videobridgeStatistics.totalRelayBytesReceived.addAndGet(this.statistics.totalRelayBytesReceived.get());
        videobridgeStatistics.totalRelayBytesSent.addAndGet(this.statistics.totalRelayBytesSent.get());
        videobridgeStatistics.relayPacketsReceived.addAndGet(this.statistics.totalRelayPacketsReceived.get());
        videobridgeStatistics.relayPacketsSent.addAndGet(this.statistics.totalRelayPacketsSent.get());
        boolean hasFailed = this.statistics.hasIceFailedEndpoint && !this.statistics.hasIceSucceededEndpoint;
        boolean hasPartiallyFailed = this.statistics.hasIceFailedEndpoint && this.statistics.hasIceSucceededEndpoint;
        videobridgeStatistics.endpointsDtlsFailed.addAndGet(this.statistics.dtlsFailedEndpoints.get());
        if (hasPartiallyFailed) {
            videobridgeStatistics.partiallyFailedConferences.incAndGet();
        }
        if (hasFailed) {
            videobridgeStatistics.failedConferences.incAndGet();
        }
        if (this.logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("expire_conf,");
            sb.append("duration=").append(durationSeconds).append(",has_failed=").append(hasFailed).append(",has_partially_failed=").append(hasPartiallyFailed);
            this.logger.info(sb.toString());
        }
    }

    AbstractEndpoint findEndpointByReceiveSSRC(long receiveSSRC) {
        return this.getEndpoints().stream().filter(ep -> ep.receivesSsrc(receiveSSRC)).findFirst().orElse(null);
    }

    @Nullable
    public AbstractEndpoint getEndpoint(@NotNull String id) {
        return this.endpointsById.get(Objects.requireNonNull(id, "id must be non null"));
    }

    @Nullable
    public Relay getRelay(@NotNull String id) {
        return this.relaysById.get(id);
    }

    @Nullable
    public AbstractEndpoint findSourceOwner(@NotNull String sourceName) {
        for (AbstractEndpoint e : this.endpointsById.values()) {
            if (e.findMediaSourceDesc(sourceName) == null) continue;
            return e;
        }
        return null;
    }

    @NotNull
    public Endpoint createLocalEndpoint(String id, boolean iceControlling, boolean sourceNames, boolean doSsrcRewriting, boolean visitor2) {
        AbstractEndpoint existingEndpoint = this.getEndpoint(id);
        if (existingEndpoint != null) {
            throw new IllegalArgumentException("Local endpoint with ID = " + id + "already created");
        }
        Endpoint endpoint = new Endpoint(id, this, this.logger, iceControlling, sourceNames, doSsrcRewriting, visitor2);
        this.videobridge.localEndpointCreated(visitor2);
        this.subscribeToEndpointEvents(endpoint);
        this.addEndpoints(Collections.singleton(endpoint));
        return endpoint;
    }

    @NotNull
    public Relay createRelay(String id, @Nullable String meshId, boolean iceControlling, boolean useUniquePort) {
        Relay existingRelay = this.getRelay(id);
        if (existingRelay != null) {
            throw new IllegalArgumentException("Relay with ID = " + id + "already created");
        }
        Relay relay = new Relay(id, this, this.logger, meshId, iceControlling, useUniquePort);
        this.relaysById.put(id, relay);
        return relay;
    }

    private void subscribeToEndpointEvents(final Endpoint endpoint) {
        endpoint.addEventHandler(new AbstractEndpoint.EventHandler(){

            @Override
            public void iceSucceeded() {
                Conference.this.getStatistics().hasIceSucceededEndpoint = true;
            }

            @Override
            public void iceFailed() {
                Conference.this.getStatistics().hasIceFailedEndpoint = true;
            }

            @Override
            public void sourcesChanged() {
                Conference.this.endpointSourcesChanged(endpoint);
            }
        });
    }

    private void endpointsChanged() {
        this.speechActivity.endpointsChanged(this.getEndpoints());
    }

    private void endpointSourcesChanged(@NotNull Endpoint endpoint) {
        this.lastNEndpointsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEndpointsCache() {
        Object object = this.endpointsCacheLock;
        synchronized (object) {
            ArrayList endpointsList = new ArrayList(this.endpointsById.size());
            this.endpointsById.values().forEach(e -> {
                if (e instanceof Endpoint) {
                    endpointsList.add((Endpoint)e);
                }
            });
            this.endpointsCache = Collections.unmodifiableList(endpointsList);
        }
    }

    public int getEndpointCount() {
        return this.endpointsById.size();
    }

    public int getRelayCount() {
        return this.relaysById.size();
    }

    public int getLocalEndpointCount() {
        return this.getLocalEndpoints().size();
    }

    public List<AbstractEndpoint> getEndpoints() {
        return new ArrayList<AbstractEndpoint>(this.endpointsById.values());
    }

    List<AbstractEndpoint> getOrderedEndpoints() {
        return this.speechActivity.getOrderedEndpoints();
    }

    public List<Endpoint> getLocalEndpoints() {
        return this.endpointsCache;
    }

    public List<Relay> getRelays() {
        return new ArrayList<Relay>(this.relaysById.values());
    }

    public final String getID() {
        return this.id;
    }

    @Nullable
    public final String getMeetingId() {
        return this.meetingId;
    }

    @Nullable
    public Endpoint getLocalEndpoint(String id) {
        AbstractEndpoint endpoint = this.getEndpoint(id);
        if (endpoint instanceof Endpoint) {
            return (Endpoint)endpoint;
        }
        return null;
    }

    public ConferenceSpeechActivity getSpeechActivity() {
        return this.speechActivity;
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    public boolean isExpired() {
        return this.expired.get();
    }

    public void endpointExpired(AbstractEndpoint endpoint) {
        String id = endpoint.getId();
        AbstractEndpoint removedEndpoint = this.endpointsById.remove(id);
        if (removedEndpoint == null) {
            this.logger.warn("No endpoint found, id=" + id);
            return;
        }
        if (removedEndpoint instanceof Endpoint) {
            this.updateEndpointsCache();
            this.endpointsById.forEach((i, senderEndpoint) -> senderEndpoint.removeReceiver(id));
            this.videobridge.localEndpointExpired(((Endpoint)removedEndpoint).getVisitor());
        }
        this.relaysById.forEach((i, relay) -> relay.endpointExpired(id));
        endpoint.getSsrcs().forEach(ssrc2 -> this.endpointsBySsrc.remove(ssrc2, endpoint));
        this.endpointsChanged();
    }

    public void relayExpired(Relay relay) {
        String id = relay.getId();
        this.relaysById.remove(id);
        this.getLocalEndpoints().forEach(senderEndpoint -> senderEndpoint.removeReceiver(id));
    }

    public void addEndpoints(Set<AbstractEndpoint> endpoints) {
        endpoints.forEach(endpoint -> {
            if (endpoint.getConference() != this) {
                throw new IllegalArgumentException("Endpoint belong to other conference = " + endpoint.getConference());
            }
            AbstractEndpoint replacedEndpoint = this.endpointsById.put(endpoint.getId(), (AbstractEndpoint)endpoint);
            if (replacedEndpoint != null) {
                this.logger.info("Endpoint with id " + endpoint.getId() + ": " + replacedEndpoint + " has been replaced by new endpoint with same id: " + endpoint);
            }
        });
        this.updateEndpointsCache();
        this.endpointsChanged();
    }

    @Override
    public void endpointMessageTransportConnected(@NotNull AbstractEndpoint abstractEndpoint) {
        List<String> recentSpeakers;
        Endpoint endpoint = (Endpoint)abstractEndpoint;
        this.epConnectionStatusMonitor.endpointConnected(endpoint.getId());
        if (!this.isExpired() && !(recentSpeakers = this.speechActivity.getRecentSpeakers()).isEmpty()) {
            endpoint.sendMessage(new DominantSpeakerMessage(recentSpeakers, this.speechActivity.isInSilence()));
        }
    }

    public AbstractEndpoint getEndpointBySsrc(long ssrc2) {
        return this.endpointsBySsrc.get(ssrc2);
    }

    public void addEndpointSsrc(@NotNull AbstractEndpoint endpoint, long ssrc2) {
        AbstractEndpoint oldEndpoint = this.endpointsBySsrc.put(ssrc2, endpoint);
        if (oldEndpoint != null && oldEndpoint != endpoint) {
            this.logger.warn("SSRC " + ssrc2 + " moved from ep " + oldEndpoint.getId() + " to ep " + endpoint.getId());
        }
    }

    public void removeEndpointSsrc(@NotNull AbstractEndpoint endpoint, long ssrc2) {
        this.endpointsBySsrc.remove(ssrc2, endpoint);
    }

    @Nullable
    public EntityBareJid getName() {
        return this.conferenceName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean shouldExpire() {
        return this.getEndpointCount() == 0 && System.currentTimeMillis() - this.creationTime > 20000L;
    }

    public boolean isRankedSpeaker(AbstractEndpoint ep) {
        if (!LoudestConfig.Companion.getRouteLoudestOnly()) {
            return false;
        }
        return this.speechActivity.isAmongLoudest(ep.getId());
    }

    private void sendOut(PacketInfo packetInfo) {
        String sourceEndpointId = packetInfo.getEndpointId();
        PotentialPacketHandler prevHandler = null;
        for (Endpoint endpoint : this.endpointsCache) {
            if (endpoint.getId().equals(sourceEndpointId) || !endpoint.wants(packetInfo)) continue;
            if (prevHandler != null) {
                prevHandler.send(packetInfo.clone());
            }
            prevHandler = endpoint;
        }
        for (Relay relay : this.relaysById.values()) {
            if (!relay.wants(packetInfo)) continue;
            if (prevHandler != null) {
                prevHandler.send(packetInfo.clone());
            }
            prevHandler = relay;
        }
        if (prevHandler != null) {
            prevHandler.send(packetInfo);
        } else {
            ByteBufferPool.returnBuffer(packetInfo.getPacket().getBuffer());
        }
    }

    public boolean hasRelays() {
        return !this.relaysById.isEmpty();
    }

    public void handleIncomingPacket(PacketInfo packetInfo) {
        Packet packet = packetInfo.getPacket();
        if (packet instanceof RtpPacket) {
            this.sendOut(packetInfo);
        } else if (packet instanceof RtcpFbPliPacket || packet instanceof RtcpFbFirPacket) {
            AbstractEndpoint ep;
            AbstractEndpoint targetEndpoint = null;
            boolean rewriter = false;
            long mediaSsrc = packet instanceof RtcpFbPliPacket ? ((RtcpFbPliPacket)packet).getMediaSourceSsrc() : ((RtcpFbFirPacket)packet).getMediaSenderSsrc();
            String endpointId = packetInfo.getEndpointId();
            if (endpointId != null && (ep = this.getEndpoint(endpointId)) instanceof Endpoint && ((Endpoint)ep).doesSsrcRewriting()) {
                rewriter = true;
                String owner = ((Endpoint)ep).unmapRtcpFbSsrc((RtcpFbPacket)packet);
                if (owner != null) {
                    targetEndpoint = this.getEndpoint(owner);
                }
            }
            if (!rewriter) {
                targetEndpoint = this.findEndpointByReceiveSSRC(mediaSsrc);
            }
            EncodingsManager.EncodingsUpdateListener pph = null;
            if (targetEndpoint instanceof Endpoint) {
                pph = (Endpoint)targetEndpoint;
            } else if (targetEndpoint instanceof RelayedEndpoint) {
                pph = ((RelayedEndpoint)targetEndpoint).getRelay();
            }
            if (pph == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Dropping FIR/PLI for media ssrc " + mediaSsrc);
                }
            } else if (pph.wants(packetInfo)) {
                pph.send(packetInfo);
            }
        } else {
            this.sendOut(packetInfo);
        }
    }

    public boolean levelChanged(@NotNull AbstractEndpoint endpoint, long level) {
        SpeakerRanking ranking = this.speechActivity.levelChanged(endpoint, level);
        if (ranking == null) {
            return false;
        }
        if (ranking.isDominant && LoudestConfig.Companion.getAlwaysRouteDominant()) {
            return false;
        }
        if (ranking.energyRanking < LoudestConfig.Companion.getNumLoudest()) {
            return false;
        }
        this.videobridge.getStatistics().tossedPacketsEnergy.addValue(ranking.energyScore);
        return true;
    }

    public JSONObject getDebugState() {
        return this.getDebugState(true);
    }

    public JSONObject getDebugState(boolean full) {
        return this.getDebugState(full, null);
    }

    public JSONObject getDebugState(boolean full, String endpointId) {
        JSONObject debugState = new JSONObject();
        debugState.put("id", this.id);
        debugState.put("rtcstatsEnabled", this.isRtcStatsEnabled);
        if (this.conferenceName != null) {
            debugState.put("name", this.conferenceName.toString());
        }
        if (this.meetingId != null) {
            debugState.put("meeting_id", this.meetingId);
        }
        if (full) {
            debugState.put("expired", this.expired.get());
            debugState.put("creationTime", this.creationTime);
            debugState.put("speechActivity", this.speechActivity.getDebugState());
            debugState.put("statistics", this.statistics.getJson());
        }
        JSONObject endpoints = new JSONObject();
        debugState.put("endpoints", endpoints);
        for (Endpoint e : this.endpointsCache) {
            if (endpointId != null && !endpointId.equals(e.getId())) continue;
            endpoints.put(e.getId(), full ? e.getDebugState() : e.getStatsId());
        }
        JSONObject relays = new JSONObject();
        debugState.put("relays", relays);
        for (Relay r : this.relaysById.values()) {
            relays.put(r.getId(), full ? r.getDebugState() : r.getId());
        }
        return debugState;
    }

    public boolean isP2p() {
        return this.isInactive() && this.getEndpointCount() == 2;
    }

    public boolean isInactive() {
        return this.getEndpoints().stream().noneMatch(e -> e.isSendingAudio() || e.isSendingVideo());
    }

    @NotNull
    public EncodingsManager getEncodingsManager() {
        return this.encodingsManager;
    }

    private class SpeechActivityListener
    implements ConferenceSpeechActivity.Listener {
        private SpeechActivityListener() {
        }

        @Override
        public void recentSpeakersChanged(List<AbstractEndpoint> recentSpeakers, boolean dominantSpeakerChanged, boolean silence) {
            Conference.this.recentSpeakersChanged(recentSpeakers, dominantSpeakerChanged, silence);
        }

        @Override
        public void lastNEndpointsChanged() {
            Conference.this.lastNEndpointsChanged();
        }
    }

    static class NoOpTimeSeriesPoint
    extends DiagnosticContext.TimeSeriesPoint {
        public NoOpTimeSeriesPoint() {
            this(Collections.emptyMap());
        }

        public NoOpTimeSeriesPoint(Map<String, Object> m3) {
            super(m3);
        }

        @Override
        public Object put(String key, Object value2) {
            return null;
        }
    }

    static class NoOpDiagnosticContext
    extends DiagnosticContext {
        NoOpDiagnosticContext() {
        }

        @Override
        public DiagnosticContext.TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, long tsMs) {
            return new NoOpTimeSeriesPoint();
        }

        @Override
        public Object put(@NotNull String key, @NotNull Object value2) {
            return null;
        }
    }

    public static class Statistics {
        public AtomicLong totalBytesReceived = new AtomicLong();
        public AtomicLong totalBytesSent = new AtomicLong();
        public AtomicLong totalPacketsReceived = new AtomicLong();
        public AtomicLong totalPacketsSent = new AtomicLong();
        public AtomicLong totalRelayBytesReceived = new AtomicLong();
        public AtomicLong totalRelayBytesSent = new AtomicLong();
        public AtomicLong totalRelayPacketsReceived = new AtomicLong();
        public AtomicLong totalRelayPacketsSent = new AtomicLong();
        public boolean hasIceFailedEndpoint = false;
        public boolean hasIceSucceededEndpoint = false;
        public AtomicInteger dtlsFailedEndpoints = new AtomicInteger();

        private JSONObject getJson() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("total_bytes_received", this.totalBytesReceived.get());
            jsonObject.put("total_bytes_sent", this.totalBytesSent.get());
            jsonObject.put("total_packets_received", this.totalPacketsReceived.get());
            jsonObject.put("total_packets_sent", this.totalPacketsSent.get());
            jsonObject.put("total_relay_bytes_received", this.totalRelayBytesReceived.get());
            jsonObject.put("total_relay_bytes_sent", this.totalRelayBytesSent.get());
            jsonObject.put("total_relay_packets_received", this.totalRelayPacketsReceived.get());
            jsonObject.put("total_relay_packets_sent", this.totalRelayPacketsSent.get());
            jsonObject.put("has_failed_endpoint", this.hasIceFailedEndpoint);
            jsonObject.put("has_succeeded_endpoint", this.hasIceSucceededEndpoint);
            jsonObject.put("dtls_failed_endpoints", this.dtlsFailedEndpoints.get());
            return jsonObject;
        }
    }
}

