/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtcp.SenderInfo;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsTracker;
import org.jitsi.nlj.util.ScheduleExecutorServiceExtensionsKt;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacketBuilder;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.DurationKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u001a\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/nlj/rtcp/RtcpRrGenerator;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "incomingStatisticsTracker", "Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;", "clock", "Ljava/time/Clock;", "additionalPacketSupplier", "Lkotlin/Function0;", "", "(Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;Ljava/time/Clock;Lkotlin/jvm/functions/Function0;)V", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "senderInfos", "", "", "Lorg/jitsi/nlj/rtcp/SenderInfo;", "doWork", "rtcpPacketReceived", "packet", "receivedTime", "Ljava/time/Instant;", "Companion", "jitsi-media-transform"})
public final class RtcpRrGenerator
implements RtcpListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final Function1<RtcpPacket, Unit> rtcpSender;
    @NotNull
    private final IncomingStatisticsTracker incomingStatisticsTracker;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function0<List<RtcpPacket>> additionalPacketSupplier;
    private boolean running;
    @NotNull
    private final Map<Long, SenderInfo> senderInfos;
    @NotNull
    private static final Duration reportingInterval = DurationKt.getMs(500);

    public RtcpRrGenerator(@NotNull ScheduledExecutorService backgroundExecutor, @NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull IncomingStatisticsTracker incomingStatisticsTracker, @NotNull Clock clock, @NotNull Function0<? extends List<? extends RtcpPacket>> additionalPacketSupplier) {
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(rtcpSender, "rtcpSender");
        Intrinsics.checkNotNullParameter(incomingStatisticsTracker, "incomingStatisticsTracker");
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(additionalPacketSupplier, "additionalPacketSupplier");
        this.backgroundExecutor = backgroundExecutor;
        this.rtcpSender = rtcpSender;
        this.incomingStatisticsTracker = incomingStatisticsTracker;
        this.clock = clock;
        this.additionalPacketSupplier = additionalPacketSupplier;
        this.running = true;
        this.senderInfos = new ConcurrentHashMap();
        this.doWork();
    }

    public /* synthetic */ RtcpRrGenerator(ScheduledExecutorService scheduledExecutorService, Function1 function1, IncomingStatisticsTracker incomingStatisticsTracker, Clock clock, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(scheduledExecutorService, function1, incomingStatisticsTracker, clock, function0);
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (packet instanceof RtcpSrPacket) {
            SenderInfo senderInfo2 = this.senderInfos.computeIfAbsent(packet.getSenderSsrc(), RtcpRrGenerator::rtcpPacketReceived$lambda-0);
            Intrinsics.checkNotNullExpressionValue(senderInfo2, "senderInfos.computeIfAbs\u2026derSsrc) { SenderInfo() }");
            SenderInfo senderInfo3 = senderInfo2;
            senderInfo3.setLastSrCompactedTimestamp(((RtcpSrPacket)packet).getSenderInfo().getCompactedNtpTimestamp());
            senderInfo3.setLastSrReceivedTime(receivedTime);
        }
    }

    private final void doWork() {
        if (this.running) {
            IncomingStatisticsSnapshot streamStats = this.incomingStatisticsTracker.getSnapshotOfActiveSsrcs();
            Instant now = this.clock.instant();
            List reportBlocks2 = new ArrayList();
            Map<Long, IncomingSsrcStats.Snapshot> $this$forEach$iv = streamStats.getSsrcStats();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, IncomingSsrcStats.Snapshot>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                SenderInfo senderInfo2;
                Map.Entry<Long, IncomingSsrcStats.Snapshot> element$iv;
                Map.Entry<Long, IncomingSsrcStats.Snapshot> entry = element$iv = iterator2.next();
                boolean bl = false;
                long ssrc2 = ((Number)entry.getKey()).longValue();
                IncomingSsrcStats.Snapshot statsSnapshot = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(this.senderInfos.computeIfAbsent(ssrc2, RtcpRrGenerator::doWork$lambda-2$lambda-1), "senderInfos.computeIfAbs\u2026rInfo()\n                }");
                int fractionLost = statsSnapshot.computeFractionLost(senderInfo2.getStatsSnapshot());
                senderInfo2.setStatsSnapshot(statsSnapshot);
                int n = statsSnapshot.getCumulativePacketsLost();
                int n2 = statsSnapshot.getSeqNumCycles();
                int n3 = statsSnapshot.getMaxSeqNum();
                long l = (long)statsSnapshot.getJitter();
                long l2 = senderInfo2.getLastSrCompactedTimestamp();
                Intrinsics.checkNotNullExpressionValue(now, "now");
                reportBlocks2.add(new RtcpReportBlock(ssrc2, fractionLost, n, n2, n3, l, l2, senderInfo2.getDelaySinceLastSr(now)));
            }
            List packets2 = new ArrayList();
            if (!((Collection)reportBlocks2).isEmpty()) {
                for (List blocks : CollectionsKt.chunked(reportBlocks2, 31)) {
                    packets2.add(new RtcpRrPacketBuilder(null, blocks, 1, null).build());
                }
            }
            packets2.addAll((Collection)this.additionalPacketSupplier.invoke());
            switch (packets2.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rtcpSender.invoke((RtcpPacket)CollectionsKt.first(packets2));
                    break;
                }
                default: {
                    for (CompoundRtcpPacket packet : CompoundRtcpPacket.Companion.createWithMtu$default(CompoundRtcpPacket.Companion, packets2, 0, 2, null)) {
                        this.rtcpSender.invoke(packet);
                    }
                }
            }
            ScheduleExecutorServiceExtensionsKt.schedule(this.backgroundExecutor, (KFunction)((Object)new Function0<Unit>((Object)this){

                public final void invoke() {
                    RtcpRrGenerator.access$doWork((RtcpRrGenerator)this.receiver);
                }
            }), reportingInterval);
        }
    }

    private static final SenderInfo rtcpPacketReceived$lambda-0(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new SenderInfo(0L, null, null, 7, null);
    }

    private static final SenderInfo doWork$lambda-2$lambda-1(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new SenderInfo(0L, null, null, 7, null);
    }

    public static final /* synthetic */ void access$doWork(RtcpRrGenerator $this) {
        $this.doWork();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtcp/RtcpRrGenerator$Companion;", "", "()V", "reportingInterval", "Ljava/time/Duration;", "getReportingInterval", "()Ljava/time/Duration;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getReportingInterval() {
            return reportingInterval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

